/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.awt.Color;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class EventGroup {
    private static final int IDBASE = 1000;
    private static int s_GroupID = 1000;
    private static Vector s_NameTable = new Vector();
    private int m_id;
    private String m_name;
    private int m_family;
    private Color m_color;
    private boolean m_show;
    private EventGroup m_prev;
    private EventGroup m_next;
    private static EventGroup s_first = null;
    private static EventGroup s_last = null;
    private static final int FAMILY_DEFAULT = 0;
    private static final int FAMILY_JDBC = 1;
    private static final int FAMILY_METADATA = 2;
    private static final int FAMILY_BUSOBJ_ACTION = 3;
    private static final int FAMILY_REMOTE_CALLS = 4;
    private static final Object[][] FAMILY_DATA = new Object[][]{{"default", Color.lightGray}, {"JDBC Actions", Color.yellow}, {"Business Object Actions", Color.magenta}, {"Metadata Creation", Color.blue}, {"Remote Calls", Color.orange}};
    public static EventGroup JBO_MISCELLANEOUS = new EventGroup("JBO_MISC");
    public static EventGroup JDBC_SELECT = new EventGroup("JDBC_SELECT", 1);
    public static EventGroup JDBC_CREATE_STATEMENT = new EventGroup("JDBC_CREATE_STATEMENT", 1);
    public static EventGroup JDBC_CONNECT = new EventGroup("JDBC_CONNECT", 1);
    public static EventGroup JDBC_CREATE_PREPARED_STATEMENT = new EventGroup("JDBC_CREATE_PREPARED_STATEMENT", 1);
    public static EventGroup JDBC_EXECUTE = new EventGroup("JDBC_EXECUTE", 1);
    public static EventGroup METAOBJECT_LOAD = new EventGroup("METAOBJECT_LOAD", 2);
    public static EventGroup EXECUTE_QUERY = new EventGroup("EXECUTE_QUERY", 3);
    public static EventGroup BC4J_CREATE_COMPOBJ = new EventGroup("BC4J_CREATE_COMPOBJ", 2, false);
    public static EventGroup BC4J_CREATE_ROOTAM = new EventGroup("BC4J_CREATE_ROOTAM", 2, true);
    public static EventGroup BC4J_CREATE_VIEWOBJECT = new EventGroup("BC4J_CREATE_VIEWOBJECT", 2, false);
    public static EventGroup BC4J_CREATE_AM = new EventGroup("BC4J_CREATE_AM", 2, false);
    public static EventGroup BC4J_CREATE_VIEWLINK = new EventGroup("BC4J_CREATE_VIEWLINK", 2, false);
    public static EventGroup SQLB_DOENTITYDML = new EventGroup("SQLB_DOENTITYDML", 3);
    public static EventGroup SQLB_DOENTITYSELECT = new EventGroup("SQLB_DOENTITYSELECT", 3);
    public static EventGroup VIEWOBJECT_GETSTATEMENT = new EventGroup("VIEWOBJECT_GETSTATEMENT", 3);
    public static EventGroup REMOTE_METHOD_CALL = new EventGroup("REMOTE_METHOD_CALL", 4);

    private /* synthetic */ void $init$() {
        this.m_prev = null;
        this.m_next = null;
    }

    private EventGroup(String string) {
        this(string, 0);
    }

    private EventGroup(String string, int n) {
        this(string, n, true);
    }

    private EventGroup(String string, int n, boolean bl) {
        this(string, n, bl, (Color)FAMILY_DATA[n][1]);
    }

    private EventGroup(String string, int n, boolean bl, Color color) {
        this.$init$();
        this.m_id = s_GroupID++;
        this.m_name = string;
        this.m_family = n;
        this.m_color = color;
        this.m_show = bl;
        s_NameTable.addElement(string);
        if (s_first == null) {
            s_first = this;
        }
        if (s_last != null) {
            this.m_prev = s_last;
            EventGroup.s_last.m_next = this;
        }
        s_last = this;
    }

    public static String getName(int n) {
        String string = (String)s_NameTable.elementAt(n - 1000);
        return string;
    }

    public int getID() {
        return this.m_id;
    }

    public String toString() {
        return this.m_name;
    }

    public String getFamily() {
        return (String)FAMILY_DATA[this.m_family][0];
    }

    public Color getColor() {
        return this.m_color;
    }

    public boolean getShow() {
        return this.m_show;
    }

    public EventGroup prev() {
        return this.m_prev;
    }

    public EventGroup next() {
        return this.m_next;
    }

    public static EventGroup first() {
        return s_first;
    }

    public EventGroup last() {
        return s_last;
    }

    public static Enumeration elements() {
        return new 1();
    }

    public static void dumpEventDetails(PrintStream printStream) {
        Enumeration enumeration = EventGroup.elements();
        while (enumeration.hasMoreElements()) {
            EventGroup eventGroup = (EventGroup)enumeration.nextElement();
            printStream.println(eventGroup.getID() + " " + eventGroup.getFamily() + " " + eventGroup.toString() + " " + eventGroup.getColor() + "  (" + eventGroup.getShow() + ")");
        }
    }

    public static final class 1
    implements Enumeration {
        private EventGroup curr;

        private /* synthetic */ void $init$() {
            this.curr = EventGroup.first();
        }

        public boolean hasMoreElements() {
            return this.curr != null;
        }

        public Object nextElement() {
            EventGroup eventGroup = this.curr;
            this.curr = this.curr.next();
            return eventGroup;
        }

        public /* synthetic */ 1() {
            this.$init$();
        }
    }
}

