/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client.remote;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidObjAccessException;
import oracle.jbo.JboException;
import oracle.jbo.JboSyncLock;
import oracle.jbo.Key;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowMatch;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetListener;
import oracle.jbo.RowSetManagementListener;
import oracle.jbo.ScrollEvent;
import oracle.jbo.StructureDef;
import oracle.jbo.UpdateEvent;
import oracle.jbo.Variable;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewLink;
import oracle.jbo.ViewObject;
import oracle.jbo.XMLInterface;
import oracle.jbo.client.remote.ApplicationModuleImpl;
import oracle.jbo.client.remote.ClientComponentObject;
import oracle.jbo.client.remote.ClientVariableValueManager;
import oracle.jbo.client.remote.ClientViewDef;
import oracle.jbo.client.remote.InternalListenerManager;
import oracle.jbo.client.remote.RowImpl;
import oracle.jbo.client.remote.RowSetImpl;
import oracle.jbo.client.remote.RowSetIteratorImpl;
import oracle.jbo.client.remote.StructureDefImpl;
import oracle.jbo.client.remote.ViewLinkImpl;
import oracle.jbo.common.AttributeDefValue;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboXMLUtil;
import oracle.jbo.common.ObjectMarshaller;
import oracle.jbo.common.PropertiesHelper;
import oracle.jbo.common.RowSetIteratorHelper;
import oracle.jbo.common.StructureDefHelper;
import oracle.jbo.common.SvcMsgIteratorState;
import oracle.jbo.common.ViewObjectDynAttr;
import oracle.jbo.common.ViewObjectSubclassDef;
import oracle.jbo.common.WeakVector;
import oracle.jbo.common.ws.WSRowSetIteratorMarshaller;
import oracle.jbo.common.ws.WSVariableValueManagerMarshaller;
import oracle.jbo.common.ws.WSViewObjectMarshaller;
import oracle.svcmsg.ServiceMessage;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ViewUsageImpl
extends PropertiesHelper
implements ViewObjectDynAttr,
WSVariableValueManagerMarshaller,
WSRowSetIteratorMarshaller,
WSViewObjectMarshaller,
InternalListenerManager,
RowSetListener,
ViewObject,
ClientComponentObject {
    static final int APPOBJ_STATE_UNINITIALIZED = -1;
    static final int APPOBJ_STATE_VALID = 0;
    static final int APPOBJ_STATE_CLOSED = 1;
    static final int APPOBJ_STATE_REMOVED = 2;
    static final String DEFAULT_INTERFACE_NAME;
    protected String mName;
    protected String mFullName;
    protected String mDefName;
    protected String mDefFullName;
    protected int mId;
    protected ApplicationModuleImpl mAM;
    protected StructureDefImpl mStruct;
    protected RowSet mDefaultRowSet;
    private WeakVector mRowSets;
    private ArrayList mStrongRowSetRefs;
    protected boolean mIsInternal;
    protected boolean mIsReadOnly;
    private boolean mIsNameGenerated;
    protected ArrayList mViewLinks;
    protected ViewCriteria mCriteria;
    protected boolean mCriteriaGotten;
    protected String mRowProxyClassName;
    protected String mInterfaceName;
    private JboSyncLock mSyncLock;
    private int mAppObjState;
    private AttributeDef[] mKeyAttrs;
    private long mSignature;
    private int mActivationMode;
    private HashMap mSubclassDefs;
    private ClientVariableValueManager mVariableManager;
    private Class mMsgBundleClass;
    private static /* synthetic */ Class class$oracle$jbo$ViewObject;

    private /* synthetic */ void $init$() {
        this.mAM = null;
        this.mRowSets = new WeakVector(4);
        this.mStrongRowSetRefs = null;
        this.mIsNameGenerated = false;
        this.mViewLinks = new ArrayList(2);
        this.mCriteria = null;
        this.mCriteriaGotten = false;
        this.mRowProxyClassName = null;
        this.mSyncLock = null;
        this.mAppObjState = -1;
        this.mActivationMode = 0;
        this.mSubclassDefs = null;
        this.mVariableManager = null;
    }

    ViewUsageImpl(ApplicationModuleImpl applicationModuleImpl, int n, String string, String string2, String string3, String string4, Class clazz, boolean bl, boolean bl2, boolean bl3) {
        this.$init$();
        this.init(applicationModuleImpl, n, string, string2, string3, string4, clazz, bl);
        this.mMsgBundleClass = clazz;
        this.setInternal(bl2);
        this.setNameGenerated(bl3);
        this.setInterfaceName(DEFAULT_INTERFACE_NAME);
    }

    protected ViewUsageImpl() {
        this.$init$();
    }

    public final Object getSyncLock() {
        if (this.mAM != null) {
            return this.mAM.getSyncLock();
        }
        this.mSyncLock = new JboSyncLock();
        return this.mSyncLock;
    }

    int getSyncMode() {
        if (this.mAM != null) {
            return this.mAM.getSyncMode();
        }
        return 0;
    }

    boolean isBatchMode() {
        int n = this.getSyncMode();
        return n == 2 || n == 5000;
    }

    public final boolean isNameGenerated() {
        return this.mIsNameGenerated;
    }

    final void setNameGenerated(boolean bl) {
        this.mIsNameGenerated = bl;
    }

    public final boolean isInternal() {
        return this.mIsInternal;
    }

    final void setInternal(boolean bl) {
        this.mIsInternal = bl;
    }

    String getRowProxyClassName() {
        return this.mRowProxyClassName;
    }

    void setRowProxyClassName(String string) {
        this.mRowProxyClassName = string;
    }

    public String getInterfaceName() {
        return this.mInterfaceName;
    }

    final void setInterfaceName(String string) {
        this.mInterfaceName = string;
    }

    final boolean isCustom() {
        return this.mInterfaceName.equals(DEFAULT_INTERFACE_NAME) ^ true;
    }

    RowImpl createRowProxy(int n, Object[] objectArray, RowSetIteratorImpl rowSetIteratorImpl, Object object, byte by, BitSet bitSet, int n2, int n3) {
        RowImpl rowImpl = null;
        if (this.mRowProxyClassName == null) {
            rowImpl = new RowImpl();
        } else {
            try {
                Class clazz = JBOClass.forName(this.mRowProxyClassName);
                rowImpl = (RowImpl)clazz.newInstance();
            }
            catch (Exception exception) {
                Diagnostic.println("Unable to create row of class=" + this.mRowProxyClassName + " voName=" + this.getName() + " Reason=" + exception.getMessage());
                throw new JboException(exception);
            }
        }
        rowImpl.initialize(n, objectArray, rowSetIteratorImpl, object, by, n2, n3);
        rowImpl.setAttributeUpdateableFlags(null, bitSet);
        this.mAM.registerUnmarshalledRow(rowImpl);
        return rowImpl;
    }

    protected void init(ApplicationModuleImpl applicationModuleImpl, int n, String string, String string2, String string3, String string4, Class clazz, boolean bl) {
        this.mAM = applicationModuleImpl;
        this.mId = n;
        this.mName = string;
        this.mFullName = string2;
        this.mDefName = string3;
        this.mDefFullName = string4;
        this.mIsReadOnly = bl;
        this.mAM.registerObject(n, this);
        this.mAppObjState = 0;
    }

    public String getName() {
        return this.mName;
    }

    public String getFullName() {
        return this.mFullName;
    }

    public String getDefName() {
        return this.mDefName;
    }

    public String getDefFullName() {
        return this.mDefFullName;
    }

    void detach() {
    }

    void afterActivation(int n) {
        this.mActivationMode = n;
    }

    public int getActivationMode() {
        int n = this.mActivationMode;
        this.mActivationMode = 0;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        if (this.mAM != null) {
            this.mAM.removeAndUnregisterObject(this.mId);
            this.mId = -1;
            Object object = this.getSyncLock();
            synchronized (object) {
                this.clearClientSide(true);
            }
        } else {
            this.clearClientSide(true);
        }
        this.mAppObjState = 2;
    }

    public int getRemoteId() {
        return this.mId;
    }

    public byte getROTEntryType() {
        return 2;
    }

    public StructureDef getStructDef() {
        if (this.mStruct == null) {
            this.setAttributeDefInfo(this.mAM.getAttributeDefInfo(this.mId));
        }
        return this.mStruct;
    }

    void setAttributeDefInfo(Object[] objectArray) {
        if (this.mStruct == null) {
            this.mStruct = new StructureDefImpl(this.getName(), this.mAM, this.mId, (AttributeDefValue[])objectArray[0]);
            int[] nArray = (int[])objectArray[1];
            if (nArray != null) {
                this.mKeyAttrs = new AttributeDef[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    this.mKeyAttrs[n] = this.getAttributeDef(nArray[n]);
                    ++n;
                }
            }
        }
    }

    int getMutDomainAttrCount() {
        return ((StructureDefImpl)this.getStructDef()).getMutDomainAttrCount();
    }

    int getUpdWhileNewAttrCount() {
        return ((StructureDefImpl)this.getStructDef()).getUpdWhileNewAttrCount();
    }

    public AttributeDef[] getAttributeDefs() {
        return this.getStructDef().getAttributeDefs();
    }

    int getLocalAttributeCount() {
        if (this.mStruct == null) {
            return 0;
        }
        return this.mStruct.getAttributeCount();
    }

    public int getAttributeCount() {
        return this.getStructDef().getAttributeCount();
    }

    public AttributeDef findAttributeDef(String string) {
        return this.getStructDef().findAttributeDef(string);
    }

    public AttributeDef lookupAttributeDef(String string) {
        return this.getStructDef().lookupAttributeDef(string);
    }

    public AttributeDef getAttributeDef(int n) {
        return this.getStructDef().getAttributeDef(n);
    }

    public int getAttributeIndexOf(String string) {
        return this.getStructDef().getAttributeIndexOf(string);
    }

    public AttributeDef[] getKeyAttributeDefs() {
        if (this.mKeyAttrs == null) {
            AttributeDef[] attributeDefArray = this.getStructDef().getAttributeDefs();
            ArrayList arrayList = new ArrayList(1);
            int n = 0;
            while (n < attributeDefArray.length) {
                if (attributeDefArray[n].isPrimaryKey()) {
                    arrayList.add((Object)attributeDefArray[n]);
                }
                ++n;
            }
            this.mKeyAttrs = (AttributeDef[])arrayList.toArray((Object[])new AttributeDef[arrayList.size()]);
        }
        return this.mKeyAttrs;
    }

    public AttributeDef[] getAttrDefsForEntityAttr(String string, String string2) {
        int[] nArray = this.getAttrIndicesForEntityAttr(string, string2);
        AttributeDef[] attributeDefArray = new AttributeDef[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            attributeDefArray[n] = this.getAttributeDef(nArray[n]);
            ++n;
        }
        return attributeDefArray;
    }

    public int[] getAttrIndicesForEntityAttr(String string, String string2) {
        return this.mAM.getAttrIndicesForEntityAttr(this.mId, string, string2);
    }

    public void setWhereClause(String string) {
        this.mAM.setWhereClause(this.mId, string);
    }

    public String getWhereClause() {
        return this.mAM.getWhereClause(this.mId);
    }

    public void setNamedWhereClauseParams(AttributeList attributeList) {
        this.getDefaultRowSetImpl().setNamedWhereClauseParams(attributeList);
    }

    public AttributeList getNamedWhereClauseParams() {
        return this.getDefaultRowSetImpl().getNamedWhereClauseParams();
    }

    public void setWhereClauseParams(Object[] objectArray) {
        this.getDefaultRowSetImpl().setWhereClauseParams(objectArray);
    }

    public void setWhereClauseParam(int n, Object object) {
        this.getDefaultRowSetImpl().setWhereClauseParam(n, object);
    }

    public void defineNamedWhereClauseParam(String string, Object object, int[] nArray) {
        this.getDefaultRowSetImpl().defineNamedWhereClauseParam(string, object, nArray);
    }

    public void removeNamedWhereClauseParam(String string) {
        this.getDefaultRowSetImpl().removeNamedWhereClauseParam(string);
    }

    public Object getNamedWhereClauseParam(String string) {
        return this.getDefaultRowSetImpl().getNamedWhereClauseParam(string);
    }

    public void setNamedWhereClauseParam(String string, Object object) {
        this.getDefaultRowSetImpl().setNamedWhereClauseParam(string, object);
    }

    public void skipNamedWhereClauseParam(String string) {
        this.getDefaultRowSetImpl().skipNamedWhereClauseParam(string);
    }

    public Object[] getWhereClauseParams() {
        return this.getDefaultRowSetImpl().getWhereClauseParams();
    }

    public void setOrderByClause(String string) {
        this.mAM.setOrderByClause(this.mId, string);
    }

    public String getOrderByClause() {
        return this.mAM.getOrderByClause(this.mId);
    }

    public String getQuery() {
        return this.mAM.getQuery(this.mId);
    }

    public void setRowMatch(RowMatch rowMatch) {
        this.mAM.setRowMatch(this.mId, rowMatch);
    }

    public RowMatch getRowMatch() {
        return this.mAM.getRowMatch(this.mId);
    }

    public void setSortBy(String string) {
        this.mAM.setSortBy(this.mId, string);
    }

    public String getSortBy() {
        return this.mAM.getSortBy(this.mId);
    }

    public void setQueryMode(int n) {
        this.mAM.setQueryMode(this.mId, n, false);
    }

    public void addQueryMode(int n) {
        this.mAM.setQueryMode(this.mId, n, true);
    }

    public int getQueryMode() {
        return this.mAM.getQueryMode(this.mId);
    }

    public Hashtable getProperties() {
        this.mProperties = this.mAM.getVOProperties(this.mId);
        return this.mProperties;
    }

    public void setProperty(String string, Object object) {
        super.setProperty(string, object);
        this.mAM.setVOProperty(this.mId, string, object);
    }

    public Object refreshProperty(String string) {
        if (this.mProperties == null) {
            return this.getProperty(string);
        }
        Object object = this.mAM.refreshVOProperty(this.mId, string);
        this.mProperties.put(string, object);
        return object;
    }

    public boolean isExecuted() {
        return this.getDefaultRowSetImpl().isExecuted();
    }

    public void executeQuery() {
        this.getDefaultRowSetImpl().executeQuery();
    }

    public String[] getViewLinkNames() {
        this.getViewLinks();
        String[] stringArray = new String[this.mViewLinks.size()];
        int n = 0;
        while (n < this.mViewLinks.size()) {
            stringArray[n] = ((ViewLinkImpl)this.mViewLinks.get(n)).getName();
            ++n;
        }
        return stringArray;
    }

    final int getAppObjState() {
        return this.mAppObjState;
    }

    public void clearCache() {
        this.clearClientCache();
        this.mAM.clearVOCache(this.mId);
    }

    void clearClientCache() {
        int n = 0;
        while (n < this.mRowSets.size()) {
            RowSetImpl rowSetImpl = (RowSetImpl)this.mRowSets.elementAt(n);
            if (rowSetImpl != null) {
                rowSetImpl.clearClientCache();
            }
            ++n;
        }
    }

    void clearClientSide(boolean bl) {
        if (this.mVariableManager != null) {
            this.mVariableManager.setNeedsRefresh();
        }
        int n = 0;
        while (n < this.mViewLinks.size()) {
            ((ViewLinkImpl)this.mViewLinks.get(n)).clearClientSide();
            ++n;
        }
        Object[] objectArray = new RowSetImpl[this.mRowSets.size()];
        this.mRowSets.copyInto(objectArray);
        int n2 = 0;
        while (n2 < this.mRowSets.size()) {
            Object object = objectArray[n2];
            if (object != null) {
                ((RowSetImpl)objectArray[n2]).clearClientSide(bl);
            }
            ++n2;
        }
        this.mViewLinks.clear();
        this.mRowSets.removeAllElements();
        if (this.mDefaultRowSet != null) {
            ((RowSetImpl)this.mDefaultRowSet).clearClientSide(bl);
        }
        if (this.mAM != null && this.mId != -1) {
            this.mAM.unregisterObject(this.mId, this);
        }
        this.mAM = null;
        this.mDefaultRowSet = null;
        this.mCriteria = null;
        this.mCriteriaGotten = false;
        this.mStruct = null;
        this.mKeyAttrs = null;
        this.mAppObjState = 1;
    }

    void addRowSet(RowSet rowSet) {
        if (!this.mRowSets.contains(rowSet)) {
            this.mRowSets.addElement(rowSet);
            if (this.isBatchMode()) {
                if (this.mStrongRowSetRefs == null) {
                    this.mStrongRowSetRefs = new ArrayList(4);
                }
                this.mStrongRowSetRefs.add((Object)rowSet);
            }
        }
    }

    void setDefaultRowSetImpl(RowSetImpl rowSetImpl) {
        this.mDefaultRowSet = rowSetImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final RowSetImpl getDefaultRowSetImpl() {
        if (this.mDefaultRowSet == null) {
            Object object = this.getSyncLock();
            synchronized (object) {
                if (this.mDefaultRowSet == null) {
                    if (this.mAM == null) {
                        throw new InvalidObjAccessException(111, this.getName());
                    }
                    RowSetImpl.createDefaultRowSet(this);
                    Diagnostic.ASSERT(this.mDefaultRowSet != null, "Default Row Set is null");
                }
            }
        }
        return (RowSetImpl)this.mDefaultRowSet;
    }

    public RowSet getRowSet() {
        return this;
    }

    public RowSetIterator getRowSetIterator() {
        return this;
    }

    public Row next() {
        return this.getDefaultRowSetImpl().next();
    }

    public Row previous() {
        return this.getDefaultRowSetImpl().previous();
    }

    public Row first() {
        return this.getDefaultRowSetImpl().first();
    }

    public Row last() {
        return this.getDefaultRowSetImpl().last();
    }

    public void reset() {
        this.getDefaultRowSetImpl().reset();
    }

    public boolean hasNext() {
        return this.getDefaultRowSetImpl().hasNext();
    }

    public boolean hasPrevious() {
        return this.getDefaultRowSetImpl().hasPrevious();
    }

    public boolean isRangeAtBottom() {
        return this.getDefaultRowSetImpl().isRangeAtBottom();
    }

    public boolean isRangeAtTop() {
        return this.getDefaultRowSetImpl().isRangeAtTop();
    }

    public int getFetchedRowCount() {
        return this.getDefaultRowSetImpl().getFetchedRowCount();
    }

    public int getRowCount() {
        return this.getDefaultRowSetImpl().getRowCount();
    }

    public long getEstimatedRowCount() {
        return this.getDefaultRowSetImpl().getEstimatedRowCount();
    }

    public Object[] getRowFilterValues() {
        if (this.mDefaultRowSet == null) {
            return null;
        }
        return this.getDefaultRowSetImpl().getRowFilterValues();
    }

    public void setRowFilterValues(Object[] objectArray) {
        if (this.mDefaultRowSet != null) {
            this.getDefaultRowSetImpl().setRowFilterValues(objectArray);
        }
    }

    public SvcMsgIteratorState getCliIteratorState() {
        if (this.mDefaultRowSet == null) {
            return null;
        }
        return this.getDefaultRowSetImpl().getCliIteratorState();
    }

    public void prepareForBatchMode(SvcMsgIteratorState svcMsgIteratorState, boolean bl) {
    }

    public int setRangeSize(int n) {
        return this.getDefaultRowSetImpl().setRangeSize(n);
    }

    public int getRangeSize() {
        if (this.mDefaultRowSet == null) {
            return 1;
        }
        return this.getDefaultRowSetImpl().getRangeSize();
    }

    public int getRangeStart() {
        if (this.mDefaultRowSet == null) {
            return -1;
        }
        return this.getDefaultRowSetImpl().getRangeStart();
    }

    public int setRangeStart(int n) {
        return this.getDefaultRowSetImpl().setRangeStart(n);
    }

    public int scrollRange(int n) {
        return this.getDefaultRowSetImpl().scrollRange(n);
    }

    public int getEstimatedRangePageCount() {
        return this.getDefaultRowSetImpl().getEstimatedRangePageCount();
    }

    public int scrollToRangePage(int n) {
        return this.getDefaultRowSetImpl().scrollToRangePage(n);
    }

    public int scrollRangeTo(Row row, int n) {
        return this.getDefaultRowSetImpl().scrollRangeTo(row, n);
    }

    public Row getRow(Key key) {
        return this.getDefaultRowSetImpl().getRow(key);
    }

    public Row getRowAtRangeIndex(int n) {
        return this.getDefaultRowSetImpl().getRowAtRangeIndex(n);
    }

    public Row getCurrentRow() {
        return this.getDefaultRowSetImpl().getCurrentRow();
    }

    public int getCurrentRowIndex() {
        return this.getDefaultRowSetImpl().getCurrentRowIndex();
    }

    public int getCurrentRowSlot() {
        return this.getDefaultRowSetImpl().getCurrentRowSlot();
    }

    public int getIterMode() {
        return this.getDefaultRowSetImpl().getIterMode();
    }

    public void setIterMode(int n) {
        this.getDefaultRowSetImpl().setIterMode(n);
    }

    public boolean isRowValidation() {
        return this.getDefaultRowSetImpl().isRowValidation();
    }

    public void setRowValidation(boolean bl) {
        this.getDefaultRowSetImpl().setRowValidation(bl);
    }

    public boolean setCurrentRow(Row row) {
        return this.getDefaultRowSetImpl().setCurrentRow(row);
    }

    public boolean setCurrentRowAtRangeIndex(int n) {
        return this.getDefaultRowSetImpl().setCurrentRowAtRangeIndex(n);
    }

    public Row createAndInitRow(AttributeList attributeList) {
        return this.getDefaultRowSetImpl().createAndInitRow(attributeList);
    }

    public Row createRow() {
        return this.getDefaultRowSetImpl().createRow();
    }

    public void insertRow(Row row) {
        this.getDefaultRowSetImpl().insertRow(row);
    }

    public void insertRowAtRangeIndex(int n, Row row) {
        this.getDefaultRowSetImpl().insertRowAtRangeIndex(n, row);
    }

    public void removeCurrentRow() {
        this.getDefaultRowSetImpl().removeCurrentRow();
    }

    public void removeCurrentRowFromCollection() {
        this.getDefaultRowSetImpl().removeCurrentRowFromCollection();
    }

    public Row removeCurrentRowAndRetain() {
        return this.getDefaultRowSetImpl().removeCurrentRowAndRetain();
    }

    public int getRangeIndexOf(Row row) {
        return this.getDefaultRowSetImpl().getRangeIndexOf(row);
    }

    public Enumeration enumerateRowsInRange() {
        return this.getDefaultRowSetImpl().enumerateRowsInRange();
    }

    public Row[] getFilteredRows(String string, Object object) {
        return this.getDefaultRowSetImpl().getFilteredRows(string, object);
    }

    public Row[] getFilteredRowsInRange(String string, Object object) {
        return this.getDefaultRowSetImpl().getFilteredRowsInRange(string, object);
    }

    public Row[] getAllRowsInRange() {
        return this.getDefaultRowSetImpl().getAllRowsInRange();
    }

    public Row[] getNextRangeSet() {
        return this.getDefaultRowSetImpl().getNextRangeSet();
    }

    public Row[] getPreviousRangeSet() {
        return this.getDefaultRowSetImpl().getPreviousRangeSet();
    }

    public ViewObject getViewObject() {
        return this;
    }

    public boolean setMasterRowSetIterator(RowSetIterator rowSetIterator) {
        return this.getDefaultRowSetImpl().setMasterRowSetIterator(rowSetIterator);
    }

    public boolean removeMasterRowSetIterator(RowSetIterator rowSetIterator) {
        return this.getDefaultRowSetImpl().removeMasterRowSetIterator(rowSetIterator);
    }

    public RowSetIterator[] getMasterRowSetIterators() {
        return this.getDefaultRowSetImpl().getMasterRowSetIterators();
    }

    public AttributeDef addDynamicAttribute(String string) {
        AttributeDef attributeDef = null;
        StructureDefHelper structureDefHelper = (StructureDefHelper)this.getStructDef();
        int n = this.mAM.addDynamicAttribute(this.mId, string);
        if (n == -1 || (attributeDef = structureDefHelper.addDynamicAttribute(string, n)) == null) {
            return null;
        }
        return attributeDef;
    }

    public Object getParent() {
        return this.mAM;
    }

    public ApplicationModule getApplicationModule() {
        return this.mAM;
    }

    public void addListener(Object object) {
        this.getDefaultRowSetImpl().getDefaultRowSetIteratorImpl().addListener(object);
    }

    public void addInternalListener(Object object) {
        this.getDefaultRowSetImpl().getDefaultRowSetIteratorImpl().addInternalListener(object);
    }

    public void removeInternalListener(Object object) {
        this.getDefaultRowSetImpl().getDefaultRowSetIteratorImpl().removeInternalListener(object);
    }

    public void removeListener(Object object) {
        if (this.mDefaultRowSet != null) {
            this.getDefaultRowSetImpl().removeListener(object);
        }
    }

    public void addManagementListener(RowSetManagementListener rowSetManagementListener) {
        this.getDefaultRowSetImpl().getDefaultRowSetIteratorImpl().addManagementListener(rowSetManagementListener);
    }

    public void removeManagementListener(RowSetManagementListener rowSetManagementListener) {
        if (this.mDefaultRowSet != null) {
            this.getDefaultRowSetImpl().removeManagementListener(rowSetManagementListener);
        }
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        ((RowSetListener)this.getDefaultRowSetImpl()).rangeRefreshed(rangeRefreshEvent);
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
        ((RowSetListener)this.getDefaultRowSetImpl()).rangeScrolled(scrollEvent);
    }

    public void rowInserted(InsertEvent insertEvent) {
        ((RowSetListener)this.getDefaultRowSetImpl()).rowInserted(insertEvent);
    }

    public void rowDeleted(DeleteEvent deleteEvent) {
        ((RowSetListener)this.getDefaultRowSetImpl()).rowDeleted(deleteEvent);
    }

    public void rowUpdated(UpdateEvent updateEvent) {
        ((RowSetListener)this.getDefaultRowSetImpl()).rowUpdated(updateEvent);
    }

    public void navigated(NavigationEvent navigationEvent) {
        ((RowSetListener)this.getDefaultRowSetImpl()).navigated(navigationEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet createRowSet(String string) {
        Object object = this.getSyncLock();
        synchronized (object) {
            RowSet rowSet;
            RowSet rowSet2 = rowSet = this.mAM.createRowSet(this, string);
            return rowSet2;
        }
    }

    public void closeRowSet() {
        if (this.mDefaultRowSet != null) {
            this.mDefaultRowSet.closeRowSet();
        }
    }

    public void closeRowSetIterator() {
        if (this.mDefaultRowSet != null) {
            this.mDefaultRowSet.closeRowSetIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRowSet(RowSet rowSet) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.mRowSets.contains(rowSet)) {
                if (this.mDefaultRowSet == rowSet) {
                    this.mDefaultRowSet = null;
                }
                this.mRowSets.removeElement(rowSet);
                if (this.isBatchMode() && this.mStrongRowSetRefs != null) {
                    this.mStrongRowSetRefs.remove((Object)rowSet);
                }
            }
        }
    }

    public RowSet[] getRowSets() {
        if (this.mAM == null) {
            throw new InvalidObjAccessException(111, this.getName());
        }
        RowSet[] rowSetArray = this.mAM.getRowSets(this.mId);
        RowSet[] rowSetArray2 = null;
        if (rowSetArray != null) {
            rowSetArray2 = new RowSet[rowSetArray.length];
            int n = 0;
            while (n < rowSetArray.length) {
                rowSetArray2[n] = rowSetArray[n].getRowSet();
                ++n;
            }
        }
        return rowSetArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet findRowSet(String string) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.isBatchMode()) {
                int n = 0;
                while (n < this.mRowSets.size()) {
                    RowSetImpl rowSetImpl = (RowSetImpl)this.mRowSets.elementAt(n);
                    if (rowSetImpl != null && rowSetImpl.getName().equals(string)) {
                        RowSet rowSet = rowSetImpl.getRowSet();
                        return rowSet;
                    }
                    ++n;
                }
                RowSet rowSet = null;
                return rowSet;
            }
            RowSet rowSet = this.mAM.findRowSet(this, string);
            if (rowSet == null) {
                RowSet rowSet2 = null;
                return rowSet2;
            }
            RowSet rowSet3 = rowSet.getRowSet();
            return rowSet3;
        }
    }

    public RowSetIterator createRowSetIterator(String string) {
        return this.getDefaultRowSetImpl().createRowSetIterator(string);
    }

    public RowSetIterator[] getRowSetIterators() {
        return this.getDefaultRowSetImpl().getRowSetIterators();
    }

    public RowSetIterator findRowSetIterator(String string) {
        return this.getDefaultRowSetImpl().findRowSetIterator(string);
    }

    public int getRowCountInRange() {
        return this.getDefaultRowSetImpl().getRowCountInRange();
    }

    public boolean isReadOnly() {
        return this.mIsReadOnly;
    }

    protected void addViewLink(ViewLink viewLink) {
        if (!this.mViewLinks.contains((Object)viewLink)) {
            this.mViewLinks.add((Object)viewLink);
        }
    }

    protected void removeViewLink(ViewLinkImpl viewLinkImpl) {
        this.mViewLinks.remove((Object)viewLinkImpl);
    }

    protected ViewLink[] getViewLinks() {
        if (this.mAM == null) {
            throw new InvalidObjAccessException(111, this.getName());
        }
        ViewLink[] viewLinkArray = this.mAM.getViewLinks(this.mId);
        int n = 0;
        while (n < viewLinkArray.length) {
            this.addViewLink(viewLinkArray[n]);
            ++n;
        }
        return viewLinkArray;
    }

    public RowSet[] getDetailRowSets() {
        if (this.mAM == null) {
            throw new InvalidObjAccessException(111, this.getName());
        }
        return this.getDefaultRowSetImpl().getDetailRowSets();
    }

    public RowSet createDetailRowSet(String string, String string2) {
        return this.getDefaultRowSetImpl().createDetailRowSet(string, string2);
    }

    public ViewCriteria createViewCriteria() {
        return new ViewCriteria(this);
    }

    void syncCriteria() {
        if (this.mCriteria != null) {
            this.applyViewCriteria(this.mCriteria);
        }
    }

    public void applyViewCriteria(ViewCriteria viewCriteria) {
        if (this.mAM == null) {
            throw new InvalidObjAccessException(111, this.getName());
        }
        this.mCriteria = viewCriteria;
        this.mCriteriaGotten = true;
        this.mAM.applyViewCriteria(this.mId, this.mCriteria);
    }

    void setViewCriteriaInternal(ViewCriteria viewCriteria) {
        this.mCriteria = viewCriteria;
        this.mCriteriaGotten = true;
    }

    public ViewCriteria getViewCriteria() {
        if (!this.isBatchMode() && !this.mCriteriaGotten) {
            this.mCriteria = this.mAM.getViewCriteria(this);
            this.mCriteriaGotten = true;
        }
        return this.mCriteria;
    }

    public Key createKey(AttributeList attributeList) {
        return RowSetIteratorHelper.createKey(attributeList, this.getKeyAttributeDefs());
    }

    public Row[] findByKey(Key key, int n) {
        return this.getDefaultRowSetImpl().findByKey(key, n);
    }

    public RowIterator findByViewCriteria(ViewCriteria viewCriteria, int n, int n2) {
        return this.getDefaultRowSetImpl().findByViewCriteria(viewCriteria, n, n2);
    }

    public Row[] findByEntity(int n, int n2) {
        return this.getDefaultRowSetImpl().findByEntity(n, n2);
    }

    protected byte[] getPiggyback() {
        return this.mAM.getPiggyback();
    }

    protected ServiceMessage getServiceMessage() {
        return this.mAM.getServiceMessage();
    }

    protected void processPiggyback(byte[] byArray) {
        this.mAM.processPiggyback(byArray);
    }

    protected ArrayList processServiceMessage(ServiceMessage serviceMessage) {
        return this.mAM.processServiceMessage(serviceMessage);
    }

    public boolean isForwardOnly() {
        return this.getDefaultRowSetImpl().isForwardOnly();
    }

    public void setForwardOnly(boolean bl) {
        this.getDefaultRowSetImpl().setForwardOnly(bl);
    }

    public byte getAccessMode() {
        return this.getDefaultRowSetImpl().getAccessMode();
    }

    public void setAccessMode(byte by) {
        this.getDefaultRowSetImpl().setAccessMode(by);
    }

    public boolean isAssociationConsistent() {
        return this.getDefaultRowSetImpl().isAssociationConsistent();
    }

    public void setAssociationConsistent(boolean bl) {
        this.getDefaultRowSetImpl().setAssociationConsistent(bl);
    }

    public final boolean isMaxFetchSizeExceeded() {
        return this.mDefaultRowSet != null ? this.getDefaultRowSetImpl().isMaxFetchSizeExceeded() : false;
    }

    public boolean isFetchComplete() {
        return this.getDefaultRowSetImpl().isFetchComplete();
    }

    public AttributeDef addViewLinkAccessor(String string) {
        AttributeDef attributeDef = null;
        if (this.mStruct != null) {
            StructureDefHelper structureDefHelper = (StructureDefHelper)this.getStructDef();
            attributeDef = structureDefHelper.addViewLinkAccessor(string, this.getAttributeCount());
        } else {
            attributeDef = this.getStructDef().findAttributeDef(string);
        }
        return attributeDef;
    }

    protected void finalize() {
        Diagnostic.println("--## finlCLI ViewUsageImpl id=" + this.mId + ", name=" + this.getName() + ", obj=" + this);
        if (this.mAM != null) {
            this.mAM.objectFinalized(this.mId);
        }
    }

    public AttributeDef findViewLinkAccessor(ViewLink viewLink) {
        int n = -1;
        if (this.mAM != null) {
            n = this.mAM.findViewLinkAccessor(this.mId, ((ViewLinkImpl)viewLink).getRemoteId());
        }
        if (n < 0) {
            return null;
        }
        return this.getAttributeDef(n);
    }

    protected ObjectMarshaller getObjectMarshaller() {
        return this.mAM.getObjectMarshaller();
    }

    public Node writeXML(long l, HashMap hashMap) {
        return this.getDefaultRowSetImpl().writeXML(l, hashMap);
    }

    public Node writeXML(int n, long l) {
        return this.getDefaultRowSetImpl().writeXML(n, l);
    }

    public void readXML(Element element, int n) {
        this.getDefaultRowSetImpl().readXML(element, n);
    }

    public Node writeXML(long l, HashMap hashMap, XSLStylesheet xSLStylesheet) {
        return JboXMLUtil.writeAndProcessXML((XMLInterface)this, l, hashMap, xSLStylesheet);
    }

    public Node writeXML(int n, long l, XSLStylesheet xSLStylesheet) {
        return JboXMLUtil.writeAndProcessXML((XMLInterface)this, n, l, xSLStylesheet);
    }

    public void readXML(Element element, int n, XSLStylesheet xSLStylesheet) {
        JboXMLUtil.processAndReadXML(this, element, n, xSLStylesheet);
    }

    public void readRowXML(Element element, int n) {
        this.mAM.findAndReadRowXML(this.mId, element, n);
    }

    public void readRowXML(Element element, int n, XSLStylesheet xSLStylesheet) {
        if (xSLStylesheet != null) {
            XMLDocument xMLDocument = new XMLDocument();
            element.getParentNode().removeChild(element);
            try {
                xMLDocument.appendChild((Node)element);
            }
            catch (Exception exception) {
                xMLDocument.adoptNode((Node)element);
                xMLDocument.appendChild((Node)element);
            }
            xMLDocument = JboXMLUtil.processXSL(xMLDocument, xSLStylesheet);
            element = xMLDocument.getDocumentElement();
        }
        this.readRowXML(element, n);
    }

    public int getMaxFetchSize() {
        return this.mAM.getMaxFetchSize(this.mId);
    }

    public void setMaxFetchSize(int n) {
        this.mAM.setMaxFetchSize(this.mId, n);
    }

    public static RowSetIteratorImpl getImplObject(Object object) {
        RowSetIteratorImpl rowSetIteratorImpl = object instanceof ViewUsageImpl ? ((ViewUsageImpl)object).getDefaultRowSetImpl().getDefaultRowSetIteratorImpl() : (object instanceof RowSetImpl ? ((RowSetImpl)object).getDefaultRowSetIteratorImpl() : (RowSetIteratorImpl)object);
        return rowSetIteratorImpl;
    }

    public void setQueryOptimizerHint(String string) {
        this.mAM.setQueryOptimizerHint(this.mId, string);
    }

    public String getQueryOptimizerHint() {
        return this.mAM.getQueryOptimizerHint(this.mId);
    }

    void setSignature(long l) {
        this.mSignature = l;
    }

    long getSignature() {
        return this.mSignature;
    }

    protected ApplicationModuleImpl getApplicationModuleProxy() {
        return (ApplicationModuleImpl)this.getApplicationModule();
    }

    public void findAndSetCurrentRowByKey(Key key, int n) {
        if (this.mDefaultRowSet != null) {
            this.getDefaultRowSetImpl().findAndSetCurrentRowByKey(key, n);
        }
    }

    public int getDynamicAttributeOffset() {
        return ((StructureDefImpl)this.getStructDef()).getDynamicAttributeOffset();
    }

    public int getDynamicAttributeCount() {
        return this.getAttributeCount() - this.getDynamicAttributeOffset();
    }

    StructureDef getSubclassDef(ClientViewDef clientViewDef) {
        StructureDef structureDef;
        if (clientViewDef == null) {
            return this;
        }
        if (this.mSubclassDefs == null) {
            this.mSubclassDefs = new HashMap(4);
        }
        if ((structureDef = (StructureDef)this.mSubclassDefs.get((Object)clientViewDef)) == null) {
            structureDef = new ViewObjectSubclassDef(this, clientViewDef);
            this.mSubclassDefs.put((Object)clientViewDef, (Object)structureDef);
        }
        return structureDef;
    }

    public VariableValueManager getVariableManager() {
        return this.mVariableManager;
    }

    public boolean hasVariables() {
        return this.mVariableManager != null;
    }

    public VariableValueManager ensureVariableManager() {
        if (this.mVariableManager == null) {
            this.mVariableManager = new ClientVariableValueManager(this.mAM, this, null);
        }
        return this.mVariableManager;
    }

    public java.util.ArrayList getVariableOpers() {
        return this.mVariableManager != null ? this.mVariableManager.getBatchOpers() : null;
    }

    public void resetVariableOpers() {
        if (this.mVariableManager != null) {
            this.mVariableManager.resetBatchOpers();
        }
    }

    public void mergeVariableValues(Variable[] variableArray, Object[] objectArray) {
        this.mergeVariableValues(variableArray, objectArray, true);
    }

    void mergeVariableValues(Variable[] variableArray, Object[] objectArray, boolean bl) {
        if (variableArray != null && variableArray.length > 0) {
            this.ensureVariableManager();
            this.mVariableManager.mergeVariableValues(variableArray, objectArray, bl);
        }
    }

    public Class getMessageBundleClass() {
        return this.mMsgBundleClass;
    }

    public int getQueryTimeOut() {
        return this.mAM.getQueryTimeOut(this.mId);
    }

    public void setQueryTimeOut(int n) {
        this.mAM.setQueryTimeOut(this.mId, n);
    }

    public boolean cancelQuery() {
        return this.mAM.cancelQuery(this.mId);
    }

    static {
        Class clazz = class$oracle$jbo$ViewObject;
        if (clazz == null) {
            clazz = class$oracle$jbo$ViewObject = ViewUsageImpl.class$("oracle.jbo.ViewObject");
        }
        DEFAULT_INTERFACE_NAME = clazz.getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

