/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client.remote;

import java.io.IOException;
import java.io.Writer;
import oracle.jbo.JboException;
import oracle.jbo.Transaction;
import oracle.jbo.client.remote.ApplicationModuleImpl;
import oracle.jbo.client.remote.RowImpl;
import oracle.jbo.domain.DomainOwnerInterface;

public class ClobDomainCharacterOutputStream
extends Writer {
    ApplicationModuleImpl am;
    int rsId;
    int rowId;
    String attrId;
    Object[] args;

    public ClobDomainCharacterOutputStream(Transaction transaction, DomainOwnerInterface domainOwnerInterface, String string) {
        this.am = (ApplicationModuleImpl)transaction;
        RowImpl rowImpl = (RowImpl)domainOwnerInterface;
        this.rsId = rowImpl.getRSIId();
        this.rowId = (Integer)rowImpl.getHandle();
        this.attrId = string;
    }

    public void write(int n) throws IOException {
        this.write(new char[]{(char)n}, 0, 1);
    }

    public void flush() {
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new JboException(new NullPointerException());
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 < 0) {
            throw new JboException(new IndexOutOfBoundsException());
        }
        if (cArray.length != 0 && n2 == 0) {
            return;
        }
        if (n2 > cArray.length) {
            n2 = cArray.length;
        }
        char[] cArray2 = cArray;
        if (n2 != cArray.length) {
            cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
        }
        this.am.writeClob(this.rsId, this.rowId, this.attrId, cArray2);
    }

    public void close() throws IOException {
        this.am.writeClob(this.rsId, this.rowId, this.attrId, new char[0]);
    }
}

