/*
 * Decompiled with CFR 0.152.
 */
package oracle.svcmsg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ServiceMessage
implements Serializable {
    static final long serialVersionUID = -7817747342547340633L;
    private ArrayList mRequests;
    private HashMap mRequestKeys;
    private ArrayList mResponses;
    private HashMap mResponseKeys;
    private String mName;

    private /* synthetic */ void $init$() {
        this.mRequests = new ArrayList(2);
        this.mRequestKeys = null;
        this.mResponses = new ArrayList(2);
        this.mResponseKeys = null;
        this.mName = null;
    }

    public ServiceMessage() {
        this.$init$();
    }

    public ServiceMessage(String string) {
        this.$init$();
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String string) {
        this.mName = string;
    }

    protected void clearEntries() {
        this.mRequests.clear();
        if (this.mRequestKeys != null) {
            this.mRequestKeys.clear();
        }
        this.mResponses.clear();
        if (this.mResponseKeys != null) {
            this.mResponseKeys.clear();
        }
    }

    public void clear() {
        this.clearEntries();
        this.mName = null;
    }

    public ServiceMessage copyTo(ServiceMessage serviceMessage) {
        serviceMessage.mRequests = (ArrayList)this.mRequests.clone();
        if (this.mRequestKeys != null) {
            serviceMessage.mRequestKeys = (HashMap)this.mRequestKeys.clone();
        }
        serviceMessage.mResponses = (ArrayList)this.mResponses.clone();
        if (this.mResponseKeys != null) {
            serviceMessage.mResponseKeys = (HashMap)this.mResponseKeys.clone();
        }
        serviceMessage.mName = this.mName;
        return serviceMessage;
    }

    public List getRequests() {
        return this.mRequests;
    }

    public List getResponses() {
        return this.mResponses;
    }

    protected void setRequests(List list) {
        this.mRequests = list instanceof ArrayList ? (ArrayList)list : new ArrayList(list);
    }

    protected void setResponses(List list) {
        this.mResponses = list instanceof ArrayList ? (ArrayList)list : new ArrayList(list);
    }

    void putRequestKey(Object object, Serializable serializable) {
        if (this.mRequestKeys == null) {
            this.mRequestKeys = new HashMap(2);
        }
        this.mRequestKeys.put(object, serializable);
    }

    void putResponseKey(Object object, Serializable serializable) {
        if (this.mResponseKeys == null) {
            this.mResponseKeys = new HashMap(2);
        }
        this.mResponseKeys.put(object, serializable);
    }

    public void addRequest(Serializable serializable) {
        this.mRequests.add(serializable);
    }

    public void addRequestWithKey(Object object, Serializable serializable) {
        this.addRequest(serializable);
        this.putRequestKey(object, serializable);
    }

    public void addResponse(Serializable serializable) {
        this.mResponses.add(serializable);
    }

    public void addResponseWithKey(Object object, Serializable serializable) {
        this.addResponse(serializable);
        this.putResponseKey(object, serializable);
    }

    public Serializable getRequestByKey(Object object) {
        if (this.mRequestKeys != null) {
            return (Serializable)this.mRequestKeys.get(object);
        }
        return null;
    }

    public Serializable getResponseByKey(Object object) {
        if (this.mResponseKeys != null) {
            return (Serializable)this.mResponseKeys.get(object);
        }
        return null;
    }

    public void insertRequest(int n, Serializable serializable) {
        this.mRequests.add(n, serializable);
    }

    public void insertRequestWithKey(int n, Object object, Serializable serializable) {
        this.insertRequest(n, serializable);
        this.putRequestKey(object, serializable);
    }

    public void insertResponse(int n, Serializable serializable) {
        this.mResponses.add(n, serializable);
    }

    public void insertReponseWityKey(int n, Object object, Serializable serializable) {
        this.insertResponse(n, serializable);
        this.putResponseKey(object, serializable);
    }

    public void removeRequest(int n) {
        this.mRequests.remove(n);
    }

    public void removeRequestByKey(Object object) {
        if (this.mRequestKeys != null) {
            Object v = this.mRequestKeys.get(object);
            if (v != null) {
                this.mRequests.remove(v);
            }
            this.mRequestKeys.remove(object);
        }
    }

    public void removeResponse(int n) {
        this.mResponses.remove(n);
    }

    public void removeResponseByKey(Object object) {
        if (this.mResponseKeys != null) {
            Object v = this.mResponseKeys.get(object);
            if (v != null) {
                this.mResponses.remove(v);
            }
            this.mResponseKeys.remove(object);
        }
    }

    public Iterator requestKeys() {
        if (this.mRequestKeys == null) {
            return null;
        }
        return this.mRequestKeys.keySet().iterator();
    }

    public Iterator requestElements() {
        if (this.mRequestKeys == null) {
            return null;
        }
        return this.mRequestKeys.values().iterator();
    }

    public Iterator responseKeys() {
        if (this.mResponseKeys == null) {
            return null;
        }
        return this.mResponseKeys.keySet().iterator();
    }

    public Iterator responseElements() {
        if (this.mResponseKeys == null) {
            return null;
        }
        return this.mResponseKeys.values().iterator();
    }
}

