/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.rules;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import oracle.jbo.JboException;
import oracle.jbo.common.JBOClass;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.server.ValidationBeanLoader;
import oracle.jbo.server.rules.GenericValidator;
import oracle.jbo.server.util.PropertyChangeEvent;
import oracle.jbo.server.util.Variant;

public class JboGenericValidator
implements Serializable,
GenericValidator {
    Object mOwner;
    Object mMin;
    Object mMax;
    Vector mList;
    Vector mVariantList;
    String mPrec;
    String mScale;
    int mPrecision;
    int mScaleInt;
    boolean mUpdateable;
    Class mType;
    boolean mbSetup;
    boolean mbInSetup;
    Object mLValue;
    String mDescription;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mMin = null;
        this.mMax = null;
        this.mList = null;
        this.mVariantList = new Vector();
        this.mUpdateable = true;
        this.mType = null;
        this.mbSetup = false;
        this.mbInSetup = false;
    }

    public JboGenericValidator() {
        this.$init$();
        this.mDescription = "Temporary";
    }

    public boolean validateValue(Object object) {
        Variant variant;
        boolean bl;
        if (!this.mbSetup) {
            if (!this.mbInSetup) {
                this.mbInSetup = true;
                if (this.mMin != null) {
                    this.mMin = this.convertType(this.mMin);
                }
                if (this.mMax != null) {
                    this.mMax = this.convertType(this.mMax);
                }
                if (this.mList != null) {
                    this.mList = this.convertList(this.mList);
                }
                this.mbSetup = true;
                this.mbInSetup = false;
            } else {
                return true;
            }
        }
        if (!(bl = (variant = this.getVariant(object)) == null ^ true) || !this.mUpdateable) {
            return false;
        }
        if (this.mVariantList.size() > 0) {
            bl = false;
            int n = 0;
            while (n < this.mVariantList.size()) {
                if (variant.compareTo((Variant)this.mVariantList.elementAt(n)) == 0) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                return bl;
            }
        } else {
            if (this.mMax != null) {
                boolean bl2 = bl = variant.compareTo(this.getVariant(this.mMax)) < 0;
                if (!bl) {
                    return bl;
                }
            }
            if (this.mMin != null) {
                boolean bl3 = bl = variant.compareTo(this.getVariant(this.mMin)) > 0;
                if (!bl) {
                    return bl;
                }
            }
        }
        if (variant.toString() != null && this.mPrec != null) {
            boolean bl4 = bl = variant.toString().length() <= this.mPrecision;
            if (!bl) {
                System.out.println("Failed - " + variant);
                return bl;
            }
        }
        return bl;
    }

    public Vector getList() {
        if (this.mList != null) {
            return (Vector)this.mList.clone();
        }
        return null;
    }

    public Object getMin() {
        return this.mMin;
    }

    public Object getMax() {
        return this.mMax;
    }

    public String getPrec() {
        return this.mPrec;
    }

    public boolean isUpdateable() {
        return this.mUpdateable;
    }

    public void setList(Vector vector) {
        this.mList = vector;
    }

    public void setMin(Object object) {
        this.mMin = object;
    }

    public void setMax(Object object) {
        this.mMax = object;
    }

    public void setPrec(String string) {
        this.mPrec = string;
        try {
            this.mPrecision = Integer.valueOf(string);
        }
        catch (Exception exception) {
            this.mPrecision = -1;
        }
    }

    public void setUpdateable(boolean bl) {
        this.mUpdateable = bl;
    }

    public void setTypeInfo(String string) {
        try {
            this.mType = JBOClass.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void setLhs(DomainInterface domainInterface) {
        if (!this.mbInSetup) {
            this.mLValue = domainInterface;
        }
    }

    Variant getVariant(Object object) {
        Variant variant = new Variant();
        Object object2 = null;
        object2 = object instanceof DomainInterface ? ((DomainInterface)object).getData() : object;
        if (object2 instanceof Number) {
            if (object2 instanceof Integer) {
                variant.setInt((Integer)object2);
            } else if (object2 instanceof Short) {
                variant.setShort((Short)object2);
            } else if (object2 instanceof Long) {
                variant.setLong((Long)object2);
            } else if (object2 instanceof Float) {
                variant.setFloat(((Float)object2).floatValue());
            } else if (object2 instanceof Double) {
                variant.setDouble((Double)object2);
            } else if (object2 instanceof BigDecimal) {
                variant.setBigDecimal((BigDecimal)object2);
            } else if (object2 instanceof BigInteger) {
                variant.setLong(((Number)object2).longValue());
            } else if (object2 instanceof Byte) {
                variant.setByte((Byte)object2);
            } else {
                variant.setDouble(((Number)object2).doubleValue());
            }
        } else if (object2 instanceof String) {
            variant.setString((String)object2);
        } else if (object2 instanceof Time) {
            variant.setTime((Time)object2);
        } else if (object2 instanceof Timestamp) {
            variant.setTimestamp((Timestamp)object2);
        } else if (object2 instanceof Date) {
            variant.setDate((Date)object2);
        } else {
            variant.setObject(object2);
        }
        return variant;
    }

    public String toString() {
        return "JboGenericValidator";
    }

    private Object convertType(Object object) {
        try {
            if (object instanceof String && this.mType != null) {
                Object object2 = TypeFactory.getInstance(this.mType, (Object)((String)object));
                return object2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    private Vector convertList(Vector vector) {
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        this.mVariantList = new Vector(vector.size());
        int n = 0;
        while (n < vector.size()) {
            Object object = this.convertType(vector.elementAt(n));
            vector2.addElement(object);
            this.mVariantList.addElement(this.getVariant(object));
            ++n;
        }
        return vector2;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws JboException {
        this.mType = propertyChangeEvent.getNewValue().getClass();
        this.mLValue = propertyChangeEvent.getNewValue();
        if (!this.validateValue(this.mLValue)) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = JboGenericValidator.class$("oracle.jbo.CSMessageBundle");
            }
            ValidationBeanLoader.raiseException(clazz, "27011", propertyChangeEvent.getSource(), propertyChangeEvent.getPropertyName(), this.mLValue, null, null);
        }
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String string) {
        this.mDescription = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

