/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InvalidObjNameException;
import oracle.jbo.InvalidOperException;
import oracle.jbo.InvalidParamException;
import oracle.jbo.JboEvent;
import oracle.jbo.Key;
import oracle.jbo.NameClashException;
import oracle.jbo.NameValuePairs;
import oracle.jbo.NavigationEvent;
import oracle.jbo.NoDefException;
import oracle.jbo.NoObjException;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.ReadOnlyViewObjectException;
import oracle.jbo.Row;
import oracle.jbo.RowEvent;
import oracle.jbo.RowIterator;
import oracle.jbo.RowMatch;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetManagementEvent;
import oracle.jbo.RowSetManagementListener;
import oracle.jbo.SQLStmtException;
import oracle.jbo.UpdateEvent;
import oracle.jbo.Variable;
import oracle.jbo.VariableManager;
import oracle.jbo.VariableManagerOwner;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewLink;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.SvcMsgIteratorState;
import oracle.jbo.common.VariableValueManagerImpl;
import oracle.jbo.common.ws.WSRowSetIteratorMarshaller;
import oracle.jbo.common.ws.WSRowSetMarshaller;
import oracle.jbo.domain.NullValue;
import oracle.jbo.domain.WhereClauseParamNoValue;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.AssociationDefImpl;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.AttributeListImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.IteratorStateHolder;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.QueryCollection;
import oracle.jbo.server.RowFilter;
import oracle.jbo.server.RowQualifier;
import oracle.jbo.server.RowSetImpl;
import oracle.jbo.server.RowSetStateHolder;
import oracle.jbo.server.SQLBuilder;
import oracle.jbo.server.ViewAttributeDefImpl;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewLinkImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.server.ViewRowSetIteratorImpl;
import oracle.jbo.server.ViewRowStorage;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ViewRowSetImpl
extends RowSetImpl
implements WSRowSetIteratorMarshaller,
WSRowSetMarshaller,
RowSet {
    protected ViewObjectImpl mQRef;
    protected ArrayList mViews;
    protected HashMap mViewMap;
    private int mRowSetIteratorId;
    protected ViewRowSetIteratorImpl mDefaultView;
    protected ArrayList mMasterViews;
    protected ArrayList mUserParams;
    protected Object[] mParamValues;
    protected ArrayList mWhereParams;
    ArrayList mExecuteUserParams;
    Object[] mExecuteParamValues;
    boolean mPassivate;
    QueryCollection mQC;
    private boolean mExecuted;
    private boolean mNotifiedRefresh;
    private boolean mIsDefaultRS;
    private boolean mIsNameGenerated;
    private byte mAccessMode;
    private boolean mExecuteMaster;
    private boolean mIsOwnedByQC;
    private byte mViewLinkMode;
    private boolean mReceiveAllInsertEvents;
    private boolean mHasStateToPassivate;
    boolean mParamsChanged;
    private RowSetStateHolder mRowSetState;
    private VariableValueManager mVariableManager;
    public static final byte VIEWLINK_MODE_UNINITIALIZED = -1;
    public static final byte VIEWLINK_MODE_INCONSISTENT = 0;
    public static final byte VIEWLINK_MODE_CONSISTENT = 1;
    public static final byte VIEWLINK_MODE_DEFAULT = 2;
    public static byte mDefaultViewLinkMode = (byte)-1;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mRowSetIteratorId = 0;
        this.mUserParams = new ArrayList(2);
        this.mWhereParams = new ArrayList(2);
        this.mPassivate = false;
        this.mQC = null;
        this.mExecuted = false;
        this.mNotifiedRefresh = false;
        this.mIsDefaultRS = false;
        this.mIsNameGenerated = false;
        this.mAccessMode = 0;
        this.mExecuteMaster = false;
        this.mIsOwnedByQC = false;
        this.mReceiveAllInsertEvents = false;
        this.mHasStateToPassivate = false;
        this.mParamsChanged = false;
        this.mRowSetState = null;
        this.mVariableManager = null;
    }

    public ViewRowSetImpl(ViewObjectImpl viewObjectImpl, String string, ViewRowSetIteratorImpl viewRowSetIteratorImpl) {
        this(viewObjectImpl, string, viewRowSetIteratorImpl, false);
    }

    ViewRowSetImpl(ViewObjectImpl viewObjectImpl, String string, ViewRowSetIteratorImpl viewRowSetIteratorImpl, boolean bl) {
        this.$init$();
        this.setDefaultRS(bl);
        this.mViewLinkMode = viewObjectImpl.getEntityDefCount() != 0 ? ViewRowSetImpl.getDefaultViewLinkMode() : (byte)0;
        this.mQRef = viewObjectImpl;
        this.mViews = new ArrayList(4);
        this.mViewMap = new HashMap(4);
        this.mMasterViews = new ArrayList(2);
        this.mDefaultView = null;
        if (string == null) {
            boolean[] blArray = new boolean[1];
            string = this.mQRef.getRowSetName(null, bl, blArray);
            this.setNameGenerated(blArray[0]);
        }
        this.setName(string);
        this.initMasterViews(viewRowSetIteratorImpl);
        viewObjectImpl.addRowSet(this);
        this.getWhereClauseParamsFromVars();
    }

    public final Object getSyncLock() {
        return ((ApplicationModuleImpl)this.getApplicationModule()).getSyncLock();
    }

    public final boolean isNameGenerated() {
        return this.mIsNameGenerated;
    }

    final void setNameGenerated(boolean bl) {
        this.mIsNameGenerated = bl;
    }

    static byte getDefaultViewLinkMode() {
        if (mDefaultViewLinkMode == -1) {
            String string = PropertyMetadata.ENV_VIEWLINK_MODE.getProperty();
            String string2 = "???";
            if (string == null) {
                mDefaultViewLinkMode = (byte)2;
                string2 = "default";
            } else if (string.equals("DEFAULT")) {
                mDefaultViewLinkMode = (byte)2;
                string2 = "default";
            } else if (string.equals("false")) {
                mDefaultViewLinkMode = 0;
                string2 = "false";
            } else if (string.equals("true")) {
                mDefaultViewLinkMode = 1;
                string2 = "true";
            } else {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("jbo.viewlink.consistent env value [" + string + "] not recognized");
                }
                mDefaultViewLinkMode = (byte)2;
                string2 = string + "default";
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("ViewRowSetImpl's jbo.viewlink.consistent = " + string2 + " (" + mDefaultViewLinkMode + ")");
            }
        }
        return mDefaultViewLinkMode;
    }

    public boolean isDefaultRS() {
        return this.mIsDefaultRS;
    }

    void setDefaultRS(boolean bl) {
        this.mIsDefaultRS = bl;
    }

    void setParamValues(Object[] objectArray) {
        this.mParamsChanged = true;
        this.mParamValues = objectArray;
    }

    RowFilter getRowFilter(Row[] rowArray) {
        return this.getRowFilter(true, rowArray, false, false);
    }

    private RowFilter getRowFilter(boolean bl, Row[] rowArray, boolean bl2, boolean bl3) {
        Object[] objectArray = this.getParameters(bl, rowArray, bl2, bl3);
        if (this.getViewObjectImpl().isForScan()) {
            Object[] objectArray2;
            Object[] objectArray3 = objectArray2 = bl2 ? this.mExecuteParamValues : this.mParamValues;
            if (objectArray2 != null) {
                int n = objectArray != null ? objectArray.length : 0;
                Object[] objectArray4 = new Object[n + objectArray2.length];
                if (n > 0) {
                    System.arraycopy(objectArray, 0, objectArray4, 0, n);
                }
                System.arraycopy(objectArray2, 0, objectArray4, n, objectArray2.length);
                objectArray = objectArray4;
            }
        }
        return this.getViewObjectImpl().buildRowFilter(objectArray);
    }

    boolean initAndRegisterQC(boolean bl, boolean bl2, RowFilter rowFilter) {
        boolean bl3 = this.initQueryCollection(bl, rowFilter);
        if (bl3) {
            this.mQRef.updateQueryCollectionCache(this.mQC, rowFilter, bl2);
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initQueryCollection(boolean bl, RowFilter rowFilter) {
        Object object = this.getSyncLock();
        synchronized (object) {
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = this.mMasterViews != null && this.mMasterViews.size() > 0;
            boolean bl5 = false;
            if (this.getViewObjectImpl().getMaxFetchSize() == 0) {
                bl = false;
                bl3 = false;
            } else if ((this.getViewObjectImpl().getQueryMode() & 1) != 0) {
                bl5 = true;
            }
            if (bl3 && this.mQC != null && this.isDirty() && this.mQRef.isAutoPostChanges()) {
                ((ApplicationModuleImpl)this.mQRef.getApplicationModule()).getDBTransaction().postChanges();
            }
            if (!bl5 && (bl3 || bl4)) {
                QueryCollection queryCollection = this.mQC;
                this.mQC = null;
                if (!(bl || this.isForwardOnly() || (bl3 || !bl4) && this.mQRef.isQueryChanged())) {
                    this.mQC = this.mQRef.getCachedQueryCollection(rowFilter);
                    if (this.mQC != null && this.mQC.isAssociationConsistent() != this.isAssociationConsistent()) {
                        this.mQC = null;
                    }
                }
                if (queryCollection != null && queryCollection != this.mQC) {
                    if (!bl && this.mQC == null && !queryCollection.isExecuted() && rowFilter.equals(queryCollection.getRowFilter())) {
                        this.mQC = queryCollection;
                    } else if (bl3 || !bl4) {
                        this.mQRef.clearQueryCollectionCache(queryCollection, bl);
                    }
                }
            }
            if (this.mQC == null) {
                this.mQC = new QueryCollection(this);
                this.mQC.setAssociationConsistent(this.isAssociationConsistent());
                this.mQC.setRowFilter(rowFilter, this.getWhereClauseParamArray().size());
                if (this.getViewObjectImpl().isForScan()) {
                    if (this.mIsDefaultRS) {
                        this.mQC.setScanBase(true);
                    } else {
                        this.mQC.setExecuted(true);
                        this.mQC.prepForQuery(false);
                    }
                }
                bl2 = true;
            } else if (bl5 && bl) {
                this.mQC.setExecuted(false);
            }
            if (!bl3 && bl4 && this.mQC != null) {
                this.mQC.setPinned(true);
            }
            boolean bl6 = bl2;
            return bl6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        if (this.mQRef != null) {
            Object object = this.getSyncLock();
            synchronized (object) {
                this.mAccessMode = 0;
                if (this.mViews != null) {
                    int n = 0;
                    while (n < this.mViews.size()) {
                        this.removeListener(this.mViews.get(n));
                        ((ViewRowSetIteratorImpl)this.mViews.get(n)).close();
                        ++n;
                    }
                    this.mViews.clear();
                    this.mViewMap.clear();
                }
                this.mDefaultView = null;
                if (this.mMasterViews != null) {
                    int n = 0;
                    while (n < this.mMasterViews.size()) {
                        ((ViewRowSetIteratorImpl)this.mMasterViews.get(n)).removeDetailViewRowSet(this.getRowSet());
                        ++n;
                    }
                    this.mMasterViews.clear();
                }
                if (this.mQC != null) {
                    QueryCollection queryCollection = this.mQC;
                    this.mQC = null;
                    this.mQRef.clearQueryCollectionCache(queryCollection, false);
                }
                if (this.hasManagementListeners()) {
                    this.fireMgmtIteratorClosed(new RowSetManagementEvent(this, 1));
                }
                this.mQRef.removeRowSet(this);
                this.mQRef = null;
            }
        }
    }

    public void closeRowSet() {
        this.close();
    }

    public void closeRowSetIterator() {
        if (this.mDefaultView != null) {
            this.mDefaultView.closeRowSetIterator();
        }
    }

    void setExecuteMaster(boolean bl) {
        this.mExecuteMaster = bl;
    }

    int getQueryTS() {
        if (this.getQueryCollection() == null) {
            return -1;
        }
        return this.getQueryCollection().getQueryTS();
    }

    public void execute(boolean bl, boolean bl2) {
        this.execute(bl, bl, bl2, true, false, null);
    }

    public void execute(boolean bl, boolean bl2, Row[] rowArray) {
        this.execute(bl, bl, bl2, true, false, rowArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Row[] rowArray) {
        Object object = this.getSyncLock();
        synchronized (object) {
            RowFilter rowFilter;
            this.mExecuteMaster = true;
            if (rowArray == null && this.mMasterViews.size() > 0) {
                rowArray = new Row[this.mMasterViews.size()];
            }
            if (bl4) {
                rowFilter = this.getRowFilter(true, rowArray, false, bl5);
                this.mExecuteParamValues = this.mParamValues;
                this.mExecuteUserParams = (ArrayList)this.getWhereClauseParamArray().clone();
                this.mParamsChanged = false;
            } else {
                rowFilter = this.getRowFilter(true, null, true, bl5);
            }
            ViewObjectImpl viewObjectImpl = this.getViewObjectImpl();
            viewObjectImpl.recalcDefaultAssocConsistent();
            boolean bl6 = this.initQueryCollection(bl, rowFilter);
            if (bl5) {
                this.mQC.setSkipQuery(true);
            }
            this.ensureStorage();
            try {
                viewObjectImpl.executeQueryForCollection(this.mQC, this.getParametersAsStorageTypes(rowArray, bl4 ^ true, bl5), this.mExecuteUserParams.size());
            }
            catch (SQLStmtException sQLStmtException) {
                this.mQC = null;
                this.setExecuted();
                this.resetIterators();
                throw sQLStmtException;
            }
            if (bl3 || this.mQRef.isQueryChanged()) {
                this.mNotifiedRefresh = false;
                this.mQRef.setQueryChanged(false);
            }
            this.setExecuted();
            if (bl6) {
                if (this.getViewObjectImpl().isViewLinkAccessorRetained()) {
                    this.mQC.setPinned(true);
                }
                this.mQRef.updateQueryCollectionCache(this.mQC, rowFilter, true);
            }
            this.notifyRefresh(bl2, true, true, true, rowArray);
            this.mHasStateToPassivate = true;
        }
    }

    public void refreshCache(int n) {
        n |= 1;
        this.executeQueryForMode(n &= 0xFFFFFFFB);
    }

    public void executeQuery() {
        this.executeQueryForMode(0);
    }

    void executeQueryForMode(int n) {
        this.executeQueryForMasters(n, null);
    }

    public Object[] executeDetailQuery(Row[] rowArray) {
        this.executeQueryForMasters(0, rowArray);
        this.getQueryCollection().setPinned(true);
        RowFilter rowFilter = this.getQueryCollection().getRowFilter();
        return rowFilter == null ? null : rowFilter.getWhereClauseParams();
    }

    public boolean doesRowFilterMatch(Row[] rowArray, Object[] objectArray) {
        RowFilter rowFilter = this.getRowFilter(rowArray);
        RowFilter rowFilter2 = this.getViewObjectImpl().buildRowFilter(objectArray);
        return rowFilter.equals(rowFilter2);
    }

    public Object[] refreshCollection(Row[] rowArray, boolean bl, boolean bl2) {
        RowFilter rowFilter = this.getRowFilter(rowArray);
        QueryCollection queryCollection = this.mQRef.getCachedQueryCollection(rowFilter);
        this.mExecuted = queryCollection != null ? queryCollection.isExecuted() : false;
        if (!this.mExecuted) {
            this.execute(false, true, true, true, false, rowArray);
        } else {
            this.mQC = queryCollection;
            this.mNotifiedRefresh = false;
            this.notifyRefresh(bl, bl2, bl2, false, rowArray);
        }
        this.mQC.setPinned(true);
        return rowFilter == null ? null : rowFilter.getWhereClauseParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeQueryForMasters(int n, Row[] rowArray) {
        Object object = this.getSyncLock();
        synchronized (object) {
            ViewObjectImpl viewObjectImpl = this.getViewObjectImpl();
            int n2 = viewObjectImpl.getQueryMode();
            try {
                if (n != 0) {
                    viewObjectImpl.setQueryMode(n);
                }
                this.execute(true, true, true, true, false, rowArray);
                Object var7_6 = null;
                if (n != 0) {
                    viewObjectImpl.setQueryMode(n2);
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (n != 0) {
                    viewObjectImpl.setQueryMode(n2);
                }
                throw throwable;
            }
        }
    }

    public void executeEmptyRowSet() {
        this.execute(true, true, true, true, true, null);
    }

    public RowSetIterator createRowSetIterator(String string) {
        return this.createViewRowSetIterator(string, false);
    }

    ViewRowSetIteratorImpl createNewRowSetIterator(String string, boolean bl) {
        return new ViewRowSetIteratorImpl(this, string, bl);
    }

    ViewRowSetIteratorImpl createViewRowSetIterator(String string, boolean bl) {
        boolean bl2;
        if (this.mAccessMode != 0 && this.mViews.size() > 0) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25011", new Object[]{this.getName()});
        }
        boolean bl3 = bl2 = string == null || string.equals("");
        while (true) {
            if (bl2) {
                string = this.getName() + "_Iterator" + this.mRowSetIteratorId++;
            }
            if (!MetaObjectManager.getSingleton().is323Compatible() && !JboNameUtil.isNameValid(string)) {
                throw new InvalidObjNameException(113, string);
            }
            if (this.findRowSetIterator(string) == null) break;
            if (!bl2 && !bl) {
                throw new NameClashException(113, string);
            }
            if (!bl) continue;
            bl2 = true;
        }
        ViewRowSetIteratorImpl viewRowSetIteratorImpl = this.createNewRowSetIterator(string, bl);
        viewRowSetIteratorImpl.setNameGenerated(bl2);
        return viewRowSetIteratorImpl;
    }

    public void setCollectionForRowFilter(Object[] objectArray, byte by) {
        byte by2 = this.getViewLinkMode();
        boolean bl = this.isAssociationConsistent();
        boolean bl2 = false;
        QueryCollection queryCollection = null;
        QueryCollection queryCollection2 = null;
        try {
            this.setViewLinkMode(by);
            bl2 = this.isAssociationConsistent();
            ViewObjectImpl viewObjectImpl = this.getViewObjectImpl();
            if (viewObjectImpl.getViewLinkDestinationAttributes() != null && objectArray != null && objectArray.length > 0) {
                RowFilter rowFilter = viewObjectImpl.buildRowFilter(objectArray);
                queryCollection = this.getQueryCollection();
                boolean bl3 = this.initAndRegisterQC(false, false, rowFilter);
                queryCollection2 = this.getQueryCollection();
                if (queryCollection != queryCollection2 && queryCollection != null) {
                    queryCollection.setAssociationConsistent(bl);
                }
            }
            Object var12_11 = null;
            this.setViewLinkMode(by2);
            if (queryCollection != queryCollection2 && queryCollection2 != null) {
                queryCollection2.setAssociationConsistent(bl2);
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.setViewLinkMode(by2);
            if (queryCollection != queryCollection2 && queryCollection2 != null) {
                queryCollection2.setAssociationConsistent(bl2);
            }
            throw throwable;
        }
    }

    public RowSetIterator[] getRowSetIterators() {
        Object[] objectArray = new RowSetIterator[this.mViews.size()];
        return (RowSetIterator[])this.mViews.toArray(objectArray);
    }

    public RowSetIterator findRowSetIterator(String string) {
        if (string == null || string.length() == 0) {
            return this.getRowSetIterator();
        }
        if (!MetaObjectManager.getSingleton().is323Compatible() && !JboNameUtil.isNameValid(string)) {
            throw new InvalidObjNameException(113, string);
        }
        ViewRowSetIteratorImpl viewRowSetIteratorImpl = (ViewRowSetIteratorImpl)this.mViewMap.get((Object)string);
        return viewRowSetIteratorImpl != null ? viewRowSetIteratorImpl.getRowSetIterator() : null;
    }

    public boolean isExecuted() {
        this.activateIteratorState(null, true);
        return this.mExecuted;
    }

    void setExecuted() {
        this.mExecuted = true;
        this.mExecuteMaster = false;
    }

    void resetExecuted() {
        this.mExecuted = false;
        this.mNotifiedRefresh = false;
    }

    public final QueryCollection getQueryCollection() {
        return this.mQC;
    }

    void setQueryCollection(QueryCollection queryCollection) {
        this.mQC = queryCollection;
    }

    public void setOwnedByQC(boolean bl) {
        this.mIsOwnedByQC = bl;
    }

    public boolean hasDefaultRowSetIterator() {
        return this.mDefaultView != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewRowSetIteratorImpl getDefaultRowSetIterator() {
        if (this.mDefaultView == null) {
            Object object = this.getSyncLock();
            synchronized (object) {
                if (this.mDefaultView == null) {
                    this.mDefaultView = this.createViewRowSetIterator(this.getName(), true);
                }
            }
        }
        return this.mDefaultView;
    }

    ViewObjectImpl getViewObjectImpl() {
        return this.mQRef;
    }

    void addViewRowSetIteratorImpl(ViewRowSetIteratorImpl viewRowSetIteratorImpl) {
        if (!this.mViews.contains((Object)viewRowSetIteratorImpl)) {
            this.mViews.add((Object)viewRowSetIteratorImpl);
            if (viewRowSetIteratorImpl.getName() == null) {
                Integer n = new Integer(this.mViews.size());
                viewRowSetIteratorImpl.setName(this.getName() + "_Iterator" + n.toString());
            }
            this.mViewMap.put((Object)viewRowSetIteratorImpl.getName(), (Object)viewRowSetIteratorImpl);
        }
    }

    public void addListener(Object object) {
        this.getDefaultRowSetIterator().addListener(object);
    }

    public void removeListener(Object object) {
        if (this.mDefaultView != null) {
            this.getDefaultRowSetIterator().removeListener(object);
        }
    }

    public void addManagementListener(RowSetManagementListener rowSetManagementListener) {
        this.getDefaultRowSetIterator().addManagementListener(rowSetManagementListener);
    }

    public void removeManagementListener(RowSetManagementListener rowSetManagementListener) {
        if (this.mDefaultView != null) {
            this.getDefaultRowSetIterator().removeManagementListener(rowSetManagementListener);
        }
    }

    public void addRowSetManagementListener(RowSetManagementListener rowSetManagementListener) {
        super.addManagementListener(rowSetManagementListener);
    }

    public void removeRowSetManagementListener(RowSetManagementListener rowSetManagementListener) {
        super.removeManagementListener(rowSetManagementListener);
    }

    void removeViewRowSetIteratorImpl(ViewRowSetIteratorImpl viewRowSetIteratorImpl) {
        if (this.mViews.contains((Object)viewRowSetIteratorImpl)) {
            if (this.mDefaultView == viewRowSetIteratorImpl) {
                this.mDefaultView = null;
            }
            this.mViews.remove((Object)viewRowSetIteratorImpl);
            this.mViewMap.remove((Object)viewRowSetIteratorImpl.getName());
            this.removeListener(viewRowSetIteratorImpl);
        }
    }

    public ArrayList getMasterViewRowSetIteratorsList() {
        return this.mMasterViews;
    }

    public Vector getMasterViewRowSetIterators() {
        return JboEnvUtil.convertArrayListToVector(this.mMasterViews);
    }

    private int getMasterRSIIndex(int n, ViewDefImpl viewDefImpl) {
        ArrayList arrayList = this.mQRef.getViewLinksForSourceAttributes();
        ViewLinkImpl viewLinkImpl = (ViewLinkImpl)arrayList.get(n);
        int n2 = 0;
        while (n2 < this.mMasterViews.size()) {
            ViewRowSetIteratorImpl viewRowSetIteratorImpl = (ViewRowSetIteratorImpl)this.mMasterViews.get(n2);
            if (viewRowSetIteratorImpl.getRowSet().getViewObject() == viewLinkImpl.getSource()) {
                return n2;
            }
            ++n2;
        }
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetImpl.class$("oracle.jbo.CSMessageBundle");
        }
        throw new NoObjException(clazz, "25037", new Object[]{this.getName(), viewLinkImpl.getName(), viewLinkImpl.getSource().getName()});
    }

    public boolean setMasterRowSetIterator(RowSetIterator rowSetIterator) {
        return this.setMasterRSI(rowSetIterator, true);
    }

    boolean setMasterRSI(RowSetIterator rowSetIterator, boolean bl) {
        boolean bl2 = false;
        ViewLink viewLink = this.findViewLinkForMasterViewRowSet(rowSetIterator = ViewObjectImpl.getImplObject(rowSetIterator));
        if (viewLink == null) {
            return false;
        }
        if (!this.mMasterViews.contains((Object)rowSetIterator)) {
            int n = 0;
            while (n < this.mMasterViews.size()) {
                if (((RowSetIterator)this.mMasterViews.get(n)).getRowSet().getViewObject() == rowSetIterator.getRowSet().getViewObject()) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
            if (bl2) {
                if (bl) {
                    ((ViewRowSetIteratorImpl)this.mMasterViews.get(n)).removeDetailViewRowSet(this.getRowSet());
                    this.mMasterViews.set(n, (Object)rowSetIterator);
                    ((ViewRowSetIteratorImpl)rowSetIterator).addDetailViewRowSet(this.getRowSet());
                }
            } else {
                this.mMasterViews.add((Object)rowSetIterator);
                ((ViewRowSetIteratorImpl)rowSetIterator).addDetailViewRowSet(this.getRowSet());
            }
            if (bl2 && bl) {
                this.notifyRefresh(true, true, true, true, null);
            }
        }
        return true;
    }

    public boolean removeMasterRowSetIterator(RowSetIterator rowSetIterator) {
        if (this.mMasterViews.contains((Object)(rowSetIterator = ViewObjectImpl.getImplObject(rowSetIterator)))) {
            ((ViewRowSetIteratorImpl)rowSetIterator).removeDetailViewRowSet(this.getRowSet());
            this.mMasterViews.remove((Object)rowSetIterator);
        }
        return true;
    }

    void removeUnusedMasterRowSetIterators(ViewLink viewLink) {
        ViewLink[] viewLinkArray = this.getViewObjectImpl().getViewLinks();
        int n = 0;
        while (n < this.mMasterViews.size()) {
            ViewRowSetIteratorImpl viewRowSetIteratorImpl = (ViewRowSetIteratorImpl)this.mMasterViews.get(n);
            int n2 = 0;
            while (n2 < viewLinkArray.length) {
                if (viewLinkArray[n2] != viewLink && viewRowSetIteratorImpl.getRowSet().getViewObject() == viewLinkArray[n2].getSource()) break;
                ++n2;
            }
            if (n2 >= viewLinkArray.length) {
                this.mMasterViews.remove(n);
                viewRowSetIteratorImpl.removeDetailViewRowSet(this.getRowSet());
                continue;
            }
            ++n;
        }
    }

    void notifyRowDeleted(Row row, int n, boolean bl, boolean bl2) {
        int n2 = 0;
        while (n2 < this.mViews.size()) {
            ((ViewRowSetIteratorImpl)this.mViews.get(n2)).notifyRowDeleted(row, n, bl, bl2);
            ++n2;
        }
    }

    void notifyRowInserted(Row row, int n, boolean bl, boolean bl2) {
        int n2 = 0;
        while (n2 < this.mViews.size()) {
            ((ViewRowSetIteratorImpl)this.mViews.get(n2)).notifyRowInserted(row, n, bl, bl2);
            ++n2;
        }
    }

    void notifyRowUpdated(Row[] rowArray, int[] nArray) {
        int n = 0;
        while (n < this.mViews.size()) {
            ((ViewRowSetIteratorImpl)this.mViews.get(n)).notifyRowUpdated(rowArray, nArray);
            ++n;
        }
    }

    void notifyQueryCollectionChanged(QueryCollection queryCollection) {
        this.mQC = queryCollection;
        this.mNotifiedRefresh = false;
        this.notifyRefresh(true, true, true, true, null);
    }

    public boolean isDirty() {
        return this.mQC.isDirty();
    }

    protected boolean isNotifiedRefresh() {
        if (this.mQRef.isQueryChanged()) {
            this.mNotifiedRefresh = false;
        }
        return this.mNotifiedRefresh;
    }

    public ViewRowImpl makeRowCopy(ViewRowImpl viewRowImpl) {
        Object[] objectArray;
        ViewRowImpl viewRowImpl2;
        ViewObject viewObject = viewRowImpl.getViewObject();
        EntityImpl[] entityImplArray = viewRowImpl.getEntities();
        if (viewObject != null && viewObject == this.mQRef) {
            viewRowImpl2 = (ViewRowImpl)this.createRowWithEntities(null, entityImplArray, this.getRowInitValues(null));
        } else {
            int n = this.mQRef.getEntityDefCount();
            EntityImpl[] entityImplArray2 = null;
            boolean bl = false;
            if (((ViewObjectImpl)viewObject).getViewDef() == this.mQRef.getViewDef()) {
                bl = true;
                entityImplArray2 = entityImplArray;
            } else {
                entityImplArray2 = new EntityImpl[n];
                int n2 = 0;
                while (entityImplArray != null && n2 < entityImplArray.length) {
                    int n3 = 0;
                    while (entityImplArray[n2] != null && n3 < n) {
                        if (entityImplArray2[n3] == null && this.mQRef.getEntityDef(n3).isBaseDefFor(entityImplArray[n2].getEntityDef())) {
                            entityImplArray2[n3] = entityImplArray[n2];
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    entityImplArray[n2] = null;
                    ++n2;
                }
            }
            if (n > 0 && !bl) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "26020", null);
            }
            viewRowImpl2 = entityImplArray2 == entityImplArray ? this.mQRef.getViewDef().createBlankInstance(null, entityImplArray2, this.mQRef, this.getQueryCollection(), null, null, false) : (ViewRowImpl)this.createRowWithEntities(null, entityImplArray2, this.getRowInitValues(null));
        }
        if (viewObject != null && this.mQRef != null && ((ViewObjectImpl)viewObject).getViewDef() == this.mQRef.getViewDef() && (objectArray = viewRowImpl.getCalcAttrs()) != null && objectArray.length > 0) {
            Object[] objectArray2 = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            viewRowImpl2.setCalcAttrs(objectArray2);
        }
        return viewRowImpl2;
    }

    int insertViewRowAt(int n, ViewRowImpl viewRowImpl) {
        int n2;
        if (this.isAssociationConsistent() && viewRowImpl.getQueryCollection() == this.mQC && viewRowImpl.getPostState() != 3 && (n2 = this.mQC.removeNewViewRow(viewRowImpl)) > -1 && n > n2) {
            --n;
        }
        this.insertRowAtInternal(n, viewRowImpl, true, true);
        return !this.isRangePaging() ? n : this.mQC.mPageStart + n;
    }

    Row insertRowAtInternal(int n, Row row, boolean bl, boolean bl2) {
        this.mHasStateToPassivate = true;
        ViewRowImpl viewRowImpl = (ViewRowImpl)row;
        this.ensureStorage();
        if (viewRowImpl.getQueryCollection() != this.mQC) {
            row = this.makeRowCopy(viewRowImpl);
        }
        if (!(this.isExecuted() || n <= this.mQC.getFetchedRowCount() && this.mQRef.getMaxFetchSize() != 0)) {
            this.execute(false, false);
        }
        if (!this.isForwardOnly() || bl2) {
            this.mQC.add(n, row, bl, bl2);
        }
        if (this.isPassivationEnabled() && this.mQRef.isInternal()) {
            viewRowImpl = (ViewRowImpl)row;
            int[] nArray = this.mQRef.getInsertParticipants();
            EntityImpl[] entityImplArray = viewRowImpl.getEntities();
            boolean bl3 = false;
            boolean bl4 = false;
            if (nArray != null && entityImplArray != null && nArray.length > 0) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    EntityImpl entityImpl;
                    if (entityImplArray.length > nArray[n2] && (entityImpl = entityImplArray[nArray[n2]]) != null) {
                        byte by = entityImpl.getPostState();
                        switch (by) {
                            case 0: {
                                bl3 = true;
                                break;
                            }
                            case -1: {
                                bl4 = true;
                            }
                        }
                    }
                    ++n2;
                }
            } else {
                bl3 = true;
            }
            if (bl3 || bl4) {
                this.mQRef.addNewRowTracker(this.mQC, viewRowImpl, n, bl4);
            }
        }
        return row;
    }

    public void insertRowAt(int n, Row row) {
        this.insertViewRowAt(n, (ViewRowImpl)row);
    }

    public void removeRowAt(int n) {
        this.mQC.remove(n);
    }

    public void removeRowFromCollectionAt(int n) {
        this.mQC.removeFromCollection(n);
    }

    public void removeRowAndRetainAt(int n) {
        this.mQC.removeAndRetain(n);
    }

    Row createRowWithEntities(int[] nArray, EntityImpl[] entityImplArray, AttributeList attributeList) {
        this.ensureStorage();
        return this.mQC.createRowWithEntities(nArray, entityImplArray, this, attributeList);
    }

    public Row createAndInitRow(AttributeList attributeList) {
        return this.doCreateAndInitRow(attributeList);
    }

    public Row createRow() {
        return this.doCreateAndInitRow(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Row doCreateAndInitRow(AttributeList attributeList) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            this.ensureStorage();
            if (this.mQRef.isReadOnly()) {
                throw new ReadOnlyViewObjectException(this.mQRef.getName());
            }
            Row row = this.createRowWithEntities(null, null, this.getRowInitValues(attributeList));
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (!this.isExecuted()) {
                this.execute(false, false);
            }
            int n = this.mQC == null ? 0 : this.mQC.getRowCount();
            return n;
        }
    }

    public int getEstimatedRangePageCount() {
        return this.getDefaultRowSetIterator().getEstimatedRangePageCount();
    }

    public long getEstimatedRowCount() {
        if (this.mQC == null) {
            RowFilter rowFilter = this.getRowFilter(null);
            this.initQueryCollection(false, rowFilter);
            this.mQRef.updateQueryCollectionCache(this.mQC, rowFilter, true);
        }
        return this.mQC.getEstimatedRowCount(this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDetailEstimatedRowCount(Row[] rowArray) {
        Object object = this.getSyncLock();
        synchronized (object) {
            RowFilter rowFilter = this.getRowFilter(rowArray);
            QueryCollection queryCollection = this.mQRef.getCachedQueryCollection(rowFilter);
            if (queryCollection == null) {
                queryCollection = new QueryCollection(this);
                queryCollection.setAssociationConsistent(this.isAssociationConsistent());
                queryCollection.setRowFilter(rowFilter, this.mExecuteUserParams.size());
                this.mQRef.updateQueryCollectionCache(queryCollection, rowFilter, false);
            }
            long l = queryCollection.getEstimatedRowCount(this, rowArray);
            return l;
        }
    }

    private void initMasterViews(RowSetIterator rowSetIterator) {
        if (rowSetIterator != null) {
            this.setMasterRowSetIterator(rowSetIterator);
            return;
        }
        ViewLink[] viewLinkArray = this.mQRef.getViewLinks();
        int n = 0;
        while (n < viewLinkArray.length) {
            if (viewLinkArray[n].getDestination() == this.mQRef) {
                try {
                    ViewRowSetIteratorImpl viewRowSetIteratorImpl = ((ViewObjectImpl)viewLinkArray[n].getSource()).getDefaultRowSet().getDefaultRowSetIterator();
                    this.setMasterRowSetIterator(viewRowSetIteratorImpl);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
    }

    void refresh(boolean bl, boolean bl2) {
        this.getDefaultRowSetIterator().refresh(bl, bl2);
    }

    void notifyRefresh(boolean bl, boolean bl2, boolean bl3, boolean bl4, Row[] rowArray) {
        if (this.mNotifiedRefresh) {
            return;
        }
        this.mNotifiedRefresh = true;
        if (bl) {
            int n = 0;
            while (n < this.mViews.size()) {
                ((ViewRowSetIteratorImpl)this.mViews.get(n)).refresh(true, false, false, false, rowArray);
                ++n;
            }
        }
        if (bl2) {
            int n = 0;
            while (n < this.mViews.size()) {
                ((ViewRowSetIteratorImpl)this.mViews.get(n)).refresh(false, true, false, false, rowArray);
                ++n;
            }
        }
        if (bl3) {
            int n = 0;
            while (n < this.mViews.size()) {
                ((ViewRowSetIteratorImpl)this.mViews.get(n)).refresh(false, false, true, bl4, rowArray);
                ++n;
            }
        }
    }

    public RowSetIterator[] getMasterRowSetIterators() {
        ArrayList arrayList = this.getMasterViewRowSetIteratorsList();
        RowSetIterator[] rowSetIteratorArray = new RowSetIterator[arrayList.size()];
        int n = 0;
        while (n < rowSetIteratorArray.length) {
            ViewRowSetIteratorImpl viewRowSetIteratorImpl = (ViewRowSetIteratorImpl)arrayList.get(n);
            rowSetIteratorArray[n] = viewRowSetIteratorImpl.getRowSetIterator();
            ++n;
        }
        return rowSetIteratorArray;
    }

    public ApplicationModule getApplicationModule() {
        return this.getViewObjectImpl().getApplicationModule();
    }

    public ViewObject getViewObject() {
        return this.getViewObjectImpl();
    }

    public RowSet getRowSet() {
        if (this.mIsDefaultRS) {
            return this.getViewObjectImpl().getRowSet();
        }
        return this;
    }

    public RowSetIterator getRowSetIterator() {
        if (this.mIsDefaultRS) {
            return this.getViewObjectImpl().getRowSetIterator();
        }
        return this;
    }

    public Object[] getRowFilterValues() {
        if (this.mDefaultView == null) {
            return null;
        }
        return this.getDefaultRowSetIterator().getRowFilterValues();
    }

    public void setRowFilterValues(Object[] objectArray) {
        if (this.mDefaultView != null) {
            this.getDefaultRowSetIterator().setRowFilterValues(objectArray);
        }
    }

    public SvcMsgIteratorState getCliIteratorState() {
        return null;
    }

    public void prepareForBatchMode(SvcMsgIteratorState svcMsgIteratorState, boolean bl) {
        if (this.mDefaultView != null) {
            this.getDefaultRowSetIterator().prepareForBatchMode(svcMsgIteratorState, bl);
        }
    }

    public int setRangeSize(int n) {
        return this.getDefaultRowSetIterator().setRangeSize(n);
    }

    public int getRangeSize() {
        if (this.mDefaultView == null) {
            return 1;
        }
        return this.getDefaultRowSetIterator().getRangeSize();
    }

    public int getRangeStart() {
        if (this.mDefaultView == null) {
            return -1;
        }
        return this.getDefaultRowSetIterator().getRangeStart();
    }

    public int setRangeStart(int n) {
        return this.getDefaultRowSetIterator().setRangeStart(n);
    }

    public int scrollRange(int n) {
        return this.getDefaultRowSetIterator().scrollRange(n);
    }

    public int scrollToRangePage(int n) {
        return this.getDefaultRowSetIterator().scrollToRangePage(n);
    }

    public int scrollRangeTo(Row row, int n) {
        return this.getDefaultRowSetIterator().scrollRangeTo(row, n);
    }

    public Row[] getAllRowsInRange() {
        return this.getDefaultRowSetIterator().getAllRowsInRange();
    }

    public Row[] getNextRangeSet() {
        return this.getDefaultRowSetIterator().getNextRangeSet();
    }

    public Row[] getPreviousRangeSet() {
        return this.getDefaultRowSetIterator().getPreviousRangeSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration enumerateRowsInRange() {
        Object object = this.getSyncLock();
        synchronized (object) {
            Enumeration enumeration = this.getDefaultRowSetIterator().enumerateRowsInRange();
            return enumeration;
        }
    }

    public int getFetchedRowCount() {
        return this.getDefaultRowSetIterator().getFetchedRowCount();
    }

    public boolean isRangeAtBottom() {
        return this.getDefaultRowSetIterator().isRangeAtBottom();
    }

    public boolean isRangeAtTop() {
        return this.getDefaultRowSetIterator().isRangeAtTop();
    }

    public void insertRow(Row row) {
        this.getDefaultRowSetIterator().insertRow(row);
    }

    public void insertRowAtRangeIndex(int n, Row row) {
        this.getDefaultRowSetIterator().insertRowAtRangeIndex(n, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row getRowFromHandle(Object object) {
        Object var2_2 = null;
        Object object2 = this.getSyncLock();
        synchronized (object2) {
            QueryCollection queryCollection = this.getQueryCollection();
            if (queryCollection == null) {
                throw new RowNotFoundException(this, object);
            }
            ViewRowStorage viewRowStorage = queryCollection.getRowStorageFromId(((Integer)object).intValue());
            if (viewRowStorage != null) {
                ViewRowImpl viewRowImpl = viewRowStorage.getRowImpl();
                return viewRowImpl;
            }
        }
        return null;
    }

    public void removeRowHandle(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row getRow(Key key) {
        Row row;
        Object object;
        if (key != null && (object = key.getRowHandle()) != null && this.mQRef.getSignature() == key.getSignature() && (row = this.getRowFromHandle(object)) != null && key.equals(row.getKey())) {
            return row;
        }
        if (this.getFetchedRowCount() > 0) {
            int n = 0;
            while ((row = this.getRow(n)) != null) {
                if (key == null || row.getKey().equals(key)) {
                    return row;
                }
                ++n;
            }
        }
        if (!this.isExecuted()) {
            Object object2 = this.getSyncLock();
            synchronized (object2) {
                this.execute(false, false);
            }
        }
        int n = 0;
        while ((row = this.getRow(n)) != null) {
            if (key == null || row.getKey().equals(key)) {
                return row;
            }
            ++n;
        }
        return null;
    }

    public int getRangeIndexOf(Row row) {
        return this.getDefaultRowSetIterator().getRangeIndexOf(row);
    }

    public void removeCurrentRow() {
        this.getDefaultRowSetIterator().removeCurrentRow();
    }

    public void removeCurrentRowFromCollection() {
        this.getDefaultRowSetIterator().removeCurrentRowFromCollection();
    }

    public Row removeCurrentRowAndRetain() {
        return this.getDefaultRowSetIterator().removeCurrentRowAndRetain();
    }

    public void setRowValidation(boolean bl) {
        this.getDefaultRowSetIterator().setRowValidation(bl);
    }

    public boolean isRowValidation() {
        return this.getDefaultRowSetIterator().isRowValidation();
    }

    public boolean setCurrentRow(Row row) {
        return this.getDefaultRowSetIterator().setCurrentRow(row);
    }

    public boolean setCurrentRowAtRangeIndex(int n) {
        return this.getDefaultRowSetIterator().setCurrentRowAtRangeIndex(n);
    }

    public Row getCurrentRow() {
        return this.getDefaultRowSetIterator().getCurrentRow();
    }

    public int getCurrentRowIndex() {
        return this.getDefaultRowSetIterator().getCurrentRowIndex();
    }

    public int getCurrentRowSlot() {
        return this.getDefaultRowSetIterator().getCurrentRowSlot();
    }

    public int getIterMode() {
        return this.getDefaultRowSetIterator().getIterMode();
    }

    public void setIterMode(int n) {
        this.getDefaultRowSetIterator().setIterMode(n);
    }

    public boolean hasNext() {
        return this.getDefaultRowSetIterator().hasNext();
    }

    public boolean hasPrevious() {
        return this.getDefaultRowSetIterator().hasPrevious();
    }

    public Row first() {
        return this.getDefaultRowSetIterator().first();
    }

    public Row last() {
        return this.getDefaultRowSetIterator().last();
    }

    public Row next() {
        return this.getDefaultRowSetIterator().next();
    }

    public Row previous() {
        return this.getDefaultRowSetIterator().previous();
    }

    public void reset() {
        this.getDefaultRowSetIterator().reset();
    }

    public RowSet[] getDetailRowSets() {
        return this.mDefaultView != null ? this.getDefaultRowSetIterator().getDetailRowSets() : new RowSet[]{};
    }

    public RowSet createDetailRowSet(String string, String string2) {
        return this.getDefaultRowSetIterator().createDetailRowSet(string, string2);
    }

    public void setForwardOnly(boolean bl) {
        if (this.isForwardOnly() != bl) {
            if (this.mViews.size() > 1) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "25011", new Object[]{this.getName()});
            }
            if (bl) {
                this.setRangeSize(1);
            }
            byte by = this.mAccessMode = bl ? (byte)1 : 0;
            if (this.mQC != null) {
                this.mQC.setAccessMode(this.mAccessMode);
            }
            this.resetExecuted();
            this.mHasStateToPassivate = true;
            this.notifyRefresh(true, false, false, true, null);
        }
    }

    public final boolean isForwardOnly() {
        return this.mAccessMode == 1;
    }

    public final boolean isRangePaging() {
        return this.mAccessMode == 2 || this.mAccessMode == 3;
    }

    public final boolean isScrollable() {
        return this.mAccessMode == 0;
    }

    public final byte getAccessMode() {
        return this.mAccessMode;
    }

    public void setAccessMode(byte by) {
        if (this.mAccessMode != by) {
            boolean bl = this.isRangePaging();
            if (this.mViews.size() > 1) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "25011", new Object[]{this.getName()});
            }
            this.mAccessMode = by;
            if (this.mQC != null) {
                if (bl != this.isRangePaging()) {
                    this.mQRef.clearQueryCollectionCache();
                    this.mQRef.closeStatements();
                    this.initQueryCollection(true, this.mQC.getRowFilter());
                } else {
                    this.mQC.setAccessMode(by);
                }
            }
            this.resetExecuted();
            this.mHasStateToPassivate = true;
            this.notifyRefresh(true, false, false, true, null);
        }
    }

    public byte getViewLinkMode() {
        return this.mViewLinkMode;
    }

    public void setViewLinkMode(byte by) {
        if (by == 1 && this.mQRef.getEntityDefCount() == 0) {
            Diagnostic.println("Warning! Ignore setting ViewLink mode on non-entity collection.");
            return;
        }
        this.mHasStateToPassivate = true;
        this.mViewLinkMode = by;
        if (this.getQueryCollection() != null) {
            this.getQueryCollection().setAssociationConsistent(this.isAssociationConsistent());
        }
    }

    public void setAssociationConsistent(boolean bl) {
        if (bl && this.mQRef.getEntityDefCount() == 0) {
            Diagnostic.println("Warning! Ignore setting Association Consistent on non-entity collection.");
            return;
        }
        this.mHasStateToPassivate = true;
        byte by = this.mViewLinkMode = bl ? (byte)1 : 0;
        if (this.getQueryCollection() != null) {
            this.getQueryCollection().setAssociationConsistent(bl);
        }
    }

    public final boolean isMaxFetchSizeExceeded() {
        boolean bl = false;
        if (this.getQueryCollection() != null) {
            bl = this.getQueryCollection().isMaxFetchSizeExceeded();
        }
        return bl;
    }

    public boolean isFetchComplete() {
        boolean bl = false;
        if (this.getQueryCollection() != null) {
            bl = this.getQueryCollection().isFetchComplete();
        }
        return bl;
    }

    public boolean isAssociationConsistent() {
        return this.mAccessMode != 1 ? (this.mViewLinkMode == 2 ? this.mQRef.isDefaultAssocConsistent() : this.mViewLinkMode == 1) : false;
    }

    void resetQC() {
        this.resetExecuted();
        this.mQC = null;
    }

    void resetIterators() {
        int n = 0;
        while (n < this.mViews.size()) {
            ViewRowSetIteratorImpl viewRowSetIteratorImpl = (ViewRowSetIteratorImpl)this.mViews.get(n);
            viewRowSetIteratorImpl.refresh(true, false);
            viewRowSetIteratorImpl.notifyIteratorReset();
            ++n;
        }
    }

    public int getRowCountInRange() {
        return this.getDefaultRowSetIterator().getRowCountInRange();
    }

    public void setWhereClauseParams(Object[] objectArray) {
        this.mHasStateToPassivate = true;
        this.mParamsChanged = true;
        this.mUserParams.clear();
        this.mWhereParams.clear();
        this.getWhereClauseParamsFromVars();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.setWhereClauseParam(n, objectArray[n]);
                ++n;
            }
        }
    }

    public void setExecuteParameters(Object[] objectArray, Object[] objectArray2, boolean bl) {
        if (this.mExecuteUserParams != null) {
            this.mExecuteUserParams.clear();
        } else {
            this.mExecuteUserParams = new ArrayList(objectArray != null && objectArray.length > 0 ? objectArray.length : 2);
        }
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.mExecuteUserParams.add(objectArray[n]);
                ++n;
            }
        }
        this.mExecuteParamValues = objectArray2;
        if (!bl) {
            this.mParamValues = objectArray2;
            this.mUserParams = (ArrayList)this.mExecuteUserParams.clone();
            this.mWhereParams = (ArrayList)this.mExecuteUserParams.clone();
        }
    }

    public void setWhereClauseParam(int n, Object object) {
        if (n >= this.mUserParams.size()) {
            JboEnvUtil.setSizeInArrayList(this.mUserParams, n + 1);
        }
        this.mUserParams.set(n, object);
        this.doSetWhereClauseParam(n, null, object);
    }

    public void setNamedWhereClauseParams(AttributeList attributeList) {
        String[] stringArray = attributeList.getAttributeNames();
        Object[] objectArray = attributeList.getAttributeValues();
        int n = 0;
        while (n < stringArray.length) {
            this.setNamedWhereClauseParam(stringArray[n], objectArray[n]);
            ++n;
        }
    }

    public AttributeList getNamedWhereClauseParams() {
        VariableValueManager variableValueManager = this.getViewObjectImpl().ensureVariableManager();
        Variable[] variableArray = variableValueManager.getVariables();
        Object[] objectArray = new Object[variableArray.length];
        String[] stringArray = new String[variableArray.length];
        int n = 0;
        while (n < variableArray.length) {
            stringArray[n] = variableArray[n].getName();
            objectArray[n] = this.getNamedWhereClauseParam(stringArray[n]);
            ++n;
        }
        return new NameValuePairs(stringArray, objectArray);
    }

    void doSetWhereClauseParam(int n, String string, Object object) {
        this.mHasStateToPassivate = true;
        this.mParamsChanged = true;
        if (this.getViewObjectImpl().getBindingStyle() != 2) {
            if (n >= this.mWhereParams.size()) {
                JboEnvUtil.setSizeInArrayList(this.mWhereParams, n + 1);
            }
            this.mWhereParams.set(n, object);
        } else {
            if (string == null) {
                string = Integer.toString(n + 1);
            }
            n = -1;
            int n2 = 0;
            while (n2 < this.mWhereParams.size()) {
                Object[] objectArray = (Object[])this.mWhereParams.get(n2);
                if (objectArray != null && string.equals(objectArray[0])) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n >= 0) {
                this.mWhereParams.set(n, (Object)new Object[]{string, object});
            } else {
                this.mWhereParams.add((Object)new Object[]{string, object});
            }
        }
    }

    public void refreshWhereClauseParams() {
        this.setWhereClauseParams(this.mUserParams.toArray());
    }

    public void defineNamedWhereClauseParam(String string, Object object, int[] nArray) {
        VariableValueManager variableValueManager = this.getViewObjectImpl().ensureVariableManager();
        Variable variable = variableValueManager.lookupVariable(string);
        boolean bl = false;
        if (variable != null) {
            VariableManager variableManager = variable.getVariableManager();
            if (variableManager.getVarMgrOwner() != this.getViewObjectImpl()) {
                variable = null;
            } else {
                String string2 = variable.getVariableKind();
                if (string2 == null || string2.equals("where")) {
                    if (string2 == null) {
                        variable.setVariableKind("where");
                    }
                    variable.setExtendedData(nArray);
                    variable.setDefaultValue(object);
                } else {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new InvalidParamException(clazz, "25064", new Object[]{this.getName(), string, string2});
                }
            }
            bl = true;
        }
        if (variable == null) {
            variable = variableValueManager.addVariable(string);
            variable.setVariableKind("where");
            variable.setExtendedData(nArray);
            variable.setDefaultValue(object);
        }
        if (bl) {
            this.refreshWhereClauseParams();
        } else {
            this.convertNamedWhereClauseParam(variable, object);
        }
    }

    public void removeNamedWhereClauseParam(String string) {
        VariableValueManager variableValueManager = this.getViewObjectImpl().getVariableManager();
        if (variableValueManager == null) {
            throw new NoDefException(132, string, this.getName());
        }
        Variable variable = variableValueManager.findVariable(string);
        VariableManager variableManager = variable.getVariableManager();
        VariableManagerOwner variableManagerOwner = variableManager.getVarMgrOwner();
        if (variableManagerOwner != this.getViewObjectImpl()) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25065", new Object[]{string, this.getViewObjectImpl().getName(), variableManagerOwner.getClass().getName()});
        }
        if (!"where".equals(variable.getVariableKind())) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidParamException(clazz, "25064", new Object[]{this.getName(), string, variable.getVariableKind()});
        }
        variableManager.removeVariable(string);
        this.refreshWhereClauseParams();
    }

    public Object getNamedWhereClauseParam(String string) {
        VariableValueManager variableValueManager = this.ensureVariableManager();
        Variable variable = variableValueManager.findVariable(string);
        String string2 = variable.getVariableKind();
        if (string2 == null || !string2.equals("where")) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidParamException(clazz, "25064", new Object[]{this.getName(), string, string2});
        }
        return variableValueManager.getVariableValue(variable);
    }

    public void setNamedWhereClauseParam(String string, Object object) {
        VariableValueManager variableValueManager = this.ensureVariableManager();
        Variable variable = variableValueManager.findVariable(string);
        String string2 = variable.getVariableKind();
        if (string2 == null || !string2.equals("where")) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidParamException(clazz, "25064", new Object[]{this.getName(), string, string2});
        }
        variableValueManager.setVariableValue(variable, object);
    }

    public void skipNamedWhereClauseParam(String string) {
        this.setNamedWhereClauseParam(string, new WhereClauseParamNoValue());
        this.refreshWhereClauseParams();
    }

    public Object[] getWhereClauseParams() {
        return this.getWhereClauseParamArray().toArray();
    }

    private final ArrayList getWhereClauseParamArray() {
        return this.mWhereParams;
    }

    /*
     * Unable to fully structure code
     */
    private final void convertNamedWhereClauseParam(Variable var1_1, Object var2_2) {
        if (var2_2 instanceof WhereClauseParamNoValue) {
            return;
        }
        var3_3 = (int[])var1_1.getExtendedData();
        if (this.getViewObjectImpl().getBindingStyle() == 2) ** GOTO lbl16
        if (var3_3 != null && var3_3.length > 0) {
            var4_4 = 0;
            while (var4_4 < var3_3.length) {
                this.doSetWhereClauseParam(var3_3[var4_4], null, var2_2);
                ++var4_4;
            }
        } else {
            v0 = ViewRowSetImpl.class$oracle$jbo$CSMessageBundle;
            if (v0 == null) {
                v0 = ViewRowSetImpl.class$oracle$jbo$CSMessageBundle = ViewRowSetImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(v0, "25070", new Object[]{var1_1.getName()});
lbl16:
            // 1 sources

            this.doSetWhereClauseParam(-1, var1_1.getName(), var2_2);
        }
    }

    private final void getWhereClauseParamsFromVars() {
        block3: {
            VariableValueManager variableValueManager;
            if (!this.hasVariables() || (variableValueManager = this.ensureVariableManager()) == null) break block3;
            Variable[] variableArray = variableValueManager.getVariablesOfKind("where");
            HashMap hashMap = null;
            int n = 0;
            while (n < variableArray.length) {
                block6: {
                    Variable variable;
                    block5: {
                        block4: {
                            variable = variableArray[n];
                            if (hashMap != null) break block4;
                            hashMap = new HashMap(variableArray.length);
                            break block5;
                        }
                        if (hashMap.get((Object)variable.getName()) != null) break block6;
                    }
                    this.convertNamedWhereClauseParam(variable, variableValueManager.getVariableValueRaw(variable, true));
                    hashMap.put((Object)variable.getName(), (Object)variable);
                }
                ++n;
            }
        }
    }

    public Object[] getParametersAsStorageTypes() {
        return this.getParametersAsStorageTypes(null);
    }

    public Object[] getParametersAsStorageTypes(Row[] rowArray) {
        return this.getParametersAsStorageTypes(rowArray, false, false);
    }

    private Object[] getParametersAsStorageTypes(Row[] rowArray, boolean bl, boolean bl2) {
        Object[] objectArray = this.getParameters(true, rowArray, bl, bl2);
        if (objectArray != null) {
            SQLBuilder sQLBuilder = this.mQRef.getSQLBuilder();
            int n = this.getViewObjectImpl().getBindingStyle();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (n == 2) {
                    Object[] objectArray2 = (Object[])objectArray[n2];
                    if (objectArray2 != null) {
                        objectArray2[1] = sQLBuilder.convertValueToStorageType(objectArray2[1]);
                    }
                } else {
                    objectArray[n2] = sQLBuilder.convertValueToStorageType(objectArray[n2]);
                }
                ++n2;
            }
        }
        return objectArray;
    }

    public Row getRow(int n) {
        QueryCollection queryCollection = this.getQueryCollection();
        if (queryCollection != null) {
            return (Row)queryCollection.get(n);
        }
        return null;
    }

    public Row getRowAtRangeIndex(int n) {
        return this.getDefaultRowSetIterator().getRowAtRangeIndex(n);
    }

    public static void dumpViewRowCache(RowSetIterator rowSetIterator, Writer writer) {
        ViewRowSetImpl viewRowSetImpl = null;
        if (rowSetIterator instanceof ViewRowSetIteratorImpl) {
            viewRowSetImpl = ((ViewRowSetIteratorImpl)rowSetIterator).getRowSetImpl();
        } else if (rowSetIterator instanceof ViewRowSetImpl) {
            viewRowSetImpl = (ViewRowSetImpl)rowSetIterator;
        } else if (rowSetIterator instanceof ViewObjectImpl) {
            viewRowSetImpl = ((ViewObjectImpl)rowSetIterator).getDefaultRowSet();
        }
        if (viewRowSetImpl != null) {
            viewRowSetImpl.getQueryCollection().dumpViewRowCache(writer);
        }
    }

    protected Row[] getRows(EntityImpl entityImpl) {
        return this.getQueryCollection().getRows(entityImpl);
    }

    public Row[] findInCacheByKey(Key key, int n) {
        key = this.prepKeyForFind(key);
        QueryCollection queryCollection = this.getQueryCollection();
        if (queryCollection != null) {
            ArrayList arrayList = queryCollection.findByKey(key, n);
            return (Row[])arrayList.toArray((Object[])new Row[arrayList.size()]);
        }
        return new Row[0];
    }

    public Row[] findByKey(Key key, int n) {
        return this.findByKey(key, n, false);
    }

    public void findAndSetCurrentRowByKey(Key key, int n) {
        this.getDefaultRowSetIterator().findAndSetCurrentRowByKey(key, n);
    }

    public Row[] findByKey(Key key, int n, boolean bl) {
        return this.findByKey(key, n, bl, false);
    }

    Key prepKeyForFind(Key key) {
        AttributeDef[] attributeDefArray = this.getViewObjectImpl().getKeyAttributeDefs();
        Object[] objectArray = null;
        int n = key.getAttributeCount();
        if (attributeDefArray != null) {
            int n2 = 0;
            while (n2 < attributeDefArray.length && n2 < n) {
                AttributeDef attributeDef;
                Class clazz;
                Object object = key.getAttribute(n2);
                if (object != null && !(object instanceof NullValue) && !(clazz = (attributeDef = attributeDefArray[n2]).getJavaType()).isInstance(object)) {
                    if (objectArray == null) {
                        objectArray = new Object[n];
                    }
                    object = ((AttributeDefImpl)attributeDef).convertToJava(object);
                }
                if (objectArray != null) {
                    objectArray[n2] = object;
                }
                ++n2;
            }
        }
        return objectArray != null ? new Key(objectArray, key.getSignature(), key.getRowHandle()) : key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Row[] findByKey(Key key, int n, boolean bl, boolean bl2) {
        key = this.prepKeyForFind(key);
        ArrayList arrayList = null;
        boolean bl3 = this.isForwardOnly();
        if (n == 0) {
            return new Row[0];
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            ViewRowImpl viewRowImpl;
            Object object2;
            if (this.getQueryCollection() != null && (object2 = key.getRowHandle()) != null && this.mQRef.getSignature() == key.getSignature() && (viewRowImpl = (ViewRowImpl)this.getRowFromHandle(object2)) != null && (key.isNull() || viewRowImpl.getPostState() == -1)) {
                arrayList = new ArrayList(2);
                arrayList.add((Object)viewRowImpl);
            }
            if (arrayList == null) {
                this.activateIteratorState(null, true);
                this.ensureStorage();
                QueryCollection queryCollection = this.getQueryCollection();
                queryCollection.prepForQuery(true);
                arrayList = queryCollection.findByKey(key, n);
                int n2 = arrayList.size();
                if (!(n != -1 && (n == -1 || n2 >= n) || queryCollection.isFetchComplete() && this.getViewObjectImpl().getMaxFetchSize() == -1 && !bl3 || bl2)) {
                    Row row;
                    Key key2;
                    if (n2 == 1 && (key2 = (row = (Row)arrayList.get(0)).getKey()) != null && key2.equals(key)) {
                        Row[] rowArray = new Row[]{row};
                        return rowArray;
                    }
                    Row[] rowArray = !bl ? this.getViewObjectImpl().retrieveByKey(this, key, n) : this.getViewObjectImpl().retrieveByKey(this, key, n, bl);
                    int n3 = rowArray.length;
                    ArrayList arrayList2 = new ArrayList(n3 > 0 ? n3 : 2);
                    int n4 = 0;
                    while (n4 < n3) {
                        ViewRowImpl viewRowImpl2 = (ViewRowImpl)rowArray[n4];
                        if (!this.isAlreadyFound(arrayList, viewRowImpl2)) {
                            if (!bl3) {
                                viewRowImpl2 = (ViewRowImpl)this.insertRowAtInternal(-1, viewRowImpl2, false, false);
                                viewRowImpl2.setPostState((byte)1);
                            }
                            arrayList2.add((Object)viewRowImpl2);
                            if (n != -1 && ++n2 >= n) break;
                        }
                        ++n4;
                    }
                    int n5 = arrayList2.size();
                    if (n5 > 0) {
                        int n6 = 0;
                        while (n6 < n5) {
                            arrayList.add(arrayList2.get(n6));
                            ++n6;
                        }
                        queryCollection.earlyRowCount(n5);
                    }
                }
            }
            Row[] rowArray = (Row[])arrayList.toArray((Object[])new Row[arrayList.size()]);
            return rowArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowIterator findByViewCriteria(ViewCriteria viewCriteria, int n, int n2) {
        if (n == 0) {
            return null;
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            this.ensureStorage();
            int n3 = viewCriteria.getCriteriaMode();
            ViewObjectImpl viewObjectImpl = null;
            ArrayList arrayList = new ArrayList(n > 0 ? (n > 100 ? 100 : n) : 10);
            ViewObjectImpl viewObjectImpl2 = this.getViewObjectImpl();
            try {
                viewCriteria.setCriteriaMode(ViewCriteria.CRITERIA_MODE_CACHE | n3);
                boolean bl = this.isForwardOnly();
                QueryCollection queryCollection = this.getQueryCollection();
                if ((n2 & 1) != 0) {
                    String string = this.getViewObjectImpl().buildViewCriteriaClauses(viewCriteria).getClauseForCache();
                    RowMatch rowMatch = string != null ? new RowMatch(string) : null;
                    int n4 = queryCollection.getFetchedRowCount();
                    int n5 = 0;
                    while (n5 < n4) {
                        ViewRowImpl viewRowImpl = (ViewRowImpl)this.getRow(n5);
                        if (rowMatch == null || rowMatch.rowQualifies(viewRowImpl)) {
                            arrayList.add((Object)viewRowImpl);
                        }
                        ++n5;
                    }
                }
                int n6 = arrayList.size();
                if ((n2 & 2) != 0 || (n2 & 4) != 0) {
                    viewObjectImpl = viewObjectImpl2.createFinderVO("_findByVC_");
                    viewObjectImpl.setQueryMode(n2);
                    viewObjectImpl.setRangeSize(n);
                    viewObjectImpl.applyViewCriteria(viewCriteria);
                    Row[] rowArray = viewObjectImpl.getAllRowsInRange();
                    ArrayList arrayList2 = new ArrayList(rowArray.length > 0 ? rowArray.length : 2);
                    int n7 = 0;
                    while (n7 < rowArray.length) {
                        ViewRowImpl viewRowImpl = (ViewRowImpl)rowArray[n7];
                        if (!this.isAlreadyFound(arrayList, viewRowImpl)) {
                            if (!bl) {
                                viewRowImpl = (ViewRowImpl)this.insertRowAtInternal(-1, viewRowImpl, false, false);
                                viewRowImpl.setPostState((byte)1);
                            }
                            arrayList2.add((Object)viewRowImpl);
                            if (n != -1 && ++n6 >= n) break;
                        }
                        ++n7;
                    }
                    int n8 = arrayList2.size();
                    if (n8 > 0) {
                        int n9 = 0;
                        while (n9 < n8) {
                            arrayList.add(arrayList2.get(n9));
                            ++n9;
                        }
                        queryCollection.earlyRowCount(n8);
                    }
                }
                Object var27_23 = null;
                viewCriteria.setCriteriaMode(n3);
                if (viewObjectImpl != null) {
                    viewObjectImpl.remove();
                }
            }
            catch (Throwable throwable) {
                Object var27_24 = null;
                viewCriteria.setCriteriaMode(n3);
                if (viewObjectImpl != null) {
                    viewObjectImpl.remove();
                }
                throw throwable;
            }
            ViewRowSetImpl viewRowSetImpl = null;
            if (arrayList.size() > 0) {
                viewRowSetImpl = (ViewRowSetImpl)viewObjectImpl2.createRowSet(null);
                viewRowSetImpl.setExecuted();
                viewRowSetImpl.initQueryCollection(true, this.getRowFilter(null));
                QueryCollection queryCollection = viewRowSetImpl.getQueryCollection();
                queryCollection.setFetchComplete(true);
                queryCollection.setExecuted(true);
                int n10 = 0;
                while (n10 < arrayList.size()) {
                    viewRowSetImpl.insertRowAtInternal(n10, (Row)arrayList.get(n10), false, true);
                    ++n10;
                }
                viewRowSetImpl.first();
                viewRowSetImpl.setRangeSize(-1);
            }
            ViewRowSetImpl viewRowSetImpl2 = viewRowSetImpl;
            return viewRowSetImpl2;
        }
    }

    public Key createKey(AttributeList attributeList) {
        return this.mQRef.createKey(attributeList);
    }

    public Row[] findByEntity(int n, int n2) {
        return this.getDefaultRowSetIterator().findByEntity(n, n2);
    }

    private ViewLink findViewLinkForMasterViewRowSet(RowSetIterator rowSetIterator) {
        ViewObject viewObject = rowSetIterator.getRowSet().getViewObject();
        ViewLink[] viewLinkArray = ((ViewObjectImpl)viewObject).getViewLinks();
        int n = 0;
        while (n < viewLinkArray.length) {
            if (viewLinkArray[n].getSource() == viewObject) {
                return viewLinkArray[n];
            }
            ++n;
        }
        return null;
    }

    public Object[] getParameters(boolean bl) {
        return this.getParameters(bl, null);
    }

    public Object[] getParameters(boolean bl, Row[] rowArray) {
        return this.getParameters(bl, rowArray, false, false);
    }

    private Object[] getParameters(boolean bl, Row[] rowArray, boolean bl2, boolean bl3) {
        ArrayList arrayList;
        Object[] objectArray;
        ArrayList arrayList2 = null;
        int n = 0;
        Object[] objectArray2 = objectArray = bl2 ? this.mExecuteParamValues : this.mParamValues;
        if (objectArray != null) {
            if (!this.getViewObjectImpl().isForScan()) {
                if (objectArray.length > 0) {
                    n = objectArray.length;
                    arrayList2 = new ArrayList(n);
                }
                int n2 = 0;
                while (n2 < n) {
                    arrayList2.add(objectArray[n2]);
                    ++n2;
                }
            }
        } else {
            arrayList2 = this.getMasterKeyValues(bl, rowArray, bl3);
            n = arrayList2 != null ? arrayList2.size() : 0;
        }
        ArrayList arrayList3 = arrayList = bl2 ? this.mExecuteUserParams : this.getWhereClauseParamArray();
        if (n == 0 && arrayList.size() == 0) {
            return null;
        }
        Object[] objectArray3 = new Object[n + arrayList.size()];
        int n3 = 0;
        boolean bl4 = this.getViewObjectImpl().getBindingStyle() == 2;
        int n4 = 0;
        while (n4 < arrayList.size()) {
            Object object = arrayList.get(n4);
            objectArray3[n3++] = bl4 && object != null ? new Object[]{((Object[])object)[0], ((Object[])object)[1]} : object;
            ++n4;
        }
        int n5 = 0;
        while (n5 < n) {
            Object object = arrayList2.get(n5);
            objectArray3[n3++] = bl4 && object != null ? new Object[]{((Object[])object)[0], ((Object[])object)[1]} : object;
            ++n5;
        }
        return objectArray3;
    }

    ArrayList getMasterKeyValues(boolean bl, Row[] rowArray, boolean bl2) {
        ArrayList arrayList = null;
        if (this.mMasterViews.size() > 0) {
            ArrayList arrayList2 = this.mQRef.getViewLinkSourceAttributes();
            ArrayList arrayList3 = this.mQRef.getViewLinksForSourceAttributes();
            ArrayList arrayList4 = this.mQRef.getViewLinkDestinationAttributes();
            if (arrayList2 != null) {
                int n = 0;
                while (n < arrayList2.size()) {
                    if (bl2) {
                        if (arrayList == null) {
                            arrayList = new ArrayList(arrayList2.size());
                        }
                        arrayList.add(null);
                    } else {
                        ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)arrayList2.get(n);
                        ViewLinkImpl viewLinkImpl = (ViewLinkImpl)arrayList3.get(n);
                        AttributeList attributeList = null;
                        if (rowArray != null && viewLinkImpl != null) {
                            ViewRowImpl viewRowImpl = null;
                            int n2 = 0;
                            while (n2 < rowArray.length) {
                                ViewRowImpl viewRowImpl2 = (ViewRowImpl)rowArray[n2];
                                if (viewRowImpl2 != null && viewRowImpl2.getViewObject() == viewLinkImpl.getSource()) {
                                    viewRowImpl = viewRowImpl2;
                                    break;
                                }
                                ++n2;
                            }
                            if (viewRowImpl != null) {
                                attributeList = viewRowImpl;
                            }
                        }
                        if (attributeList == null) {
                            int n3 = this.getMasterRSIIndex(n, viewAttributeDefImpl.getViewDef());
                            ViewRowSetIteratorImpl viewRowSetIteratorImpl = (ViewRowSetIteratorImpl)this.mMasterViews.get(n3);
                            attributeList = viewRowSetIteratorImpl.getCurrentRow();
                            if (attributeList == null && this.mExecuteMaster && !viewRowSetIteratorImpl.getRowSetImpl().isExecuted()) {
                                viewRowSetIteratorImpl.getRowSetImpl().execute(false, false);
                                attributeList = viewRowSetIteratorImpl.first();
                            }
                            if (rowArray != null) {
                                rowArray[n3] = attributeList;
                            }
                        }
                        Object[] objectArray = null;
                        if (viewAttributeDefImpl.getIndex() == -1 && attributeList != null) {
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("ViewRowSetImpl: WARNING - Foreign key \"" + viewAttributeDefImpl.getName() + "\" not found on ViewObject \"" + ((ViewRowImpl)attributeList).getViewObject().getName() + "\"");
                            }
                            try {
                                EntityImpl entityImpl = viewAttributeDefImpl.getEntityInstance((Row)attributeList);
                                objectArray = entityImpl.getAttribute(viewAttributeDefImpl.getAttributeDefImpl().getIndex());
                            }
                            catch (RuntimeException runtimeException) {}
                        } else {
                            Object[] objectArray2 = objectArray = attributeList == null ? null : attributeList.getAttribute(viewAttributeDefImpl.getIndex());
                        }
                        if ((objectArray != null || bl) && viewLinkImpl != null) {
                            if (viewLinkImpl.qoAssoc.getSourceEnd().mDBObjectName == null) {
                                objectArray = ((ViewAttributeDefImpl)arrayList4.get(n)).convertToJava(objectArray);
                            } else {
                                AttributeDefImpl[] attributeDefImplArray = viewLinkImpl.mReversedUsage ? viewLinkImpl.qoAssoc.getDestinationEnd().getIntersectAttrs() : viewLinkImpl.qoAssoc.getSourceEnd().getIntersectAttrs();
                                objectArray = attributeDefImplArray[n].convertToJava(objectArray);
                            }
                        }
                        if (this.getViewObjectImpl().getBindingStyle() == 2) {
                            String string = this.getViewObjectImpl().getViewDef().appendBindingNameForAttr(null, viewAttributeDefImpl).toString();
                            objectArray = new Object[]{string, objectArray};
                        }
                        if (arrayList == null) {
                            arrayList = new ArrayList(arrayList2.size());
                        }
                        arrayList.add((Object)objectArray);
                    }
                    ++n;
                }
            }
        }
        return arrayList;
    }

    AttributeList initForeignKeyValues(Row row) {
        ArrayList arrayList = this.mQRef.getViewLinkDestinationAttributes();
        if (this.mQC == null || arrayList == null || arrayList.size() == 0) {
            return new AttributeListImpl();
        }
        return this.initForeignKeyValues(row, arrayList, this.getRowInitValues(null));
    }

    AttributeList initForeignKeyValues(Row row, ArrayList arrayList, AttributeList attributeList) {
        int n;
        if (attributeList != null && (n = attributeList.getAttributeCount()) > 0) {
            ViewAttributeDefImpl[] viewAttributeDefImplArray = new ViewAttributeDefImpl[this.mQRef.getAttributeCount()];
            int n2 = 0;
            while (n2 < n) {
                Object object = attributeList.getAttribute(n2);
                ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)arrayList.get(n2);
                EntityImpl entityImpl = viewAttributeDefImpl.getEntityInstance(row);
                if (entityImpl != null) {
                    entityImpl.populateAttributeAsChanged(viewAttributeDefImpl.mAttrDesc.mIndex, viewAttributeDefImpl.convertToJava(object));
                } else if (viewAttributeDefImpl.mKind != 0) {
                    ((ViewRowImpl)row).populateAttributeAsChanged(viewAttributeDefImpl.mIndex, viewAttributeDefImpl.convertToJava(object));
                }
                viewAttributeDefImplArray[n2] = viewAttributeDefImpl;
                ++n2;
            }
            try {
                this.mQRef.updateReferenceEntities(null, null, n, null, viewAttributeDefImplArray, new Row[]{row}, true);
            }
            catch (RowNotFoundException rowNotFoundException) {
                // empty catch block
            }
        }
        return attributeList;
    }

    AttributeList getRowInitValues(AttributeList attributeList) {
        ArrayList arrayList;
        ViewLink[] viewLinkArray;
        if (this.mQRef.getViewDef().isFinderView() && (viewLinkArray = this.mQRef.getViewLinks()).length > 0 && ((ViewLinkImpl)viewLinkArray[0]).getViewLinkDef().getEntityAssociationReference() != null) {
            return new AttributeListImpl();
        }
        AssociationDefImpl associationDefImpl = this.getViewObjectImpl().getAssocAccessorDef();
        if (associationDefImpl != null) {
            Object[] objectArray;
            ArrayList arrayList2 = this.mQRef.getViewLinkDestinationAttributes();
            Object var5_5 = null;
            RowFilter rowFilter = this.getQueryCollection().getRowFilter();
            if (rowFilter != null && (objectArray = rowFilter.getRowInitValues()) != null && arrayList2 != null) {
                int n = arrayList2.size();
                int n2 = objectArray.length - n;
                if (attributeList == null) {
                    attributeList = new AttributeListImpl(n);
                }
                int n3 = 0;
                while (n3 < n) {
                    String string = ((AttributeDefImpl)arrayList2.get(n3)).getName();
                    if (attributeList.getAttribute(string) == null && n2 >= 0 && n2 < objectArray.length) {
                        attributeList.setAttribute(string, objectArray[n2]);
                    }
                    ++n3;
                    ++n2;
                }
            }
        }
        if (attributeList == null) {
            attributeList = new AttributeListImpl();
        }
        if (this.mMasterViews.size() > 0 && (arrayList = this.mQRef.getViewLinkSourceAttributes()) != null && arrayList.size() > 0) {
            ArrayList arrayList3 = this.mQRef.getViewLinkDestinationAttributes();
            int n = 0;
            while (n < arrayList.size()) {
                String string = ((ViewAttributeDefImpl)arrayList3.get(n)).getName();
                if (attributeList.getAttribute(string) == null) {
                    ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)arrayList.get(n);
                    Object object = null;
                    if (this.mIsOwnedByQC) {
                        Object[] objectArray = this.getQueryCollection().getRowFilter().getRowInitValues();
                        object = objectArray[n];
                    } else {
                        int n4 = this.getMasterRSIIndex(n, viewAttributeDefImpl.getViewDef());
                        ViewRowSetIteratorImpl viewRowSetIteratorImpl = (ViewRowSetIteratorImpl)this.mMasterViews.get(n4);
                        Row row = viewRowSetIteratorImpl.getCurrentRow();
                        if (viewAttributeDefImpl.getIndex() == -1 && row != null) {
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("ViewRowSetImpl: WARNING - Foreign key \"" + viewAttributeDefImpl.getName() + "\" not found on ViewObject \"" + viewRowSetIteratorImpl.getRowSetImpl().getViewObjectImpl().getName() + "\"");
                            }
                            try {
                                EntityImpl entityImpl = viewAttributeDefImpl.getEntityInstance(row);
                                object = entityImpl.getAttribute(viewAttributeDefImpl.getAttributeDefImpl().getIndex());
                            }
                            catch (RuntimeException runtimeException) {}
                        } else {
                            object = row == null ? null : row.getAttribute(viewAttributeDefImpl.getIndex());
                        }
                    }
                    attributeList.setAttribute(string, object);
                }
                ++n;
            }
        }
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureStorage() {
        if (this.mQC != null && this.mQC.getAttributeCount() > 0) {
            return;
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            this.getViewObjectImpl().getAttributeCount();
            if (this.mQC == null) {
                RowFilter rowFilter = this.getRowFilter(null);
                this.initAndRegisterQC(false, true, rowFilter);
            }
            this.mQC.createColumnList();
        }
    }

    public Hashtable getProperties() {
        return this.getViewObjectImpl().getProperties();
    }

    boolean refreshEventPropagation() {
        this.getViewObjectImpl().propagateEvent(ViewObjectImpl.EVENT_PROPAGATION_REMOVE);
        int n = 0;
        while (n < this.mViews.size()) {
            ViewRowSetIteratorImpl viewRowSetIteratorImpl = (ViewRowSetIteratorImpl)this.mViews.get(n);
            if (viewRowSetIteratorImpl != null && viewRowSetIteratorImpl.refreshEventPropagation()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Row[] getMasterRowsForRefreshRowSet(Row row) {
        ArrayList arrayList = this.mQRef.getViewLinksForSourceAttributes();
        Row[] rowArray = new Row[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            ViewLinkImpl viewLinkImpl = (ViewLinkImpl)arrayList.get(n);
            if (((ViewRowImpl)row).getViewObject() == viewLinkImpl.getSource()) {
                rowArray[n] = row;
            }
            ++n;
        }
        return rowArray;
    }

    void refreshRowSet(JboEvent jboEvent) {
        boolean bl = false;
        boolean bl2 = false;
        Row[] rowArray = null;
        if (jboEvent instanceof RowSetManagementEvent && ((RowSetManagementEvent)jboEvent).getEventType() == 0) {
            bl2 = true;
        }
        if (jboEvent instanceof RangeRefreshEvent || bl2) {
            if (this.isExecuted()) {
                this.mQRef.clearQueryCollectionCache(this);
                this.mQC = null;
                bl = true;
                if (bl2 || ((RowSetIterator)jboEvent.getSource()).getCurrentRow() == null) {
                    this.initAndRegisterQC(false, true, this.getRowFilter(null));
                    this.resetIterators();
                    this.mQC.setFetchComplete(true);
                    return;
                }
            }
        } else if (jboEvent instanceof UpdateEvent) {
            UpdateEvent updateEvent = (UpdateEvent)jboEvent;
            Row row = updateEvent.getRow();
            if (this.mReceiveAllInsertEvents && this.mQRef.isSourceAttribute(updateEvent.getChangedAttrIndices()) && this.mMasterViews.size() > 0) {
                rowArray = this.getMasterRowsForRefreshRowSet(row);
                this.resetExecuted();
                this.execute(false, true, false, true, false, rowArray);
                return;
            }
            if (row == ViewObjectImpl.getImplObject(jboEvent.getSource()).getCurrentRow() && this.mQRef.isSourceAttribute(updateEvent.getChangedAttrIndices())) {
                bl = true;
            }
        } else if (jboEvent instanceof NavigationEvent) {
            bl = true;
            if (this.mReceiveAllInsertEvents && this.mMasterViews.size() > 0) {
                NavigationEvent navigationEvent = (NavigationEvent)jboEvent;
                Row row = navigationEvent.getRow();
                rowArray = this.getMasterRowsForRefreshRowSet(row);
                this.resetExecuted();
                this.execute(false, true, false, true, false, rowArray);
                return;
            }
        } else if (jboEvent instanceof DeleteEvent && ((RowEvent)jboEvent).getRowIndex() == ViewObjectImpl.getImplObject(jboEvent.getSource()).getCurrentRowIndex()) {
            bl = true;
        }
        if (!bl) {
            return;
        }
        if (!this.getViewObjectImpl().isViewLinkAccessorRetained()) {
            this.resetExecuted();
        } else {
            this.mNotifiedRefresh = false;
            this.execute(false, true, false, true, false, null);
        }
        this.notifyRefresh(true, true, true, true, rowArray);
    }

    private boolean isAlreadyFound(ArrayList arrayList, ViewRowImpl viewRowImpl) {
        Key key = viewRowImpl.getKey();
        int n = 0;
        while (n < arrayList.size()) {
            ViewRowImpl viewRowImpl2 = (ViewRowImpl)arrayList.get(n);
            if (viewRowImpl2.getKey().equals(key)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void printActiveObjsTab(PrintWriter printWriter) {
        this.getQueryCollection().printActiveObjsTab(printWriter);
    }

    public void printRUChain(PrintWriter printWriter) {
        this.getQueryCollection().printRUChain(printWriter);
    }

    public void printColl(PrintWriter printWriter, int n) {
        this.getQueryCollection().printColl(printWriter, n);
    }

    public int[] getCollMgmtInfo() {
        if (this.mQC != null) {
            return this.mQC.getCollMgmtInfo();
        }
        return null;
    }

    void setRowSetActivationRequired(RowSetStateHolder rowSetStateHolder) {
        this.mRowSetState = rowSetStateHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activateRowSetState() {
        if (this.mRowSetState == null) {
            return;
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            RowSetStateHolder rowSetStateHolder = this.mRowSetState;
            this.mRowSetState = null;
            if (rowSetStateHolder.mExecuted && !this.mExecuted) {
                this.execute(true, true, true, false, false, null);
                QueryCollection queryCollection = this.getQueryCollection();
                if (queryCollection != null && queryCollection.getUnpostedRowCount() > 0) {
                    queryCollection.fetch(queryCollection.getUnpostedRowCount() - 1);
                }
            }
        }
    }

    final void activateIteratorState(Element element, boolean bl) {
        NodeList nodeList;
        if (this.mRowSetState != null && element != null && ((nodeList = element.getElementsByTagName("cd")).getLength() > 0 || "1".equals(element.getAttribute("cli")))) {
            RowSetStateHolder rowSetStateHolder = this.mRowSetState;
            this.activateRowSetState();
            if (element != null && this.mDefaultView == null) {
                this.getDefaultRowSetIterator().setIteratorActivationRequired(rowSetStateHolder);
            }
        }
        if (this.mDefaultView != null) {
            this.getDefaultRowSetIterator().activateIteratorState(element, bl);
        }
    }

    final IteratorStateHolder getIteratorState() {
        IteratorStateHolder iteratorStateHolder = null;
        if (this.mDefaultView != null) {
            iteratorStateHolder = this.getDefaultRowSetIterator().getIteratorState();
        }
        return iteratorStateHolder;
    }

    public Row[] getFilteredRows(RowQualifier rowQualifier) {
        return this.getDefaultRowSetIterator().getFilteredRows(rowQualifier);
    }

    public Row[] getFilteredRowsInRange(RowQualifier rowQualifier) {
        return this.getDefaultRowSetIterator().getFilteredRowsInRange(rowQualifier);
    }

    public Row[] getFilteredRows(String string, Object object) {
        return this.getDefaultRowSetIterator().getFilteredRows(string, object);
    }

    public Row[] getFilteredRowsInRange(String string, Object object) {
        return this.getDefaultRowSetIterator().getFilteredRowsInRange(string, object);
    }

    public void setPassivationEnabled(boolean bl) {
        if (this.getViewObjectImpl().isInternal()) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25061", new Object[]{this.getName()});
        }
        this.mPassivate = bl;
    }

    public boolean isPassivationEnabled() {
        return this.mPassivate;
    }

    public void setPassivationEnabledInternal(boolean bl) {
        this.mPassivate = bl;
    }

    boolean isReceiveAllInsertEvents() {
        return this.mReceiveAllInsertEvents;
    }

    public void setReceiveAllInsertEvents(boolean bl) {
        this.mReceiveAllInsertEvents = bl;
    }

    final boolean hasStateToPassivate() {
        return this.mHasStateToPassivate;
    }

    void setStateToPassivate(boolean bl) {
        this.mHasStateToPassivate = bl;
    }

    final boolean hasParamsChanged() {
        return this.mParamsChanged;
    }

    public VariableValueManager getVariableManager() {
        return this.mVariableManager;
    }

    public boolean hasVariables() {
        if (this.mVariableManager != null) {
            return true;
        }
        return this.getViewObjectImpl().hasVariables();
    }

    public VariableValueManager ensureVariableManager() {
        if (this.mVariableManager == null) {
            VariableValueManager variableValueManager = this.getViewObjectImpl().ensureVariableManager();
            this.mVariableManager = new 1(this, new VariableValueManager[]{variableValueManager});
        }
        return this.mVariableManager;
    }

    public Class getMessageBundleClass() {
        return this.getViewObjectImpl().getMessageBundleClass();
    }

    public boolean cancelQuery() {
        if (this.mQC != null) {
            return this.mQC.cancelQuery();
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class 1
    extends VariableValueManagerImpl {
        protected void populateVariableValue(Variable variable, Object object) {
            super.populateVariableValue(variable, object);
            if ("where".equals(variable.getVariableKind())) {
                ViewRowSetImpl.this.getWhereClauseParamsFromVars();
            }
        }

        public /* synthetic */ 1(VariableManagerOwner variableManagerOwner, VariableManager[] variableManagerArray) {
            super(variableManagerOwner, variableManagerArray);
        }
    }
}

