/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import oracle.jbo.AttributeDef;
import oracle.jbo.InvalidOperException;
import oracle.jbo.InvalidParamException;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.ViewLink;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.NamedObjectImpl;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.AssociationDefImpl;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.ComponentObjectImpl;
import oracle.jbo.server.DefObject;
import oracle.jbo.server.IteratorStateHolder;
import oracle.jbo.server.ViewAttributeDefImpl;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewLinkDefImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowSetIteratorImpl;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewLinkImpl
extends ComponentObjectImpl
implements ViewLink {
    protected ViewLinkDefImpl qoAssoc;
    protected ViewObjectImpl source;
    protected ViewObjectImpl destination;
    protected boolean mReversedUsage;
    boolean mIsDynamic;
    private AttributeDef mSourceAccessor;
    static final String MTH_setSource = "ViewLinkImpl.setSource";
    static final String MTH_setDestination = "ViewLinkImpl.setDestination";
    static final String FULLNAME = "fn";
    static final String MASTER = "ma";
    static final String DETAIL = "dt";
    static final String ASSOC = "as";
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$server$ViewLinkDefImpl;

    private /* synthetic */ void $init$() {
        this.mReversedUsage = false;
        this.mIsDynamic = true;
        this.mSourceAccessor = null;
    }

    public ViewLinkImpl() {
        this.$init$();
    }

    public DefObject getDef() {
        return this.qoAssoc;
    }

    void setDef(DefObject defObject) {
        if (this.qoAssoc == defObject) {
            return;
        }
        if (defObject == null) {
            if (this.destination != null) {
                this.destination.removeViewLink(this, true);
                this.destination = null;
            }
            if (this.source != null) {
                this.source.removeViewLink(this, true);
                this.source = null;
            }
        }
        super.setDef(defObject);
        this.qoAssoc = (ViewLinkDefImpl)defObject;
    }

    public String getDefName() {
        String string;
        ViewLinkDefImpl viewLinkDefImpl = this.getViewLinkDef();
        if (viewLinkDefImpl == null) {
            Class clazz = class$oracle$jbo$server$ViewLinkDefImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$ViewLinkDefImpl = ViewLinkImpl.class$("oracle.jbo.server.ViewLinkDefImpl");
            }
            string = JboNameUtil.getLastPartOfName(clazz.getName());
        } else {
            string = viewLinkDefImpl.getName();
        }
        return string;
    }

    public String getDefFullName() {
        String string;
        ViewLinkDefImpl viewLinkDefImpl = this.getViewLinkDef();
        if (viewLinkDefImpl == null) {
            Class clazz = class$oracle$jbo$server$ViewLinkDefImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$ViewLinkDefImpl = ViewLinkImpl.class$("oracle.jbo.server.ViewLinkDefImpl");
            }
            string = clazz.getName();
        } else {
            string = viewLinkDefImpl.getFullName();
        }
        return string;
    }

    public ViewLinkDefImpl getViewLinkDef() {
        return this.qoAssoc;
    }

    public ViewObject getSource() {
        return this.source;
    }

    void checkForRecursiveViewLinks(ViewObject viewObject, ArrayList arrayList) {
        if (viewObject == null) {
            return;
        }
        if (arrayList == null) {
            arrayList = new ArrayList(2);
            arrayList.add((Object)viewObject);
        }
        int n = arrayList.size();
        arrayList.add((Object)this.source);
        if (this.source == viewObject) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            int n2 = arrayList.size() - 1;
            while (n2 >= 0) {
                String string = ((ViewObject)arrayList.get(n2)).getName();
                if (!bl) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string);
                bl = false;
                --n2;
            }
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewLinkImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25227", new Object[]{stringBuffer.toString()});
        }
        ViewLink[] viewLinkArray = this.source.getViewLinks();
        int n3 = 0;
        while (n3 < viewLinkArray.length) {
            if (viewLinkArray[n3].getDestination() == this.source) {
                ((ViewLinkImpl)viewLinkArray[n3]).checkForRecursiveViewLinks(viewObject, arrayList);
            }
            ++n3;
        }
        arrayList.remove(n);
    }

    public void setSource(ViewObject viewObject) {
        if (this.destination != null && this.destination == viewObject) {
            throw new InvalidParamException(MTH_setSource, "source", viewObject.getName(), "source same as destination");
        }
        ViewDefImpl viewDefImpl = ((ViewObjectImpl)viewObject).getViewDef();
        if (viewDefImpl != this.qoAssoc.getSourceOwner()) {
            if (viewDefImpl != this.qoAssoc.getDestinationOwner()) {
                throw new InvalidParamException(MTH_setSource, "source", viewObject.getName(), "view def mismatch");
            }
            if (this.destination != null && !this.mReversedUsage) {
                throw new InvalidParamException(MTH_setSource, "source", viewObject.getName(), "view def mismatch");
            }
            this.mReversedUsage = true;
        }
        if (this.source != null) {
            this.source.removeViewLink(this, true);
        }
        this.source = (ViewObjectImpl)viewObject;
        this.checkForRecursiveViewLinks(this.destination, null);
        this.source.addViewLink(this, this.mReversedUsage);
    }

    public ViewObject getDestination() {
        return this.destination;
    }

    public void setDestination(ViewObject viewObject) {
        if (this.source != null && this.source == viewObject) {
            throw new InvalidParamException(MTH_setDestination, "destination", viewObject.getName(), "destination same as source");
        }
        ViewDefImpl viewDefImpl = ((ViewObjectImpl)viewObject).getViewDef();
        if (viewDefImpl != this.qoAssoc.getDestinationOwner()) {
            if (viewDefImpl != this.qoAssoc.getSourceOwner()) {
                throw new InvalidParamException(MTH_setDestination, "destination", viewObject.getName(), "view def mismatch");
            }
            if (this.source != null && !this.mReversedUsage) {
                throw new InvalidParamException(MTH_setDestination, "destination", viewObject.getName(), "view def mismatch");
            }
            this.mReversedUsage = true;
        }
        if (this.destination != null) {
            this.destination.removeViewLink(this, true);
        }
        this.destination = (ViewObjectImpl)viewObject;
        this.checkForRecursiveViewLinks(this.destination, null);
        this.destination.addViewLink(this, this.mReversedUsage);
    }

    public boolean isReversedUsage() {
        return this.mReversedUsage;
    }

    void setReversedUsage(boolean bl) {
        this.mReversedUsage = bl;
    }

    public AttributeDef getSourceAccessor() {
        if (this.mSourceAccessor != null && this.source != null && this.source == ((AttributeDefImpl)this.mSourceAccessor).getParent()) {
            return this.mSourceAccessor;
        }
        return null;
    }

    void setSourceAccessor(AttributeDef attributeDef) {
        this.mSourceAccessor = attributeDef;
    }

    XMLElement passivateAttributeArray(XMLDocument xMLDocument, AttributeDefImpl[] attributeDefImplArray) {
        XMLElement xMLElement = (XMLElement)xMLDocument.createElement("Attrs");
        int n = attributeDefImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            XMLElement xMLElement2 = (XMLElement)xMLDocument.createElement("a");
            xMLElement2.appendChild((Node)xMLDocument.createTextNode(new Integer(attributeDefImplArray[n2].mIndex).toString()));
            xMLElement.appendChild((Node)xMLElement2);
            ++n2;
        }
        return xMLElement;
    }

    XMLElement passivateSettings(XMLDocument xMLDocument) {
        if (!this.mIsDynamic) {
            return null;
        }
        XMLElement xMLElement = (XMLElement)xMLDocument.createElement("VL");
        xMLElement.setAttribute("Name", this.getName());
        NamedObjectImpl namedObjectImpl = this.getParent();
        if (this.source.getParent() == namedObjectImpl) {
            xMLElement.setAttribute(MASTER, this.source.getName());
        } else {
            xMLElement.setAttribute(MASTER, this.source.getFullName());
            xMLElement.setAttribute(FULLNAME, FULLNAME);
        }
        if (this.destination.getParent() == namedObjectImpl) {
            xMLElement.setAttribute(DETAIL, this.destination.getName());
        } else {
            xMLElement.setAttribute(DETAIL, this.destination.getFullName());
            xMLElement.setAttribute(FULLNAME, FULLNAME);
        }
        if (this.qoAssoc.isDynamic()) {
            if (this.qoAssoc.mAssocRef == null) {
                XMLElement xMLElement2 = (XMLElement)xMLDocument.createElement(ASSOC);
                ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mSourceAccessor;
                String string = viewAttributeDefImpl.getName();
                String string2 = ((AssociationDefImpl)viewAttributeDefImpl.getAttributeDefImpl()).mAssociationVOName;
                if (string2 != null) {
                    string = string2 + ":" + string;
                }
                xMLElement2.appendChild((Node)xMLDocument.createTextNode(string));
                xMLElement.appendChild((Node)xMLElement2);
                xMLElement.appendChild((Node)this.passivateAttributeArray(xMLDocument, this.qoAssoc.getAttributeDefImpls()));
                xMLElement.appendChild((Node)this.passivateAttributeArray(xMLDocument, this.qoAssoc.getOtherAttributeDefImpls()));
                xMLElement2 = (XMLElement)xMLDocument.createElement("Wh");
                xMLElement2.appendChild((Node)xMLDocument.createTextNode(this.qoAssoc.mAssocClause));
                xMLElement.appendChild((Node)xMLElement2);
            } else {
                xMLElement.setAttribute(ASSOC, this.qoAssoc.getEntityAssociationReference().getDef().getFullName());
            }
        } else {
            xMLElement.setAttribute("Def", this.qoAssoc.getFullName());
        }
        return xMLElement;
    }

    static void activateSettings(Element element, ApplicationModuleImpl applicationModuleImpl) {
        Row[] rowArray;
        ViewRowSetIteratorImpl viewRowSetIteratorImpl;
        String string = element.getAttribute("Name");
        if (applicationModuleImpl.findViewLink(string) != null) {
            return;
        }
        ViewObjectImpl viewObjectImpl = (ViewObjectImpl)applicationModuleImpl.findViewObject(element.getAttribute(MASTER));
        ViewObjectImpl viewObjectImpl2 = (ViewObjectImpl)applicationModuleImpl.findViewObject(element.getAttribute(DETAIL));
        if (viewObjectImpl == null || viewObjectImpl2 == null) {
            Diagnostic.println("Cannot activate ViewLink :" + string);
            return;
        }
        Key key = null;
        IteratorStateHolder iteratorStateHolder = null;
        ViewRowSetIteratorImpl viewRowSetIteratorImpl2 = viewRowSetIteratorImpl = viewObjectImpl2.mViewRowSet != null ? viewObjectImpl2.mViewRowSet.mDefaultView : null;
        if (viewRowSetIteratorImpl != null) {
            if (viewRowSetIteratorImpl.mIteratorState != null) {
                iteratorStateHolder = viewRowSetIteratorImpl.mIteratorState;
            } else {
                Row row = viewObjectImpl2.getCurrentRow();
                if (row != null) {
                    key = row.getKey();
                }
            }
        }
        ViewLink viewLink = null;
        String string2 = element.getAttribute("Def");
        if (string2.length() > 0) {
            viewLink = applicationModuleImpl.createViewLink(string, string2, viewObjectImpl, viewObjectImpl2);
        } else {
            string2 = element.getAttribute(ASSOC);
            if (string2.length() > 0) {
                viewLink = applicationModuleImpl.createViewLinkFromEntityAssocName(string, string2, viewObjectImpl, viewObjectImpl2);
            } else {
                NodeList nodeList = element.getChildNodes();
                viewLink = applicationModuleImpl.createViewLinkBetweenViewObjects(string, nodeList.item(0).getFirstChild().getNodeValue(), viewObjectImpl, ViewLinkImpl.activateAttributeArray(viewObjectImpl, (Element)nodeList.item(1)), viewObjectImpl2, ViewLinkImpl.activateAttributeArray(viewObjectImpl2, (Element)nodeList.item(2)), nodeList.item(3).getFirstChild().getNodeValue());
            }
        }
        if (iteratorStateHolder != null) {
            viewRowSetIteratorImpl.restoreIteratorState(iteratorStateHolder);
        } else if (key != null && (rowArray = viewObjectImpl2.findByKey(key, 1)) != null && rowArray.length > 0) {
            viewObjectImpl2.setCurrentRow(rowArray[0]);
        }
    }

    static AttributeDef[] activateAttributeArray(ViewObject viewObject, Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        AttributeDef[] attributeDefArray = new AttributeDef[n];
        try {
            while (n > 0) {
                attributeDefArray[--n] = viewObject.getAttributeDef(Integer.valueOf(nodeList.item(n).getFirstChild().getNodeValue()));
            }
            AttributeDef[] attributeDefArray2 = attributeDefArray;
            return attributeDefArray2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JboException(numberFormatException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

