/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import java.util.Hashtable;
import java.util.Locale;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import oracle.adf.share.ADFContext;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.NoXMLFileException;
import oracle.jbo.Session;
import oracle.jbo.SessionContext;
import oracle.jbo.SessionContextManager;
import oracle.jbo.Version;
import oracle.jbo.common.DefLocaleContext;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.MOMProperties;
import oracle.jbo.common.PropertyManager;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.SessionContextManagerImpl;
import oracle.jbo.common.StringManager;
import oracle.jbo.common.Timer;
import oracle.jbo.server.DefaultTxnHandlerFactoryImpl;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.PackageDefImpl;
import oracle.jbo.server.TransactionHandlerFactory;
import oracle.jbo.server.security.JboJAASContext;
import oracle.jbo.server.security.JboJAASFactory;
import oracle.jbo.server.security.JboJAASUserManager;
import oracle.jbo.server.security.JboPolicyManager;

public class SessionImpl
implements Session {
    private ArrayList mPkgInfos;
    private Hashtable mEnv;
    private Locale mLocale;
    private TransactionHandlerFactory mTxnHandlerFactory;
    private LocaleContext mLocaleContext;
    private Hashtable mUserData;
    protected JboJAASContext mJAASContext;
    private static SessionContextManager mSessContextMgr;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$server$SessionImpl;

    private /* synthetic */ void $init$() {
        this.mPkgInfos = new ArrayList();
        this.mEnv = new Hashtable();
        this.mLocale = null;
        this.mTxnHandlerFactory = new DefaultTxnHandlerFactoryImpl();
        this.mLocaleContext = null;
        this.mJAASContext = null;
    }

    public SessionImpl() {
        this.$init$();
    }

    public static SessionImpl init(Hashtable hashtable) {
        Class clazz;
        String string = (String)hashtable.get(PropertyMetadata.JBO_PROJECT.getName());
        Hashtable hashtable2 = PropertyManager.loadProperties(hashtable);
        MetaObjectManager metaObjectManager = MetaObjectManager.getSingleton();
        if (string != null) {
            metaObjectManager.loadProjectDefinition(string);
        }
        if ((clazz = class$oracle$jbo$server$SessionImpl) == null) {
            clazz = class$oracle$jbo$server$SessionImpl = SessionImpl.class$("oracle.jbo.server.SessionImpl");
        }
        Class clazz2 = clazz;
        String string2 = MOMProperties.getProperty("SessionClass", clazz2.getName());
        SessionImpl sessionImpl = null;
        Class clazz3 = JBOClass.findCustomClass(string2, clazz2);
        sessionImpl = (SessionImpl)JBOClass.newInstance(clazz3);
        sessionImpl.setEnvironment(hashtable2);
        return sessionImpl;
    }

    public Hashtable getEnvironment() {
        return this.mEnv;
    }

    void setEnvironment(Hashtable hashtable) {
        this.mEnv = (Hashtable)hashtable.clone();
    }

    public Locale getLocale() {
        if (this.mLocale == null) {
            this.mLocale = StringManager.getDefaultLocale();
        }
        return this.mLocale;
    }

    public void setProperty(String string, String string2) {
        this.mEnv.put(string, string2);
    }

    public void setLocale(Locale locale) {
        this.mLocale = locale;
        this.mLocaleContext = new DefLocaleContext(this.mLocale);
    }

    private String getDeployPlatform() {
        Hashtable hashtable = this.getEnvironment();
        if (hashtable != null) {
            return (String)hashtable.get(PropertyMetadata.DEPLOY_PLATFORM.pName);
        }
        return null;
    }

    String getAppModuleServerType() {
        String string = this.getDeployPlatform();
        if (string != null && (string.equals("Ejb") || string.equals("EjbIas") || string.equals("EjbWls"))) {
            Hashtable hashtable = this.getEnvironment();
            string = hashtable != null ? (String)hashtable.get("jbo.server.ejb.beantype") : null;
        }
        return string;
    }

    public void loadPackage(String string) {
        Timer timer = new Timer();
        PackageDefImpl packageDefImpl = null;
        try {
            packageDefImpl = MetaObjectManager.loadProject(string);
        }
        catch (NoXMLFileException noXMLFileException) {
        }
        catch (JboException jboException) {
            throw jboException;
        }
        if (packageDefImpl == null) {
            packageDefImpl = MetaObjectManager.findPackage(string);
        }
        if (packageDefImpl.isProject()) {
            ArrayList arrayList = packageDefImpl.getPackageDefNames(false);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.addPackageDef(MetaObjectManager.findPackage((String)iterator.next()));
            }
        } else {
            this.addPackageDef(packageDefImpl);
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("Total Time Taken to load " + string + " is : " + timer.getElapsedTime() + " ms ");
        }
    }

    PackageDefImpl[] getPackageDefs() {
        return (PackageDefImpl[])this.mPkgInfos.toArray((Object[])new PackageDefImpl[this.mPkgInfos.size()]);
    }

    public String getVersion() {
        return Version.getAsString();
    }

    public String[] getApplicationModuleDefNames(String string) {
        PackageDefImpl packageDefImpl = MetaObjectManager.findPackage(string);
        return SessionImpl.convToArr(packageDefImpl.getApplicationModuleDefNames(false));
    }

    public String[] getAllApplicationModuleDefNames() {
        PackageDefImpl[] packageDefImplArray = this.getPackageDefs();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < packageDefImplArray.length) {
            arrayList.addAll((Collection)packageDefImplArray[n].getApplicationModuleDefNames(true));
            ++n;
        }
        return SessionImpl.convToArr(arrayList);
    }

    public String[] getViewDefNames(String string) {
        PackageDefImpl packageDefImpl = MetaObjectManager.findPackage(string);
        return SessionImpl.convToArr(packageDefImpl.getViewDefNames(false));
    }

    public String[] getAllViewDefNames() {
        PackageDefImpl[] packageDefImplArray = this.getPackageDefs();
        ArrayList arrayList = new ArrayList();
        Object var3_3 = null;
        int n = 0;
        while (n < packageDefImplArray.length) {
            arrayList.addAll((Collection)packageDefImplArray[n].getViewDefNames(true));
            ++n;
        }
        return SessionImpl.convToArr(arrayList);
    }

    public String[] getEntityDefNames(String string) {
        PackageDefImpl packageDefImpl = MetaObjectManager.findPackage(string);
        return SessionImpl.convToArr(packageDefImpl.getEntityDefNames(false));
    }

    public String[] getAllEntityDefNames() {
        PackageDefImpl[] packageDefImplArray = this.getPackageDefs();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < packageDefImplArray.length) {
            arrayList.addAll((Collection)packageDefImplArray[n].getEntityDefNames(true));
            ++n;
        }
        return SessionImpl.convToArr(arrayList);
    }

    public String[] getEntityAssociationDefNames(String string) {
        PackageDefImpl packageDefImpl = MetaObjectManager.findPackage(string);
        return SessionImpl.convToArr(packageDefImpl.getEntityAssociationDefNames(false));
    }

    public String[] getAllEntityAssociationDefNames() {
        PackageDefImpl[] packageDefImplArray = this.getPackageDefs();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < packageDefImplArray.length) {
            arrayList.addAll((Collection)packageDefImplArray[n].getEntityAssociationDefNames(true));
            ++n;
        }
        return SessionImpl.convToArr(arrayList);
    }

    public String[] getViewLinkDefNames(String string) {
        PackageDefImpl packageDefImpl = MetaObjectManager.findPackage(string);
        return SessionImpl.convToArr(packageDefImpl.getViewLinkDefNames(false));
    }

    public String[] getAllViewLinkDefNames() {
        PackageDefImpl[] packageDefImplArray = this.getPackageDefs();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < packageDefImplArray.length) {
            arrayList.addAll((Collection)packageDefImplArray[n].getViewLinkDefNames(true));
            ++n;
        }
        return SessionImpl.convToArr(arrayList);
    }

    public String[] getPackageNames() {
        PackageDefImpl[] packageDefImplArray = this.getPackageDefs();
        String[] stringArray = new String[packageDefImplArray.length];
        int n = 0;
        while (n < packageDefImplArray.length) {
            stringArray[n] = packageDefImplArray[n].getFullName();
            ++n;
        }
        return stringArray;
    }

    public TransactionHandlerFactory getTransactionHandlerFactory() {
        return this.mTxnHandlerFactory;
    }

    public static SessionContextManager getSessionContextManager() {
        return mSessContextMgr;
    }

    public static void setSessionContextManager(SessionContextManager sessionContextManager) {
        mSessContextMgr = sessionContextManager;
    }

    public static SessionContextManager findOrCreateSessionContextManager() {
        SessionContextManager sessionContextManager = mSessContextMgr;
        if (sessionContextManager == null) {
            sessionContextManager = SessionContextManagerImpl.getInstance();
        }
        return sessionContextManager;
    }

    static SessionContext getCurrentSessionContext() {
        return SessionImpl.findOrCreateSessionContextManager().getCurrentSession();
    }

    static void setCurrentSessionContext(SessionContext sessionContext) {
        SessionImpl.findOrCreateSessionContextManager().setCurrentSession(sessionContext);
    }

    public void setTransactionHandlerFactory(TransactionHandlerFactory transactionHandlerFactory) {
        this.mTxnHandlerFactory = transactionHandlerFactory;
    }

    void addPackageDef(PackageDefImpl packageDefImpl) {
        if (packageDefImpl != null && !this.mPkgInfos.contains((Object)packageDefImpl)) {
            this.mPkgInfos.add((Object)packageDefImpl);
        }
    }

    private static String[] convToArr(ArrayList arrayList) {
        return (String[])arrayList.toArray((Object[])new String[arrayList.size()]);
    }

    public LocaleContext getLocaleContext() {
        if (this.mLocaleContext == null) {
            Locale locale = this.getLocale();
            this.mLocaleContext = new DefLocaleContext(locale);
        }
        return this.mLocaleContext;
    }

    public Hashtable getUserData() {
        return this.mUserData;
    }

    void setUserData(Hashtable hashtable) {
        this.mUserData = hashtable;
    }

    public String getUserPrincipalName() {
        String string = (String)this.getEnvironment().get(PropertyMetadata.USER_PRINCIPAL.pName);
        if (string != null) {
            return string;
        }
        return ADFContext.getCurrent().getSecurityContext().getUserName();
    }

    public boolean isUserInRole(String string) {
        JboJAASUserManager jboJAASUserManager;
        String string2 = this.getUserPrincipalName();
        if (string2 != null && string2.length() > 0 && (jboJAASUserManager = this.getUserManager()) != null) {
            return jboJAASUserManager.isUserInRole(string2, string);
        }
        return false;
    }

    public boolean isClient() {
        return false;
    }

    public Subject getSubject() {
        LoginContext loginContext = (LoginContext)this.getEnvironment().get("javax.security.auth.login.LoginContext");
        if (loginContext != null) {
            return loginContext.getSubject();
        }
        return null;
    }

    public String[] getUserRoles() {
        JboJAASUserManager jboJAASUserManager;
        String string = this.getUserPrincipalName();
        if (string != null && string.length() > 0 && (jboJAASUserManager = this.getUserManager()) != null) {
            return jboJAASUserManager.getRoles(string);
        }
        return null;
    }

    boolean isCheckPermission() {
        return JboEnvUtil.isCheckPermission(this.getEnvironment());
    }

    JboJAASContext getJAASContext() {
        if (this.mJAASContext == null && JboEnvUtil.isUserAuthenticated(this.getEnvironment())) {
            this.mJAASContext = JboJAASFactory.create();
            if (this.mJAASContext == null) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = SessionImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new JboException(clazz, "24000", null);
            }
            this.mJAASContext.initialize(this.getEnvironment());
        }
        return this.mJAASContext;
    }

    JboPolicyManager getPolicyManager() {
        return this.getJAASContext() != null ? this.getJAASContext().getPolicyManager() : null;
    }

    JboJAASUserManager getUserManager() {
        return this.getJAASContext() != null ? this.getJAASContext().getJAASUserManager() : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

