/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import oracle.jbo.ApplicationModule;
import oracle.jbo.DefinitionChangedException;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.RepConversion;
import oracle.jbo.pcoll.PCollManager;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.EntityCache;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.ViewObjectImpl;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Serializer {
    ApplicationModuleImpl rootAM;
    DBTransactionImpl txn;
    static final String MOM_TS = "MomVer";
    static final String APPMOD = "AM";
    static final String TXN = "TXN";
    static final String VIEWLINK = "VL";
    static final String VIEWLINKREV = "rev";
    static final String VO_STATIC = "VO";
    static final String DB_CONN = "CONN";
    static final String DYNAMIC = "Dyn";
    static final String DEF = "Def";
    static final String ENTITY = "EO";
    static final String CONTAINEE = "CEO";
    static final String NAME = "Name";
    static final String KEY = "Key";
    static final String KEY_ATTRS = "Attrs";
    static final String ROWSET = "RS";
    static final String IS_EXECUTED = "Ex";
    static final String HAS_ITERATOR = "It";
    static final String RANGE_START = "St";
    static final String RANGE_SIZE = "Sz";
    static final String FK_PARAMS = "fk";
    static final String PARAMS = "args";
    static final String DIFF_PARAMS = "da";
    static final String EX_FK_PARAMS = "exFK";
    static final String EX_PARAMS = "exArgs";
    static final String PARAMCOUNT = "ct";
    static final String PARAM = "arg";
    static final String NULL_VALUE = "%null%";
    static final String CLIENTDATA = "cd";
    static final String VO_SIGNATURE = "sig";
    static final String CUSTOMDATA = "cud";
    static final String VARIABLES = "vars";
    static final String RS_VARIABLES = "rsvars";
    static final String VIEW_CRITERIA = "VC";
    static final String VC_ROW = "Row";
    static final String VC_IDX = "i";
    static final String VC_UC = "uc";
    static final String VC_CJ = "cj";
    static final String VC_VAL = "v";
    static final String VC_ATTR = "a";
    static final String USER_QUERY = "uq";
    static final String QUERY_SELECT = "Se";
    static final String QUERY_FROM = "Fr";
    static final String QUERY_WHERE = "Wh";
    static final String QUERY_ORDER = "Or";
    static final String TXN_VAL_MODE = "Def";
    static final String TXN_NEW_MODE = "New";
    static final String TXN_LOCKING_MODE = "Lok";
    static final String ST_FALSE = "0";
    static final String ST_TRUE = "1";
    static final String VO_MAXFETCHSIZE = "ms";
    static final String VO_FWDMODE = "fo";
    static final String VO_FETCHSIZE = "fs";
    static final String VO_FETCHMODE = "fm";
    static final String VO_ITERMODE = "im";
    static final String VO_ASSOC_CONS = "ac";
    static final String VO_ACCESSOR_RET = "acr";
    static final String VO_VC_NAMES = "name";
    static final String VO_APPLIED_VC_NAMES = "avcs";
    static final String VO_REMOTE = "cli";
    static final String VO_PARAM_NAME = "n";
    static final String VO_PARAM_TYPE = "t";
    static final String VO_MANAGEROWSBYKEY = "mk";
    static final String SNAPSHOT_STACK = "psc";
    static final String SNAPSHOT = "ps";
    static final String SNAPSHOT_ID = "psi";
    static final String SNAPSHOT_NAME = "psn";
    static final String SNAPSHOT_TYPE = "pst";
    static final String PCOLL_OBJ_ID = "pcid";
    public static final int PASSIVATE_STACK_FLAG = 1;
    public static final int PASSIVATE_TXN_FLAG = 2;
    public static final int PASSIVATE_CONN_FLAG = 4;
    public static final int DEFAULT_PASSIVATE_FLAGS = 1;
    public static final int ACTIVATE_ROLLBACK_FLAG = 1;
    public static final int ACTIVATE_TXN_FLAG = 2;
    public static final int ACTIVATE_CONN_FLAG = 4;
    public static final int ACTIVATE_SKIP_RESTORE_VO_FROM_DEF = 8;
    public static final int DEFAULT_ACTIVATE_FLAGS = 1;

    Serializer(ApplicationModuleImpl applicationModuleImpl) {
        this.rootAM = applicationModuleImpl;
        this.txn = applicationModuleImpl.getDBTransactionImpl();
    }

    abstract int snapCommittedEOs();

    abstract void replayCommittedEOs(int var1);

    abstract void removeCommittedEOs(int var1);

    abstract int passivateRootAM(byte[] var1);

    abstract int passivateRootAM(byte[] var1, int var2);

    abstract int passivateRootAM(int var1, byte[] var2);

    abstract int passivateRootAM(int var1, byte[] var2, int var3);

    abstract byte[] activateRootAM(int var1, boolean var2);

    abstract byte[] activateRootAM(int var1, boolean var2, int var3);

    abstract void removeRootAM(int var1);

    abstract int reservePassivationId();

    void passivate(XMLDocument xMLDocument, byte[] byArray) {
        this.passivate(xMLDocument, byArray, 1);
    }

    void passivate(XMLDocument xMLDocument, byte[] byArray, int n) {
        try {
            XMLElement xMLElement = (XMLElement)xMLDocument.createElement(APPMOD);
            Element element = xMLDocument.createElement(CLIENTDATA);
            if (byArray != null) {
                element.appendChild(xMLDocument.createTextNode(RepConversion.bArray2String(byArray)));
            }
            xMLElement.appendChild((Node)element);
            xMLElement.setAttribute(MOM_TS, MetaObjectManager.getSingleton().getVersionTimestamp().toString());
            if ((n & 4) == 0) {
                this.passivateTxn(xMLDocument, xMLElement);
            }
            if ((n & 2) == 0) {
                this.rootAM.doPassivateAMState(xMLDocument, xMLElement, n);
            }
            xMLDocument.appendChild((Node)xMLElement);
            if (Diagnostic.isOn()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                xMLDocument.print((OutputStream)byteArrayOutputStream);
                Diagnostic.println(byteArrayOutputStream.toString());
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    byte[] activate(XMLDocument xMLDocument) {
        return this.activate(xMLDocument, 1);
    }

    byte[] activate(XMLDocument xMLDocument, int n) {
        boolean bl = false;
        try {
            try {
                XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
                Node node = xMLElement.getFirstChild().getFirstChild();
                byte[] byArray = node != null ? RepConversion.convertHexStringToByte(node.getNodeValue()) : new byte[]{};
                Long l = new Long(xMLElement.getAttribute(MOM_TS));
                bl = MetaObjectManager.getSingleton().getVersionTimestamp().compareTo(l) > 0;
                if (bl) {
                    this.rootAM.handleDefinitionChangedOnActivate(l);
                }
                if ((n & 4) == 0) {
                    NodeList nodeList;
                    if ((n & 1) > 0) {
                        this.txn.rollback();
                    }
                    if ((nodeList = xMLElement.getChildrenByTagName(TXN)).getLength() > 0) {
                        this.activateTxn((XMLElement)nodeList.item(0));
                    }
                }
                if ((n & 2) == 0) {
                    this.rootAM.doActivateAMState(xMLElement, n);
                }
                byte[] byArray2 = byArray;
                Object var13_10 = null;
                return byArray2;
            }
            catch (JboException jboException) {
                throw bl ? new DefinitionChangedException(jboException) : jboException;
            }
            catch (Exception exception) {
                throw bl ? new DefinitionChangedException(exception) : new JboException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            throw throwable;
        }
    }

    static ViewObjectImpl activateDynamicVO(ApplicationModule applicationModule, ViewObjectImpl viewObjectImpl, String string, NodeList nodeList, int[] nArray) {
        boolean bl;
        boolean bl2 = bl = nodeList.item(0).getNodeName() != ENTITY;
        if (viewObjectImpl == null) {
            int n = string.lastIndexOf(46);
            if (n > 0) {
                applicationModule = applicationModule.findApplicationModule(string.substring(0, n));
                string = string.substring(n + 1);
            }
            if (bl) {
                viewObjectImpl = (ViewObjectImpl)applicationModule.createViewObjectFromQueryStmt(string, nodeList.item(0).getFirstChild().getNodeValue());
            } else {
                Node node = nodeList.item(3).getFirstChild();
                String string2 = node != null ? node.getNodeValue().intern() : null;
                node = nodeList.item(4).getFirstChild();
                String string3 = node != null ? node.getNodeValue().intern() : null;
                viewObjectImpl = (ViewObjectImpl)applicationModule.createViewObjectFromQueryClauses(string, nodeList.item(0).getFirstChild().getNodeValue(), nodeList.item(1).getFirstChild().getNodeValue(), nodeList.item(2).getFirstChild().getNodeValue(), NULL_VALUE == string2 ? null : string2, NULL_VALUE == string3 ? null : string3);
            }
        }
        nArray[0] = bl ? 1 : 5;
        return viewObjectImpl;
    }

    void passivateTxn(XMLDocument xMLDocument, XMLElement xMLElement) throws Exception {
        Object object;
        ArrayList arrayList = (ArrayList)this.txn.mTransPostListeners.clone();
        ArrayList arrayList2 = (ArrayList)this.txn.mTransListeners.clone();
        HashMap hashMap = (HashMap)this.txn.mValidationListeners.clone();
        XMLElement xMLElement2 = (XMLElement)xMLDocument.createElement(TXN);
        xMLElement2.setAttribute("Def", this.txn.isBundledExceptionMode() ? ST_TRUE : ST_FALSE);
        xMLElement2.setAttribute(TXN_NEW_MODE, this.txn.isTrackNewAndModifiedRowsOnly() ? ST_TRUE : ST_FALSE);
        xMLElement2.setAttribute(TXN_LOCKING_MODE, String.valueOf(this.txn.getLockingMode()));
        PCollManager pCollManager = this.txn.getPCollManager();
        if (pCollManager != null) {
            xMLElement2.setAttribute(PCOLL_OBJ_ID, String.valueOf(pCollManager.getNextObjId()));
        }
        int n = 0;
        n = 0;
        while (n < arrayList2.size()) {
            object = arrayList2.get(n);
            if (object instanceof EntityImpl) {
                Serializer.passivateEntity(xMLDocument, xMLElement2, (EntityImpl)object, 0x10000000L);
                hashMap.remove(object);
                arrayList.remove(object);
            }
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            object = arrayList.get(n);
            if (object instanceof EntityImpl) {
                Serializer.passivateEntity(xMLDocument, xMLElement2, (EntityImpl)object, 0x10000000L);
                hashMap.remove(object);
            }
            ++n;
        }
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof EntityImpl)) continue;
            Serializer.passivateEntity(xMLDocument, xMLElement2, (EntityImpl)object, 0x10000000L);
        }
        xMLElement.appendChild((Node)xMLElement2);
    }

    void activateTxn(XMLElement xMLElement) throws Exception {
        String string;
        String string2;
        boolean bl = ST_TRUE.equals(xMLElement.getAttribute("Def"));
        if (bl) {
            this.txn.setBundledExceptionMode(bl);
        }
        if (bl = ST_TRUE.equals(xMLElement.getAttribute(TXN_NEW_MODE))) {
            this.txn.setTrackNewAndModifiedRowsOnly(bl);
        }
        if ((string2 = xMLElement.getAttribute(TXN_LOCKING_MODE)) != null) {
            this.txn.setLockingMode(Integer.parseInt(string2));
        }
        if ((string = xMLElement.getAttribute(PCOLL_OBJ_ID)) != null && string.length() > 0) {
            this.txn.getPCollManager().useObjIdUpto(Integer.valueOf(string).intValue());
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Serializer.activateEntity((XMLElement)nodeList.item(n), this.txn, null, true);
            ++n;
        }
    }

    static void passivateEntity(XMLDocument xMLDocument, XMLElement xMLElement, EntityImpl entityImpl, long l) throws Exception {
        byte by = entityImpl.getPostState();
        if (entityImpl.getEntityState() == 0 && (by == 3 || by == 4)) {
            return;
        }
        Key key = entityImpl.retrievePrimaryKey(true, false);
        if (key != null) {
            XMLElement xMLElement2 = (XMLElement)xMLDocument.createElement(ENTITY);
            xMLElement2.setAttribute(NAME, entityImpl.mEbi.getFullName());
            CDATASection cDATASection = xMLDocument.createCDATASection(KEY);
            cDATASection.setNodeValue(key.toStringFormat(false));
            xMLElement2.appendChild((Node)cDATASection);
            Node node = entityImpl.writeXML(-1, l);
            try {
                xMLElement2.appendChild(node);
            }
            catch (XMLDOMException xMLDOMException) {
                node = xMLDocument.adoptNode(node);
                xMLElement2.appendChild(node);
            }
            xMLElement.appendChild((Node)xMLElement2);
        }
    }

    static void activateEntity(XMLElement xMLElement, DBTransactionImpl dBTransactionImpl, EntityImpl entityImpl, boolean bl) throws Exception {
        EntityDefImpl entityDefImpl = EntityDefImpl.findDefObject(xMLElement.getAttribute(NAME));
        Node node = xMLElement.getFirstChild();
        Key key = new Key(node.getNodeValue(), entityDefImpl.getPrimaryKeys());
        EntityImpl entityImpl2 = null;
        node = node.getNextSibling();
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = Byte.valueOf(((XMLElement)node).getAttribute("PS")) != 0;
            if (bl2) {
                entityImpl2 = entityDefImpl.findByPrimaryKey(dBTransactionImpl, key);
            }
            boolean bl4 = false;
            if (entityImpl2 == null) {
                bl4 = true;
            } else {
                byte by = entityImpl2.getPostState();
                boolean bl5 = bl4 = by != 1 && by != 2;
            }
            if (bl4) {
                EntityImpl entityImpl3;
                entityImpl2 = entityDefImpl.newInstance(dBTransactionImpl);
                entityImpl2.initActivatedEntity(entityImpl);
                entityImpl2.setStateToNew();
                if (bl2 && (entityImpl3 = entityImpl2.activateMissingEntity(key)) != entityImpl2) {
                    entityImpl2.remove();
                    entityImpl2 = entityImpl3;
                }
            } else if (entityImpl == null) {
                String string = ((XMLElement)node).getAttribute(EntityImpl.XML_PK_CHANGED);
                bl4 = string != null && string.length() > 0;
            }
            entityImpl2.readAttrsFromXML((Element)((XMLElement)node), entityDefImpl.getAttributeDefImpls(), 1);
            entityImpl2.notifyEntityActivated(false);
        } else {
            EntityCache entityCache = dBTransactionImpl.findEntityCache(entityDefImpl);
            if (entityCache != null && (entityImpl2 = entityCache.get(key)) != null) {
                switch (entityImpl2.getPostState()) {
                    case 1: {
                        if (entityImpl2.isLocked()) break;
                        entityImpl2.readAttrsFromXML((Element)((XMLElement)node), entityDefImpl.getAttributeDefImpls(), -1);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case -1: 
                    case 0: {
                        break;
                    }
                }
            }
        }
    }

    void passivateCommitList(XMLDocument xMLDocument) {
        try {
            XMLElement xMLElement = (XMLElement)xMLDocument.createElement(TXN);
            ArrayList arrayList = (ArrayList)this.txn.mTransListeners.clone();
            int n = 0;
            n = 0;
            while (n < arrayList.size()) {
                Object object = arrayList.get(n);
                if (object instanceof EntityImpl) {
                    Serializer.passivateEntity(xMLDocument, xMLElement, (EntityImpl)object, 0L);
                }
                ++n;
            }
            if (xMLElement.getFirstChild() != null) {
                xMLDocument.appendChild((Node)xMLElement);
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    void activateCommitList(XMLDocument xMLDocument) {
        try {
            XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
            NodeList nodeList = xMLElement.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Serializer.activateEntity((XMLElement)nodeList.item(n), this.txn, null, false);
                ++n;
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }
}

