/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Properties;
import oracle.jbo.AttributeDef;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.PropertyMetadata;

public class JDBCInteract {
    public static boolean mDoTrace;

    public static void init() {
        mDoTrace = PropertyMetadata.PN_JBO_JDBC_TRACE.getPropertyAsBoolean();
    }

    public static String getStmtVarName(Statement statement) {
        if (statement instanceof CallableStatement) {
            return "cStmt";
        }
        if (statement instanceof PreparedStatement) {
            return "pStmt";
        }
        if (statement instanceof Statement) {
            return "stmt";
        }
        JDBCInteract.println("// ERROR:  Unknown stmt type " + statement.getClass().getName() + "  ");
        return "???";
    }

    public static String getValueString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Integer) {
            return "new Integer(" + object.toString() + ")";
        }
        if (object instanceof String) {
            return "\"" + object.toString() + "\"";
        }
        if (object instanceof BigDecimal) {
            return "new BigDecimal((double) " + object.toString() + ")";
        }
        if (object instanceof Double) {
            return "new Double((double) " + object.toString() + ")";
        }
        if (object instanceof Date) {
            return "new Date(\"" + object.toString() + "\")";
        }
        JDBCInteract.println("// ERROR:  Unknown data type " + object.getClass().getName() + "  ");
        return "\"" + object.toString() + "\"";
    }

    public static void println(String string) {
        if (Diagnostic.isOn()) {
            Diagnostic.println(string + "  // JBO-JDBC-INTERACT");
        }
    }

    public static void header() {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("import java.util.*;");
        JDBCInteract.println("import java.sql.*;");
        JDBCInteract.println("import java.io.*;");
        JDBCInteract.println("public class JDBCCalls");
        JDBCInteract.println("{");
        JDBCInteract.println("   public Connection conn = null;");
        JDBCInteract.println("   public CallableStatement cStmt = null;");
        JDBCInteract.println("   public PreparedStatement pStmt = null;");
        JDBCInteract.println("   public Statement stmt = null;");
        JDBCInteract.println("   public ResultSet rslt = null;");
        JDBCInteract.println("   public static void main(String argv[])");
        JDBCInteract.println("   {");
        JDBCInteract.println("      DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());");
    }

    public static void connect(String string) {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      conn = DriverManager.getConnection(\"" + string + "\");");
    }

    public static void connect(String string, Properties properties) {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      conn = DriverManager.getConnection(\"" + string + "\", /*properties*/);");
    }

    public static void connect(String string, String string2, String string3) {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      conn = DriverManager.getConnection(\"" + string + "\", \"" + string2 + "\", \"" + string3 + "\");");
    }

    public static void setAutoCommit(boolean bl) {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      conn.setAutoCommit(" + bl + ");");
    }

    public static void commit() {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      conn.commit();");
    }

    public static void rollback() {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      conn.rollback();");
    }

    public static void closeConn() {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      conn.close();");
    }

    public static void closeStmt(Statement statement) {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      " + JDBCInteract.getStmtVarName(statement) + ".close();");
    }

    public static void createStatement() {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      stmt = conn.createStatement();");
    }

    public static void prepareStatement(String string) {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      pStmt = conn.prepareStatement(\"" + string + "\");");
    }

    public static void prepareCall(String string) {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      cStmt = conn.prepareCall(\"" + string + "\");");
    }

    public static void executeUpdate(Statement statement, String string) {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      " + JDBCInteract.getStmtVarName(statement) + ".executeUpdate(\"" + string + "\");");
    }

    public static void addBatch(Statement statement) {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      (OraclePreparedStatement)" + JDBCInteract.getStmtVarName(statement) + ".addBatch();");
    }

    public static void executeBatch(Statement statement) {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      (OraclePreparedStatement)" + JDBCInteract.getStmtVarName(statement) + ".executeBatch();");
    }

    public static void execute(Statement statement) {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      " + JDBCInteract.getStmtVarName(statement) + ".execute();");
    }

    public static void executeQuery(Statement statement) {
        if (!mDoTrace) {
            return;
        }
        JDBCInteract.println("      rslt = " + JDBCInteract.getStmtVarName(statement) + ".executeQuery();");
    }

    static void setNullInternal(Statement statement, int n, String string, int n2, AttributeDef attributeDef) {
        if (!mDoTrace) {
            return;
        }
        String string2 = JDBCInteract.getStmtVarName(statement);
        String string3 = "";
        if (attributeDef != null) {
            string3 = " /*" + attributeDef.getName() + "*/";
        }
        if (string != null) {
            JDBCInteract.println("      " + string2 + ".setNullAtName(" + string + ", " + n2 + ");" + string3);
        } else {
            JDBCInteract.println("      " + string2 + ".setNull(" + n + ", " + n2 + ");" + string3);
        }
    }

    public static void setNull(Statement statement, int n, int n2, AttributeDef attributeDef) {
        JDBCInteract.setNullInternal(statement, n, null, n2, attributeDef);
    }

    public static void setNullAtName(Statement statement, String string, int n, AttributeDef attributeDef) {
        JDBCInteract.setNullInternal(statement, -1, string, n, attributeDef);
    }

    public static void setObjectInternal(Statement statement, int n, String string, Object object, AttributeDef attributeDef) {
        if (!mDoTrace) {
            return;
        }
        String string2 = JDBCInteract.getStmtVarName(statement);
        String string3 = JDBCInteract.getValueString(object);
        String string4 = "";
        if (attributeDef != null) {
            string4 = " /*" + attributeDef.getName() + "*/";
        }
        if (string != null) {
            JDBCInteract.println("      " + string2 + ".setObjectAtName(" + string + ", " + string3 + ");" + string4);
        } else {
            JDBCInteract.println("      " + string2 + ".setObject(" + n + ", " + string3 + ");" + string4);
        }
    }

    public static void setObject(Statement statement, int n, Object object, AttributeDef attributeDef) {
        JDBCInteract.setObjectInternal(statement, n, null, object, attributeDef);
    }

    public static void setObjectAtName(Statement statement, String string, Object object, AttributeDef attributeDef) {
        JDBCInteract.setObjectInternal(statement, -1, string, object, attributeDef);
    }

    public static void registerOutParameter(Statement statement, int n, int n2) {
        if (!mDoTrace) {
            return;
        }
        String string = JDBCInteract.getStmtVarName(statement);
        JDBCInteract.println("      " + string + ".registerOutParameter(" + n + ", " + n2 + ");");
    }
}

