/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import oracle.jbo.JboException;
import oracle.jbo.PersistenceException;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.ComponentObjectImpl;
import oracle.jbo.server.DefObject;
import oracle.jbo.server.EntityAssociationReference;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.RowDef;
import oracle.jbo.server.ViewAttributeDefImpl;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewObjectImpl;

public class EntityReference
extends ComponentObjectImpl {
    protected EntityDefImpl mEOInfo;
    protected ArrayList mAssocRefs;
    protected ArrayList mAttrRefs;
    private AttributeDefImpl[] mDiscrColumns;
    private int[] mDiscrColLoadIndices;
    private boolean mLockParticipant;
    private boolean mDeleteParticipant;
    private boolean mInsertParticipant;
    private boolean mReference;
    private int mIndex;
    private boolean mHasPrimaryKeys;
    private boolean mIsReadOnly;
    private boolean mIsEntireObjectTable;

    private /* synthetic */ void $init$() {
        this.mAssocRefs = new ArrayList();
        this.mAttrRefs = new ArrayList();
        this.mDiscrColumns = null;
        this.mDiscrColLoadIndices = null;
        this.mLockParticipant = true;
        this.mDeleteParticipant = true;
        this.mInsertParticipant = true;
        this.mReference = false;
        this.mIndex = -1;
        this.mHasPrimaryKeys = false;
        this.mIsReadOnly = false;
        this.mIsEntireObjectTable = false;
    }

    EntityReference() {
        this.$init$();
    }

    void setReferenceObject(DefObject defObject) {
        this.mEOInfo = (EntityDefImpl)defObject;
    }

    void setDef(DefObject defObject) {
        super.setDef(defObject);
        this.mEOInfo = (EntityDefImpl)defObject;
    }

    int getOrderIndex() {
        return this.mIndex;
    }

    void setOrderIndex(int n) {
        this.mIndex = n;
    }

    public EntityDefImpl getEntityDef() {
        return this.mEOInfo;
    }

    public DefObject getDef() {
        return this.getEntityDef();
    }

    ViewAttributeDefImpl[] getViewAttributeDefImpls() {
        return (ViewAttributeDefImpl[])this.mAttrRefs.toArray((Object[])new ViewAttributeDefImpl[this.mAttrRefs.size()]);
    }

    void setViewAttributeDefImpls(ViewAttributeDefImpl[] viewAttributeDefImplArray) {
        this.mAttrRefs.clear();
        int n = 0;
        while (n < viewAttributeDefImplArray.length) {
            this.mAttrRefs.add((Object)viewAttributeDefImplArray[n]);
            viewAttributeDefImplArray[n].setParent(this);
            ++n;
        }
    }

    ArrayList getAssociationReferencesList() {
        return this.mAssocRefs;
    }

    EntityAssociationReference[] getAssociationReferences() {
        return (EntityAssociationReference[])this.mAssocRefs.toArray((Object[])new EntityAssociationReference[this.mAssocRefs.size()]);
    }

    void setAssociationReferences(EntityAssociationReference[] entityAssociationReferenceArray) {
        this.mAssocRefs.clear();
        int n = 0;
        while (n < entityAssociationReferenceArray.length) {
            this.mAssocRefs.add((Object)entityAssociationReferenceArray[n]);
            ++n;
        }
    }

    ViewAttributeDefImpl createViewAttribute(String string, String string2, AttributeDefImpl attributeDefImpl, int n, byte by, Class clazz, boolean bl, Object object, RowDef rowDef) {
        int n2 = -1;
        ViewAttributeDefImpl viewAttributeDefImpl = this.findViewAttrDefByViewAttrName(string, attributeDefImpl);
        if (viewAttributeDefImpl != null) {
            n2 = viewAttributeDefImpl.getIndex();
            if (n >= 0 && n2 != n) {
                throw new JboException("Internal problem (EntityReference.createViewAttribute): attr indices mismatch for " + string + " index=" + n + ", attrIndex=" + viewAttributeDefImpl.getIndex());
            }
            n = n2;
        }
        viewAttributeDefImpl = new ViewAttributeDefImpl(string, string2, attributeDefImpl, n, by, clazz, bl, object, rowDef, null);
        viewAttributeDefImpl.setParent(this);
        if (n2 >= 0) {
            this.mAttrRefs.set(n2, (Object)viewAttributeDefImpl);
        } else {
            this.mAttrRefs.add((Object)viewAttributeDefImpl);
        }
        return viewAttributeDefImpl;
    }

    ViewDefImpl getViewObject() {
        return (ViewDefImpl)this.mParent;
    }

    void addEntityAssociationReference(EntityAssociationReference entityAssociationReference) {
        if (!this.mAssocRefs.contains((Object)entityAssociationReference)) {
            this.mAssocRefs.add((Object)entityAssociationReference);
        }
    }

    void addViewAttributeDefImpl(ViewAttributeDefImpl viewAttributeDefImpl) {
        if (!this.mAttrRefs.contains((Object)viewAttributeDefImpl)) {
            this.mAttrRefs.add((Object)viewAttributeDefImpl);
        }
    }

    void setLockParticipant(boolean bl) {
        this.mLockParticipant = bl;
    }

    boolean isLockParticipant() {
        return this.mLockParticipant;
    }

    void setDeleteParticipant(boolean bl) {
        this.mDeleteParticipant = bl;
    }

    boolean isDeleteParticipant() {
        return this.isReference() ? false : this.mDeleteParticipant;
    }

    void setInsertParticipant(boolean bl) {
        this.mInsertParticipant = bl;
    }

    boolean isInsertParticipant() {
        return this.mInsertParticipant;
    }

    public boolean isEntireObjectTable() {
        return this.mIsEntireObjectTable;
    }

    public void setEntireObjectTable(boolean bl) {
        this.mIsEntireObjectTable = bl;
    }

    ViewAttributeDefImpl[] getViewAttributeDefImpls(AttributeDefImpl attributeDefImpl) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.mAttrRefs.size()) {
            AttributeDefImpl attributeDefImpl2 = ((ViewAttributeDefImpl)this.mAttrRefs.get(n)).getAttributeDefImpl();
            if (attributeDefImpl2 == attributeDefImpl || attributeDefImpl.getName() == attributeDefImpl2.getName()) {
                arrayList.add(this.mAttrRefs.get(n));
            }
            ++n;
        }
        return (ViewAttributeDefImpl[])arrayList.toArray((Object[])new ViewAttributeDefImpl[arrayList.size()]);
    }

    void setReference(boolean bl) {
        this.mReference = bl;
    }

    void setReadOnly(boolean bl) {
        this.mIsReadOnly = bl;
    }

    boolean isReference() {
        return this.mReference;
    }

    protected ViewAttributeDefImpl findViewAttributeDefImpl(String string, AttributeDefImpl attributeDefImpl) {
        return this.findViewAttrDefByEntityAttrName(string, attributeDefImpl);
    }

    protected ViewAttributeDefImpl findViewAttrDefByViewAttrName(String string, AttributeDefImpl attributeDefImpl) {
        string = string.intern();
        int n = 0;
        while (n < this.mAttrRefs.size()) {
            ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mAttrRefs.get(n);
            if (viewAttributeDefImpl.getAttributeDefImpl() == attributeDefImpl && viewAttributeDefImpl.getName() == string) {
                return viewAttributeDefImpl;
            }
            ++n;
        }
        return null;
    }

    protected ViewAttributeDefImpl findViewAttrDefByEntityAttrName(String string, AttributeDefImpl attributeDefImpl) {
        string = string.intern();
        int n = 0;
        while (n < this.mAttrRefs.size()) {
            ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mAttrRefs.get(n);
            if (viewAttributeDefImpl.getAttributeDefImpl() == attributeDefImpl && attributeDefImpl.getName() == string) {
                return viewAttributeDefImpl;
            }
            ++n;
        }
        return null;
    }

    protected ViewAttributeDefImpl findViewAttributeDefImpl(String string) {
        string = string.intern();
        int n = 0;
        while (n < this.mAttrRefs.size()) {
            ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mAttrRefs.get(n);
            if (viewAttributeDefImpl.getAttributeDefImpl().getName() == string) {
                return viewAttributeDefImpl;
            }
            ++n;
        }
        return null;
    }

    protected ArrayList findViewAttributeDefImpls(AttributeDefImpl attributeDefImpl) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.mAttrRefs.size()) {
            ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mAttrRefs.get(n);
            if (viewAttributeDefImpl.getAttributeDefImpl() == attributeDefImpl) {
                arrayList.add((Object)viewAttributeDefImpl);
            }
            ++n;
        }
        return arrayList;
    }

    boolean isReadOnly() {
        return this.mIsReadOnly;
    }

    ArrayList findEntityAssociationReferences(ViewAttributeDefImpl viewAttributeDefImpl) {
        ArrayList arrayList = null;
        AttributeDefImpl attributeDefImpl = viewAttributeDefImpl.getAttributeDefImpl();
        int n = 0;
        while (n < this.mAssocRefs.size()) {
            EntityAssociationReference entityAssociationReference = (EntityAssociationReference)this.mAssocRefs.get(n);
            if (entityAssociationReference.getEntityReference() == this) {
                AttributeDefImpl[] attributeDefImplArray = entityAssociationReference.getEntityAssociation().findEndByName(entityAssociationReference.getEndName()).getAttributeDefImpls();
                int n2 = 0;
                while (n2 < attributeDefImplArray.length) {
                    if (attributeDefImplArray[n2] == attributeDefImpl) {
                        if (arrayList == null) {
                            arrayList = new ArrayList(5);
                        }
                        arrayList.add((Object)entityAssociationReference);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList;
    }

    boolean hasDiscrColumns() {
        AttributeDefImpl[] attributeDefImplArray = this.getEntityDef().getDiscrColumns();
        return attributeDefImplArray != null && attributeDefImplArray.length > 0;
    }

    AttributeDefImpl[] getDiscrColumns() {
        return this.mDiscrColumns;
    }

    int[] getDiscrColLoadIndices() {
        AttributeDefImpl[] attributeDefImplArray = this.getDiscrColumns();
        if (attributeDefImplArray != null && this.mDiscrColLoadIndices == null) {
            this.mDiscrColLoadIndices = ViewObjectImpl.calcDiscrColLoadIndices(attributeDefImplArray, this.getViewObject().getAttributeDefs());
        }
        return this.mDiscrColLoadIndices;
    }

    void verifyReference() {
        this.verifyReadOnly();
        this.verifyPrimaryKeys();
        this.verifyDiscrColumns();
        if (!this.mHasPrimaryKeys || this.isReadOnly()) {
            this.setInsertParticipant(false);
            this.setDeleteParticipant(false);
            this.setLockParticipant(false);
        }
        if (!this.mHasPrimaryKeys && this.mIndex > 0) {
            this.setReference(true);
        }
        if (this.isReference()) {
            this.setInsertParticipant(false);
            this.setDeleteParticipant(false);
        }
        if (this.isInsertParticipant()) {
            AttributeDefImpl[] attributeDefImplArray = this.getEntityDef().getPrimaryKeys();
            int n = 0;
            while (n < attributeDefImplArray.length) {
                ArrayList arrayList = this.findViewAttributeDefImpls(attributeDefImplArray[n]);
                byte by = -1;
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)arrayList.get(n2);
                    if (by < viewAttributeDefImpl.getUpdateableFlag()) {
                        by = viewAttributeDefImpl.getUpdateableFlag();
                    }
                    ++n2;
                }
                if (this.mIndex > 0 && by == 0 && !attributeDefImplArray[n].isRetrievedOnInsert()) {
                    this.setInsertParticipant(false);
                }
                ++n;
            }
        }
    }

    boolean hasPrimaryKeys() {
        return this.mHasPrimaryKeys;
    }

    private void verifyPrimaryKeys() {
        AttributeDefImpl[] attributeDefImplArray = this.getEntityDef().getPrimaryKeys();
        int n = 0;
        while (n < attributeDefImplArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.mAttrRefs.size()) {
                if (attributeDefImplArray[n] == ((ViewAttributeDefImpl)this.mAttrRefs.get(n2)).getAttributeDefImpl()) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl && this.mAttrRefs.size() > 0) {
                this.mHasPrimaryKeys = false;
                if (MetaObjectManager.getSingleton().is323Compatible()) {
                    return;
                }
                throw new PersistenceException("26028", new String[]{this.getViewObject().getName(), this.getName(), attributeDefImplArray[n].getName()});
            }
            ++n;
        }
        this.mHasPrimaryKeys = true;
    }

    private void verifyDiscrColumns() {
        AttributeDefImpl[] attributeDefImplArray = this.getEntityDef().getDiscrColumns();
        ArrayList arrayList = null;
        int n = 0;
        while (attributeDefImplArray != null && n < attributeDefImplArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.mAttrRefs.size()) {
                ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mAttrRefs.get(n2);
                if (attributeDefImplArray[n] == viewAttributeDefImpl.getAttributeDefImpl()) {
                    if (arrayList == null) {
                        arrayList = new ArrayList(2);
                    }
                    arrayList.add((Object)viewAttributeDefImpl);
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                throw new PersistenceException("26015", new String[]{this.getViewObject().getName(), this.getName(), attributeDefImplArray[n].getName()});
            }
            ++n;
        }
        if (arrayList != null) {
            this.mDiscrColumns = new AttributeDefImpl[arrayList.size()];
            arrayList.toArray((Object[])this.mDiscrColumns);
        }
    }

    private void verifyReadOnly() {
        if (!this.mIsReadOnly) {
            int n = 0;
            while (n < this.mAttrRefs.size()) {
                ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mAttrRefs.get(n);
                if (viewAttributeDefImpl.getUpdateableFlag() != 0) {
                    this.mIsReadOnly = false;
                    return;
                }
                ++n;
            }
            this.mIsReadOnly = true;
        }
    }
}

