/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboException;
import oracle.jbo.ReadXMLException;
import oracle.jbo.common.DataDocument;
import oracle.jbo.server.ViewObjectDeletedRowNodeFilter;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewObjectRowNodeFilter;
import oracle.jbo.server.XmlDocumentReader;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class DotNetXmlDocumentReader
extends XmlDocumentReader {
    private XMLSchema mSchema;
    private DataDocument mDataDocument;
    private ArrayList mChangedViewObjects;
    private XMLElement mDiffGramDataNode;
    private XMLElement mDiffGramBeforeNode;
    private boolean bSearched;

    private /* synthetic */ void $init$() {
        this.mChangedViewObjects = new ArrayList();
        this.bSearched = false;
    }

    public DotNetXmlDocumentReader(Document document) {
        super(document);
        this.$init$();
        this.buildSchema();
    }

    public DataDocument readDataDocument(ApplicationModule applicationModule) {
        DataDocument dataDocument;
        this.mDataDocument = dataDocument = new DataDocument("");
        this.setupDocument(applicationModule);
        this.readData();
        this.mDataDocument = null;
        return dataDocument;
    }

    public Element getChildElement(Element element, String string, int n) {
        Element element2 = null;
        if (n == 1) {
            String string2 = element.getAttributeNS("urn:schemas-microsoft-com:xml-diffgram-v1", "id");
            NodeList nodeList = this.mDiffGramBeforeNode.getChildrenByTagName(element.getNodeName());
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                Element element3 = (Element)nodeList.item(0);
                String string3 = element3.getAttributeNS("urn:schemas-microsoft-com:xml-diffgram-v1", "id");
                if (string3.equals(string2)) {
                    element2 = element3;
                    break;
                }
                ++n2;
            }
        } else if (n == 0) {
            element2 = element;
        }
        if (element2 != null) {
            return (Element)DotNetXmlDocumentReader.getChildByTagName(element2, string, true);
        }
        return null;
    }

    public TreeWalker createRowNodeWalker(ViewObjectImpl viewObjectImpl, Node node) {
        return ((XMLDocument)this.getXMLDocument()).createTreeWalker((Node)this.mDiffGramDataNode, 1, (NodeFilter)new ViewObjectRowNodeFilter(viewObjectImpl), false);
    }

    public NodeIterator createRowNodeIterator(ViewObjectImpl viewObjectImpl, Node node) {
        return ((XMLDocument)this.getXMLDocument()).createNodeIterator((Node)this.mDiffGramDataNode, 1, (NodeFilter)new ViewObjectRowNodeFilter(viewObjectImpl), false);
    }

    public NodeIterator createDeletedRowNodeIterator(ViewObjectImpl viewObjectImpl, Node node) {
        return ((XMLDocument)this.getXMLDocument()).createNodeIterator((Node)this.mDiffGramBeforeNode, 1, (NodeFilter)new ViewObjectDeletedRowNodeFilter(viewObjectImpl, this), false);
    }

    private void buildSchema() {
        NodeList nodeList;
        if (this.mSchema == null && (nodeList = this.getXMLDocument().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema")).getLength() != 0) {
            try {
                XSDBuilder xSDBuilder = new XSDBuilder();
                Element element = (Element)nodeList.item(0);
                XMLDocument xMLDocument = new XMLDocument();
                xMLDocument.appendChild(xMLDocument.adoptNode((Node)element));
                this.mSchema = xSDBuilder.build(xMLDocument, null);
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
        }
    }

    private void setupDocument(ApplicationModule applicationModule) {
        XSDElement xSDElement = this.findDataSetElement();
        if (xSDElement != null) {
            String[] stringArray = applicationModule.getViewObjectNames();
            XSDNode xSDNode = xSDElement.getType();
            if (xSDNode instanceof XSDComplexType) {
                XSDComplexType xSDComplexType = (XSDComplexType)xSDNode;
                XSDNode[] xSDNodeArray = xSDComplexType.getElementSet();
                int n = 0;
                while (n < xSDNodeArray.length) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        ViewObjectImpl viewObjectImpl = (ViewObjectImpl)applicationModule.findViewObject(stringArray[n2]);
                        if (viewObjectImpl.getViewDef().getXMLRowElementTag().equals(xSDNodeArray[n].getName())) {
                            this.mChangedViewObjects.add(viewObjectImpl);
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            this.searchDiffGramNodes();
        }
    }

    private XSDElement findDataSetElement() {
        if (this.mSchema != null) {
            XMLSchemaNode xMLSchemaNode = this.mSchema.getSchemaByTargetNS(this.mSchema.getSchemaTargetNS());
            XSDNode[] xSDNodeArray = xMLSchemaNode.getElementSet();
            Object var3_3 = null;
            int n = 0;
            while (n < xSDNodeArray.length) {
                XSDElement xSDElement = (XSDElement)xSDNodeArray[n];
                XSDAnnotation xSDAnnotation = xSDElement.getAnnotation();
                if (xSDAnnotation != null) {
                    Vector vector = xSDAnnotation.getAttributes();
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        XMLAttr xMLAttr = (XMLAttr)vector.get(n2);
                        if (xMLAttr.getLocalName().equalsIgnoreCase("IsDataSet") && xMLAttr.getValue().equalsIgnoreCase("true")) {
                            return xSDElement;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return null;
    }

    private void readData() {
        if (this.mDiffGramDataNode == null) {
            return;
        }
        Iterator iterator = this.mChangedViewObjects.iterator();
        while (iterator.hasNext()) {
            ViewObjectImpl viewObjectImpl = (ViewObjectImpl)iterator.next();
            try {
                viewObjectImpl.readFromXml(this, (Element)this.mDiffGramDataNode);
                this.mDataDocument.addViewObject(viewObjectImpl);
            }
            catch (ReadXMLException readXMLException) {
                // empty catch block
            }
        }
    }

    private void searchDiffGramNodes() {
        if (!this.bSearched) {
            this.bSearched = true;
            XSDElement xSDElement = this.findDataSetElement();
            NodeList nodeList = this.getXMLDocument().getElementsByTagNameNS("urn:schemas-microsoft-com:xml-diffgram-v1", "diffgram");
            if (nodeList.getLength() != 0) {
                Element element = (Element)nodeList.item(0);
                if ((nodeList = element.getElementsByTagNameNS(xSDElement.getTargetNS(), xSDElement.getName())).getLength() != 0) {
                    this.mDiffGramDataNode = (XMLElement)nodeList.item(0);
                }
                if ((nodeList = element.getElementsByTagNameNS("urn:schemas-microsoft-com:xml-diffgram-v1", "before")).getLength() != 0) {
                    this.mDiffGramBeforeNode = (XMLElement)nodeList.item(0);
                }
            }
        }
    }

    Element findCurrentNodeById(String string, String string2) {
        NodeList nodeList = this.mDiffGramDataNode.getElementsByTagName(string);
        int n = 0;
        while (n < nodeList.getLength()) {
            String string3 = ((Element)nodeList.item(n)).getAttributeNS("urn:schemas-microsoft-com:xml-diffgram-v1", "id");
            if (string3 != null && string3.equals(string2)) {
                return (Element)nodeList.item(n);
            }
            ++n;
        }
        return null;
    }

    static Node getChildByTagName(Element element, String string, boolean bl) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (bl ? node.getNodeName().equalsIgnoreCase(string) : node.getNodeName().equals(string)) break;
            node = node.getNextSibling();
        }
        return node;
    }
}

