/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;
import oracle.jbo.AlreadyConnectedException;
import oracle.jbo.AttributeList;
import oracle.jbo.Key;
import oracle.jbo.NotConnectedException;
import oracle.jbo.ViewObject;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.DatabaseTransactionFactory;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.TransactionHandler;

public class DBTransactionImpl2
extends DBTransactionImpl {
    public void connect(Connection connection) {
        if (this.isConnected(false)) {
            throw new AlreadyConnectedException();
        }
        this.setJdbcConnection(connection);
        this.refreshConnectionMetadata();
        DBTransactionImpl.initTxn(this.getTxnApplicationModuleImpl(), this, this.getTransactionHandler());
    }

    public void connect(String string) {
        if (this.isConnected(false)) {
            throw new AlreadyConnectedException();
        }
        this.mConnectionCredentials.mjdbcURL = string;
        DBTransactionImpl.initTxn(this.getTxnApplicationModuleImpl(), this, this.getTransactionHandler());
    }

    public void connect(String string, Properties properties) {
        if (this.isConnected(false)) {
            throw new AlreadyConnectedException();
        }
        this.mConnectionCredentials.mjdbcURL = string;
        this.mConnectionCredentials.mjdbcInfo = properties;
        DBTransactionImpl.initTxn(this.getTxnApplicationModuleImpl(), this, this.getTransactionHandler());
    }

    public void connect(String string, String string2, String string3) {
        if (this.isConnected(false)) {
            throw new AlreadyConnectedException();
        }
        this.mConnectionCredentials.mjdbcURL = string;
        this.mConnectionCredentials.mjdbcUser = string2;
        this.mConnectionCredentials.mjdbcPassword = string3;
        DBTransactionImpl.initTxn(this.getTxnApplicationModuleImpl(), this, this.getTransactionHandler());
    }

    public void connectToDataSource(String string, String string2, String string3, String string4) {
        if (this.isConnected(false)) {
            throw new AlreadyConnectedException();
        }
        throw new UnsupportedOperationException();
    }

    public void connectToDataSource(String string, String string2, String string3, String string4, String string5, String string6) {
        if (this.isConnected(false)) {
            throw new AlreadyConnectedException();
        }
        throw new UnsupportedOperationException();
    }

    public void connectToDataSource(DataSource dataSource, boolean bl) {
        this.connectToDataSource(dataSource, null, null, bl);
    }

    public void connectToDataSource(DataSource dataSource, String string, String string2, boolean bl) {
        if (this.isConnected(false)) {
            throw new AlreadyConnectedException();
        }
        this.mConnectionCredentials.mIsJTABased = bl;
        this.mConnectionCredentials.mjdbcUser = string;
        this.mConnectionCredentials.mjdbcPassword = string2;
        this.mConnectionCredentials.mDataSource = dataSource;
        TransactionHandler transactionHandler = null;
        Object var6_6 = null;
        transactionHandler = bl ? DBTransactionImpl.createJTATransactionHandler(this.getTxnApplicationModuleImpl()) : DBTransactionImpl.createTransactionHandler(this.getTxnApplicationModuleImpl());
        this.transitionToState(5);
        DBTransactionImpl.initTxn(this.getTxnApplicationModuleImpl(), this, transactionHandler);
    }

    public void connectToDataSource(Hashtable hashtable, String string, String string2, String string3, boolean bl) {
        this.connectToDataSource(DBTransactionImpl.lookupDataSource(hashtable, string), string2, string3, bl);
    }

    public void connectToDataSource(Hashtable hashtable, String string, boolean bl) {
        this.connectToDataSource(hashtable, string, null, null, bl);
    }

    public void disconnect(boolean bl) {
        if (!this.mConnectionCredentials.mCredentialsOK) {
            throw new NotConnectedException();
        }
        super.disconnect(bl);
    }

    public void reconnect() {
        if (!this.isConnected(false)) {
            if (this.getJdbcConnection() != null) {
                this.disconnect(true);
            }
            if (this.mConnectionCredentials.mCredentialsOK) {
                ApplicationModuleImpl applicationModuleImpl = this.getTxnApplicationModuleImpl();
                if (applicationModuleImpl != null && !applicationModuleImpl.isLoaded()) {
                    applicationModuleImpl.resetState(18);
                }
                TransactionHandler transactionHandler = this.mConnectionCredentials.mIsJTABased ? DBTransactionImpl.createJTATransactionHandler(applicationModuleImpl) : DBTransactionImpl.createTransactionHandler(applicationModuleImpl);
                DBTransactionImpl.initTxn(applicationModuleImpl, this, transactionHandler);
                this.getTxnApplicationModuleImpl().activateConnectionState();
            } else {
                throw new NotConnectedException();
            }
        }
    }

    public void reconnect(boolean bl) {
        if (!this.mConnectionCredentials.mCredentialsOK) {
            throw new NotConnectedException();
        }
        if (bl || !this.isConnected(false)) {
            this.getTxnApplicationModuleImpl().resetState(18);
            this.closeTransaction();
            DBTransactionImpl dBTransactionImpl = DatabaseTransactionFactory.getFactory().create(this.mConnectionCredentials.mjdbcURL, this.mConnectionCredentials.mjdbcUser, this.mConnectionCredentials.mjdbcPassword, this.mConnectionCredentials.mjdbcInfo);
            DBTransactionImpl.initTxn(this.getTxnApplicationModuleImpl(), dBTransactionImpl, this.getTransactionHandler());
        }
    }

    public Statement createStatement(int n) {
        this.checkConnected();
        return super.createStatement(n);
    }

    public CallableStatement createCallableStatement(String string, int n) {
        this.checkConnected();
        return super.createCallableStatement(string, n);
    }

    public PreparedStatement createPreparedStatement(String string, int n) {
        this.checkConnected();
        return super.createPreparedStatement(string, n);
    }

    public EntityImpl createEntityInstance(EntityDefImpl entityDefImpl, AttributeList attributeList) {
        this.checkConnected();
        return super.createEntityInstance(entityDefImpl, attributeList);
    }

    public EntityImpl createEntityInstance(String string, AttributeList attributeList) {
        this.checkConnected();
        return super.createEntityInstance(string, attributeList);
    }

    public EntityImpl findByPrimaryKey(EntityDefImpl entityDefImpl, Key key) {
        this.checkConnected();
        return super.findByPrimaryKey(entityDefImpl, key);
    }

    public EntityImpl findByPrimaryKey(String string, Key key) {
        this.checkConnected();
        return super.findByPrimaryKey(string, key);
    }

    public ViewObject createViewObjectFromQueryClauses(String string, String string2, String string3, String string4, String string5) {
        this.checkConnected();
        return super.createViewObjectFromQueryClauses(string, string2, string3, string4, string5);
    }

    public ViewObject createViewObjectFromQueryStmt(String string) {
        this.checkConnected();
        return super.createViewObjectFromQueryStmt(string);
    }

    public Object createRef(String string, byte[] byArray) {
        this.checkConnected();
        return super.createRef(string, byArray);
    }

    public Timestamp getCurrentDbTime() {
        this.checkConnected();
        return super.getCurrentDbTime();
    }
}

