/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.sql.Connection;
import java.util.Properties;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.pool.ResourcePoolManager;
import oracle.jbo.server.ConnectionPool;
import oracle.jbo.server.ConnectionPoolManager;
import oracle.jbo.server.ConnectionPoolManagerFactory;
import oracle.jbo.server.ConnectionPoolManagerHelper;

public class ConnectionPoolManagerImpl
extends ResourcePoolManager
implements ConnectionPoolManager {
    private int mInitPoolSize;
    private int mMaxPoolSize;

    private /* synthetic */ void $init$() {
        this.mInitPoolSize = 0;
        this.mMaxPoolSize = Integer.MAX_VALUE;
    }

    public ConnectionPoolManagerImpl() {
        this.$init$();
        this.init();
    }

    private void init() {
        this.mInitPoolSize = this.getProperty(PropertyMetadata.ENV_INIT_JDBC_POOL_SIZE.pName, new Integer(PropertyMetadata.ENV_INIT_JDBC_POOL_SIZE.pDefault));
        this.mMaxPoolSize = this.getProperty(PropertyMetadata.ENV_MAX_JDBC_POOL_SIZE.pName, new Integer(PropertyMetadata.ENV_MAX_JDBC_POOL_SIZE.pDefault));
    }

    public Connection getConnection(String string, String string2, Properties properties, String string3, String string4) {
        return this.getConnectionPool(string).getConnection(string2, properties, string3, string4);
    }

    public Connection getConnectionForInternalUse(String string, String string2, Properties properties, String string3, String string4) {
        return this.getConnection(string, string2, properties, string3, string4);
    }

    public void addConnection(String string, Connection connection) {
        this.getConnectionPool(string).addConnection(connection);
    }

    public void returnConnection(String string, Connection connection) {
        this.returnConnection(string, connection, null);
    }

    public void returnConnection(String string, Connection connection, Properties properties) {
        this.getConnectionPool(string).returnConnection(connection);
    }

    public void returnConnectionForInternalUse(String string, Connection connection, Properties properties) {
        this.returnConnection(string, connection, properties);
    }

    public void removeConnection(String string, Connection connection) {
        this.getConnectionPool(string).removeConnection(connection);
    }

    public String generatePoolKey(String string, Properties properties) {
        return ConnectionPoolManagerHelper.generatePoolKey(string, properties);
    }

    public String generatePoolKey(String string, String string2, String string3) {
        return ConnectionPoolManagerHelper.generatePoolKey(string, string2, string3);
    }

    public int getInitPoolSize() {
        return this.mInitPoolSize;
    }

    public int getMaxPoolSize() {
        return this.mMaxPoolSize;
    }

    protected int getMonitorSleepInterval() {
        return this.getProperty(PropertyMetadata.ENV_JDBC_POOL_MONITOR_SLEEP_INTERVAL.pName, Integer.valueOf(PropertyMetadata.ENV_JDBC_POOL_MONITOR_SLEEP_INTERVAL.pDefault));
    }

    private int getProperty(String string, int n) {
        return ConnectionPoolManagerFactory.getProperty(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionPool getConnectionPool(String string) {
        ConnectionPool connectionPool = null;
        Integer n = this.mLock;
        synchronized (n) {
            connectionPool = (ConnectionPool)this.getResourcePool(string);
            if (connectionPool == null) {
                connectionPool = new ConnectionPool(string, this);
                this.addResourcePool(string, connectionPool);
            }
        }
        return connectionPool;
    }
}

