/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.jbo.JboException;
import oracle.jbo.JboSerializationException;
import oracle.jbo.common.JboXMLUtil;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.Serializer;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;

class ByteSerializer
extends Serializer {
    ByteSerializer(ApplicationModuleImpl applicationModuleImpl) {
        super(applicationModuleImpl);
    }

    byte[] storeToByteStream(XMLDocument xMLDocument, Integer n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            xMLDocument.print((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            throw new JboSerializationException(true, -1, "NoCache", iOException);
        }
    }

    XMLDocument processByteStream(byte[] byArray) {
        try {
            DOMParser dOMParser = JboXMLUtil.createDOMParser(false);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            dOMParser.parse((InputStream)byteArrayInputStream);
            byteArrayInputStream.close();
            XMLDocument xMLDocument = dOMParser.getDocument();
            return xMLDocument;
        }
        catch (Exception exception) {
            throw new JboSerializationException(false, -1, "NoCache", exception);
        }
    }

    byte[] snapCommittedEOsToBytes() {
        XMLDocument xMLDocument = new XMLDocument();
        this.passivateCommitList(xMLDocument);
        return this.storeToByteStream(xMLDocument, null);
    }

    void replayCommittedEOsFromBytes(byte[] byArray) {
        this.activateCommitList(this.processByteStream(byArray));
    }

    void removeCommittedEOs(byte[] byArray) {
        this.processByteStream(byArray);
    }

    byte[] passivateRootAMToBytes(byte[] byArray, int n) {
        XMLDocument xMLDocument = new XMLDocument();
        this.passivate(xMLDocument, byArray, n);
        return this.storeToByteStream(xMLDocument, null);
    }

    byte[] activateRootAMFromBytes(byte[] byArray) {
        return this.activate(this.processByteStream(byArray));
    }

    byte[] activateRootAMFromBytes(byte[] byArray, int n) {
        return this.activate(this.processByteStream(byArray), n);
    }

    byte[] activateRootAM(int n) {
        throw new JboException("Not supported");
    }

    int snapCommittedEOs() {
        throw new JboException("Not supported");
    }

    void replayCommittedEOs(int n) {
        throw new JboException("Not supported");
    }

    void removeCommittedEOs(int n) {
        throw new JboException("Not supported");
    }

    int passivateRootAM(byte[] byArray) {
        throw new JboException("Not supported");
    }

    int passivateRootAM(byte[] byArray, int n) {
        throw new JboException("Not supported");
    }

    int passivateRootAM(int n, byte[] byArray) {
        throw new JboException("Not supported");
    }

    int passivateRootAM(int n, byte[] byArray, int n2) {
        throw new JboException("Not supported");
    }

    byte[] activateRootAM(int n, boolean bl) {
        throw new JboException("Not supported");
    }

    byte[] activateRootAM(int n, boolean bl, int n2) {
        throw new JboException("Not supported");
    }

    void removeRootAM(int n) {
        throw new JboException("Not supported");
    }

    int reservePassivationId() {
        throw new JboException("Not supported");
    }
}

