/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.util.ArrayList;
import oracle.jbo.ApplicationPoolSvcMsgContext;
import oracle.jbo.ConnectionMetadata;
import oracle.jbo.JboException;
import oracle.jbo.JboSerializationException;
import oracle.jbo.NotConnectedException;
import oracle.jbo.PCollException;
import oracle.jbo.SessionData;
import oracle.jbo.Transaction;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.SvcMsgRequestParams;
import oracle.jbo.common.ampool.AMStatistics;
import oracle.jbo.common.ampool.ConnectionStrategy;
import oracle.jbo.common.ampool.SessionCookie;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.ApplicationModuleRemoteAdapter;

public class ApplicationPoolMessageHandler {
    private final ApplicationModuleImpl mAppModule;
    private ApplicationPoolSvcMsgContext mCtx;
    private ApplicationModuleRemoteAdapter mRemoteAdapter;
    private ConnectionStrategy mStrategy;
    private boolean mIsBatchHandler;

    private /* synthetic */ void $init$() {
        this.mStrategy = null;
        this.mIsBatchHandler = false;
    }

    ApplicationPoolMessageHandler(ApplicationModuleImpl applicationModuleImpl) {
        this.$init$();
        this.mAppModule = applicationModuleImpl;
    }

    void init(ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext, ApplicationModuleRemoteAdapter applicationModuleRemoteAdapter, boolean bl) {
        this.mCtx = applicationPoolSvcMsgContext;
        this.mRemoteAdapter = applicationModuleRemoteAdapter;
        this.mIsBatchHandler = bl;
    }

    void reset() {
        this.mCtx = null;
        this.mRemoteAdapter = null;
        this.mIsBatchHandler = false;
    }

    public ApplicationPoolSvcMsgContext getContext() {
        return this.mCtx;
    }

    public ApplicationPoolSvcMsgContext doPoolMessage() {
        if (this.mCtx == null) {
            throw new JboException("Cannot process pool message.  An message context has not been set.");
        }
        int n = -1;
        if (this.mIsBatchHandler) {
            n = this.mAppModule.getObjectMarshaller().getSyncMode();
            this.mAppModule.getObjectMarshaller().setSyncMode(2);
        }
        SvcMsgRequestParams svcMsgRequestParams = this.mCtx.getRequest();
        while (svcMsgRequestParams != null) {
            switch (svcMsgRequestParams.getOperation()) {
                case 7: {
                    ConnectionMetadata connectionMetadata = this.mAppModule.getTransaction().getConnectionMetadata();
                    ConnectionMetadata connectionMetadata2 = (ConnectionMetadata)svcMsgRequestParams.getObjectParams()[1];
                    if (connectionMetadata != null && connectionMetadata2 != null && connectionMetadata.getSignature() == connectionMetadata2.getSignature()) break;
                }
                case 6: {
                    SessionCookie sessionCookie = this.mCtx.getSessionCookie();
                    SessionData sessionData = new SessionData(sessionCookie.getEnvironment(), sessionCookie.getUserData());
                    try {
                        this.mAppModule.prepareSession(sessionData);
                        this.mCtx.addRtnEvent(4);
                        this.mCtx.setRtnSessionData(sessionData);
                        break;
                    }
                    catch (JboException jboException) {
                        if ("33021".equals(jboException.getErrorCode())) {
                            this.mCtx.setStatus(16);
                            this.mCtx.setAuthException(jboException);
                            break;
                        }
                        throw jboException;
                    }
                }
                case 3: 
                case 4: {
                    int n2 = svcMsgRequestParams.getIntParams()[0];
                    try {
                        if (svcMsgRequestParams.getOperation() == 4) {
                            this.mAppModule.removeState(n2);
                            break;
                        }
                        int n3 = svcMsgRequestParams.getIntParams()[1];
                        if (this.mIsBatchHandler && !this.mCtx.getIgnorePiggyback()) {
                            n3 |= 4;
                        }
                        byte[] byArray = this.mAppModule.activateState(n2, (SessionData)svcMsgRequestParams.getObjectParams()[0], n3);
                        this.mCtx.setRtnClientData(byArray);
                        this.mCtx.addRtnEvent(6);
                        break;
                    }
                    catch (PCollException pCollException) {
                        if (pCollException.getErrorCode() != null && pCollException.getErrorCode().equals("28039")) {
                            this.mCtx.addRtnEvent(6);
                            Diagnostic.println(new StringBuffer(32).append("The root passivation record for passivate id, ").append(n2).append(", was not located").toString());
                            break;
                        }
                        throw pCollException;
                    }
                    catch (JboSerializationException jboSerializationException) {
                        Object[] objectArray = jboSerializationException.getDetails();
                        if (objectArray == null || objectArray.length == 0) {
                            if (jboSerializationException.getErrorCode() != null && jboSerializationException.getErrorCode().equals("28039")) {
                                this.mCtx.addRtnEvent(6);
                            }
                            Diagnostic.println(new StringBuffer(32).append("The passivation record for passivate id, ").append(n2).append(", was not located or was empty").toString());
                            break;
                        }
                        if (jboSerializationException.getErrorCode() != null && jboSerializationException.getErrorCode().equals("25033") && objectArray[0] instanceof IndexOutOfBoundsException) {
                            Diagnostic.println(new StringBuffer(32).append("The passivation record for passivate id, ").append(n2).append(", was not located in memory").toString());
                            break;
                        }
                        throw jboSerializationException;
                    }
                    catch (JboException jboException) {
                        if ("25055".equals(jboException.getErrorCode())) break;
                        throw jboException;
                    }
                }
                case 5: {
                    this.mAppModule.resetState(svcMsgRequestParams.getIntParams()[0]);
                    break;
                }
                case 12: {
                    this.mCtx.setRtnReservedPassivationId(this.mAppModule.reservePassivationId());
                    this.mCtx.addRtnEvent(7);
                    break;
                }
                case 2: {
                    ArrayList arrayList;
                    if (Diagnostic.isOn() && (arrayList = this.mCtx.getRtnEventList()) != null) {
                        Diagnostic.ASSERT(arrayList.contains(new Integer(2)) ^ true, "Illegal state:  MessageContext should only have one failover event");
                    }
                    boolean bl = false;
                    if (this.mCtx.isApplicationModuleConnected() || this.mAppModule.getTransaction().isConnected()) {
                        this.mCtx.setApplicationModuleConnected(true);
                        bl = true;
                    } else {
                        Object var26_23;
                        boolean bl2 = this.mCtx.isRetainState();
                        try {
                            this.mCtx.setRetainState(true);
                            this.doPoolReconnect();
                            var26_23 = null;
                            this.mCtx.setRetainState(bl2);
                        }
                        catch (Throwable throwable) {
                            var26_23 = null;
                            this.mCtx.setRetainState(bl2);
                            throw throwable;
                        }
                    }
                    int n4 = svcMsgRequestParams.getIntParams()[1];
                    int n5 = this.mAppModule.passivateState(svcMsgRequestParams.getIntParams()[0], (byte[])svcMsgRequestParams.getObjectParams()[0], svcMsgRequestParams.getIntParams()[1]);
                    if ((n4 & 0x10) == 0) {
                        this.mCtx.setRtnPassivationId(n5);
                        this.mCtx.addRtnEvent(2);
                    }
                    if (bl) break;
                    this.doPoolDisconnect(true);
                    break;
                }
                case 10: {
                    this.doPoolReconnect();
                    break;
                }
                case 14: {
                    AMStatistics aMStatistics = this.mAppModule.getAMStatistics();
                    if (aMStatistics == null) break;
                    aMStatistics = this.doAMStatistics(aMStatistics);
                    this.mCtx.setRtnAMStatistics(aMStatistics);
                    this.mCtx.addRtnEvent(8);
                    break;
                }
                case 8: {
                    this.doPoolConnect();
                    break;
                }
                case 9: {
                    this.doPoolDisconnect(svcMsgRequestParams.getBooleanParams()[0]);
                    break;
                }
                case 11: {
                    try {
                        this.mAppModule.remove();
                    }
                    catch (Throwable throwable) {
                        try {
                            this.mAppModule.getTransaction().disconnect();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    this.mCtx.addRtnEvent(5);
                    break;
                }
                case 13: {
                    this.mAppModule.getTransaction().setBundledExceptionMode(svcMsgRequestParams.getBooleanParams()[0]);
                    break;
                }
            }
            if (this.mCtx.getStatus() != 1) break;
            this.mCtx.incrementRequestPointer();
            svcMsgRequestParams = this.mCtx.getRequest();
        }
        if (this.mCtx.getStatus() == 1) {
            this.mCtx.setRtnMostRecentStackId(this.mAppModule.getMostRecentStackId());
            Transaction transaction = this.mAppModule.getTransaction();
            try {
                if (transaction != null && !this.mCtx.isApplicationModuleRemoved()) {
                    this.mCtx.setRtnConnectionMetadata(transaction.getConnectionMetadata());
                }
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
            this.mCtx.setStatus(8);
        }
        if (this.mRemoteAdapter != null) {
            this.mRemoteAdapter.finishServiceMessage();
            if (this.mCtx.getIgnorePiggyback()) {
                this.mRemoteAdapter.clearServiceMessage();
            }
        }
        if (n >= 0) {
            this.mAppModule.getObjectMarshaller().setSyncMode(n);
        }
        return this.mCtx;
    }

    private void doPoolDisconnect(boolean bl) {
        this.mCtx.getSessionCookie().setMessageContext(this.mCtx);
        this.getConnectionStrategy().disconnect(this.mAppModule, bl, this.mCtx.getSessionCookie());
    }

    private void doPoolConnect() {
        this.mCtx.getSessionCookie().setMessageContext(this.mCtx);
        this.getConnectionStrategy().connect(this.mAppModule, this.mCtx.getSessionCookie(), null);
    }

    private void doPoolReconnect() {
        this.mCtx.getSessionCookie().setMessageContext(this.mCtx);
        this.getConnectionStrategy().reconnect(this.mAppModule, this.mCtx.getSessionCookie(), null);
    }

    private AMStatistics doAMStatistics(AMStatistics aMStatistics) {
        aMStatistics.mSessionID = this.mCtx.getSessionCookie().getSessionId();
        aMStatistics.mLockTime = System.currentTimeMillis() - this.mCtx.getSessionCookie().getLastUpdateLong();
        return aMStatistics;
    }

    private ConnectionStrategy getConnectionStrategy() {
        if (this.mStrategy == null) {
            String string = (String)this.mCtx.getSessionCookie().getEnvironment().get(PropertyMetadata.ENV_AMPOOL_CONNECTION_STRATEGY_CLASS_NAME.pName);
            if (string == null) {
                string = JboEnvUtil.getProperty(PropertyMetadata.ENV_AMPOOL_CONNECTION_STRATEGY_CLASS_NAME.pName, PropertyMetadata.ENV_AMPOOL_CONNECTION_STRATEGY_CLASS_NAME.pDefault);
            }
            try {
                Class clazz = JBOClass.forName(string);
                this.mStrategy = (ConnectionStrategy)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JboException(classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JboException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new JboException(instantiationException);
            }
        }
        return this.mStrategy;
    }
}

