/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ApplicationModuleCreateException;
import oracle.jbo.ComponentObject;
import oracle.jbo.JboException;
import oracle.jbo.PersistenceException;
import oracle.jbo.ViewLink;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.server.AppModuleUsage;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.ComponentObjectImpl;
import oracle.jbo.server.ComponentUsage;
import oracle.jbo.server.DefObject;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.RemoteServer;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewLinkDefImpl;
import oracle.jbo.server.ViewLinkImpl;
import oracle.jbo.server.ViewLinkUsage;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewUsage;

public class ApplicationModuleDefImpl
extends DefObject {
    private static final int INITIAL_NUM_OF_VOS = 8;
    private static final int INITIAL_NUM_OF_VLS = 4;
    private static final int INITIAL_NUM_OF_AMS = 2;
    private static final int INITIAL_NUM_OF_COMPS = 4;
    private static final int INITIAL_NUM_OF_REMOTE_SRVS = 2;
    protected boolean mClearCacheOnCommit;
    protected boolean mClearCacheOnRollback;
    protected boolean mRequeryOnCommit;
    protected HashMap mValidatorTypes;
    protected HashMap mViewUsages;
    protected ArrayList mViewUsageList;
    protected HashMap mViewLinkUsages;
    protected ArrayList mViewLinkUsageList;
    private HashMap mAppModuleUsages;
    private ArrayList mAppModuleUsageList;
    protected HashMap mRemoteServers;
    protected HashMap mCompUsages;
    protected ArrayList mCompUsageList;
    private int mIsLoadComponentsLazily;
    private int mNumComponentsToLoad;
    private static final int LOAD_COMP_LAZILY_DEFAULT = -1;
    private static final int LOAD_COMP_LAZILY_FALSE = 0;
    private static final int LOAD_COMP_LAZILY_TRUE = 1;
    private static int mDefaultLoadComponentsLazily = -1;
    private static /* synthetic */ Class class$oracle$jbo$server$ApplicationModuleImpl;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$server$ApplicationModuleDefImpl;

    private /* synthetic */ void $init$() {
        this.mClearCacheOnCommit = false;
        this.mClearCacheOnRollback = true;
        this.mRequeryOnCommit = false;
        this.mValidatorTypes = null;
        this.mViewUsages = new HashMap(8);
        this.mViewUsageList = new ArrayList(8);
        this.mViewLinkUsages = new HashMap(4);
        this.mViewLinkUsageList = new ArrayList(4);
        this.mAppModuleUsages = new HashMap(2);
        this.mAppModuleUsageList = new ArrayList(2);
        this.mRemoteServers = new HashMap(2);
        this.mCompUsages = new HashMap(4);
        this.mCompUsageList = new ArrayList(4);
        this.mIsLoadComponentsLazily = -1;
        this.mNumComponentsToLoad = 0;
    }

    static int getLoadComponentsLazilyValue(String string) {
        int n = "true".equals(string) ? 1 : ("false".equals(string) ? 0 : -1);
        return n;
    }

    static void initDefaultLoadComponentsLazily() {
        String string;
        if (mDefaultLoadComponentsLazily == -1 && (mDefaultLoadComponentsLazily = ApplicationModuleDefImpl.getLoadComponentsLazilyValue(string = PropertyMetadata.ENV_LOAD_COMP_LAZILY.getProperty())) == -1) {
            mDefaultLoadComponentsLazily = 0;
        }
    }

    protected ApplicationModuleDefImpl() {
        this.$init$();
        ApplicationModuleDefImpl.initDefaultLoadComponentsLazily();
        this.mIsLoadComponentsLazily = mDefaultLoadComponentsLazily;
    }

    public static ApplicationModuleDefImpl findDefObjectNoSub(String string) {
        Class clazz = class$oracle$jbo$server$ApplicationModuleDefImpl;
        if (clazz == null) {
            clazz = class$oracle$jbo$server$ApplicationModuleDefImpl = ApplicationModuleDefImpl.class$("oracle.jbo.server.ApplicationModuleDefImpl");
        }
        return (ApplicationModuleDefImpl)MetaObjectManager.findMetaObject(string, 101, clazz, false);
    }

    public static ApplicationModuleDefImpl findDefObject(String string) {
        Class clazz = class$oracle$jbo$server$ApplicationModuleDefImpl;
        if (clazz == null) {
            clazz = class$oracle$jbo$server$ApplicationModuleDefImpl = ApplicationModuleDefImpl.class$("oracle.jbo.server.ApplicationModuleDefImpl");
        }
        return (ApplicationModuleDefImpl)MetaObjectManager.findMetaObject(string, 101, clazz, true);
    }

    void setComponentClass(Class clazz) {
        this.mComponentClass = clazz;
    }

    public Class getComponentClass() {
        Class clazz;
        if (this.mComponentClass != null) {
            clazz = this.mComponentClass;
        } else {
            clazz = class$oracle$jbo$server$ApplicationModuleImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$ApplicationModuleImpl = ApplicationModuleDefImpl.class$("oracle.jbo.server.ApplicationModuleImpl");
            }
        }
        return clazz;
    }

    public String getServerClassName(String string) {
        Object object;
        if (string != null && (object = this.mRemoteServers.get((Object)string)) instanceof RemoteServer) {
            return ((RemoteServer)object).getServerClassName();
        }
        return null;
    }

    public String getClientProxyClassName(String string) {
        Object object;
        if (string != null && (object = this.mRemoteServers.get((Object)string)) instanceof RemoteServer) {
            return ((RemoteServer)object).getProxyClassName();
        }
        return null;
    }

    public boolean isClearCacheOnCommit() {
        return this.mClearCacheOnCommit;
    }

    public boolean isClearCacheOnRollback() {
        return this.mClearCacheOnRollback;
    }

    public boolean isRequeryOnCommit() {
        return this.mRequeryOnCommit;
    }

    public boolean isLoadComponentsLazily() {
        return this.mIsLoadComponentsLazily == 1;
    }

    public void setLoadComponentsLazily(boolean bl) {
        this.mIsLoadComponentsLazily = bl ? 1 : 0;
    }

    void setLoadComponentsLazilyValue(int n) {
        this.mIsLoadComponentsLazily = n;
    }

    void setNumComponentsToLoad(int n) {
        this.mNumComponentsToLoad = n;
    }

    public String[] getViewObjectNames() {
        Object[] objectArray = new String[this.mViewUsageList.size()];
        return (String[])this.mViewUsageList.toArray(objectArray);
    }

    public String[] getViewLinkNames() {
        Object[] objectArray = new String[this.mViewLinkUsageList.size()];
        return (String[])this.mViewLinkUsageList.toArray(objectArray);
    }

    public String[] getApplicationModuleNames() {
        Object[] objectArray = new String[this.mAppModuleUsageList.size()];
        return (String[])this.mAppModuleUsageList.toArray(objectArray);
    }

    public String[] getComponentObjectNames() {
        Object[] objectArray = new String[this.mCompUsageList.size()];
        return (String[])this.mCompUsageList.toArray(objectArray);
    }

    protected boolean hasViewObject(String string) {
        return this.mViewUsages.get((Object)string) != null;
    }

    protected boolean hasViewLink(String string) {
        return this.mViewLinkUsages.get((Object)string) != null;
    }

    protected boolean hasApplicationModule(String string) {
        return this.mAppModuleUsages.get((Object)string) != null;
    }

    protected boolean hasComponentObject(String string) {
        return this.mCompUsages.get((Object)string) != null;
    }

    protected ViewObject loadViewObject(ApplicationModule applicationModule, String string) {
        ViewUsage viewUsage = (ViewUsage)this.mViewUsages.get((Object)string);
        if (viewUsage == null) {
            return null;
        }
        ViewObject viewObject = ((ApplicationModuleImpl)applicationModule).doCreateViewObject(string, ViewDefImpl.findDefObject(viewUsage.getViewDefName()), false);
        ((ApplicationModuleImpl)applicationModule).decrNumComponentsToLoad();
        ArrayList arrayList = viewUsage.getDetailViewLinks();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                ViewLinkUsage viewLinkUsage = (ViewLinkUsage)arrayList.get(n);
                applicationModule.findViewLink(viewLinkUsage.mName);
                ++n;
            }
        }
        return viewObject;
    }

    protected ViewLink loadViewLink(ApplicationModule applicationModule, String string) {
        ViewLinkUsage viewLinkUsage = (ViewLinkUsage)this.mViewLinkUsages.get((Object)string);
        if (viewLinkUsage == null) {
            return null;
        }
        String string2 = viewLinkUsage.mSrcViewUsageName.substring(viewLinkUsage.mSrcViewUsageName.lastIndexOf(".") + 1);
        String string3 = viewLinkUsage.mDstViewUsageName.substring(viewLinkUsage.mDstViewUsageName.lastIndexOf(".") + 1);
        ViewObject viewObject = ((ApplicationModuleImpl)applicationModule).doFindViewObject(string2);
        if (viewObject == null) {
            throw new PersistenceException("26008", new String[]{viewLinkUsage.mSrcViewUsageName});
        }
        ViewObject viewObject2 = ((ApplicationModuleImpl)applicationModule).doFindViewObject(string3);
        if (viewObject2 == null) {
            throw new PersistenceException("26008", new String[]{viewLinkUsage.mDstViewUsageName});
        }
        ViewLinkImpl viewLinkImpl = (ViewLinkImpl)((ApplicationModuleImpl)applicationModule).doFindViewLink(string, false);
        if (viewLinkImpl == null) {
            viewLinkImpl = (ViewLinkImpl)((ApplicationModuleImpl)applicationModule).createViewLink(string, ViewLinkDefImpl.findDefObject(viewLinkUsage.mViewLinkDefName), viewObject, viewObject2, false);
            ((ApplicationModuleImpl)applicationModule).decrNumComponentsToLoad();
            if (viewLinkUsage.mReversedUsage) {
                viewLinkImpl.setReversedUsage(true);
            }
            viewLinkImpl.mIsDynamic = false;
        }
        return viewLinkImpl;
    }

    protected ApplicationModule loadApplicationModule(ApplicationModule applicationModule, String string) {
        AppModuleUsage appModuleUsage = (AppModuleUsage)this.mAppModuleUsages.get((Object)string);
        if (appModuleUsage == null) {
            return null;
        }
        String string2 = appModuleUsage.getName();
        String string3 = appModuleUsage.getDefName();
        ApplicationModuleImpl applicationModuleImpl = (ApplicationModuleImpl)applicationModule;
        if (!((ApplicationModuleImpl)applicationModule).isLoadComponentsLazily()) {
            while (applicationModuleImpl != null) {
                if (applicationModuleImpl.getDefFullName().equals(string3)) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = ApplicationModuleDefImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new ApplicationModuleCreateException(clazz, "25226", new Object[]{string3}, null);
                }
                applicationModuleImpl = (ApplicationModuleImpl)applicationModuleImpl.getParent();
            }
        }
        ApplicationModuleImpl applicationModuleImpl2 = ((ApplicationModuleImpl)applicationModule).createApplicationModuleImpl(string2, ApplicationModuleDefImpl.findDefObject(string3), false);
        ((ApplicationModuleImpl)applicationModule).decrNumComponentsToLoad();
        return applicationModuleImpl2;
    }

    protected ComponentObject loadComponentObject(ApplicationModule applicationModule, String string) {
        ComponentUsage componentUsage = (ComponentUsage)this.mCompUsages.get((Object)string);
        if (componentUsage == null) {
            return null;
        }
        ComponentObject componentObject = applicationModule.createComponentObject(string, componentUsage.getCompDefName());
        ((ApplicationModuleImpl)applicationModule).decrNumComponentsToLoad();
        if (componentObject instanceof ComponentObjectImpl) {
            Iterator iterator = componentUsage.getPlatforms();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                ((ComponentObjectImpl)componentObject).setProxyClassName(string2, componentUsage.getProxyClassName(string2));
            }
        }
        return componentObject;
    }

    protected void loadComponents(ApplicationModuleImpl applicationModuleImpl) {
        applicationModuleImpl.setNumComponentsToLoad(this.mNumComponentsToLoad);
        if (!applicationModuleImpl.isLoadComponentsLazily() && this.mNumComponentsToLoad > 0) {
            int n = 0;
            while (n < this.mViewUsageList.size()) {
                String string = (String)this.mViewUsageList.get(n);
                this.loadViewObject(applicationModuleImpl, string);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.mViewLinkUsageList.size()) {
                String string = (String)this.mViewLinkUsageList.get(n2);
                this.loadViewLink(applicationModuleImpl, string);
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.mAppModuleUsageList.size()) {
                String string = (String)this.mAppModuleUsageList.get(n3);
                this.loadApplicationModule(applicationModuleImpl, string);
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.mCompUsageList.size()) {
                String string = (String)this.mCompUsageList.get(n4);
                this.loadComponentObject(applicationModuleImpl, string);
                ++n4;
            }
            if (applicationModuleImpl.getNumComponentsToLoad() != 0) {
                throw new JboException("Internal error: NumComponentsToLoad not zero after loadComponents");
            }
        }
    }

    void setProxyNames(ViewObjectImpl viewObjectImpl) {
        ViewUsage viewUsage = this.getViewUsage(viewObjectImpl);
        if (viewUsage != null) {
            Iterator iterator = viewUsage.getPlatforms();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                viewObjectImpl.setProxyClassName(string, viewUsage.getProxyClassName(string));
            }
            iterator = viewUsage.getRowPlatforms();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                viewObjectImpl.setRowProxyClassName(string, viewUsage.getRowProxyClassName(string));
            }
        }
    }

    private ViewUsage getViewUsage(ViewObjectImpl viewObjectImpl) {
        String string = viewObjectImpl.getViewDef().getFullName();
        Iterator iterator = this.mViewUsages.values().iterator();
        while (iterator.hasNext()) {
            ViewUsage viewUsage = (ViewUsage)iterator.next();
            if (!viewUsage.getViewDefName().equals(string)) continue;
            return viewUsage;
        }
        return null;
    }

    protected static ApplicationModuleDefImpl loadFromXML(DefElement defElement) {
        ApplicationModuleDefImpl applicationModuleDefImpl = new ApplicationModuleDefImpl();
        return ApplicationModuleDefImpl.loadFromXML(defElement, applicationModuleDefImpl);
    }

    protected static ApplicationModuleDefImpl loadFromXML(DefElement defElement, ApplicationModuleDefImpl applicationModuleDefImpl) {
        DefElement defElement2;
        String string = defElement.readString("Name");
        String string2 = defElement.readString("Extends");
        if (string2 != null && string2.length() > 0) {
            applicationModuleDefImpl = ApplicationModuleDefImpl.loadFromXML(MetaObjectManager.loadBaseElement(string2), applicationModuleDefImpl);
            ApplicationModuleDefImpl applicationModuleDefImpl2 = ApplicationModuleDefImpl.findDefObjectNoSub(string2);
            if (string != null) {
                applicationModuleDefImpl.setName(string);
            }
            applicationModuleDefImpl.setBaseDefObject(applicationModuleDefImpl2);
        } else if (string != null) {
            applicationModuleDefImpl.setName(string);
        }
        String string3 = defElement.readString("ComponentClass");
        applicationModuleDefImpl.setComponentInterfaceName(defElement.readString("ComponentInterface"));
        applicationModuleDefImpl.setClientProxyClassName(defElement.readString("ClientProxyName"));
        applicationModuleDefImpl.mClearCacheOnCommit = defElement.readBoolean("ClearCacheOnCommit");
        applicationModuleDefImpl.mClearCacheOnRollback = defElement.readBoolean("ClearCacheOnRollback");
        applicationModuleDefImpl.mRequeryOnCommit = defElement.readBoolean("RequeryOnCommit");
        int n = ApplicationModuleDefImpl.getLoadComponentsLazilyValue(defElement.readString("LoadComponentsLazily"));
        if (n != -1) {
            applicationModuleDefImpl.setLoadComponentsLazilyValue(n);
        }
        if (string3 != null) {
            Class clazz = class$oracle$jbo$server$ApplicationModuleImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$ApplicationModuleImpl = ApplicationModuleDefImpl.class$("oracle.jbo.server.ApplicationModuleImpl");
            }
            applicationModuleDefImpl.setComponentClass(JBOClass.findCustomClass(string3, clazz));
        }
        applicationModuleDefImpl.loadViewImports(defElement);
        ArrayList arrayList = defElement.getChildrenList("ViewUsage");
        int n2 = 0;
        while (n2 < arrayList.size()) {
            defElement2 = (DefElement)arrayList.get(n2);
            String string4 = defElement2.readString("Name");
            if (!applicationModuleDefImpl.mViewUsageList.contains((Object)string4)) {
                applicationModuleDefImpl.mViewUsageList.add((Object)string4);
            }
            ViewUsage viewUsage = new ViewUsage(defElement2.readString("ViewObjectName"));
            ArrayList arrayList2 = defElement2.getChildrenList("Remote");
            int n3 = 0;
            while (n3 < arrayList2.size()) {
                String string5;
                DefElement defElement3 = (DefElement)arrayList2.get(n3);
                String string6 = ApplicationModuleDefImpl.convertPlatform(defElement3.readString("Name"));
                String string7 = defElement3.readString("ClientProxyName");
                if (string7 != null && string7.length() > 0) {
                    viewUsage.setProxyClassName(string6, string7);
                }
                if ((string5 = defElement3.readString("ClientRowProxyName")) != null && string5.length() > 0) {
                    viewUsage.setRowProxyClassName(string6, string5);
                }
                ++n3;
            }
            applicationModuleDefImpl.mViewUsages.put((Object)string4, (Object)viewUsage);
            ++n2;
        }
        arrayList = defElement.getChildrenList("ViewLinkUsage");
        int n4 = 0;
        while (n4 < arrayList.size()) {
            defElement2 = (DefElement)arrayList.get(n4);
            String string8 = defElement2.readString("Name");
            String string9 = defElement2.readString("SrcViewUsageName");
            String string10 = defElement2.readString("DstViewUsageName");
            if (string9 == null || string10 == null) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Invalid Source and Destination View Usages ");
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ApplicationModuleDefImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new JboException(clazz, "26000", null);
            }
            ViewLinkUsage viewLinkUsage = new ViewLinkUsage();
            viewLinkUsage.mName = string8;
            viewLinkUsage.mReversedUsage = defElement2.readBoolean("Reversed");
            viewLinkUsage.mViewLinkDefName = defElement2.readString("ViewLinkObjectName");
            viewLinkUsage.mSrcViewUsageName = string9;
            viewLinkUsage.mDstViewUsageName = string10;
            String string11 = viewLinkUsage.mReversedUsage ? viewLinkUsage.mSrcViewUsageName.substring(viewLinkUsage.mSrcViewUsageName.lastIndexOf(".") + 1) : viewLinkUsage.mDstViewUsageName.substring(viewLinkUsage.mDstViewUsageName.lastIndexOf(".") + 1);
            ViewUsage viewUsage = (ViewUsage)applicationModuleDefImpl.mViewUsages.get((Object)string11);
            viewUsage.addDetailViewLink(viewLinkUsage);
            applicationModuleDefImpl.mViewLinkUsages.put((Object)string8, (Object)viewLinkUsage);
            if (!applicationModuleDefImpl.mViewLinkUsageList.contains((Object)string8)) {
                applicationModuleDefImpl.mViewLinkUsageList.add((Object)string8);
            }
            ++n4;
        }
        arrayList = defElement.getChildrenList("Remote");
        int n5 = 0;
        while (n5 < arrayList.size()) {
            defElement2 = (DefElement)arrayList.get(n5);
            String string12 = ApplicationModuleDefImpl.convertPlatform(defElement2.readString("Name"));
            if (string12 != null) {
                applicationModuleDefImpl.mRemoteServers.put((Object)string12, (Object)new RemoteServer(defElement2.readString("ServerClassName"), defElement2.readString("ClientProxyName")));
            }
            ++n5;
        }
        arrayList = defElement.getChildrenList("AppModuleUsage");
        int n6 = 0;
        while (n6 < arrayList.size()) {
            defElement2 = (DefElement)arrayList.get(n6);
            String string13 = defElement2.readString("Name");
            if (!applicationModuleDefImpl.mAppModuleUsageList.contains((Object)string13)) {
                applicationModuleDefImpl.mAppModuleUsageList.add((Object)string13);
            }
            AppModuleUsage appModuleUsage = new AppModuleUsage(string13, defElement2.readString("FullName"));
            applicationModuleDefImpl.mAppModuleUsages.put((Object)string13, (Object)appModuleUsage);
            ++n6;
        }
        arrayList = defElement.getChildrenList("ComponentUsage");
        int n7 = 0;
        while (n7 < arrayList.size()) {
            defElement2 = (DefElement)arrayList.get(n7);
            String string14 = defElement2.readString("Name");
            applicationModuleDefImpl.mCompUsageList.add((Object)string14);
            ComponentUsage componentUsage = new ComponentUsage(defElement2.readString("ComponentObjectName"));
            ArrayList arrayList3 = defElement2.getChildrenList("Remote");
            int n8 = 0;
            while (n8 < arrayList3.size()) {
                DefElement defElement4 = (DefElement)arrayList3.get(n8);
                String string15 = ApplicationModuleDefImpl.convertPlatform(defElement4.readString("Name"));
                String string16 = defElement4.readString("ClientProxyName");
                componentUsage.setProxyClassName(string15, string16);
                ++n8;
            }
            applicationModuleDefImpl.mCompUsages.put((Object)string14, (Object)componentUsage);
            ++n7;
        }
        applicationModuleDefImpl.loadProperties(defElement);
        applicationModuleDefImpl.loadVariables(defElement);
        defElement = null;
        applicationModuleDefImpl.setNumComponentsToLoad(applicationModuleDefImpl.mViewUsageList.size() + applicationModuleDefImpl.mAppModuleUsages.size() + applicationModuleDefImpl.mViewLinkUsageList.size() + applicationModuleDefImpl.mCompUsages.size());
        return applicationModuleDefImpl;
    }

    public void loadContainees() {
        if (this.mViewUsages != null && this.mViewUsages.size() > 0) {
            int n = 0;
            while (n < this.mViewUsageList.size()) {
                String string = (String)this.mViewUsageList.get(n);
                ViewUsage viewUsage = (ViewUsage)this.mViewUsages.get((Object)string);
                ViewDefImpl.findDefObject(viewUsage.getViewDefName());
                ++n;
            }
        }
        if (this.mViewLinkUsages != null && this.mViewLinkUsages.size() > 0) {
            int n = 0;
            while (n < this.mViewLinkUsageList.size()) {
                String string = (String)this.mViewLinkUsageList.get(n);
                ViewLinkUsage viewLinkUsage = (ViewLinkUsage)this.mViewLinkUsages.get((Object)string);
                ViewLinkDefImpl.findDefObject(viewLinkUsage.mViewLinkDefName);
                ++n;
            }
        }
        int n = 0;
        while (n < this.mAppModuleUsageList.size()) {
            String string = (String)this.mAppModuleUsageList.get(n);
            AppModuleUsage appModuleUsage = (AppModuleUsage)this.mAppModuleUsages.get((Object)string);
            String string2 = appModuleUsage.getDefName();
            ApplicationModuleDefImpl applicationModuleDefImpl = ApplicationModuleDefImpl.findDefObject(string2);
            applicationModuleDefImpl.loadContainees();
            ++n;
        }
    }

    private void loadViewImports(DefElement defElement) {
        ArrayList arrayList = defElement.readStringArrayList("ViewImports");
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                ViewDefImpl.findDefObject((String)arrayList.get(n));
                ++n;
            }
        }
    }

    void setDefForComponent(ComponentObjectImpl componentObjectImpl) {
    }

    void unsetDefForComponent(ComponentObjectImpl componentObjectImpl) {
        if (this.isDynamic()) {
            this.getPackageDef().removeChild(this, "AppModule");
        }
    }

    private static String convertPlatform(String string) {
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

