/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.rules;

import com.sun.java.util.collections.ArrayList;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.util.Iterator;
import java.util.Vector;
import oracle.jbo.AttrSetValException;
import oracle.jbo.AttrValException;
import oracle.jbo.AttributeDef;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.RowValException;
import oracle.jbo.ValidationException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.mom.PropertyNameValueDef;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.rules.AbstractValidator;
import oracle.jbo.rules.JboCompareValidator;
import oracle.jbo.rules.JboLengthValidator;
import oracle.jbo.rules.JboListValidator;
import oracle.jbo.rules.JboRangeValidator;
import oracle.jbo.rules.JboRegExpValidator;
import oracle.jbo.rules.JboValidatorContext;
import oracle.jbo.rules.JboValidatorInterface;
import oracle.jbo.rules.ValidationManager;

public class RulesBeanUtils {
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$common$JboResourceBundle;

    public static void loadValidators(DefElement defElement, ValidationManager validationManager, Class clazz) {
        ArrayList arrayList = defElement.getSimilarChildrenList("ValidationBean");
        int n = 0;
        while (n < arrayList.size()) {
            JboValidatorInterface jboValidatorInterface = RulesBeanUtils.loadValidationRule((DefElement)arrayList.get(n), clazz);
            if (jboValidatorInterface != null) {
                validationManager.addValidator(jboValidatorInterface);
            }
            ++n;
        }
    }

    public static JboValidatorInterface loadValidatorBean(DefElement defElement) {
        JboValidatorInterface jboValidatorInterface = null;
        try {
            jboValidatorInterface = RulesBeanUtils.createNewValidatorInstance(defElement);
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
        if (!(jboValidatorInterface instanceof AbstractValidator) && jboValidatorInterface != null) {
            jboValidatorInterface = RulesBeanUtils.createUserValidator(jboValidatorInterface);
        }
        return jboValidatorInterface;
    }

    public static JboValidatorInterface createUserValidator(JboValidatorInterface jboValidatorInterface) {
        return new 1JboUserValidator(jboValidatorInterface);
    }

    private static JboValidatorInterface createNewValidatorInstance(DefElement defElement) throws Exception {
        Class clazz = JBOClass.forName(defElement.readString("ValidationBeanClass"));
        JboValidatorInterface jboValidatorInterface = (JboValidatorInterface)clazz.newInstance();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        ArrayList arrayList = defElement.getChildrenList("NamedData");
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                PropertyNameValueDef propertyNameValueDef = new PropertyNameValueDef();
                propertyNameValueDef.loadFromXMLFile((DefElement)arrayList.get(n));
                propertyNameValueDef.setBeanProperty(beanInfo, jboValidatorInterface);
                ++n;
            }
        }
        return jboValidatorInterface;
    }

    public static void raiseException(Class clazz, String string, Object object, int n, String string2, AttributeDef attributeDef, Object object2, String string3, Exception exception) {
        Class clazz2;
        ValidationException validationException;
        if (object2 instanceof Row) {
            validationException = new RowValException(clazz, string, string2, ((Row)object2).getKey(), null, string3);
        } else {
            AttrSetValException attrSetValException = new AttrSetValException(n, clazz, string, string2, attributeDef.getName(), object2, string3);
            if (object instanceof Row) {
                attrSetValException.setRowKey(n, ((Row)object).getKey());
            }
            validationException = attrSetValException;
        }
        if ((clazz2 = class$oracle$jbo$common$JboResourceBundle) == null) {
            clazz2 = class$oracle$jbo$common$JboResourceBundle = RulesBeanUtils.class$("oracle.jbo.common.JboResourceBundle");
        }
        if (clazz2.isAssignableFrom(clazz)) {
            validationException.setAppendCodes(false);
        }
        if (exception != null) {
            validationException.addToDetails(exception);
        }
        throw validationException;
    }

    public static JboValidatorInterface loadValidationRule(DefElement defElement, Class clazz) {
        JboValidatorInterface jboValidatorInterface = null;
        String string = defElement.getElementName();
        String string2 = defElement.readString("OperandType");
        boolean bl = defElement.readBoolean("Inverse");
        String string3 = defElement.readString("OnAttribute");
        if ("CompareValidationBean".equals(string)) {
            String string4 = defElement.readString("CompareValue");
            String string5 = defElement.readString("CompareType");
            int n = JboCompareValidator.convertOperType(string5);
            if (string2.equals("LITERAL")) {
                jboValidatorInterface = new JboCompareValidator(bl, n, string4);
            } else {
                if (string2.equals("SQL")) {
                    throw new UnsupportedOperationException("SQL Validator");
                }
                if (string2.equals("JBO")) {
                    throw new UnsupportedOperationException("VO Validator");
                }
            }
        } else if ("RangeValidationBean".equals(string)) {
            String string6 = defElement.readString("MinValue");
            String string7 = defElement.readString("MaxValue");
            jboValidatorInterface = new JboRangeValidator(bl, string6, string7);
        } else if ("ListValidationBean".equals(string)) {
            if (string2.equals("LITERAL")) {
                Vector vector = defElement.readStringArray("List");
                if (vector != null) {
                    jboValidatorInterface = new JboListValidator(bl, vector);
                }
            } else {
                if (string2.equals("SQL")) {
                    throw new UnsupportedOperationException("SQL Validator");
                }
                if (string2.equals("JBO")) {
                    throw new UnsupportedOperationException("VO Validator");
                }
            }
        } else if ("LengthValidationBean".equals(string)) {
            String string8 = defElement.readString("CompareType");
            int n = JboLengthValidator.convertOperType(string8);
            String string9 = defElement.readString("DataType");
            int n2 = JboLengthValidator.convertDataType(string9);
            String string10 = defElement.readString("CompareLength");
            jboValidatorInterface = new JboLengthValidator(bl, n, n2, string10);
        } else if ("RegExpValidationBean".equals(string)) {
            String string11 = defElement.readString("Pattern");
            String string12 = defElement.readString("Flags");
            jboValidatorInterface = new JboRegExpValidator(bl, string11, string12);
        } else if ("ValidationBean".equals(string)) {
            jboValidatorInterface = RulesBeanUtils.loadValidatorBean(defElement);
        }
        if (jboValidatorInterface == null && Diagnostic.isOn()) {
            Diagnostic.println("No validator loaded for :" + string);
        }
        if ((string2 = defElement.readString("ResId")) != null) {
            if (jboValidatorInterface instanceof AbstractValidator) {
                ((AbstractValidator)((Object)jboValidatorInterface)).setErrorMsgId(string2);
                ((AbstractValidator)((Object)jboValidatorInterface)).setErrorMessageClass(clazz);
            } else if (Diagnostic.isOn()) {
                Diagnostic.println("Validation Error message unused :" + string2);
            }
        }
        if (jboValidatorInterface instanceof AbstractValidator) {
            ((AbstractValidator)((Object)jboValidatorInterface)).setValidatingAttributeName(string3);
        }
        return jboValidatorInterface;
    }

    public static AttrValException validate(Iterator iterator, Row row, JboValidatorContext jboValidatorContext, boolean bl) {
        AttrValException attrValException = RulesBeanUtils.validateObject(iterator, jboValidatorContext, bl);
        if (attrValException != null) {
            attrValException.setRowKey(jboValidatorContext.getSourceType(), row.getKey());
        }
        return attrValException;
    }

    /*
     * Unable to fully structure code
     */
    public static AttrValException validateObject(Iterator var0, JboValidatorContext var1_1, boolean var2_2) {
        block8: {
            var3_3 = null;
            if (!var2_2) ** GOTO lbl15
            while (var0.hasNext()) {
                ((JboValidatorInterface)var0.next()).validate(var1_1);
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                try {
                    ((JboValidatorInterface)var0.next()).validate(var1_1);
                    continue;
                }
                catch (JboException var4_4) {
                    if (var3_3 == null) {
                        var3_3 = new ArrayList(5);
                    }
                    var3_3.add((Object)var4_4);
                }
lbl15:
                // 3 sources

                ** while (var0.hasNext())
            }
lbl16:
            // 1 sources

            if (var3_3 != null) {
                if (var3_3.size() == 1 && (var5_5 = var3_3.get(0)) instanceof AttrValException) {
                    return (AttrValException)var5_5;
                }
                v0 = RulesBeanUtils.class$oracle$jbo$CSMessageBundle;
                if (v0 == null) {
                    v0 = RulesBeanUtils.class$oracle$jbo$CSMessageBundle = RulesBeanUtils.class$("oracle.jbo.CSMessageBundle");
                }
                var6_6 = new AttrValException(v0, "27025", var1_1.getSourceFullName(), var1_1.getAttributeName(), var1_1.getNewValue(), var3_3, true);
                return var6_6;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class 1JboUserValidator
    extends AbstractValidator
    implements JboValidatorInterface {
        JboValidatorInterface mBean;

        1JboUserValidator(JboValidatorInterface jboValidatorInterface) {
            this.mBean = jboValidatorInterface;
        }

        public void validate(JboValidatorContext jboValidatorContext) {
            try {
                this.mBean.validate(jboValidatorContext);
            }
            catch (AttrValException attrValException) {
                throw attrValException;
            }
            catch (Exception exception) {
                RulesBeanUtils.raiseException(this.getErrorMessageClass(), this.getErrorMsgId(), jboValidatorContext.getSource(), jboValidatorContext.getSourceType(), jboValidatorContext.getSourceFullName(), jboValidatorContext.getAttributeDef(), jboValidatorContext.getNewValue(), null, exception);
            }
        }

        public boolean validateValue(Object object) {
            return false;
        }

        public String getDescription() {
            return this.mBean.getDescription();
        }

        public void setDescription(String string) {
            this.mBean.setDescription(string);
        }
    }
}

