/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.pcoll;

import java.sql.Connection;
import java.sql.DriverManager;
import oracle.jbo.JboException;
import oracle.jbo.PCollException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.WeakVector;
import oracle.jbo.pcoll.OraclePersistManager;
import oracle.jbo.pcoll.PCollManagerHelper;
import oracle.jbo.pcoll.PCollection;
import oracle.jbo.pcoll.PersistManager;

public class PCollManager {
    public static final String PERSIST_MGR_ORACLE = "oracle.jbo.pcoll.OraclePersistManager";
    public static final String PERSIST_MGR_NONE = "None";
    public static final int CLOSE_RETAIN_TABLE = 1;
    private int mCollSeqId;
    private PCollManagerHelper mHelper;
    private Connection mConn;
    private String mDBURL;
    private boolean mConnCreatedLocally;
    private WeakVector mColls;
    private boolean mNameResolved;
    private String mName;
    private String mPersistMgrName;
    private PersistManager mPersistMgr;
    private boolean mHasPersistMgr;
    private boolean mPersistent;
    private boolean mIsOpen;
    private long mObjId;
    private long mTableSignature;
    private boolean mTableCreated;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mCollSeqId = 0;
        this.mHelper = null;
        this.mConn = null;
        this.mDBURL = null;
        this.mConnCreatedLocally = false;
        this.mNameResolved = false;
        this.mName = null;
        this.mPersistent = false;
        this.mIsOpen = true;
        this.mObjId = 0L;
        this.mTableSignature = -1;
        this.mTableCreated = false;
    }

    public PCollManager(PCollManagerHelper pCollManagerHelper, String string, String string2) {
        this(pCollManagerHelper, string, string2, false);
    }

    public PCollManager(PCollManagerHelper pCollManagerHelper, String string, String string2, boolean bl) {
        this(pCollManagerHelper, string, string2, bl, false);
    }

    public PCollManager(PCollManagerHelper pCollManagerHelper, String string, String string2, boolean bl, boolean bl2) {
        this.$init$();
        this.mPersistent = bl;
        this.mHasPersistMgr = string2 == null || !string2.equals(PERSIST_MGR_NONE);
        this.mHelper = pCollManagerHelper;
        this.init(string, string2);
        this.mTableCreated = bl2;
    }

    public PCollManager(PCollManagerHelper pCollManagerHelper, String string, boolean bl) {
        this.$init$();
        this.mHasPersistMgr = true;
        this.mHelper = pCollManagerHelper;
        this.mPersistent = bl;
        this.init(string, null);
    }

    public PCollManager(String string, String string2, String string3) {
        this.$init$();
        this.mHasPersistMgr = string3 == null || !string3.equals(PERSIST_MGR_NONE);
        try {
            this.mDBURL = string;
        }
        catch (Exception exception) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = PCollManager.class$("oracle.jbo.CSMessageBundle");
            }
            PCollException.throwException(clazz, "28001", null, exception);
        }
        this.init(string2, string3);
    }

    public boolean isOpen() {
        return this.mIsOpen;
    }

    public synchronized void reopen(String string) {
        this.mColls = new WeakVector(10);
        this.mIsOpen = true;
        this.mNameResolved = false;
        if (this.mTableSignature >= 0L) {
            PersistManager persistManager = this.getPersistManager();
            if (persistManager != null) {
                persistManager.init(1);
            }
        } else {
            this.setName(string);
        }
    }

    public synchronized void close() {
        this.close(0);
    }

    public synchronized void close(int n) {
        this.mIsOpen = false;
        if (this.mPersistMgr != null) {
            if ((n & 1) > 0) {
                this.holdTableSignature();
                this.mPersistMgr.close(1);
            } else {
                this.mPersistMgr.close();
            }
            this.mPersistMgr = null;
        }
        this.mColls = null;
        if (this.mConn != null && this.mConnCreatedLocally) {
            try {
                this.mConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mConn = null;
        this.mConnCreatedLocally = false;
    }

    public synchronized void releaseConnection() {
        this.mConn = null;
        this.mConnCreatedLocally = false;
    }

    void init(String string, String string2) {
        if (this.mHasPersistMgr && this.mHelper == null && this.mDBURL == null) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("**PCollManager.init turning off persist mgr for " + string2);
                Diagnostic.println("     because there is neither PCollManagerHelper nor DBURL");
            }
            this.mHasPersistMgr = false;
        }
        this.mColls = new WeakVector(10);
        if (string2 == null) {
            string2 = PERSIST_MGR_ORACLE;
        }
        this.mPersistMgrName = string2;
        this.mPersistMgr = null;
        if (string != null) {
            this.setName(string);
        }
    }

    public boolean hasPersistMgr() {
        return this.mHasPersistMgr;
    }

    boolean isPersistent() {
        return this.mPersistent;
    }

    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        if (this.mNameResolved) {
            return;
        }
        PCollManager pCollManager = this;
        synchronized (pCollManager) {
            if (this.mNameResolved) {
                return;
            }
            if (string == null || string.length() == 0) {
                string = "Unknown";
            }
            this.mName = "PS_" + string;
        }
    }

    public synchronized void overrideObjectNames(String string, String string2) {
        PersistManager persistManager;
        if (string != null) {
            this.mName = string;
        }
        if (string2 != null && (persistManager = this.getPersistManager()) != null && PERSIST_MGR_ORACLE.equals(this.mPersistMgrName)) {
            ((OraclePersistManager)persistManager).setTxnSeqName(string2);
        }
        this.mNameResolved = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolveName() {
        if (this.mNameResolved) {
            return;
        }
        PCollManager pCollManager = this;
        synchronized (pCollManager) {
            if (this.mNameResolved) {
                return;
            }
            if (this.mName == null) {
                this.mName = "PS_Unknown";
            }
            this.mNameResolved = true;
            int n = 0;
            String string = this.mName;
            PersistManager persistManager = this.getPersistManager();
            if (persistManager != null) {
                int n2 = persistManager.getMaxTabNameLength();
                if (this.mName.length() > n2) {
                    string = this.mName.substring(0, n2);
                }
                if (this.mTableSignature >= 0L) {
                    boolean bl = persistManager.waitForTableName(string);
                    if (!bl || this.mTableSignature != persistManager.getTableSignature(string)) {
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = PCollManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        PCollException.throwException(clazz, "28006", new Object[]{string}, null);
                    }
                    this.mTableSignature = -1;
                } else {
                    while (!persistManager.holdTableName(string, true)) {
                        String string2 = "_" + new Integer(++n).toString();
                        if (this.mName.length() + string2.length() > n2) {
                            string = this.mName.substring(0, n2 - string2.length()) + string2;
                            continue;
                        }
                        string = this.mName + string2;
                    }
                }
                Diagnostic.println("**PCollManager.resolveName** tabName=" + string);
            }
            this.mName = string;
            if (persistManager == null) return;
            persistManager.setTableName(this.mName);
            return;
        }
    }

    public long getPersistentNextNodeId(int n) {
        PersistManager persistManager = this.getPersistManager();
        return persistManager != null ? persistManager.queryNextNodeId(n) : (long)-1;
    }

    public long getNextObjId(int n) {
        PersistManager persistManager = this.getPersistManager();
        return this.mPersistent && persistManager != null ? persistManager.queryNextObjId(n) : (this.mObjId = this.mObjId + 1L);
    }

    public long getNextObjId() {
        return ++this.mObjId;
    }

    public void useObjIdUpto(long l) {
        if (this.mObjId < l) {
            this.mObjId = l + 1L;
        }
    }

    String getPersistMgrName() {
        return this.mPersistMgrName;
    }

    public PCollection createCollection(String string, int n) {
        return this.createCollection(string, n, -1);
    }

    public PCollection createCollection(String string, int n, int n2, int n3) {
        return new PCollection(this, string, n, n2, n3);
    }

    public PCollection createCollection(String string, int n, int n2) {
        return this.createCollection(string, n, n2, -1);
    }

    public Connection getConnection() {
        return this.mConn;
    }

    Connection ensureConnection() {
        if (this.mHasPersistMgr && this.mConn == null) {
            try {
                if (this.mHelper != null) {
                    this.mConn = this.mHelper.getPersistManagerConnection();
                } else if (this.mDBURL != null) {
                    Connection connection = this.mConn = this.mHasPersistMgr ? DriverManager.getConnection(this.mDBURL) : null;
                    if (this.mConn != null) {
                        this.mConnCreatedLocally = true;
                    }
                }
                if (this.mConn != null && this.mConn.getAutoCommit()) {
                    this.mConn.setAutoCommit(false);
                }
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = PCollManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28001", null, exception);
            }
        }
        return this.mConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection(Connection connection) {
        if (this.mHasPersistMgr) {
            PCollManager pCollManager = this;
            synchronized (pCollManager) {
                this.mConn = connection;
                this.mConnCreatedLocally = false;
                try {
                    if (this.mConn.getAutoCommit()) {
                        this.mConn.setAutoCommit(false);
                    }
                }
                catch (Exception exception) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = PCollManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28001", null, exception);
                }
            }
        }
    }

    synchronized int register(PCollection pCollection, int n) {
        int n2;
        PersistManager persistManager = this.getPersistManager();
        this.mColls.addElement(pCollection);
        if (n <= 0) {
            if (this.mPersistent && persistManager != null) {
                n2 = (int)persistManager.queryNextCollectionId();
            } else {
                int n3 = this.mCollSeqId;
                n2 = n3;
                this.mCollSeqId = n3 + 1;
            }
        } else {
            n2 = n;
        }
        return n2;
    }

    synchronized boolean unregister(PCollection pCollection) {
        boolean bl = false;
        if (this.mColls != null) {
            bl = this.mColls.removeElement(pCollection);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PersistManager getPersistManager() {
        if (!this.mHasPersistMgr) {
            return null;
        }
        PCollManager pCollManager = this;
        synchronized (pCollManager) {
            if (this.mPersistMgr == null) {
                String string = this.getPersistMgrName();
                try {
                    Class clazz = JBOClass.forName(string);
                    this.mPersistMgr = (PersistManager)clazz.newInstance();
                    this.mPersistMgr.setPCollManager(this);
                    this.mPersistMgr.setPersistent(this.mPersistent);
                    this.mPersistMgr.setTableCreated(this.mTableCreated);
                }
                catch (Exception exception) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = PCollManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28000", new Object[]{string}, exception);
                }
            }
            PersistManager persistManager = this.mPersistMgr;
            return persistManager;
        }
    }

    public void commit() {
        PersistManager persistManager = this.getPersistManager();
        if (persistManager != null) {
            persistManager.commit();
        }
    }

    public void setSequenceIncrementSize(long l) {
        PersistManager persistManager = this.getPersistManager();
        if (persistManager != null && persistManager instanceof OraclePersistManager) {
            ((OraclePersistManager)persistManager).setSequenceIncrementSize(l);
        }
    }

    private void holdTableSignature() {
        PersistManager persistManager = this.getPersistManager();
        if (persistManager != null && !this.mPersistent) {
            this.mTableSignature = persistManager.getTableSignature(this.mName);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

