/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.pcoll;

import com.sun.java.util.collections.ArrayList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import oracle.jbo.PCollException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.pcoll.PCollKeyInfo;
import oracle.jbo.pcoll.PCollManager;
import oracle.jbo.pcoll.PCollNode;
import oracle.jbo.pcoll.PCollection;
import oracle.jbo.pcoll.PersistManager;

public abstract class JDBCPersistManager
implements PersistManager {
    public static final int CONTSTAT_FIRST_PART = 1;
    public static final int CONTSTAT_FIRST_AND_SECOND_PART = 2;
    public static final int CONTSTAT_SECOND_PART = 3;
    private PCollManager mPCollManager;
    private boolean mTableCreated;
    private boolean mKeyInfoTableCreated;
    private int mNumPendingOps;
    private String mTableName;
    private String mKeyInfoTableName;
    private int mCommitThreshhold;
    boolean mPersistent;
    private boolean mControlTabCreated;
    private static final String CONTROL_TAB_NAME = "PCOLL_CONTROL";
    private static final long TIME_LIM_FOR_RETIRING_CNTL_ROW = 60000L;
    private static final long TIME_LIM_FOR_LOCKING_CNTL_ROW = 10000L;
    public static final boolean mDebugOn = true;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mPCollManager = null;
        this.mTableCreated = false;
        this.mKeyInfoTableCreated = false;
        this.mNumPendingOps = 0;
        this.mTableName = null;
        this.mKeyInfoTableName = null;
        this.mCommitThreshhold = 20;
        this.mPersistent = false;
        this.mControlTabCreated = false;
    }

    public JDBCPersistManager() {
        this.$init$();
    }

    public abstract int getMaxTabNameLength();

    protected abstract String sqlCreateControlTable(String var1);

    protected abstract int sqlTableExistsErrorCode();

    protected abstract void dropTable(String var1);

    protected abstract String sqlAddKeyContColumn(String var1);

    protected abstract String sqlDropKeyInfoTable(String var1);

    protected abstract String sqlCreateKeyInfoTable(String var1);

    protected abstract String sqlCreateKeyInfoKeyIndex(String var1, String var2);

    protected abstract String sqlCreateKeyInfoIdIndex(String var1, String var2);

    protected abstract String sqlCreateTable(String var1);

    protected abstract String sqlCreateIndex(String var1);

    protected abstract long sqlNextSequenceVal(String var1);

    protected abstract Date getCurrentTimeFromDb();

    protected abstract String sqlDeleteControlRow(String var1, String var2);

    protected abstract String sqlUpdateControlRow(String var1, String var2, String var3);

    protected abstract String sqlLockControlRow(String var1, String var2);

    protected abstract String sqlInsertControlRow(String var1, String var2);

    protected abstract int sqlLockConflictErrorCode();

    protected abstract int contentChunkLength();

    protected abstract String sqlDeleteKeyInfo(String var1, long var2);

    protected abstract void bindDeleteKeyInfo(PreparedStatement var1, long var2, int var4) throws SQLException;

    protected abstract String sqlInsertKeyInfo(String var1);

    protected abstract void bindInsertKeyInfo(PreparedStatement var1, long var2, int var4, int var5, int var6) throws SQLException;

    protected abstract String sqlInsertDataRow(String var1, long var2, long var4, int var6);

    protected abstract void bindInsertDataRow(PreparedStatement var1, long var2, long var4, int var6, int var7, int var8, int var9, byte[] var10, int var11) throws SQLException;

    protected abstract String sqlDeleteOldChunksDataRow(String var1, long var2, int var4, int var5, int var6);

    protected abstract void bindDeleteOldChunksDataRow(PreparedStatement var1, long var2, int var4, int var5, int var6) throws SQLException;

    protected abstract String sqlUpdateDataRow(String var1, long var2, long var4, int var6);

    protected abstract void bindUpdateDataRow(PreparedStatement var1, long var2, long var4, int var6, int var7, int var8, int var9, byte[] var10, int var11) throws SQLException;

    protected abstract String sqlChangeParentDataRow(String var1, long var2, long var4, int var6);

    protected abstract void bindChangeParentDataRow(PreparedStatement var1, long var2, long var4, int var6) throws SQLException;

    protected abstract String sqlDeleteDataRow(String var1, long var2, int var4);

    protected abstract void bindDeleteDataRow(PreparedStatement var1, long var2, int var4) throws SQLException;

    protected abstract String sqlDeleteAllDataRows(String var1, int var2);

    protected abstract void bindDeleteAllDataRows(PreparedStatement var1, int var2) throws SQLException;

    protected abstract String sqlRetrieveDataRow(String var1, long var2, int var4, boolean var5, boolean var6);

    protected abstract void bindRetrieveDataRow(PreparedStatement var1, long var2, int var4, boolean var5) throws SQLException;

    protected abstract byte[] getContentDataRow(ResultSet var1, long[] var2, long[] var3, int[] var4, boolean var5) throws SQLException;

    protected abstract String sqlRetrieveIdsWithKey(String var1, String var2, int var3, Object var4, int var5);

    protected abstract void bindRetrieveIdsWithKey(PreparedStatement var1, int var2, Object var3, int var4, int var5) throws SQLException;

    public synchronized void close() {
        this.close(0);
    }

    public synchronized void close(int n) {
        block4: {
            Connection connection = this.mPCollManager.getConnection();
            if (connection != null) {
                try {
                    connection.rollback();
                    if (this.mTableCreated && !this.mPersistent && (n & 1) == 0) {
                        this.dropTable(this.mTableName);
                        this.deleteControlRow(CONTROL_TAB_NAME, this.mTableName);
                        connection.commit();
                    }
                }
                catch (Exception exception) {
                    if (!Diagnostic.isOn()) break block4;
                    Diagnostic.printStackTrace(exception);
                }
            }
        }
    }

    public void setPCollManager(PCollManager pCollManager) {
        this.mPCollManager = pCollManager;
    }

    public synchronized Connection getConnection() {
        return this.mPCollManager.ensureConnection();
    }

    public void setTableName(String string) {
        this.mTableName = string;
    }

    public void setCommitThreshhold(int n) {
        if (n <= 1) {
            n = 1;
        }
        this.mCommitThreshhold = n;
    }

    public boolean isPersistent() {
        return this.mPersistent;
    }

    public void setPersistent(boolean bl) {
        this.mPersistent = bl;
    }

    public void setTableCreated(boolean bl) {
        this.mTableCreated = bl;
    }

    protected static void closeStmt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected static void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized void commit() {
        if (Diagnostic.isOn()) {
            Diagnostic.println("**commit** #pending ops=" + this.mNumPendingOps);
        }
        if (!this.mPersistent) {
            this.updateControlRow(this.mTableName, "updatedate");
        }
        try {
            this.getConnection().commit();
        }
        catch (SQLException sQLException) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
            }
            PCollException.throwException(clazz, "28007", new Object[]{this.mTableName}, sQLException);
        }
        this.mNumPendingOps = 0;
        this.waitForTableName(this.mTableName);
    }

    synchronized void commitIfNeeded() {
        if (++this.mNumPendingOps >= this.mCommitThreshhold) {
            this.commit();
        }
    }

    protected void handleControlTableExists(SQLException sQLException) {
        int n = sQLException.getErrorCode();
        if (n != this.sqlTableExistsErrorCode()) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("**createControlTable failed with SQL code: " + n);
                Diagnostic.printStackTrace(sQLException);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
            }
            PCollException.throwException(clazz, "28002", new Object[]{CONTROL_TAB_NAME}, sQLException);
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("**createControlTable** tabname=PCOLL_CONTROL already exists");
        }
    }

    protected void dropOutdatedControlTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createControlTable() {
        if (this.mControlTabCreated) {
            return;
        }
        JDBCPersistManager jDBCPersistManager = this;
        synchronized (jDBCPersistManager) {
            block11: {
                if (this.mControlTabCreated) {
                    return;
                }
                this.mPCollManager.resolveName();
                if (this.mControlTabCreated) {
                    return;
                }
                Statement statement = null;
                Object var2_3 = null;
                this.dropOutdatedControlTable();
                try {
                    block10: {
                        try {
                            statement = this.getConnection().createStatement();
                            String string = this.sqlCreateControlTable(CONTROL_TAB_NAME);
                            statement.execute(string);
                            if (!Diagnostic.isOn()) break block10;
                            Diagnostic.println("**createControlTable** tabname=PCOLL_CONTROL created");
                        }
                        catch (SQLException sQLException) {
                            this.handleControlTableExists(sQLException);
                            Object var7_6 = null;
                            JDBCPersistManager.closeStmt(statement);
                            statement = null;
                            break block11;
                        }
                    }
                    Object var7_5 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    JDBCPersistManager.closeStmt(statement);
                    statement = null;
                    throw throwable;
                }
                JDBCPersistManager.closeStmt(statement);
                statement = null;
            }
            this.mControlTabCreated = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createKeyInfoTable() {
        block28: {
            String string;
            Statement statement;
            block26: {
                block25: {
                    if (this.mKeyInfoTableCreated) {
                        return;
                    }
                    statement = null;
                    try {
                        statement = this.getConnection().createStatement();
                    }
                    catch (SQLException sQLException) {
                        Class clazz;
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**createStatement failed**");
                            Diagnostic.printStackTrace(sQLException);
                        }
                        if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        PCollException.throwException(clazz, "28006", new Object[]{this.mTableName}, sQLException);
                    }
                    string = null;
                    try {
                        string = this.sqlAddKeyContColumn(this.mTableName);
                        if (string == null) break block25;
                        statement.execute(string);
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**createKeyInfoTable** added keycont col");
                        }
                    }
                    catch (SQLException sQLException) {
                        this.commit();
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**createKeyInfoTable** add keycont failed, sqlStmt=" + string);
                            Diagnostic.printStackTrace(sQLException);
                        }
                        JDBCPersistManager.closeStmt(statement);
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        PCollException.throwException(clazz, "28012", new Object[]{"keycont", this.mTableName}, sQLException);
                    }
                }
                this.mKeyInfoTableName = this.mTableName + "_ky";
                try {
                    string = this.sqlDropKeyInfoTable(this.mKeyInfoTableName);
                    statement.execute(string);
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("**createKeyInfoTable** dropped key info table: " + this.mKeyInfoTableName);
                    }
                }
                catch (SQLException sQLException) {
                    if (!Diagnostic.isOn()) break block26;
                    Diagnostic.println("**createKeyInfoTable** drop table failed, tabname=" + this.mKeyInfoTableName);
                }
            }
            try {
                string = this.sqlCreateKeyInfoTable(this.mKeyInfoTableName);
                statement.execute(string);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**createKeyInfoTable** created key info table: " + this.mKeyInfoTableName);
                }
            }
            catch (SQLException sQLException) {
                this.commit();
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**createKeyInfoTable** create table failed, sqlStmt=" + string);
                    Diagnostic.printStackTrace(sQLException);
                }
                JDBCPersistManager.closeStmt(statement);
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28013", new Object[]{this.mKeyInfoTableName}, sQLException);
            }
            String string2 = null;
            string = null;
            try {
                block27: {
                    try {
                        string2 = this.mTableName + "_ki";
                        string = this.sqlCreateKeyInfoKeyIndex(string2, this.mKeyInfoTableName);
                        statement.execute(string);
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**createKeyInfoTable** created index, indexname=" + string2);
                        }
                        string2 = this.mTableName + "_kj";
                        string = this.sqlCreateKeyInfoIdIndex(string2, this.mKeyInfoTableName);
                        statement.execute(string);
                        if (!Diagnostic.isOn()) break block27;
                        Diagnostic.println("**createKeyInfoTable** created index, indexname=" + string2);
                    }
                    catch (SQLException sQLException) {
                        Class clazz;
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**createKeyInfoTable** create index failed, sqlStmt=" + string);
                            Diagnostic.printStackTrace(sQLException);
                        }
                        if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        PCollException.throwException(clazz, "28008", new Object[]{string2, this.mTableName}, sQLException);
                        Object var10_9 = null;
                        this.commit();
                        JDBCPersistManager.closeStmt(statement);
                        statement = null;
                        break block28;
                    }
                }
                Object var10_8 = null;
                this.commit();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.commit();
                JDBCPersistManager.closeStmt(statement);
                statement = null;
                throw throwable;
            }
            JDBCPersistManager.closeStmt(statement);
            statement = null;
        }
        this.mKeyInfoTableCreated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createTable() {
        if (this.mTableCreated) return;
        JDBCPersistManager jDBCPersistManager = this;
        synchronized (jDBCPersistManager) {
            block26: {
                if (this.mTableCreated) {
                    return;
                }
                this.createControlTable();
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    statement = this.getConnection().createStatement();
                }
                catch (SQLException sQLException) {
                    Class clazz;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("**createStatement failed**");
                        Diagnostic.printStackTrace(sQLException);
                    }
                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28006", new Object[]{this.mTableName}, sQLException);
                }
                if (!this.mPersistent) {
                    this.dropTable(this.mTableName);
                }
                String string = null;
                try {
                    block25: {
                        try {
                            block24: {
                                if (this.mPersistent) {
                                    try {
                                        block23: {
                                            try {
                                                long l;
                                                String string2 = this.mTableName + "_SEQ";
                                                string = "create sequence " + string2;
                                                statement.execute(string);
                                                if (Diagnostic.isOn()) {
                                                    Diagnostic.println("**createTable** created sequence, seqName=" + string2);
                                                }
                                                if (!(resultSet = statement.executeQuery(string = "select max(collid) from " + this.mTableName)).next() || (l = resultSet.getLong(1)) <= 1L) break block23;
                                                string = "alter sequence " + string2 + " restart with " + ++l;
                                                statement.executeQuery(string);
                                                this.sqlNextSequenceVal(string2);
                                                if (!Diagnostic.isOn()) break block23;
                                                Diagnostic.println("**createTable** updated sequence start with " + l);
                                            }
                                            catch (SQLException sQLException) {
                                                Object var12_9 = null;
                                                JDBCPersistManager.closeResultSet(resultSet);
                                                resultSet = null;
                                                break block24;
                                            }
                                        }
                                        Object var12_8 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var12_10 = null;
                                        JDBCPersistManager.closeResultSet(resultSet);
                                        resultSet = null;
                                        throw throwable;
                                    }
                                    JDBCPersistManager.closeResultSet(resultSet);
                                    resultSet = null;
                                }
                            }
                            string = this.sqlCreateTable(this.mTableName);
                            statement.execute(string);
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("**createTable** created table, tabname=" + this.mTableName);
                            }
                            string = this.sqlCreateIndex(this.mTableName);
                            statement.execute(string);
                            if (!Diagnostic.isOn()) break block25;
                            Diagnostic.println("**createTable** created index");
                        }
                        catch (SQLException sQLException) {
                            if (!this.mPersistent) {
                                Class clazz;
                                if (Diagnostic.isOn()) {
                                    Diagnostic.println("**createTable** created table/index error");
                                    Diagnostic.println("Executing: " + string);
                                    Diagnostic.printStackTrace(sQLException);
                                }
                                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                                    clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                                }
                                PCollException.throwException(clazz, "28006", new Object[]{this.mTableName}, sQLException);
                            }
                            Object var14_14 = null;
                            this.commit();
                            JDBCPersistManager.closeStmt(statement);
                            statement = null;
                            break block26;
                        }
                    }
                    Object var14_13 = null;
                    this.commit();
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    this.commit();
                    JDBCPersistManager.closeStmt(statement);
                    statement = null;
                    throw throwable;
                }
                JDBCPersistManager.closeStmt(statement);
                statement = null;
            }
            this.mTableCreated = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deleteControlRow(String string, String string2) {
        this.createControlTable();
        Statement statement = null;
        try {
            try {
                statement = this.getConnection().createStatement();
                String string3 = this.sqlDeleteControlRow(string, string2);
                statement.executeUpdate(string3);
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**deleteControlRow** tabName=" + string2 + " delete error");
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28003", new Object[]{string2}, null);
                Object var7_6 = null;
                JDBCPersistManager.closeStmt(statement);
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JDBCPersistManager.closeStmt(statement);
            statement = null;
            throw throwable;
        }
        JDBCPersistManager.closeStmt(statement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void updateControlRow(String string, String string2) {
        this.createControlTable();
        Statement statement = null;
        try {
            try {
                statement = this.getConnection().createStatement();
                String string3 = this.sqlUpdateControlRow(CONTROL_TAB_NAME, string, string2);
                statement.executeUpdate(string3);
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**updateControlRow** tabName=" + string + ", " + string2 + " update error");
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28005", new Object[]{string}, null);
                Object var7_6 = null;
                JDBCPersistManager.closeStmt(statement);
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JDBCPersistManager.closeStmt(statement);
            statement = null;
            throw throwable;
        }
        JDBCPersistManager.closeStmt(statement);
    }

    protected boolean handleControlRowLockConflict(SQLException sQLException, boolean bl, String string) {
        Class clazz;
        int n = sQLException.getErrorCode();
        if (n == this.sqlLockConflictErrorCode() && bl) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("**holdTableName** tabName=" + string + " locked by someone else");
            }
            return false;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("**holdTableName** tabName=" + string + " select error");
            Diagnostic.printStackTrace(sQLException);
        }
        if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
            clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
        }
        PCollException.throwException(clazz, "28004", new Object[]{string}, null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized long queryControlRow(String string, String string2) {
        this.createControlTable();
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = null;
        long l = -1;
        try {
            try {
                statement = this.getConnection().createStatement();
                string3 = "select " + string2 + " from " + CONTROL_TAB_NAME + " where tabname='" + string + "'";
                resultSet = statement.executeQuery(string3);
                if (resultSet.next()) {
                    Date date = (Date)resultSet.getObject(1);
                    l = date.getTime();
                }
            }
            catch (SQLException sQLException) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**queryControlRow** tabName=" + string + ", " + string2 + " update error, sqlStmt=" + string3);
                    Diagnostic.printStackTrace(sQLException);
                }
                Object var11_9 = null;
                JDBCPersistManager.closeResultSet(resultSet);
                resultSet = null;
                JDBCPersistManager.closeStmt(statement);
                return l;
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            JDBCPersistManager.closeResultSet(resultSet);
            resultSet = null;
            JDBCPersistManager.closeStmt(statement);
            statement = null;
            throw throwable;
        }
        JDBCPersistManager.closeResultSet(resultSet);
        resultSet = null;
        JDBCPersistManager.closeStmt(statement);
        return l;
    }

    public long getTableSignature(String string) {
        this.createControlTable();
        if (this.mPersistent) {
            return -1;
        }
        return this.queryControlRow(string, "updatedate");
    }

    public void init(int n) {
        if ((n & 1) > 0) {
            this.createControlTable();
            this.mTableCreated = true;
            this.mKeyInfoTableName = this.mTableName + "_ky";
            this.mKeyInfoTableCreated = true;
        } else {
            this.createTable();
        }
    }

    public boolean waitForTableName(String string) {
        long l = System.currentTimeMillis();
        do {
            if (!this.holdTableName(string, false)) continue;
            return true;
        } while (System.currentTimeMillis() - l <= 10000L);
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
        }
        PCollException.throwException(clazz, "28004", new Object[]{this.mTableName}, null);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean holdTableName(String string, boolean bl) {
        ResultSet resultSet;
        Statement statement;
        block16: {
            boolean bl2;
            block18: {
                boolean bl3;
                block17: {
                    this.createControlTable();
                    if (this.mPersistent) {
                        return true;
                    }
                    statement = null;
                    resultSet = null;
                    boolean bl4 = false;
                    try {
                        try {
                            statement = this.getConnection().createStatement();
                            String string2 = this.sqlLockControlRow(CONTROL_TAB_NAME, string);
                            resultSet = statement.executeQuery(string2);
                            if (!resultSet.next()) {
                                if (bl) {
                                    if (Diagnostic.isOn()) {
                                        Diagnostic.println("**holdTableName** tabName=" + string + " not found in controltab");
                                    }
                                    try {
                                        string2 = this.sqlInsertControlRow(CONTROL_TAB_NAME, string);
                                        statement.execute(string2);
                                        this.getConnection().commit();
                                        bl4 = true;
                                        if (Diagnostic.isOn()) {
                                            Diagnostic.println("**holdTableName** tabName=" + string + " inserted into controltab");
                                        }
                                        break block16;
                                    }
                                    catch (SQLException sQLException) {
                                        if (Diagnostic.isOn()) {
                                            Diagnostic.println("**holdTableName** tabName=" + string + " insertion failed");
                                            Diagnostic.printStackTrace(sQLException);
                                        }
                                        boolean bl5 = false;
                                        Object var20_9 = null;
                                        JDBCPersistManager.closeResultSet(resultSet);
                                        resultSet = null;
                                        JDBCPersistManager.closeStmt(statement);
                                        return bl5;
                                    }
                                }
                                if (Diagnostic.isOn()) {
                                    Diagnostic.println("**holdTableName** tabName=" + string + " could not be located after commit");
                                }
                                bl3 = false;
                                Object var20_10 = null;
                                break block17;
                            }
                            if (!bl4 && bl) {
                                Date date = (Date)resultSet.getObject(2);
                                Date date2 = this.getCurrentTimeFromDb();
                                long l = date.getTime();
                                long l2 = date2.getTime();
                                if (l2 < l || l2 - l <= 60000L) {
                                    this.getConnection().commit();
                                    bl2 = false;
                                    break block18;
                                }
                                this.updateControlRow(string, "createdate");
                            }
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("**holdTableName** tabName=" + string + " locked in controltab");
                            }
                            break block16;
                        }
                        catch (SQLException sQLException) {
                            boolean bl6 = this.handleControlRowLockConflict(sQLException, bl, string);
                            Object var20_13 = null;
                            JDBCPersistManager.closeResultSet(resultSet);
                            resultSet = null;
                            JDBCPersistManager.closeStmt(statement);
                            return bl6;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var20_14 = null;
                        JDBCPersistManager.closeResultSet(resultSet);
                        resultSet = null;
                        JDBCPersistManager.closeStmt(statement);
                        statement = null;
                        throw throwable;
                    }
                }
                JDBCPersistManager.closeResultSet(resultSet);
                resultSet = null;
                JDBCPersistManager.closeStmt(statement);
                return bl3;
            }
            Object var20_11 = null;
            JDBCPersistManager.closeResultSet(resultSet);
            resultSet = null;
            JDBCPersistManager.closeStmt(statement);
            return bl2;
        }
        Object var20_12 = null;
        JDBCPersistManager.closeResultSet(resultSet);
        resultSet = null;
        JDBCPersistManager.closeStmt(statement);
        return true;
    }

    public long queryNextCollectionId() {
        this.createTable();
        return this.sqlNextSequenceVal(this.mTableName + "_SEQ");
    }

    public long queryNextObjId(int n) {
        return this.queryNextId("id", true, " where collid =?", n);
    }

    public long queryNextNodeId(int n) {
        return this.queryNextId("id", false, " where collid=?", n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long queryNextId(String string, boolean bl, String string2, int n) {
        this.createTable();
        Statement statement = null;
        ResultSet resultSet = null;
        long l = 1L;
        String string3 = null;
        try {
            try {
                string3 = "select " + (bl ? "max(" : "min(") + string + ") from " + this.mTableName + string2;
                if (n == -1) {
                    statement = this.getConnection().createStatement();
                    resultSet = statement.executeQuery(string3);
                } else {
                    statement = this.getConnection().prepareStatement(string3);
                    PreparedStatement preparedStatement = (PreparedStatement)statement;
                    preparedStatement.setInt(1, n);
                    resultSet = preparedStatement.executeQuery();
                }
                if (resultSet.next()) {
                    l = resultSet.getLong(1);
                    l = bl ? (l <= 0L ? 1L : (l = l + 1L)) : (l >= 0L ? (long)-1 : (l = l - 1L));
                }
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**queryNextId** error, sqlStmt=" + string3);
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28011", new Object[]{this.mTableName, string, new Integer(n)}, sQLException);
                Object var13_11 = null;
                JDBCPersistManager.closeResultSet(resultSet);
                resultSet = null;
                JDBCPersistManager.closeStmt(statement);
                return l;
            }
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            JDBCPersistManager.closeResultSet(resultSet);
            resultSet = null;
            JDBCPersistManager.closeStmt(statement);
            statement = null;
            throw throwable;
        }
        JDBCPersistManager.closeResultSet(resultSet);
        resultSet = null;
        JDBCPersistManager.closeStmt(statement);
        return l;
    }

    private void compareContent(long l, long l2, int n, byte[] byArray) {
        try {
            int n2;
            long[] lArray = new long[1];
            Object[] objectArray = this.retrieve(l, n, false, lArray);
            InputStream inputStream = (InputStream)objectArray[1];
            int n3 = 0;
            while (n3 < byArray.length) {
                int n4 = inputStream.read();
                if (n4 < 0) {
                    Diagnostic.ASSERT(false, "EOS on index: " + n3);
                }
                if (byArray[n3] != (byte)n4) {
                    Diagnostic.ASSERT(false, "Content diff: " + n3);
                }
                ++n3;
            }
            if (inputStream.read() >= 0) {
                Diagnostic.ASSERT(false, "Extra stuff");
            }
            if (l2 != lArray[0]) {
                Diagnostic.ASSERT(false, "Parent id mismatch");
            }
            if ((n2 = this.getContentLenDataRow(this.mTableName, l, n, false)) != byArray.length) {
                Diagnostic.ASSERT(false, "Content len mismatch");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private PCollKeyInfo[] deserializeKeyArr(ObjectInputStream objectInputStream) throws Exception {
        int n = objectInputStream.readInt();
        PCollKeyInfo[] pCollKeyInfoArray = new PCollKeyInfo[n];
        int n2 = 0;
        while (n2 < n) {
            pCollKeyInfoArray[n2] = (PCollKeyInfo)objectInputStream.readObject();
            ++n2;
        }
        return pCollKeyInfoArray;
    }

    private byte[] serializeKeyArr(PCollKeyInfo[] pCollKeyInfoArray) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        byte[] byArray = null;
        try {
            objectOutputStream.writeInt(pCollKeyInfoArray.length);
            int n = 0;
            while (n < pCollKeyInfoArray.length) {
                objectOutputStream.writeObject(pCollKeyInfoArray[n]);
                ++n;
            }
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            PCollNode.closeOutputStream(objectOutputStream);
            objectOutputStream = null;
            PCollNode.closeOutputStream(byteArrayOutputStream);
            byteArrayOutputStream = null;
            throw throwable;
        }
        PCollNode.closeOutputStream(objectOutputStream);
        objectOutputStream = null;
        PCollNode.closeOutputStream(byteArrayOutputStream);
        byteArrayOutputStream = null;
        return byArray;
    }

    public void updateKeyInfo(long l, int n, PCollKeyInfo[] pCollKeyInfoArray) throws SQLException {
        if (!this.mKeyInfoTableCreated) {
            return;
        }
        PreparedStatement preparedStatement = null;
        String string = null;
        try {
            string = this.sqlDeleteKeyInfo(this.mKeyInfoTableName, l);
            preparedStatement = this.getConnection().prepareStatement(string);
            this.bindDeleteKeyInfo(preparedStatement, l, n);
            if (Diagnostic.isOn()) {
                Diagnostic.println("   stmt: " + string);
            }
            preparedStatement.execute();
            JDBCPersistManager.closeStmt(preparedStatement);
            preparedStatement = null;
            string = this.sqlInsertKeyInfo(this.mKeyInfoTableName);
            preparedStatement = this.getConnection().prepareStatement(string);
            if (Diagnostic.isOn()) {
                Diagnostic.println("   stmt: " + string);
            }
            if (pCollKeyInfoArray != null) {
                int n2 = 0;
                while (n2 < pCollKeyInfoArray.length) {
                    int n3 = pCollKeyInfoArray[n2].mKeyId;
                    Object object = pCollKeyInfoArray[n2].mKey;
                    if (object != null) {
                        int n4 = object.hashCode();
                        this.bindInsertKeyInfo(preparedStatement, l, n, n3, n4);
                        preparedStatement.execute();
                    }
                    ++n2;
                }
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            JDBCPersistManager.closeStmt(preparedStatement);
            preparedStatement = null;
            throw throwable;
        }
        JDBCPersistManager.closeStmt(preparedStatement);
        preparedStatement = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void insert(long l, long l2, int n, PCollKeyInfo[] pCollKeyInfoArray, byte[] byArray) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("**insert** id=" + l + ", parid=" + l2 + ", collid=" + n + ", keyArr.len=" + (pCollKeyInfoArray == null ? -1 : pCollKeyInfoArray.length) + ", cont.len=" + byArray.length);
        }
        int n2 = pCollKeyInfoArray == null ? 0 : pCollKeyInfoArray.length;
        byte[] byArray2 = null;
        PreparedStatement preparedStatement = null;
        String string = null;
        this.createTable();
        try {
            try {
                if (n2 > 0) {
                    this.createKeyInfoTable();
                    byArray2 = this.serializeKeyArr(pCollKeyInfoArray);
                }
                FlatTwoByteArrs flatTwoByteArrs = new FlatTwoByteArrs(byArray2, byArray);
                int n3 = byArray2 != null ? byArray2.length : 0;
                int n4 = flatTwoByteArrs.length();
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = this.contentChunkLength();
                byte[] byArray3 = null;
                string = this.sqlInsertDataRow(this.mTableName, l, l2, n);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("   stmt: " + string);
                }
                preparedStatement = this.getConnection().prepareStatement(string);
                while (true) {
                    int n9;
                    if (n5 >= n4) {
                        string = null;
                        this.updateKeyInfo(l, n, pCollKeyInfoArray);
                        this.commitIfNeeded();
                        break;
                    }
                    if (n2 == 0 && n4 <= n8) {
                        byArray3 = byArray;
                        n9 = n4;
                    } else if (byArray.length == 0 && n4 <= n8) {
                        byArray3 = byArray2;
                        n9 = n4;
                    } else {
                        n9 = n4 - n5 < n8 ? n4 - n5 : n8;
                        if (byArray3 == null || byArray3.length != n9) {
                            byArray3 = new byte[n9];
                        }
                        n7 = flatTwoByteArrs.copyInto(n5, byArray3, 0, n9);
                    }
                    this.bindInsertDataRow(preparedStatement, l, l2, n, n3, byArray.length, n6, byArray3, n7);
                    preparedStatement.execute();
                    this.commitIfNeeded();
                    n5 += n9;
                    ++n6;
                }
            }
            catch (Exception exception) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**insert** error, sqlStmt=" + string);
                    Diagnostic.printStackTrace(exception);
                }
                if (exception instanceof SQLException) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28030", new Object[]{this.mTableName, new Integer(n), new Long(l)}, exception);
                }
                Object var23_20 = null;
                JDBCPersistManager.closeStmt(preparedStatement);
                return;
            }
            Object var23_19 = null;
        }
        catch (Throwable throwable) {
            Object var23_21 = null;
            JDBCPersistManager.closeStmt(preparedStatement);
            preparedStatement = null;
            throw throwable;
        }
        JDBCPersistManager.closeStmt(preparedStatement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deleteOldChunksDataRow(String string, long l, int n, int n2, int n3) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("**deleteOldChunksDataRow** id=" + l + ", collid=" + n + ", beg=" + n2 + ", end=" + n3);
        }
        this.createTable();
        PreparedStatement preparedStatement = null;
        String string2 = null;
        try {
            try {
                string2 = this.sqlDeleteOldChunksDataRow(string, l, n, n2, n3);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("   stmt: " + string2);
                }
                preparedStatement = this.getConnection().prepareStatement(string2);
                this.bindDeleteOldChunksDataRow(preparedStatement, l, n, n2, n3);
                preparedStatement.execute();
                this.commitIfNeeded();
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**deleteOldChunksDataRow** error, sqlStmt=" + string2);
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28032", new Object[]{string, new Integer(n), new Long(l)}, sQLException);
                Object var11_9 = null;
                JDBCPersistManager.closeStmt(preparedStatement);
                return;
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            JDBCPersistManager.closeStmt(preparedStatement);
            preparedStatement = null;
            throw throwable;
        }
        JDBCPersistManager.closeStmt(preparedStatement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void update(long l, long l2, int n, PCollKeyInfo[] pCollKeyInfoArray, byte[] byArray) {
        PreparedStatement preparedStatement;
        block21: {
            block20: {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**update** id=" + l + ", parid=" + l2 + ", collid=" + n + ", keyArr.len=" + (pCollKeyInfoArray == null ? -1 : pCollKeyInfoArray.length) + ", cont.len=" + byArray.length);
                }
                int n2 = pCollKeyInfoArray == null ? 0 : pCollKeyInfoArray.length;
                byte[] byArray2 = null;
                preparedStatement = null;
                String string = null;
                this.createTable();
                try {
                    try {
                        if (n2 > 0) {
                            this.createKeyInfoTable();
                            byArray2 = this.serializeKeyArr(pCollKeyInfoArray);
                        }
                        FlatTwoByteArrs flatTwoByteArrs = new FlatTwoByteArrs(byArray2, byArray);
                        int n3 = byArray2 != null ? byArray2.length : 0;
                        int n4 = flatTwoByteArrs.length();
                        int n5 = 0;
                        int n6 = 0;
                        int n7 = 0;
                        int n8 = this.contentChunkLength();
                        int n9 = this.getContentLenDataRow(this.mTableName, l, n, true);
                        int n10 = (n9 + (n8 - 1)) / n8;
                        int n11 = (n4 + (n8 - 1)) / n8;
                        byte[] byArray3 = null;
                        if (n10 > n11) {
                            this.deleteOldChunksDataRow(this.mTableName, l, n, n11 + 1, n10);
                        } else if (n10 != 0 && n10 < n11) {
                            this.delete(l, n);
                            this.insert(l, l2, n, pCollKeyInfoArray, byArray);
                            Object var26_21 = null;
                            break block20;
                        }
                        string = this.sqlUpdateDataRow(this.mTableName, l, l2, n);
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("   stmt: " + string);
                        }
                        preparedStatement = this.getConnection().prepareStatement(string);
                        while (true) {
                            int n12;
                            if (n5 >= n4) {
                                string = null;
                                this.updateKeyInfo(l, n, pCollKeyInfoArray);
                                this.commitIfNeeded();
                                break block21;
                            }
                            if (n4 <= n8) {
                                byArray3 = byArray;
                                n12 = n4;
                            } else if (byArray.length == 0 && n4 < n8) {
                                byArray3 = byArray2;
                                n12 = n4;
                            } else {
                                n12 = n4 - n5 < n8 ? n4 - n5 : n8;
                                if (byArray3 == null || byArray3.length != n12) {
                                    byArray3 = new byte[n12];
                                }
                                n7 = flatTwoByteArrs.copyInto(n5, byArray3, 0, n12);
                            }
                            this.bindUpdateDataRow(preparedStatement, l, l2, n, n3, byArray.length, n6, byArray3, n7);
                            preparedStatement.execute();
                            this.commitIfNeeded();
                            n5 += n12;
                            ++n6;
                        }
                    }
                    catch (Exception exception) {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**update** error, sqlStmt=" + string);
                            Diagnostic.printStackTrace(exception);
                        }
                        if (exception instanceof SQLException) {
                            Class clazz = class$oracle$jbo$CSMessageBundle;
                            if (clazz == null) {
                                clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                            }
                            PCollException.throwException(clazz, "28031", new Object[]{this.mTableName, new Integer(n), new Long(l)}, exception);
                        }
                        Object var26_23 = null;
                        JDBCPersistManager.closeStmt(preparedStatement);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var26_24 = null;
                    JDBCPersistManager.closeStmt(preparedStatement);
                    preparedStatement = null;
                    throw throwable;
                }
            }
            JDBCPersistManager.closeStmt(preparedStatement);
            return;
        }
        Object var26_22 = null;
        JDBCPersistManager.closeStmt(preparedStatement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void changeParent(long l, long l2, int n) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("**changeParent** id=" + l + ", parid=" + l2 + ", collid=" + n);
        }
        this.createTable();
        PreparedStatement preparedStatement = null;
        String string = null;
        try {
            try {
                string = this.sqlChangeParentDataRow(this.mTableName, l, l2, n);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("   stmt: " + string);
                }
                preparedStatement = this.getConnection().prepareStatement(string);
                this.bindChangeParentDataRow(preparedStatement, l, l2, n);
                preparedStatement.execute();
                this.commitIfNeeded();
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**changeParent** error, sqlStmt=" + string);
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28031", new Object[]{this.mTableName, new Integer(n), new Long(l)}, sQLException);
                Object var10_7 = null;
                JDBCPersistManager.closeStmt(preparedStatement);
                return;
            }
            Object var10_6 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            JDBCPersistManager.closeStmt(preparedStatement);
            preparedStatement = null;
            throw throwable;
        }
        JDBCPersistManager.closeStmt(preparedStatement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void delete(long l, int n) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("**delete** id=" + l);
        }
        this.createTable();
        PreparedStatement preparedStatement = null;
        String string = null;
        try {
            try {
                string = this.sqlDeleteDataRow(this.mTableName, l, n);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("   stmt: " + string);
                }
                preparedStatement = this.getConnection().prepareStatement(string);
                this.bindDeleteDataRow(preparedStatement, l, n);
                preparedStatement.execute();
                string = null;
                this.updateKeyInfo(l, n, null);
                this.commitIfNeeded();
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**delete** error, sqlStmt=" + string);
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28032", new Object[]{this.mTableName, new Integer(n), new Long(l)}, sQLException);
                Object var8_6 = null;
                JDBCPersistManager.closeStmt(preparedStatement);
                return;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            JDBCPersistManager.closeStmt(preparedStatement);
            preparedStatement = null;
            throw throwable;
        }
        JDBCPersistManager.closeStmt(preparedStatement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void deleteAll(int n) {
        if (!this.mTableCreated && !this.mPersistent) {
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("**deleteAll** collid=" + n);
        }
        this.createTable();
        PreparedStatement preparedStatement = null;
        String string = null;
        try {
            try {
                string = this.sqlDeleteAllDataRows(this.mTableName, n);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("   stmt: " + string);
                }
                preparedStatement = this.getConnection().prepareStatement(string);
                this.bindDeleteAllDataRows(preparedStatement, n);
                preparedStatement.execute();
                string = null;
                this.updateKeyInfo(0L, n, null);
                this.commitIfNeeded();
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**deleteAll** error, sqlStmt=" + string);
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28038", new Object[]{this.mTableName, new Integer(n)}, sQLException);
                Object var6_5 = null;
                JDBCPersistManager.closeStmt(preparedStatement);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            JDBCPersistManager.closeStmt(preparedStatement);
            preparedStatement = null;
            throw throwable;
        }
        JDBCPersistManager.closeStmt(preparedStatement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getContentLenDataRow(String string, long l, int n, boolean bl) {
        int n2;
        String string2;
        block10: {
            if (!this.mTableCreated && !this.mPersistent) {
                return 0;
            }
            if (Diagnostic.isOn()) {
                Diagnostic.print("**getContentLenDataRow** id=" + l + ", collid=" + n);
            }
            this.createTable();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            string2 = null;
            n2 = 0;
            int[] nArray = new int[2];
            try {
                block9: {
                    try {
                        string2 = this.sqlRetrieveDataRow(this.mTableName, l, n, true, false);
                        preparedStatement = this.getConnection().prepareStatement(string2);
                        this.bindRetrieveDataRow(preparedStatement, l, n, true);
                        resultSet = preparedStatement.executeQuery();
                        if (!resultSet.next()) break block9;
                        this.getContentDataRow(resultSet, null, null, nArray, true);
                        n2 = nArray[1];
                        if (!bl) break block9;
                        n2 += nArray[0];
                    }
                    catch (SQLException sQLException) {
                        Class clazz;
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**getContentLenDataRow** error, sqlStmt=" + string2);
                            Diagnostic.printStackTrace(sQLException);
                        }
                        if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        PCollException.throwException(clazz, "28033", new Object[]{this.mTableName, new Integer(n), new Long(l)}, sQLException);
                        Object var13_11 = null;
                        JDBCPersistManager.closeResultSet(resultSet);
                        resultSet = null;
                        JDBCPersistManager.closeStmt(preparedStatement);
                        preparedStatement = null;
                        break block10;
                    }
                }
                Object var13_10 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                JDBCPersistManager.closeResultSet(resultSet);
                resultSet = null;
                JDBCPersistManager.closeStmt(preparedStatement);
                preparedStatement = null;
                throw throwable;
            }
            JDBCPersistManager.closeResultSet(resultSet);
            resultSet = null;
            JDBCPersistManager.closeStmt(preparedStatement);
            preparedStatement = null;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println(", ret=" + n2);
            Diagnostic.println("   stmt: " + string2);
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object[] retrieve(long l, int n, boolean bl, long[] lArray) {
        String string;
        Object object;
        PCollKeyInfo[] pCollKeyInfoArray;
        block26: {
            ObjectInputStream objectInputStream;
            ByteArrayInputStream byteArrayInputStream;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block25: {
                Object[] objectArray;
                block24: {
                    if (!this.mTableCreated && !this.mPersistent) {
                        return null;
                    }
                    if (Diagnostic.isOn()) {
                        Diagnostic.print("**retrieve** id=" + l + ", collid=" + n);
                    }
                    this.createTable();
                    preparedStatement = null;
                    resultSet = null;
                    pCollKeyInfoArray = null;
                    byteArrayInputStream = null;
                    objectInputStream = null;
                    object = null;
                    string = null;
                    int n2 = 0;
                    int[] nArray = new int[2];
                    int n3 = 0;
                    int n4 = 0;
                    byte[] byArray = null;
                    try {
                        try {
                            string = this.sqlRetrieveDataRow(this.mTableName, l, n, false, bl);
                            preparedStatement = this.getConnection().prepareStatement(string);
                            this.bindRetrieveDataRow(preparedStatement, l, n, false);
                            resultSet = preparedStatement.executeQuery();
                            do {
                                if (resultSet.next()) {
                                    byte[] byArray2 = this.getContentDataRow(resultSet, null, lArray, nArray, false);
                                    if (n4 == 0) {
                                        n2 = nArray[0] + nArray[1];
                                    }
                                    if (n2 <= byArray2.length) {
                                        byArray = byArray2;
                                    } else {
                                        if (byArray == null) {
                                            byArray = new byte[n2];
                                        }
                                        System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
                                    }
                                    n3 += byArray2.length;
                                } else {
                                    Class clazz;
                                    if (n4 == 0) {
                                        objectArray = null;
                                        Object var22_19 = null;
                                        break block24;
                                    }
                                    if (Diagnostic.isOn()) {
                                        Diagnostic.println("**retrieve** error, sqlStmt=" + string);
                                        Diagnostic.println("Expecting more rows, but exhausted result set");
                                    }
                                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                                        clazz = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                                    }
                                    PCollException.throwException(clazz, "28033", new Object[]{this.mTableName, new Integer(n), new Long(l)}, null);
                                }
                                ++n4;
                            } while (n3 < n2);
                            if (byArray == null) break block25;
                            if (nArray[0] != 0) {
                                byteArrayInputStream = new ByteArrayInputStream(byArray, 0, nArray[0]);
                                objectInputStream = new ObjectInputStream(byteArrayInputStream);
                                pCollKeyInfoArray = this.deserializeKeyArr(objectInputStream);
                            }
                            if (!bl) {
                                object = new ByteArrayInputStream(byArray, nArray[0], nArray[1]);
                            }
                            break block25;
                        }
                        catch (Exception exception) {
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("**retrieve** error, sqlStmt=" + string);
                                Diagnostic.printStackTrace(exception);
                            }
                            if (exception instanceof SQLException) {
                                Class clazz = class$oracle$jbo$CSMessageBundle;
                                if (clazz == null) {
                                    clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                                }
                                PCollException.throwException(clazz, "28033", new Object[]{this.mTableName, new Integer(n), new Long(l)}, exception);
                            }
                            Object var22_21 = null;
                            PCollNode.closeInputStream(objectInputStream);
                            objectInputStream = null;
                            PCollNode.closeInputStream(byteArrayInputStream);
                            byteArrayInputStream = null;
                            JDBCPersistManager.closeResultSet(resultSet);
                            resultSet = null;
                            JDBCPersistManager.closeStmt(preparedStatement);
                            preparedStatement = null;
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var22_22 = null;
                        PCollNode.closeInputStream(objectInputStream);
                        objectInputStream = null;
                        PCollNode.closeInputStream(byteArrayInputStream);
                        byteArrayInputStream = null;
                        JDBCPersistManager.closeResultSet(resultSet);
                        resultSet = null;
                        JDBCPersistManager.closeStmt(preparedStatement);
                        preparedStatement = null;
                        throw throwable;
                    }
                }
                PCollNode.closeInputStream(objectInputStream);
                objectInputStream = null;
                PCollNode.closeInputStream(byteArrayInputStream);
                byteArrayInputStream = null;
                JDBCPersistManager.closeResultSet(resultSet);
                resultSet = null;
                JDBCPersistManager.closeStmt(preparedStatement);
                return objectArray;
            }
            Object var22_20 = null;
            PCollNode.closeInputStream(objectInputStream);
            objectInputStream = null;
            PCollNode.closeInputStream(byteArrayInputStream);
            byteArrayInputStream = null;
            JDBCPersistManager.closeResultSet(resultSet);
            resultSet = null;
            JDBCPersistManager.closeStmt(preparedStatement);
            preparedStatement = null;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.print(", parid=" + lArray[0]);
            if (object == null) {
                Diagnostic.println(", null");
            } else {
                Diagnostic.println(", ret=" + object.getClass().getName());
            }
            Diagnostic.println("   stmt: " + string);
        }
        return new Object[]{pCollKeyInfoArray, object};
    }

    /*
     * Loose catch block
     */
    public synchronized long[] retrieveIdsWithKey(int n, Object object, int n2) {
        long[] lArray;
        block28: {
            Object var31_27;
            if (!(this.mTableCreated && this.mKeyInfoTableCreated || this.mPersistent)) {
                return new long[0];
            }
            int n3 = object.hashCode();
            if (Diagnostic.isOn()) {
                Diagnostic.println("**retrieveIdsWithKey** keyId=" + n + ", keyval.hash=" + n3 + ", collid=" + n2);
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            PCollKeyInfo[] pCollKeyInfoArray = null;
            ByteArrayInputStream byteArrayInputStream = null;
            ObjectInputStream objectInputStream = null;
            lArray = null;
            String string = null;
            int n4 = 0;
            long[] lArray2 = new long[1];
            long[] lArray3 = new long[1];
            int[] nArray = new int[2];
            int n5 = 0;
            int n6 = 0;
            byte[] byArray = null;
            boolean bl = false;
            boolean bl2 = true;
            try {
                string = this.sqlRetrieveIdsWithKey(this.mTableName, this.mKeyInfoTableName, n, object, n2);
                preparedStatement = this.getConnection().prepareStatement(string);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("   stmt: " + string);
                }
                ArrayList arrayList = new ArrayList();
                long l = 0L;
                this.bindRetrieveIdsWithKey(preparedStatement, n, object, n3, n2);
                resultSet = preparedStatement.executeQuery();
                while (true) {
                    int n7;
                    byte[] byArray2 = null;
                    if (resultSet.next()) {
                        byArray2 = this.getContentDataRow(resultSet, lArray2, lArray3, nArray, false);
                    } else {
                        bl = true;
                    }
                    if (bl || bl2) {
                        if (!bl && l == lArray2[0]) {
                            Diagnostic.ASSERT(false, "Found extra data row for id=" + l + ", contentIdx=" + n6 + ", keyLen=" + nArray[0]);
                        }
                        bl2 = false;
                        if (byArray != null && byArray.length > 0) {
                            PCollNode.closeInputStream(objectInputStream);
                            objectInputStream = null;
                            PCollNode.closeInputStream(byteArrayInputStream);
                            byteArrayInputStream = null;
                            byteArrayInputStream = new ByteArrayInputStream(byArray, 0, nArray[0]);
                            objectInputStream = new ObjectInputStream(byteArrayInputStream);
                            pCollKeyInfoArray = this.deserializeKeyArr(objectInputStream);
                            if (pCollKeyInfoArray != null) {
                                int n8 = 0;
                                while (n8 < pCollKeyInfoArray.length) {
                                    if (n == pCollKeyInfoArray[n8].mKeyId && object.equals(pCollKeyInfoArray[n8].mKey)) {
                                        arrayList.add((Object)new Long(l));
                                        break;
                                    }
                                    ++n8;
                                }
                            }
                        }
                        if (bl) break;
                        l = lArray2[0];
                        n4 = nArray[0];
                        n5 = 0;
                        n6 = 0;
                    }
                    int n9 = n7 = n4 - n5 < byArray2.length ? n4 - n5 : byArray2.length;
                    if (n4 <= byArray2.length) {
                        byArray = byArray2;
                    } else {
                        if (byArray == null) {
                            byArray = new byte[n4];
                        }
                        System.arraycopy(byArray2, 0, byArray, n5, n7);
                    }
                    if ((n5 += n7) >= n4) {
                        bl2 = true;
                    }
                    ++n6;
                }
                lArray = new long[arrayList.size()];
                int n10 = 0;
                while (n10 < lArray.length) {
                    lArray[n10] = (Long)arrayList.get(n10);
                    ++n10;
                }
                var31_27 = null;
            }
            catch (Throwable throwable) {
                Object var31_28 = null;
                PCollNode.closeInputStream(objectInputStream);
                objectInputStream = null;
                PCollNode.closeInputStream(byteArrayInputStream);
                byteArrayInputStream = null;
                JDBCPersistManager.closeResultSet(resultSet);
                resultSet = null;
                JDBCPersistManager.closeStmt(preparedStatement);
                preparedStatement = null;
                throw throwable;
            }
            PCollNode.closeInputStream(objectInputStream);
            objectInputStream = null;
            PCollNode.closeInputStream(byteArrayInputStream);
            byteArrayInputStream = null;
            JDBCPersistManager.closeResultSet(resultSet);
            resultSet = null;
            JDBCPersistManager.closeStmt(preparedStatement);
            preparedStatement = null;
            {
                break block28;
                catch (Exception exception) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("**retrieve** error, sqlStmt=" + string);
                        Diagnostic.printStackTrace(exception);
                    }
                    if (exception instanceof SQLException) {
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = JDBCPersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        PCollException.throwException(clazz, "28040", new Object[]{this.mTableName, new Integer(n), new Integer(n3)}, null);
                    }
                    var31_27 = null;
                    PCollNode.closeInputStream(objectInputStream);
                    objectInputStream = null;
                    PCollNode.closeInputStream(byteArrayInputStream);
                    byteArrayInputStream = null;
                    JDBCPersistManager.closeResultSet(resultSet);
                    resultSet = null;
                    JDBCPersistManager.closeStmt(preparedStatement);
                    preparedStatement = null;
                }
            }
        }
        if (lArray == null) {
            lArray = new long[]{};
        }
        if (Diagnostic.isOn()) {
            Diagnostic.print("   ret=");
            int n11 = 0;
            while (n11 < lArray.length) {
                Diagnostic.print("[" + n11 + "]" + lArray[n11]);
                if (n11 + 1 < lArray.length) {
                    Diagnostic.print(",");
                }
                ++n11;
            }
            Diagnostic.println("");
        }
        return lArray;
    }

    public void notifyPCollEvent(int n, Object object, Object object2) {
        if (PCollection.mEventTrace) {
            PCollection.printPCollEvent(n, object, object2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class FlatTwoByteArrs {
        byte[] mArr1;
        int mLen1;
        byte[] mArr2;
        int mLen2;

        FlatTwoByteArrs(byte[] byArray, byte[] byArray2) {
            this.mArr1 = byArray;
            this.mArr2 = byArray2;
            this.mLen1 = this.mArr1 == null ? 0 : this.mArr1.length;
            this.mLen2 = this.mArr2 == null ? 0 : this.mArr2.length;
        }

        int length() {
            return this.mLen1 + this.mLen2;
        }

        int copyInto(int n, byte[] byArray, int n2, int n3) {
            int n4;
            if (n + n3 <= this.mLen1) {
                System.arraycopy(this.mArr1, n, byArray, n2, n3);
                n4 = 1;
            } else if (n >= this.mLen1) {
                System.arraycopy(this.mArr2, n - this.mLen1, byArray, n2, n3);
                n4 = 3;
            } else {
                int n5 = this.mLen1 - n;
                System.arraycopy(this.mArr1, n, byArray, n2, n5);
                System.arraycopy(this.mArr2, 0, byArray, n2 + n5, n3 - n5);
                n4 = 2;
            }
            return n4;
        }
    }
}

