/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.mom;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import oracle.adf.share.ADFContext;
import oracle.jbo.InvalidDefNameException;
import oracle.jbo.InvalidOperException;
import oracle.jbo.JboException;
import oracle.jbo.NoDefException;
import oracle.jbo.NoXMLFileException;
import oracle.jbo.PersistenceException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.EventGroup;
import oracle.jbo.common.InstrumentedEvent;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.MOMProperties;
import oracle.jbo.common.MetaObjectBase;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.WeakKeyHashtable;
import oracle.jbo.mom.ContainerDefImpl;
import oracle.jbo.mom.DefinitionContext;
import oracle.jbo.mom.DefinitionContextAgeable;
import oracle.jbo.mom.DefinitionContextStandard;
import oracle.jbo.mom.DefinitionMgrListener;
import oracle.jbo.mom.DefinitionObject;
import oracle.jbo.mom.DefinitionObjectInfo;
import oracle.jbo.mom.LongRunningStatementMonitor;
import oracle.jbo.mom.MOMParser;
import oracle.jbo.mom.MOMParserMDS;
import oracle.jbo.mom.MOMParserNonMDS;
import oracle.jbo.mom.xml.DTDVersion;
import oracle.jbo.mom.xml.DefDocument;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.mom.xml.DefXMLParser;
import oracle.jbo.mom.xml.XMLContext;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLParseException;

public abstract class DefinitionManager
implements MetaObjectBase {
    private WeakKeyHashtable mContextMap;
    protected boolean mLazyLoading;
    private int mLazyLoadingProp;
    protected Context mContext;
    protected boolean mSubstituteStat;
    private boolean mUseGlobalSubstitution;
    private DTD mJboDTD;
    private DefXMLParser xmlDoc;
    protected boolean mbValidateName;
    private boolean m323Compatible;
    private boolean m903Compatible;
    private ContainerDefImpl mProject;
    private DefinitionMgrListener mListener;
    private int mUsesMDS;
    private String mMOMCacheScope;
    private static /* synthetic */ Class class$java$util$Hashtable;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mContextMap = new WeakKeyHashtable();
        this.mLazyLoading = true;
        this.mLazyLoadingProp = -1;
        this.mContext = null;
        this.mSubstituteStat = false;
        this.mUseGlobalSubstitution = false;
        this.mJboDTD = null;
        this.xmlDoc = null;
        this.mbValidateName = true;
        this.m323Compatible = false;
        this.m903Compatible = false;
        this.mProject = null;
        this.mListener = null;
        this.mUsesMDS = -1;
        this.mMOMCacheScope = null;
    }

    protected DefinitionManager() {
        block2: {
            this.$init$();
            try {
                this.mJboDTD = DefXMLParser.getJboDTD(DTDVersion.getLatestDTDFullName(this));
                this.xmlDoc = new DefXMLParser(this);
            }
            catch (XMLParseException xMLParseException) {
                if (!Diagnostic.isOn()) break block2;
                Diagnostic.println(xMLParseException.toString());
            }
        }
    }

    protected void initListener() {
        String string = PropertyMetadata.ENV_DEF_MGR_LISTENER.getProperty();
        if (string != null) {
            Class clazz = JBOClass.findCustomClass(string, null);
            this.mListener = (DefinitionMgrListener)JBOClass.newInstance(clazz);
        }
    }

    protected void initManager() {
        String string = PropertyMetadata.ENV_USE_GLOBAL_SUB_MAP.getProperty();
        if (string != null && string.equals(Boolean.TRUE.toString())) {
            this.mUseGlobalSubstitution = true;
        }
        this.initListener();
        this.reportVMProperties();
        this.initCompatibilityFlags();
        this.initJNDIContext();
        this.mProject = this.loadProjectDefinition();
        this.mLazyLoading = this.mProject != null ? this.mProject.isLazyLoading() : this.getLazyLoadProp();
        this.initSubExtendsPropForProject();
    }

    protected void setNameCheck(boolean bl) {
        this.mbValidateName = bl;
    }

    public DefXMLParser getJboXMLDoc() {
        return this.xmlDoc;
    }

    public DTD getJboDTD() {
        return this.mJboDTD;
    }

    public void setContextImpl(Context context) {
        if (context instanceof XMLContext) {
            this.mContext = context;
            Diagnostic.println(" New JNDI Context set for BC4J Framework");
        } else {
            Diagnostic.println(new StringBuffer(" Error:  Expecting XMLContext.  Got ").append(context.getClass().getName()));
        }
    }

    public boolean isLazyLoadingMode() {
        return this.mLazyLoading;
    }

    protected void setLazyLoadingMode(boolean bl) {
        this.mLazyLoading = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContainerDefImpl findContainer(String string) {
        if (this.mbValidateName && !JboNameUtil.isFullNameValid(string)) {
            throw new InvalidDefNameException(151, string);
        }
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(true);
        Object object = definitionContext.getCacheLock();
        synchronized (object) {
            Object object2 = definitionContext.findDefObj(string);
            if (object2 == null) {
                object2 = this.loadLazyDefinitionObject(string, null, false, true);
            }
            if (object2 instanceof ContainerDefImpl) {
                ContainerDefImpl containerDefImpl = (ContainerDefImpl)object2;
                return containerDefImpl;
            }
        }
        return null;
    }

    public Object findDefinitionObject(String string, int n, Class clazz, boolean bl) {
        return this.findDefinitionObject(string, n, clazz, bl, true);
    }

    public Object findDefinitionObject(String string, int n, Class clazz, boolean bl, boolean bl2) {
        return this.findDefinitionObject(string, n, clazz, bl, true, false);
    }

    public Object findDefinitionObjectDontCheckName(String string, int n, Class clazz, boolean bl) {
        return this.findDefinitionObject(string, n, clazz, bl, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findDefinitionObject(String string, int n, Class clazz, boolean bl, boolean bl2, boolean bl3) {
        if (!bl3 && this.mbValidateName && !JboNameUtil.isFullNameValid(string)) {
            throw new InvalidDefNameException(n, string);
        }
        try {
            DefinitionContext definitionContext = this.getCurrentDefinitionContext(true);
            Object object = null;
            Object object2 = definitionContext.getCacheLock();
            synchronized (object2) {
                if (bl) {
                    string = this.findSubstituteName(string);
                }
                object = definitionContext.findDefObj(string);
                if (bl2 && object == null) {
                    object = this.loadLazyDefinitionObject(string, null, true, bl);
                }
            }
            if (clazz.isInstance(object)) {
                Object object3 = object;
                return object3;
            }
        }
        catch (NoXMLFileException noXMLFileException) {
            // empty catch block
        }
        throw new NoDefException(n, string);
    }

    protected String findSubstituteName(String string) {
        try {
            DefinitionContext definitionContext = this.getCurrentDefinitionContext(true);
            HashMap hashMap = new HashMap(10);
            while (true) {
                String string2 = null;
                if (this.mUseGlobalSubstitution) {
                    NamingEnumeration<Binding> namingEnumeration = this.mContext.listBindings(string);
                    if (namingEnumeration.hasMoreElements()) {
                        Binding binding = (Binding)namingEnumeration.nextElement();
                        string2 = (String)binding.getObject();
                    }
                } else {
                    string2 = definitionContext.findSubstitution(string);
                }
                if (string2 != null) {
                    string = string2;
                    if (hashMap.get((Object)string) != null) {
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = DefinitionManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        throw new InvalidOperException(clazz, "26036", new Object[]{string});
                    }
                    hashMap.put((Object)string, (Object)string);
                    continue;
                }
                break;
            }
        }
        catch (NamingException namingException) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("Error trying to find substitute name for " + string);
                Diagnostic.printStackTrace(namingException);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DefinitionManager.class$("oracle.jbo.CSMessageBundle");
            }
            JboException jboException = new JboException(clazz, "26049", new Object[]{string});
            jboException.addToDetails(namingException);
            throw jboException;
        }
        return string;
    }

    protected abstract Object loadSpecialObjects(DefElement var1, String var2, String var3);

    protected abstract Object loadLazyFromSharedObject(String var1, ContainerDefImpl var2, boolean var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object loadLazyDefinitionObject(String string, ContainerDefImpl containerDefImpl, boolean bl, boolean bl2) {
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(true);
        Object object = definitionContext.getCacheLock();
        synchronized (object) {
            int n = 0;
            if (InstrumentedEvent.isActive) {
                n = InstrumentedEvent.startEvent(EventGroup.METAOBJECT_LOAD, "Loading meta-object: " + string);
            }
            if (containerDefImpl == null && bl) {
                containerDefImpl = this.loadParent(string);
            }
            try {
                try {
                    String string2;
                    DefinitionObject definitionObject = null;
                    definitionObject = (DefinitionObject)definitionContext.findDefObj(string);
                    if (definitionObject != null) {
                        DefinitionObject definitionObject2 = definitionObject;
                        Object var21_10 = null;
                        if (InstrumentedEvent.isActive) {
                            InstrumentedEvent.endEvent(n);
                        }
                        return definitionObject2;
                    }
                    DefElement defElement = this.loadDefElement(string);
                    Object object2 = this.loadSpecialObjects(defElement, string, string2 = defElement.getNodeName());
                    if (object2 != null) {
                        Object object3 = object2;
                        Object var21_11 = null;
                        if (InstrumentedEvent.isActive) {
                            InstrumentedEvent.endEvent(n);
                        }
                        return object3;
                    }
                    definitionObject = this.loadFromXML(string, defElement, string2);
                    if (definitionObject != null) {
                        String string3 = null;
                        string3 = containerDefImpl != null ? (containerDefImpl != this.getDynamicObjectsContainer() ? JboNameUtil.getContainerPartOfName(containerDefImpl.getFullName()) + "." + definitionObject.getName() : string) : definitionObject.getName();
                        if (!this.mSubstituteStat && !string3.equals(string)) {
                            if (Diagnostic.isOn()) {
                                Diagnostic.println(" Object name in xml file " + string3 + " does not match metaobj name " + string);
                            }
                            throw new NoXMLFileException(string);
                        }
                        definitionObject.setFullName(string);
                        if (containerDefImpl != null) {
                            containerDefImpl.addChild(definitionObject);
                        } else {
                            definitionContext.insertDefObj(string, definitionObject, true);
                        }
                        if (!this.mLazyLoading) {
                            definitionObject.resolveReferences();
                        }
                        definitionObject.finishedLoading();
                    }
                    DefinitionObject definitionObject3 = definitionObject;
                    Object var21_12 = null;
                    if (InstrumentedEvent.isActive) {
                        InstrumentedEvent.endEvent(n);
                    }
                    return definitionObject3;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    Class clazz;
                    if (Diagnostic.isOn()) {
                        String string4 = JboNameUtil.getDocumentName(string);
                        Diagnostic.println("Generic exception trying to load XML File " + string4);
                        Diagnostic.printStackTrace(exception);
                    }
                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = DefinitionManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    JboException jboException = new JboException(clazz, "26049", new Object[]{string});
                    jboException.addToDetails(exception);
                    throw jboException;
                }
            }
            catch (Throwable throwable) {
                Object var21_13 = null;
                if (InstrumentedEvent.isActive) {
                    InstrumentedEvent.endEvent(n);
                }
                throw throwable;
            }
        }
    }

    public DefElement loadDefElement(String string) {
        return this.getCurrentDefinitionContext(true).readAndParse(string).getRootDefElement();
    }

    protected abstract DefinitionObject loadFromXML(String var1, DefElement var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerDefImpl loadParent(String string) {
        String string2 = JboNameUtil.getContainerPartOfName(string);
        if (string2 == null) {
            return this.getDynamicObjectsContainer();
        }
        String string3 = JboNameUtil.getLastPartOfName(string2);
        String string4 = string2 + "." + string3;
        try {
            DefinitionContext definitionContext = this.getCurrentDefinitionContext(true);
            Object object = definitionContext.getCacheLock();
            synchronized (object) {
                Object object2 = definitionContext.findDefObj(string4);
                if (object2 != null && object2 instanceof ContainerDefImpl) {
                    ContainerDefImpl containerDefImpl = (ContainerDefImpl)object2;
                    return containerDefImpl;
                }
                ContainerDefImpl containerDefImpl = (ContainerDefImpl)this.loadLazyDefinitionObject(string4, null, false, true);
                return containerDefImpl;
            }
        }
        catch (NoXMLFileException noXMLFileException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Cannot Load parent Package : " + string4);
                Diagnostic.println("Business Object Browsing may be unavailable");
            }
            ContainerDefImpl containerDefImpl = this.getDynamicObjectsContainer();
            return containerDefImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContainerDefImpl getDynamicObjectsContainer() {
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(true);
        Object object = definitionContext.getCacheLock();
        synchronized (object) {
            String string = this.getDynamicPackageName();
            ContainerDefImpl containerDefImpl = (ContainerDefImpl)definitionContext.findDefObj(string);
            if (containerDefImpl == null) {
                containerDefImpl = this.createContainerDefObject(false);
                definitionContext.insertDefObj(string, containerDefImpl, false);
                containerDefImpl.setName(string);
                containerDefImpl.setFullName(string);
                containerDefImpl.setSynchronized();
            }
            ContainerDefImpl containerDefImpl2 = containerDefImpl;
            return containerDefImpl2;
        }
    }

    protected abstract String getDynamicPackageName();

    protected abstract String getProjectFileExtension();

    protected abstract ContainerDefImpl createContainerDefObject(boolean var1);

    private ContainerDefImpl loadProjectDefinition(DefinitionContext definitionContext, DefDocument defDocument, String string) {
        try {
            DefElement defElement = defDocument.getRootDefElement();
            String string2 = defElement.getNodeName();
            ContainerDefImpl containerDefImpl = this.createContainerDefObject(true);
            definitionContext.insertDefObj(string, containerDefImpl, true);
            containerDefImpl.loadFromXMLFile(defElement);
            if (this.loadSubstitutes(definitionContext, defElement)) {
                containerDefImpl.setHasSubstitutes(true);
            }
            containerDefImpl.setIsProject(true);
            ContainerDefImpl containerDefImpl2 = containerDefImpl;
            return containerDefImpl2;
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            Class clazz;
            if (Diagnostic.isOn()) {
                String string3 = JboNameUtil.getDocumentName(string);
                Diagnostic.println("Unexpected exception loading XML file " + string3);
                Diagnostic.printStackTrace(exception);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DefinitionManager.class$("oracle.jbo.CSMessageBundle");
            }
            JboException jboException = new JboException(clazz, "26049", new Object[]{string});
            jboException.addToDetails(exception);
            throw jboException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContainerDefImpl loadProjectDefinition(InputStream inputStream, String string) {
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(true);
        Object object = definitionContext.getCacheLock();
        synchronized (object) {
            DefDocument defDocument = definitionContext.parse(inputStream, string);
            ContainerDefImpl containerDefImpl = this.loadProjectDefinition(definitionContext, defDocument, string);
            return containerDefImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContainerDefImpl loadProjectDefinition(Reader reader, String string) {
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(true);
        Object object = definitionContext.getCacheLock();
        synchronized (object) {
            DefDocument defDocument = definitionContext.parse(reader, string);
            ContainerDefImpl containerDefImpl = this.loadProjectDefinition(definitionContext, defDocument, string);
            return containerDefImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerDefImpl loadProjectDefinition(String string) {
        if (this.mbValidateName && !JboNameUtil.isFullNameValid(string)) {
            throw new InvalidDefNameException(151, string);
        }
        String string2 = string + this.getProjectFileExtension();
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(true);
        Object object = definitionContext.getCacheLock();
        synchronized (object) {
            Object object2 = definitionContext.findDefObj(string2);
            if (object2 == null) {
                DefDocument defDocument = definitionContext.readAndParse(string2);
                object2 = this.loadProjectDefinition(definitionContext, defDocument, string2);
            }
            if (object2 instanceof ContainerDefImpl) {
                ContainerDefImpl containerDefImpl = (ContainerDefImpl)object2;
                return containerDefImpl;
            }
            ContainerDefImpl containerDefImpl = null;
            return containerDefImpl;
        }
    }

    public ContainerDefImpl loadProjectDefinition() {
        String string = PropertyMetadata.JBO_PROJECT.getProperty();
        if (!JboEnvUtil.isEmptyString(string)) {
            return this.loadProjectDefinition(string);
        }
        return null;
    }

    protected void initSubExtendsPropForProject() {
        ContainerDefImpl containerDefImpl = null;
        if (this.mProject != null) {
            containerDefImpl = this.mProject;
        } else {
            String string = PropertyMetadata.GLOBAL_SUBSTITUTION.getProperty();
            if (!JboEnvUtil.isEmptyString(string)) {
                string = string.trim();
                containerDefImpl = this.loadProjectDefinition(string);
            }
        }
        if (containerDefImpl != null) {
            this.mSubstituteStat = containerDefImpl.hasSubstitutes();
        }
    }

    public boolean is323Compatible() {
        return this.m323Compatible;
    }

    public boolean is903Compatible() {
        return this.m903Compatible;
    }

    private void initCompatibilityFlags() {
        this.m323Compatible = this.getBooleanFlag(PropertyMetadata.JBO_323_COMPATIBLE, false);
        this.m903Compatible = this.getBooleanFlag(PropertyMetadata.JBO_903_COMPATIBLE, false);
    }

    protected boolean getBooleanFlag(PropertyMetadata propertyMetadata, boolean bl) {
        String string = propertyMetadata.getProperty();
        boolean bl2 = bl;
        if (string != null) {
            bl2 = "true".equals(string);
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println(propertyMetadata + " Flag: " + bl2 + ", str: " + string);
        }
        return bl2;
    }

    private void initJNDIContext() {
        try {
            String string = PropertyMetadata.MOM_CONTEXT_FACTORY.getProperty();
            String string2 = null;
            string2 = string != null ? string.trim() : PropertyMetadata.MOM_CONTEXT_FACTORY.pDefault;
            String string3 = PropertyMetadata.MOM_INITIAL_CONTEXT.getProperty();
            String string4 = null;
            string4 = string3 != null ? string3.trim() : PropertyMetadata.MOM_INITIAL_CONTEXT.pDefault;
            Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
            hashtable.put(PropertyMetadata.INITIAL_CONTEXT_FACTORY.pName, string2);
            hashtable.put(PropertyMetadata.MOM_INITIAL_CONTEXT.pName, string4);
            this.mContext = this.createInitialContext(hashtable);
        }
        catch (Exception exception) {
            PersistenceException persistenceException = new PersistenceException("26024", null);
            persistenceException.addToDetails(exception);
            if (Diagnostic.isOn()) {
                Diagnostic.println("DefinitionManager: Error Creating Initial Context ");
                Diagnostic.println("Exception class is " + persistenceException.getClass().getName());
                Diagnostic.printStackTrace(persistenceException);
            }
            throw persistenceException;
        }
    }

    public boolean getLazyLoadProp() {
        String string;
        if (this.mLazyLoadingProp == -1 && (string = PropertyMetadata.IS_LAZY_LOADING_TRUE.getProperty()) != null) {
            this.mLazyLoadingProp = (string = string.trim()).equals("true") ? 1 : (string.equals("false") ? 0 : -2);
        }
        return this.mLazyLoadingProp != 0;
    }

    public void loadContext(String string, String string2) {
        block6: {
            try {
                if (string == null) {
                    string = PropertyMetadata.MOM_CONTEXT_FACTORY.pDefault;
                }
                if (string2 == null) {
                    string2 = PropertyMetadata.MOM_INITIAL_CONTEXT.pDefault;
                }
                Hashtable<String, String> hashtable = new Hashtable<String, String>(10);
                hashtable.put(PropertyMetadata.INITIAL_CONTEXT_FACTORY.pName, string);
                hashtable.put(PropertyMetadata.MOM_INITIAL_CONTEXT.pName, string2);
                this.mContext = this.createInitialContext(hashtable);
                if (this.mContext != null) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("DefinitionManager: Created Initial Context '" + this.mContext + "'");
                    }
                    return;
                }
            }
            catch (Exception exception) {
                if (!Diagnostic.isOn()) break block6;
                Diagnostic.println("Error Loading Initial Context");
                Diagnostic.printStackTrace(exception);
            }
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public Properties getMOMProperties() {
        return MOMProperties.getProperties();
    }

    private boolean loadSubstitutes(DefinitionContext definitionContext, DefElement defElement) throws Exception {
        boolean bl = false;
        HashMap hashMap = defElement.loadTableMap("Substitutes", "Substitute", "OldName", "NewName");
        if (hashMap != null && hashMap.size() > 0) {
            String string = null;
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                String string2 = (String)hashMap.get((Object)string);
                String string3 = null;
                if (this.mUseGlobalSubstitution) {
                    NamingEnumeration<Binding> namingEnumeration = this.mContext.listBindings(string);
                    if (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
                        Binding binding = (Binding)namingEnumeration.nextElement();
                        string3 = (String)binding.getObject();
                    }
                } else {
                    string3 = definitionContext.findSubstitution(string);
                }
                if (string3 == null) {
                    if (this.mUseGlobalSubstitution) {
                        this.mContext.bind(string, (Object)string2);
                    } else {
                        definitionContext.bindSubstitution(string, string2);
                    }
                    bl = true;
                    continue;
                }
                if (string2.equals(string3) || !Diagnostic.isOn()) continue;
                Diagnostic.println("Skipping substitution for: " + string + "->" + string2);
                Diagnostic.println("  because one already exists.  Old: " + string + "->" + string3);
            }
        }
        return bl;
    }

    public DefElement loadBaseXMLElement(String string) {
        return this.getCurrentDefinitionContext(true).readAndParse(string).getRootDefElement();
    }

    URL createURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = '/' + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("Cannot create url for: " + string);
                System.exit(0);
            }
        }
        return uRL;
    }

    private Context createInitialContext(Hashtable hashtable) throws NamingException {
        if (JboEnvUtil.inJServer()) {
            try {
                Class clazz = JBOClass.forName("oracle.jbo.server.xml.aurora.AuroraJNDIContextHelper");
                Class[] classArray = new Class[1];
                Class clazz2 = class$java$util$Hashtable;
                if (clazz2 == null) {
                    clazz2 = class$java$util$Hashtable = DefinitionManager.class$("java.util.Hashtable");
                }
                classArray[0] = clazz2;
                Method method = clazz.getMethod("createContext", classArray);
                Object[] objectArray = new Object[]{hashtable};
                Context context = (Context)method.invoke(null, objectArray);
                return context;
            }
            catch (InvocationTargetException invocationTargetException) {
                NamingException namingException;
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof NamingException) {
                    namingException = (NamingException)throwable;
                } else {
                    namingException = new NamingException(throwable.getMessage());
                    namingException.setRootCause(throwable);
                }
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException(exception.getMessage());
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        return new InitialContext(hashtable);
    }

    public void reportVMProperties() {
        String string = "unknown";
        String string2 = "unknown";
        String string3 = "unknown";
        String string4 = "unknown";
        String string5 = "unknown";
        String string6 = "unknown";
        try {
            String string7 = System.getProperty("java.version").substring(0, 3);
            if (string7.equals("1.1")) {
                string2 = System.getProperty("java.version");
                string3 = string = System.getProperty("java.vendor");
            } else {
                string2 = System.getProperty("java.vm.version");
                string = System.getProperty("java.vm.vendor");
                string3 = System.getProperty("java.vm.name");
            }
            string4 = System.getProperty("os.name");
            string5 = System.getProperty("os.version");
            string6 = System.getProperty("user.name");
        }
        catch (Exception exception) {
            Diagnostic.println("WARNING: ReportVMproperties had problems accessing SystemProperties");
        }
        Diagnostic.println(new StringBuffer("JavaVMVersion: ").append(string2));
        Diagnostic.println(new StringBuffer("JavaVMVendor: ").append(string));
        Diagnostic.println(new StringBuffer("JavaVMName: ").append(string3));
        Diagnostic.println(new StringBuffer("OperatingSystemName: ").append(string4));
        Diagnostic.println(new StringBuffer("OperatingSystemVersion: ").append(string5));
        Diagnostic.println(new StringBuffer("OperatingSystemUsername: ").append(string6));
    }

    public abstract String[] getXMLVersionArray();

    protected String getLatestDTDVersion() {
        return DTDVersion.getLatestXMLVersion(this);
    }

    public void dumpDefObjInfo(int n, Object object, DefinitionObjectInfo definitionObjectInfo, boolean bl, PrintWriter printWriter) {
        Object object2 = definitionObjectInfo.getDefinitionObject();
        String string = object2 != null ? object2.getClass().getName() : "null";
        printWriter.println((bl ? "  Use " : "  Entry ") + n + ": " + object);
        printWriter.println("     Obj = " + string + ", ageable = " + definitionObjectInfo.isAgeable() + ", retired = " + definitionObjectInfo.isRetired());
    }

    public void dumpMOM(Writer writer, boolean bl) {
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(false);
        if (definitionContext != null) {
            definitionContext.dumpMOM(writer, bl);
        } else {
            PrintWriter printWriter = new PrintWriter(writer, true);
            printWriter.println("-- no DefinitionContext for current thread");
        }
    }

    public void dumpMOM() {
        this.dumpMOM(new PrintWriter(System.out), true);
    }

    protected void insertDefinition(String string, Object object, boolean bl) {
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(true);
        definitionContext.insertDefObj(string, object, bl);
    }

    protected void insertDefinition(String string, Object object) {
        this.insertDefinition(string, object, true);
    }

    protected Object removeDefinition(String string) {
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(false);
        if (definitionContext == null) {
            return null;
        }
        return definitionContext.removeDefObj(string);
    }

    public Object findLoadedObject(String string) {
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(false);
        if (definitionContext == null) {
            return null;
        }
        return definitionContext.findDefObj(string);
    }

    public void removeAllDefinitions() {
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(false);
        if (definitionContext != null) {
            definitionContext.purgeCache();
        }
    }

    public Object getMapLock() {
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(true);
        return definitionContext.getCacheLock();
    }

    protected com.sun.java.util.collections.Map getCurrentApplicationMap(boolean bl) {
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(bl);
        if (definitionContext == null) {
            return null;
        }
        return (com.sun.java.util.collections.Map)definitionContext.getCacheLock();
    }

    protected HashMap getDefinitionObjectsMap() {
        return (HashMap)this.getCurrentApplicationMap(true);
    }

    protected abstract String getDefaultMOMCacheScope();

    public String getMOMCacheScope() {
        if (this.mMOMCacheScope == null) {
            this.mMOMCacheScope = ADFContext.APPLICATION_SCOPE;
            String string = this.getDefaultMOMCacheScope();
            if (string != null) {
                if (string.equals("request")) {
                    this.mMOMCacheScope = ADFContext.REQUEST_SCOPE;
                } else if (string.equals("session")) {
                    this.mMOMCacheScope = ADFContext.SESSION_SCOPE;
                }
            }
        }
        return this.mMOMCacheScope;
    }

    protected abstract boolean usesMDSByDefault();

    protected boolean usesMDS() {
        if (this.mUsesMDS < 0) {
            this.mUsesMDS = this.usesMDSByDefault() ? 1 : 0;
        }
        return this.mUsesMDS == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefinitionContext getCurrentDefinitionContext(boolean bl) {
        ADFContext aDFContext = ADFContext.getCurrent();
        Map map = aDFContext.getScope(ADFContext.REQUEST_SCOPE);
        DefinitionContext definitionContext = (DefinitionContext)map.get(this);
        if (definitionContext == null) {
            String string = this.getMOMCacheScope();
            if (string == ADFContext.REQUEST_SCOPE) {
                if (bl) {
                    MOMParser mOMParser = this.usesMDS() ? (MOMParser)new MOMParserMDS(this) : (MOMParser)new MOMParserNonMDS(this);
                    definitionContext = new DefinitionContextStandard(this, mOMParser);
                    map.put(this, definitionContext);
                }
            } else if (string == ADFContext.SESSION_SCOPE) {
                Map map2 = aDFContext.getScope(string);
                definitionContext = (DefinitionContext)map2.get(this);
                if (definitionContext == null && bl) {
                    MOMParser mOMParser = this.usesMDS() ? (MOMParser)new MOMParserMDS(this) : (MOMParser)new MOMParserNonMDS(this);
                    definitionContext = new DefinitionContextStandard(this, mOMParser);
                    map2.put(this, definitionContext);
                }
            } else {
                WeakKeyHashtable weakKeyHashtable = this.mContextMap;
                synchronized (weakKeyHashtable) {
                    Object object = aDFContext.getADFConfig().getId();
                    definitionContext = (DefinitionContext)this.mContextMap.get(object);
                    if (definitionContext == null && bl) {
                        MOMParser mOMParser = this.usesMDS() ? (MOMParser)new MOMParserMDS(this) : (MOMParser)new MOMParserNonMDS(this);
                        definitionContext = new DefinitionContextAgeable(this, mOMParser, this.mListener);
                        this.mContextMap.put(object, definitionContext);
                    }
                }
            }
        }
        return definitionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongRunningStatementMonitor getStatementMonitor() {
        DefinitionContext definitionContext = this.getCurrentDefinitionContext(true);
        Object object = definitionContext.getCacheLock();
        synchronized (object) {
            LongRunningStatementMonitor longRunningStatementMonitor = definitionContext.getStatementMonitor();
            return longRunningStatementMonitor;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

