/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.expr;

import java.io.LineNumberReader;
import oracle.jbo.expr.JIException;
import oracle.jbo.expr.JIExpr;
import oracle.jbo.expr.JIParserNode;
import oracle.jbo.expr.JIToken;

public class JIExprJava
extends JIExpr {
    private String[] mPackages;

    private /* synthetic */ void $init$() {
        this.mPackages = new String[]{"java.lang"};
    }

    public JIExprJava() {
        this.$init$();
    }

    public JIExprJava(LineNumberReader lineNumberReader) {
        super(lineNumberReader);
        this.$init$();
    }

    public String[] getPackages() {
        return this.mPackages;
    }

    public void setPackages(String[] stringArray) {
        this.mPackages = stringArray;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        if (clazz == null) {
            int n = 0;
            while (n < this.mPackages.length) {
                try {
                    clazz = Class.forName(this.mPackages[n] + "." + string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = null;
                }
                if (clazz != null) break;
                ++n;
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class " + string + " not found");
        }
        return clazz;
    }

    public JIParserNode getTerm() {
        JIParserNode jIParserNode = null;
        JIToken jIToken = this.findNextWord(false);
        if (jIToken.equals("!")) {
            JIParserNode jIParserNode2 = this.getTerm();
            jIParserNode = new JIParserNode(this, 62, jIToken.getTokStr(), null);
            jIParserNode.setLeftChild(jIParserNode2);
        } else if (jIToken.equals("new")) {
            jIParserNode = new JIParserNode(this, 81, jIToken.getTokStr(), null);
            JIParserNode jIParserNode3 = this.getIdentTerm();
            jIParserNode.setRightChild(jIParserNode3);
        } else if (jIToken.equals("isvalid")) {
            jIParserNode = new JIParserNode(this, 82, jIToken.getTokStr(), null);
            JIParserNode jIParserNode4 = this.getExpr();
            jIParserNode.setLeftChild(jIParserNode4);
        } else {
            this.rewindWord();
            jIParserNode = super.getTerm();
        }
        return jIParserNode;
    }

    public int getComparisonOperators(JIToken jIToken) {
        int n = 0;
        if (jIToken.getTokStr().equals("=")) {
            if (this.findNextWord(false).equals("=")) {
                n = 70;
            } else {
                this.rewindWord();
            }
        } else if (jIToken.getTokStr().equals(">")) {
            if (this.findNextWord(false).equals("=")) {
                n = 72;
            } else {
                this.rewindWord();
                n = 71;
            }
        } else if (jIToken.getTokStr().equals("<")) {
            if (this.findNextWord(false).equals("=")) {
                n = 74;
            } else {
                this.rewindWord();
                n = 73;
            }
        } else if (jIToken.getTokStr().equals("!")) {
            if (this.findNextWord(false).equals("=")) {
                n = 75;
            } else {
                this.rewindWord();
            }
        } else if (jIToken.getTokStr().equals("~")) {
            n = 76;
        }
        return n;
    }

    public String getReservedWord(int n) {
        switch (n) {
            case 60: {
                return "&&";
            }
            case 61: {
                return "||";
            }
        }
        throw new JIException("Does not have reserved word for " + n);
    }

    public boolean checkForReservedWord(String string, int n) {
        return string.equals(this.getReservedWord(60));
    }
}

