/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ws;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.NoObjException;
import oracle.jbo.ViewLink;
import oracle.jbo.ViewObject;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.ws.WSAMComponent;
import oracle.jbo.common.ws.WSApplicationModuleImpl;
import oracle.jbo.common.ws.WSAttributeDefImpl;
import oracle.jbo.common.ws.WSObject;
import oracle.jbo.common.ws.WSViewObjectImpl;

public class WSViewLinkImpl
extends WSAMComponent
implements Serializable,
ViewLink {
    private String mName;
    private String mDefFullName;
    private String mEntityAssocName;
    private String mAccessorName;
    private boolean mIsNew;
    private String mAssocClause;
    private transient WSViewObjectImpl mSource;
    private transient WSAttributeDefImpl[] mSourceAttrs;
    private String mSourceName;
    private transient WSViewObjectImpl mDestination;
    private transient WSAttributeDefImpl[] mDestinationAttrs;
    private String mDestinationName;
    private transient ViewLink mVL;
    private transient WSApplicationModuleImpl mParent;

    private /* synthetic */ void $init$() {
        this.mVL = null;
        this.mParent = null;
    }

    WSViewLinkImpl(String string, WSApplicationModuleImpl wSApplicationModuleImpl) {
        this.$init$();
        this.mId = wSApplicationModuleImpl.registerObject(this);
        this.mName = string;
        this.mParent = wSApplicationModuleImpl;
        this.mIsNew = false;
        this.mObjStat = 1;
    }

    WSViewLinkImpl(String string, String string2, boolean bl, WSViewObjectImpl wSViewObjectImpl, WSViewObjectImpl wSViewObjectImpl2, WSApplicationModuleImpl wSApplicationModuleImpl) {
        this.$init$();
        this.mId = wSApplicationModuleImpl.registerObject(this);
        this.mName = string;
        if (bl) {
            this.mDefFullName = string2;
        } else {
            this.mEntityAssocName = string2;
        }
        this.mSource = wSViewObjectImpl;
        this.mDestination = wSViewObjectImpl2;
        this.mParent = wSApplicationModuleImpl;
        this.mIsNew = true;
        this.mObjStat = 0;
        this.afterCreate();
    }

    WSViewLinkImpl(String string, String string2, WSViewObjectImpl wSViewObjectImpl, WSAttributeDefImpl[] wSAttributeDefImplArray, WSViewObjectImpl wSViewObjectImpl2, WSAttributeDefImpl[] wSAttributeDefImplArray2, String string3, WSApplicationModuleImpl wSApplicationModuleImpl) {
        this.$init$();
        this.mId = wSApplicationModuleImpl.registerObject(this);
        this.mName = string;
        this.mAccessorName = string2;
        this.mSource = wSViewObjectImpl;
        this.mSourceAttrs = wSAttributeDefImplArray;
        this.mDestination = wSViewObjectImpl2;
        this.mDestinationAttrs = wSAttributeDefImplArray2;
        this.mAssocClause = string3;
        this.mParent = wSApplicationModuleImpl;
        this.mIsNew = true;
        this.mObjStat = 0;
        this.afterCreate();
    }

    public WSObject getParent() {
        return this.mParent;
    }

    ViewLink getViewLinkImpl() {
        return this.mVL;
    }

    void setViewLinkImpl(ViewLink viewLink) {
        this.mVL = viewLink;
        this.mParent.registerImplToWSObject(this.mVL, this);
    }

    public Object getImplObject() {
        return this.getViewLinkImpl();
    }

    public void setImplObject(Object object) {
        this.setViewLinkImpl((ViewLink)object);
    }

    int getBatchCommMode() {
        return ((WSApplicationModuleImpl)this.getApplicationModule()).getBatchCommMode();
    }

    public void markForError(Exception exception, boolean bl) {
        if (!bl) {
            this.mObjStat = -1;
            this.mParent.removeChild(this);
            this.mParent = null;
        }
    }

    ApplicationModule getApplicationModule() {
        return this.mParent;
    }

    void beforeSend(List list) {
        this.mSourceName = this.mSource.getName();
        this.mDestinationName = this.mDestination.getName();
    }

    void afterSend() {
        if (this.mObjStat == 100) {
            this.mParent.removeChild(this);
            return;
        }
    }

    void doInit() {
        if (this.mObjStat == -1) {
            return;
        }
        try {
            ViewLink viewLink;
            ApplicationModule applicationModule = this.mParent.getApplicationModuleImpl();
            if (this.mIsNew) {
                if (this.mDefFullName != null) {
                    viewLink = applicationModule.createViewLink(this.mName, this.mDefFullName, this.mSource, this.mDestination);
                } else if (this.mEntityAssocName != null) {
                    viewLink = applicationModule.createViewLinkFromEntityAssocName(this.mName, this.mEntityAssocName, this.mSource, this.mDestination);
                } else {
                    AttributeDef[] attributeDefArray = null;
                    ViewObject viewObject = this.mSource.getViewObjectImpl();
                    if (this.mSourceAttrs != null && this.mSourceAttrs.length > 0) {
                        attributeDefArray = new AttributeDef[this.mSourceAttrs.length];
                        int n = 0;
                        while (n < this.mSourceAttrs.length) {
                            attributeDefArray[n] = viewObject.lookupAttributeDef(this.mSourceAttrs[n].getName());
                            ++n;
                        }
                    }
                    AttributeDef[] attributeDefArray2 = null;
                    ViewObject viewObject2 = this.mDestination.getViewObjectImpl();
                    if (this.mDestinationAttrs != null && this.mDestinationAttrs.length > 0) {
                        attributeDefArray2 = new AttributeDef[this.mDestinationAttrs.length];
                        int n = 0;
                        while (n < this.mDestinationAttrs.length) {
                            attributeDefArray2[n] = viewObject2.lookupAttributeDef(this.mDestinationAttrs[n].getName());
                            ++n;
                        }
                    }
                    viewLink = applicationModule.createViewLinkBetweenViewObjects(this.mName, this.mAccessorName, viewObject, attributeDefArray, viewObject2, attributeDefArray2, this.mAssocClause);
                }
            } else {
                viewLink = applicationModule.findViewLink(this.mName);
                if (viewLink == null) {
                    throw new NoObjException(115, this.getName());
                }
                if (this.mObjStat == 100) {
                    viewLink.remove();
                    return;
                }
            }
            this.setViewLinkImpl(viewLink);
        }
        catch (Exception exception) {
            this.processWSException(exception);
        }
    }

    public ViewObject getSource() {
        return this.mSource;
    }

    public ViewObject getDestination() {
        return this.mDestination;
    }

    public String getDefName() {
        return this.mDefFullName == null ? null : JboNameUtil.getLastPartOfName(this.mDefFullName);
    }

    public String getDefFullName() {
        return this.mDefFullName;
    }

    public String getName() {
        return this.mName;
    }

    public String getFullName() {
        return this.mParent.getName() + "." + this.mName;
    }

    public void remove() {
        if (this.mObjStat == 0) {
            this.mParent.removeChild(this);
        }
        this.mObjStat = 100;
    }

    public Object getProperty(String string) {
        if (this.mVL != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mVL.getProperty(string);
        }
        this.invalidOperation("getProperty");
        return null;
    }

    public Object refreshProperty(String string) {
        if (this.mVL != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mVL.refreshProperty(string);
        }
        this.invalidOperation("refreshProperty");
        return null;
    }

    public Hashtable getProperties() {
        if (this.mVL != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mVL.getProperties();
        }
        this.invalidOperation("getProperties");
        return null;
    }

    void resolveAfterLoad(WSApplicationModuleImpl wSApplicationModuleImpl) {
        this.mParent = wSApplicationModuleImpl;
        this.mSource = this.mParent.findWSViewObject(this.mSourceName);
        this.mDestination = this.mParent.findWSViewObject(this.mDestinationName);
    }
}

