/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.util.Dictionary;
import java.util.Enumeration;
import oracle.jbo.common.WeakKeyEntry;
import oracle.jbo.common.WeakKeyEnumerator;

public class WeakKeyHashtableImpl
extends Dictionary {
    private WeakKeyEntry[] table;
    int count;
    private int threshold;
    private float loadFactor;

    private void init(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new WeakKeyEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public WeakKeyHashtableImpl(int n, float f) {
        this.init(n, f);
    }

    public WeakKeyHashtableImpl(int n) {
        this.init(n, 0.75f);
    }

    public WeakKeyHashtableImpl() {
        try {
            this.init(101, 0.75f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error("panic");
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new WeakKeyEnumerator(this, this.table, true);
    }

    public synchronized Enumeration elements() {
        return new WeakKeyEnumerator(this, this.table, false);
    }

    public synchronized Object get(Object object) {
        WeakKeyEntry[] weakKeyEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % weakKeyEntryArray.length;
        WeakKeyEntry weakKeyEntry = null;
        WeakKeyEntry weakKeyEntry2 = weakKeyEntryArray[n2];
        while (weakKeyEntry2 != null) {
            Object object2 = weakKeyEntry2.check();
            if (object2 == null) {
                if (weakKeyEntry == null) {
                    weakKeyEntryArray[n2] = weakKeyEntry2.next;
                } else {
                    weakKeyEntry.next = weakKeyEntry2.next;
                }
                --this.count;
            } else {
                if (weakKeyEntry2.hash == n && object2.equals(object)) {
                    return weakKeyEntry2.val;
                }
                weakKeyEntry = weakKeyEntry2;
            }
            weakKeyEntry2 = weakKeyEntry2.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        WeakKeyEntry[] weakKeyEntryArray = this.table;
        int n2 = n * 2 + 1;
        WeakKeyEntry[] weakKeyEntryArray2 = new WeakKeyEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = weakKeyEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            WeakKeyEntry weakKeyEntry = weakKeyEntryArray[n3];
            while (weakKeyEntry != null) {
                WeakKeyEntry weakKeyEntry2 = weakKeyEntry;
                weakKeyEntry = weakKeyEntry.next;
                if (weakKeyEntry2.check() != null) {
                    int n4 = (weakKeyEntry2.hash & Integer.MAX_VALUE) % n2;
                    weakKeyEntry2.next = weakKeyEntryArray2[n4];
                    weakKeyEntryArray2[n4] = weakKeyEntry2;
                    continue;
                }
                --this.count;
            }
        }
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        WeakKeyEntry[] weakKeyEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % weakKeyEntryArray.length;
        Object var6_6 = null;
        WeakKeyEntry weakKeyEntry = weakKeyEntryArray[n2];
        while (weakKeyEntry != null) {
            Object object3 = weakKeyEntry.check();
            if (object3 == null) {
                if (var6_6 == null) {
                    weakKeyEntryArray[n2] = weakKeyEntry.next;
                } else {
                    var6_6.next = weakKeyEntry.next;
                }
                --this.count;
            } else if (weakKeyEntry.hash == n && object3.equals(object)) {
                Object object4 = weakKeyEntry.val;
                weakKeyEntry.val = object2;
                return object4;
            }
            weakKeyEntry = weakKeyEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        WeakKeyEntry weakKeyEntry2 = new WeakKeyEntry();
        weakKeyEntry2.next = weakKeyEntryArray[n2];
        weakKeyEntryArray[n2] = weakKeyEntry2;
        ++this.count;
        weakKeyEntry2.hash = n;
        weakKeyEntry2.val = object2;
        weakKeyEntry2.setThing(object);
        return null;
    }

    public synchronized Object remove(Object object) {
        WeakKeyEntry[] weakKeyEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % weakKeyEntryArray.length;
        WeakKeyEntry weakKeyEntry = weakKeyEntryArray[n2];
        WeakKeyEntry weakKeyEntry2 = null;
        while (weakKeyEntry != null) {
            Object object2 = weakKeyEntry.check();
            if (object2 == null || weakKeyEntry.hash == n && object2.equals(object)) {
                if (weakKeyEntry2 != null) {
                    weakKeyEntry2.next = weakKeyEntry.next;
                } else {
                    weakKeyEntryArray[n2] = weakKeyEntry.next;
                }
                --this.count;
                if (object2 != null) {
                    return weakKeyEntry.check();
                }
            } else {
                weakKeyEntry2 = weakKeyEntry;
            }
            weakKeyEntry = weakKeyEntry.next;
        }
        return null;
    }
}

