/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import oracle.jbo.common.ArrayResourceBundle;
import oracle.jbo.common.GraphicsUtils;
import oracle.jbo.common.ResourceUtils;

public final class ResourceManager {
    static final String imageBase = "images/";
    private static final ResourceManager instance = new ResourceManager();
    private static HashMap iconCache = new HashMap();

    private ResourceManager() {
    }

    public static ResourceManager getInstance() {
        return instance;
    }

    public static Object getObj(ArrayResourceBundle arrayResourceBundle, int n) {
        return arrayResourceBundle.getObject(n);
    }

    public static String getStr(ArrayResourceBundle arrayResourceBundle, int n) {
        return arrayResourceBundle.getString2(n);
    }

    public static char getChar(ArrayResourceBundle arrayResourceBundle, int n) {
        return ((Character)arrayResourceBundle.getObject(n)).charValue();
    }

    public static Icon getIcon(ArrayResourceBundle arrayResourceBundle, int n) {
        URL uRL;
        String string = arrayResourceBundle.getString2(n);
        if (string == null || string.length() == 0) {
            return null;
        }
        Class<?> clazz = arrayResourceBundle.getClass();
        String string2 = clazz.getName() + "." + string;
        Icon icon = ResourceManager.getIcon(string2);
        if (icon == null && (icon = ResourceManager.getIcon(uRL = clazz.getResource(string))) != null) {
            iconCache.put(string2, icon);
        }
        return icon;
    }

    public static Image getImage(ArrayResourceBundle arrayResourceBundle, int n) {
        String string = arrayResourceBundle.getString2(n);
        if (string == null || string.length() == 0) {
            return null;
        }
        Class<?> clazz = arrayResourceBundle.getClass();
        URL uRL = clazz.getResource(string);
        return ResourceManager.getImage(uRL);
    }

    public static Font getFont(ArrayResourceBundle arrayResourceBundle, int n) {
        return (Font)arrayResourceBundle.getObject(n);
    }

    public static KeyStroke getAccelerator(ArrayResourceBundle arrayResourceBundle, int n) {
        String string = arrayResourceBundle.getString2(n);
        if (string != null && string.length() > 0) {
            return KeyStroke.getKeyStroke(string);
        }
        return null;
    }

    public static Integer getInteger(ArrayResourceBundle arrayResourceBundle, int n) {
        String string = arrayResourceBundle.getObject(n).toString();
        if (string.length() == 1 && Character.isLetter(string.charAt(0))) {
            return new Integer(string.charAt(0));
        }
        return Integer.valueOf(string);
    }

    public static char getMnemonic(ArrayResourceBundle arrayResourceBundle, int n) {
        int n2;
        String string = ResourceManager.getStr(arrayResourceBundle, n);
        int n3 = n2 = string != null ? string.length() : 0;
        if (n2 == 1) {
            return n2 > 0 ? string.charAt(0) : (char)'\u0000';
        }
        return (char)ResourceUtils.getMnemonicKeyCode(string);
    }

    public static String getImageBase() {
        return imageBase;
    }

    public static void uncacheIcon(Icon icon) {
        iconCache.values().remove(icon);
        if (icon instanceof ImageIcon) {
            ((ImageIcon)icon).getImage().flush();
        }
    }

    private static Icon getIcon(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toString();
        Object v = iconCache.get(string);
        if (v instanceof Icon) {
            return (Icon)v;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(uRL);
        ImageIcon imageIcon = GraphicsUtils.createImageIcon(image);
        return imageIcon;
    }

    private static Icon getIcon(String string) {
        if (string == null) {
            return null;
        }
        Object v = iconCache.get(string);
        if (v instanceof Icon) {
            return (Icon)v;
        }
        return null;
    }

    private static Image getImage(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toString();
        Object v = iconCache.get(string);
        if (v instanceof ImageIcon) {
            return ((ImageIcon)v).getImage();
        }
        Image image = Toolkit.getDefaultToolkit().createImage(uRL);
        ImageIcon imageIcon = GraphicsUtils.createImageIcon(image);
        iconCache.put(string, imageIcon);
        return imageIcon.getImage();
    }
}

