/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jbo.JboException;
import oracle.jbo.NoDefException;
import oracle.jbo.Row;
import oracle.jbo.RowComparator;
import oracle.jbo.RowMatchBindValueSupplier;
import oracle.jbo.StructureDef;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.expr.JIExprSQL;
import oracle.jbo.expr.JIParserNode;
import oracle.jbo.expr.JISyntaxError;
import oracle.jbo.expr.JIValueSupplier;

public class RowMatch
implements Serializable {
    static final long serialVersionUID = 7289620958726840447L;
    private String mWhereClause;
    private transient JIExprSQL mWhereExpr;
    private transient JIParserNode mParsedExpr;
    private transient String mPatternStr;
    private transient Pattern mPattern;
    private static transient String anyThing = ".*";

    private /* synthetic */ void $init$() {
        this.mWhereClause = null;
        this.mWhereExpr = null;
        this.mParsedExpr = null;
        this.mPatternStr = null;
        this.mPattern = null;
    }

    public RowMatch() {
        this.$init$();
    }

    public RowMatch(String string) {
        this.$init$();
        this.setWhereClause(string);
    }

    public String getWhereClause() {
        return this.mWhereClause;
    }

    public void setWhereClause(String string) {
        this.mWhereClause = string;
        if (this.mWhereClause != null) {
            if (this.mWhereClause.toUpperCase().startsWith(" WHERE ")) {
                this.mWhereClause = this.mWhereClause.substring(" WHERE ".length());
            }
            StringReader stringReader = new StringReader(this.mWhereClause);
            this.mWhereExpr = new JIExprSQL(new LineNumberReader(stringReader));
            this.mWhereExpr.setContinueRead(true);
        } else {
            this.mWhereExpr = null;
        }
        this.mParsedExpr = null;
        this.mPatternStr = null;
        this.mPattern = null;
    }

    public JIParserNode getParsedExpr() {
        if (this.mParsedExpr == null && this.mWhereExpr != null) {
            this.mParsedExpr = this.mWhereExpr.getBooleanExpr();
            this.mWhereExpr.noMoreTokenCheck();
        }
        return this.mParsedExpr;
    }

    public boolean rowQualifies(Row row) {
        JIParserNode jIParserNode = this.getParsedExpr();
        if (jIParserNode == null) {
            return true;
        }
        return JIParserNode.convertIntoBoolean(this.mParsedExpr.evaluate(new RowValueSupplier(row, this)));
    }

    Pattern getCompiledPattern(String string) {
        if (this.mPattern == null || this.mPatternStr.compareTo(string) != 0) {
            this.mPatternStr = string;
            String string2 = string;
            string2 = string2.replaceAll("%", anyThing);
            this.mPattern = Pattern.compile(string2);
        }
        return this.mPattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getVariableVal(Row row, String string) {
        Object object = null;
        char c = string.charAt(0);
        try {
            if (c != ':') return row.getAttribute(string);
            StructureDef structureDef = row.getStructureDef();
            if (!(structureDef instanceof RowMatchBindValueSupplier)) throw new JISyntaxError("Variable " + string + " not recognized");
            return ((RowMatchBindValueSupplier)((Object)structureDef)).getRowMatchBindValue(row, string.substring(1));
        }
        catch (NoDefException noDefException) {
            throw new JISyntaxError("Variable " + string + " not recognized");
        }
    }

    public boolean equals(Object object) {
        if (object instanceof RowMatch) {
            RowMatch rowMatch = (RowMatch)object;
            String string = this.getWhereClause();
            String string2 = rowMatch.getWhereClause();
            if (string == null) {
                return string2 == null;
            }
            return string.equals(string2);
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setWhereClause(this.mWhereClause);
    }

    public class RowValueSupplier
    implements JIValueSupplier {
        private Row mRow;
        private RowMatch mRowMatch;

        RowValueSupplier(Row row, RowMatch rowMatch2) {
            this.mRow = row;
            this.mRowMatch = rowMatch2;
        }

        public Object getVariableVal(String string) {
            return this.mRowMatch.getVariableVal(this.mRow, string);
        }

        public Object getFieldVal(Object object, String string) {
            throw new JboException("getFieldVal not supported");
        }

        public Object getLiteralFieldVal(Object object, String string) {
            throw new JboException("getLiteralFieldVal not supported");
        }

        public void setVariableVal(String string, Object object) {
            throw new JboException("setVariableVal not supported");
        }

        public void setFieldVal(Object object, String string, Object object2) {
            throw new JboException("setFieldVal not supported");
        }

        public void setLiteralFieldVal(Object object, String string, Object object2) {
            throw new JboException("setLiteralFieldVal not supported");
        }

        public Object unaryOperation(Object object, int n) {
            return null;
        }

        public Object binaryOperation(Object object, Object object2, int n) {
            return null;
        }

        public Boolean compareValues(Object object, Object object2, int n) {
            if (n == 70) {
                return new Boolean(RowComparator.compareEquals(object, object2));
            }
            if (n == 75) {
                return new Boolean(RowComparator.compareEquals(object, object2) ^ true);
            }
            int n2 = RowComparator.compareValues(object, object2);
            if (n == 71) {
                return new Boolean(n2 > 0);
            }
            if (n == 72) {
                return new Boolean(n2 >= 0);
            }
            if (n == 73) {
                return new Boolean(n2 < 0);
            }
            if (n == 74) {
                return new Boolean(n2 <= 0);
            }
            throw new JboException("Unrecognized nodeType in compareValues: " + n);
        }

        public boolean isRegExpMatch(String string, String string2) {
            if (string != null && string2 != null) {
                Pattern pattern = this.mRowMatch.getCompiledPattern(string2);
                Matcher matcher = pattern.matcher(string);
                return matcher.matches();
            }
            return false;
        }

        public void print(String string) {
            if (Diagnostic.isOn()) {
                Diagnostic.print(string);
            }
        }

        public void println(String string) {
            if (Diagnostic.isOn()) {
                Diagnostic.println(string);
            }
        }
    }
}

