/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jpub.runtime.MutableStruct;
import oracle.ord.im.OrdImageBase;
import oracle.ord.im.OrdMediaUtil;
import oracle.ord.im.OrdSource;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

public class OrdImage
extends OrdImageBase {
    OracleConnection conn = null;
    static final OrdImage _OrdImageFactory = new OrdImage();

    public boolean checkProperties() throws SQLException {
        boolean bl = false;
        String string = "declare  obj ordsys.OrdImage;  res INTEGER;  begin    obj := ?;  res := 0;  if( obj.checkProperties() = TRUE) then   res := 1 ;  end if;  ? := res;  end;";
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.setCustomDatum(1, (CustomDatum)this);
            oracleCallableStatement.registerOutParameter(2, 4);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(2);
        }
        finally {
            Object var5_4 = null;
            oracleCallableStatement.close();
        }
        return bl;
    }

    public void clearLocal() throws SQLException {
        this.getSetSourceObject().setLocal(new BigDecimal(0.0));
    }

    public void copy(OrdImage ordImage) throws SQLException {
        String string = " DECLARE  obj     ORDSYS.ORDImage;  destObj ORDSYS.ORDImage;  BEGIN  obj := ?; destObj := ?; obj.copy(destObj);  ? := destObj;  END ; ";
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.setCustomDatum(1, (CustomDatum)this);
            oracleCallableStatement.setCustomDatum(2, (CustomDatum)ordImage);
            oracleCallableStatement.registerOutParameter(3, 2002, "ORDSYS.ORDIMAGE");
            oracleCallableStatement.execute();
            ordImage.copyStruct((OrdImage)oracleCallableStatement.getCustomDatum(3, OrdImage.getFactory()));
        }
        finally {
            Object var5_4 = null;
            ordImage.conn = this.conn;
            oracleCallableStatement.close();
        }
    }

    void copyObject(OrdImage ordImage) throws SQLException {
        this._struct = ordImage._struct;
        if (this._ctx == null) {
            this._ctx = ordImage._ctx;
        }
        if (this.conn == null) {
            this.conn = ordImage.conn;
        }
    }

    private void copyStruct(OrdImageBase ordImageBase) throws SQLException {
        this._struct = ordImageBase._struct;
    }

    public CustomDatum create(Datum datum, int n) throws SQLException {
        if (datum == null) {
            return null;
        }
        OrdImage ordImage = new OrdImage();
        ordImage._struct = new MutableStruct((STRUCT)datum, OrdImageBase._sqlType, OrdImageBase._factory);
        ordImage._ctx = new OrdImageBase._Ctx((Connection)((STRUCT)datum).getConnection());
        ordImage.conn = (OracleConnection)ordImage._ctx.getConnection();
        return ordImage;
    }

    public void deleteContent() throws SQLException {
        this.copyStruct(super._deleteContent());
    }

    public void export(byte[][] byArray, String string, String string2, String string3) throws SQLException {
        this.copyStruct(super._export(byArray, string, string2, string3));
    }

    public BFILE getBFILE() throws SQLException {
        return super._getBFILE();
    }

    public String getCompressionFormat() throws SQLException {
        return super.get_CompressionFormat();
    }

    public BLOB getContent() throws SQLException {
        return this.getSetSourceObject().getLocaldata();
    }

    public String getContentFormat() throws SQLException {
        return super.get_ContentFormat();
    }

    public int getContentLength() throws SQLException {
        Integer n = super.get_ContentLength();
        if (n != null) {
            return n;
        }
        return 0;
    }

    BLOB getContentReadOnly() throws SQLException {
        return this.getSourceObject().getLocaldata();
    }

    public byte[] getDataInByteArray() throws SQLException, IOException, OutOfMemoryError {
        return OrdMediaUtil.getDataInByteArray(this.getContentReadOnly());
    }

    public boolean getDataInFile(String string) throws SQLException, IOException {
        return OrdMediaUtil.getDataInFile(string, this.getContentReadOnly());
    }

    public InputStream getDataInStream() throws SQLException {
        return this.getContentReadOnly().getBinaryStream();
    }

    public static CustomDatumFactory getFactory() {
        return _OrdImageFactory;
    }

    public String getFormat() throws SQLException {
        return super.get_Format();
    }

    public int getHeight() throws SQLException {
        Integer n = super.get_Height();
        if (n != null) {
            return n;
        }
        return 0;
    }

    public String getMimeType() throws SQLException {
        return super.get_MimeType();
    }

    private OrdSource getSetSourceObject() throws SQLException {
        super.set_Source(super.get_Source());
        return super.get_Source();
    }

    public String getSource() throws SQLException {
        return super._getSource();
    }

    public String getSourceLocation() throws SQLException {
        return this.getSourceObject().getSrclocation();
    }

    public String getSourceName() throws SQLException {
        return this.getSourceObject().getSrcname();
    }

    private OrdSource getSourceObject() throws SQLException {
        return super.get_Source();
    }

    public String getSourceType() throws SQLException {
        return this.getSourceObject().getSrctype();
    }

    public Timestamp getUpdateTime() throws SQLException {
        return this.getSourceObject().getUpdatetime();
    }

    public int getWidth() throws SQLException {
        Integer n = super.get_Width();
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void importData(byte[][] byArray) throws SQLException {
        String string = "declare  obj ordsys.OrdImage;  begin    obj := ?;  obj.import(?);  ? := obj;  end;";
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.setCustomDatum(1, (CustomDatum)this);
            oracleCallableStatement.setBytes(2, byArray[0]);
            oracleCallableStatement.registerOutParameter(2, -3);
            oracleCallableStatement.registerOutParameter(3, 2002, "ORDSYS.ORDIMAGE");
            oracleCallableStatement.execute();
            byArray[0] = oracleCallableStatement.getBytes(2);
            this.copyStruct((OrdImage)oracleCallableStatement.getCustomDatum(3, OrdImage.getFactory()));
        }
        finally {
            Object var5_4 = null;
            oracleCallableStatement.close();
        }
    }

    public void importFrom(byte[][] byArray, String string, String string2, String string3) throws SQLException {
        this.copyStruct(super._importFrom(byArray, string, string2, string3));
    }

    public boolean isLocal() throws SQLException {
        BigDecimal bigDecimal = this.getSourceObject().getLocal();
        if (bigDecimal == null) {
            return true;
        }
        return bigDecimal.intValue() != 0;
    }

    public boolean loadDataFromByteArray(byte[] byArray) throws SQLException, IOException {
        this.deleteContent();
        this.setLocal();
        this.setUpdateTime(null);
        return OrdMediaUtil.loadDataFromByteArray(byArray, this.getContent());
    }

    public boolean loadDataFromFile(String string) throws SQLException, IOException {
        this.deleteContent();
        this.setLocal();
        this.setUpdateTime(null);
        return OrdMediaUtil.loadData(string, this.getContent());
    }

    public boolean loadDataFromInputStream(InputStream inputStream) throws SQLException, IOException {
        this.deleteContent();
        this.setLocal();
        this.setUpdateTime(null);
        return OrdMediaUtil.loadDataFromInputStream(inputStream, this.getContent());
    }

    public void process(String string) throws SQLException {
        this.copyStruct(super._process(string));
    }

    public void processCopy(String string, OrdImage ordImage) throws SQLException {
        String string2 = " DECLARE  obj     ORDSYS.ORDImage;  destObj ORDSYS.ORDImage;  BEGIN  obj := ?; destObj := ?; obj.processCopy('" + string + "', destObj); " + " ? := destObj; " + " END ; ";
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string2);
            oracleCallableStatement.setCustomDatum(1, (CustomDatum)this);
            oracleCallableStatement.setCustomDatum(2, (CustomDatum)ordImage);
            oracleCallableStatement.registerOutParameter(3, 2002, "ORDSYS.ORDIMAGE");
            oracleCallableStatement.execute();
            ordImage.copyStruct((OrdImage)oracleCallableStatement.getCustomDatum(3, OrdImage.getFactory()));
        }
        finally {
            Object var6_5 = null;
            oracleCallableStatement.close();
        }
    }

    public void setCompressionFormat(String string) throws SQLException {
        super.set_CompressionFormat(string);
    }

    void setContent(BLOB bLOB) throws SQLException {
        this.getSetSourceObject().setLocaldata(bLOB);
    }

    public void setContentFormat(String string) throws SQLException {
        super.set_ContentFormat(string);
    }

    public void setContentLength(int n) throws SQLException {
        super.set_ContentLength(new Integer(n));
    }

    public void setFormat(String string) throws SQLException {
        super.set_Format(string);
    }

    public void setHeight(int n) throws SQLException {
        super.set_Height(new Integer(n));
    }

    public void setLocal() throws SQLException {
        this.getSetSourceObject().setLocal(new BigDecimal(1.0));
    }

    public void setMimeType(String string) throws SQLException {
        super.set_MimeType(string);
    }

    public void setProperties() throws SQLException {
        this.copyStruct(super._setProperties());
    }

    public void setProperties(String string) throws SQLException {
        this.copyStruct(super._setProperties(string));
    }

    public void setSource(String string, String string2, String string3) throws SQLException {
        OrdSource ordSource = this.getSetSourceObject();
        ordSource.setSrctype(string);
        ordSource.setSrclocation(string2);
        ordSource.setSrcname(string3);
    }

    void setSourceObject(OrdSource ordSource) throws SQLException {
        super.set_Source(ordSource);
    }

    public void setUpdateTime(Timestamp timestamp) throws SQLException {
        this.copyStruct(super._setUpdateTime(timestamp));
    }

    public void setWidth(int n) throws SQLException {
        super.set_Width(new Integer(n));
    }
}

