/*
 * Decompiled with CFR 0.152.
 */
package br.rs.gov.tce.function;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class ValidaCNPJ {
    private static final NumberFormat nfCNPJ = new DecimalFormat("00000000000000");

    private ValidaCNPJ() {
    }

    public static int validaCnpjLong(long cnpj) {
        if (cnpj > 999999999999999L) {
            return 0;
        }
        String cnpjStr = nfCNPJ.format(cnpj);
        return ValidaCNPJ.validaCnpj(cnpjStr) ? 1 : 0;
    }

    public static boolean validaCnpj(String cnpj) {
        int soma = 0;
        try {
            Long.parseLong(cnpj);
        }
        catch (Exception e) {
            return false;
        }
        if (cnpj.length() > 8 && cnpj.length() < 14) {
            while (cnpj.length() < 14) {
                cnpj = "0" + cnpj;
                System.out.println("1.1-- " + cnpj + "/" + cnpj.length());
            }
        }
        if (cnpj.length() == 14) {
            int i;
            int j = 5;
            for (i = 0; i < 12; ++i) {
                soma += j-- * (cnpj.charAt(i) - 48);
                if (j >= 2) continue;
                j = 9;
            }
            if ((soma = 11 - soma % 11) > 9) {
                soma = 0;
            }
            if (soma == cnpj.charAt(12) - 48) {
                soma = 0;
                j = 6;
                for (i = 0; i < 13; ++i) {
                    soma += j-- * (cnpj.charAt(i) - 48);
                    if (j >= 2) continue;
                    j = 9;
                }
                if ((soma = 11 - soma % 11) > 9) {
                    soma = 0;
                }
                if (soma == cnpj.charAt(13) - 48) {
                    return true;
                }
            }
        }
        return false;
    }
}

