/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.ws.validacao.client;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

public class CsvReader {
    static final String DEFAULT_SEP = ",";
    final String separator;
    final String[] colNames;
    final List<String> colList;
    final int colNamesLength;
    String[] lineVals;

    public CsvReader(String line) {
        this(line, DEFAULT_SEP);
    }

    public CsvReader(String line, String sep) {
        this.separator = sep;
        this.colNames = line.split(this.separator);
        this.colList = Arrays.asList(this.colNames);
        this.colNamesLength = this.colNames.length;
    }

    public void readLine(String line) {
        this.lineVals = line.split(this.separator, this.colNamesLength);
    }

    public int getColsLength() {
        return this.colNamesLength;
    }

    public boolean hasColumnName(String colName) {
        return this.colList.indexOf(colName) >= 0;
    }

    public String getString(String colName) {
        int idx = this.colList.indexOf(colName);
        return this.getString(idx);
    }

    public String getString(int idx) {
        return this.lineVals[idx];
    }

    public int getInt(String colName) {
        return Integer.parseInt(this.getString(colName));
    }

    public int getInt(int idx) {
        return Integer.parseInt(this.getString(idx));
    }

    public double getDouble(String colName) {
        return Double.parseDouble(this.getString(colName));
    }

    public double getDouble(int idx) {
        return Double.parseDouble(this.getString(idx));
    }

    public BigDecimal getBigDecimal(String colName) {
        return new BigDecimal(this.getString(colName));
    }

    public BigDecimal getBigDecimal(int idx) {
        return new BigDecimal(this.getString(idx));
    }

    public Integer getIntegerOrDefault(String colName, Integer def) {
        try {
            return this.getInt(colName);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public BigDecimal getBigDecimalOrDefault(String colName, BigDecimal def) {
        try {
            return this.getBigDecimal(colName);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }
}

