/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.ws.responsaveis.client;

import br.gov.rs.tce.ssl.util.SSLFactoryUtils;
import br.gov.rs.tce.util.ProxyBean;
import br.gov.rs.tce.ws.responsaveis.webservice.impl.Wsresponsaveis;
import https.wsresponsaveis_tce_rs_gov.EntidadeSatbWSPojo;
import https.wsresponsaveis_tce_rs_gov.EntidadeWSPojo;
import https.wsresponsaveis_tce_rs_gov.ResponsaveisWSPojo;
import https.wsresponsaveis_tce_rs_gov_br.ResponsaveisWebService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;

public class ResponsaveisWSClient {
    private static ResponsaveisWebService responsaveisWS;
    private static final String ARQUIVO_PROPERTIES = "conf/pad.properties";
    private static final String ARQUIVO_PROXY_PROPERTIES = "remessa/proxy.properties";

    public static void initalize() throws WebServiceException {
        try {
            try {
                SSLFactoryUtils.initNaiveSSLSocketFactory();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            ProxyBean proxyBean = new ProxyBean(ARQUIVO_PROXY_PROPERTIES);
            proxyBean.carregaDadosAutenticacao();
            ProxyBean.debug();
            String url = ResponsaveisWSClient.carregaConfigUrl();
            System.out.println("PAD-Modelo URL: " + url);
            Wsresponsaveis wsresp = new Wsresponsaveis(new URL(url));
            responsaveisWS = wsresp.getResponsaveisWebServiceImplPort();
            Map requestContext = ((BindingProvider)responsaveisWS).getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", url);
            requestContext.put("com.sun.xml.internal.ws.connect.timeout", 1000);
            requestContext.put("com.sun.xml.internal.ws.request.timeout", 5000);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static EntidadeWSPojo buscarDadosEntidade(Long codigoOrgao) throws Exception {
        return responsaveisWS.buscarDadosEntidade(codigoOrgao);
    }

    public static ResponsaveisWSPojo buscarResponsaveis(Long codigoOrgao, String periodoInicio, String periodoFim) throws Exception {
        return responsaveisWS.buscarResponsaveis(codigoOrgao, periodoInicio, periodoFim);
    }

    public static ResponsaveisWSPojo buscarResponsaveisComplementares(Long codigoOrgao, String periodoInicio, String periodoFim) throws Exception {
        return responsaveisWS.buscarResponsaveisComplementares(codigoOrgao, periodoInicio, periodoFim);
    }

    public static List<EntidadeSatbWSPojo> listaEntidadesAtualizadas(Integer nrAnos) throws Exception {
        return responsaveisWS.listaEntidadesAtualizadas(nrAnos);
    }

    private static String carregaConfigUrl() {
        String url = null;
        try {
            File file = new File(ARQUIVO_PROPERTIES);
            FileInputStream is = new FileInputStream(file);
            Properties props = new Properties();
            props.load(is);
            url = props.getProperty("wsresponsaveis.url");
            ((InputStream)is).close();
            props.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }
}

