/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.quadros;

import br.gov.rs.tce.pad.beans.QuadroAbstrato;
import br.gov.rs.tce.pad.beans.QuadroContas;
import br.gov.rs.tce.pad.beans.QuadroTotal;
import br.gov.rs.tce.pad.beans.Quadros;
import br.gov.rs.tce.pad.beans.Tela;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.modelo.decisao.NavegacaoTelasControle;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.panel.quadros.AtualizaQuadroEventoListener;
import br.gov.rs.tce.pad.visao.panel.quadros.PainelQuadroTotal;
import br.gov.rs.tce.pad.visao.panel.quadros.QuadroAjusteValores;
import br.gov.rs.tce.pad.visao.panel.quadros.QuadroRelacionamento;
import br.gov.rs.tce.pad.visao.panel.quadros.TelaQuadro;
import br.gov.rs.tce.pad.visao.panel.quadros.TelaQuadroComum;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.adf.model.BindingContext;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.jui.JUPanelBinding;

public class TelaQuadros
extends JPanel
implements PadModelo,
JUPanel {
    private BorderLayout layoutQuadros = new BorderLayout();
    private JPanel pnlCentro = new JPanel();
    private BindingContext _bindingContext;
    private Tela _tela;
    private BoxLayout layoutQuadrosCentro = new BoxLayout(this.pnlCentro, 3);
    private List _quadrosPanel = new ArrayList(2);
    protected JUPanelBinding _panelBinding;

    public void jbInit() throws Exception {
        this.setLayout(this.layoutQuadros);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pnlCentro.setLayout(this.layoutQuadrosCentro);
        this.add((Component)this.pnlCentro, "Center");
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        this._bindingContext = bindCtx;
        this._panelBinding = new JUPanelBinding();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        NavegacaoTelasControle navegacao = (NavegacaoTelasControle)bindCtx.findDataControl("NavegacaoDataControl");
        this._tela = navegacao.getConfigTelaAtual();
    }

    public final Tela getConfigTela() {
        return this._tela;
    }

    @Override
    public final void preparaTela() {
        Quadros quadros = this._tela.getQuadros();
        QuadroAbstrato[] quadrosAbstratos = quadros.getQuadro();
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this._bindingContext);
        ArrayList<TelaQuadro> telasQuadroAjustes = new ArrayList<TelaQuadro>(4);
        AtualizaQuadroEventoListener btnPopupListener = new AtualizaQuadroEventoListener(this._bindingContext);
        for (int i = 0; i < quadrosAbstratos.length; ++i) {
            if (quadrosAbstratos[i] instanceof QuadroContas) {
                QuadroContas quadro = (QuadroContas)quadrosAbstratos[i];
                Class classeQuadro = null;
                switch (quadro.getTipoQuadroId()) {
                    case 0: {
                        classeQuadro = QuadroRelacionamento.class;
                        break;
                    }
                    case 1: {
                        classeQuadro = QuadroAjusteValores.class;
                    }
                }
                btnPopupListener.adicionaVO(quadro.getNomeViewObject());
                TelaQuadro painelQuadro = this.criaQuadro(classeQuadro, remessa, quadro, btnPopupListener);
                if (quadro.getTipoQuadroId() == 1) {
                    telasQuadroAjustes.add(painelQuadro);
                }
                try {
                    this.pnlCentro.add((JPanel)((Object)painelQuadro));
                }
                catch (ClassCastException e) {
                    throw new ConfiguracaoException("A classe " + painelQuadro.getClass().getName() + " n\u00e3o estende JPanel.");
                }
                this._quadrosPanel.add(painelQuadro);
                continue;
            }
            if (!(quadrosAbstratos[i] instanceof QuadroTotal)) continue;
            QuadroTotal qTotal = (QuadroTotal)quadrosAbstratos[i];
            PainelQuadroTotal pnlTotal = new PainelQuadroTotal();
            pnlTotal.setPanelBinding(this._panelBinding);
            this.inicializaBindingQuadroTotal(this._bindingContext, qTotal, pnlTotal, telasQuadroAjustes);
            pnlTotal.ajustaLabelsQuadro(remessa, qTotal);
            this.pnlCentro.add(pnlTotal);
            this._quadrosPanel.add(pnlTotal);
        }
        if (this._tela.getObservacoes() != null) {
            JLabel obs = new JLabel();
            obs.setText(this._tela.getObservacoes());
            obs.setForeground(Color.RED);
            obs.setFont(new Font("Tahoma", 1, 11));
            obs.setPreferredSize(new Dimension(600, 56));
            obs.setAlignmentX(0.5f);
            this.pnlCentro.add(obs);
        }
    }

    private TelaQuadro criaQuadro(Class<? extends TelaQuadroComum> classePainel, Remessa remessa, QuadroContas quadroContas, ActionListener btnPopupListener) {
        TelaQuadro quadro = null;
        try {
            quadro = classePainel.newInstance();
            this.inicializaPainelQuadro(quadro, remessa, quadroContas, btnPopupListener);
        }
        catch (ClassCastException e) {
            throw new ConfiguracaoException("Classe: " + classePainel.getName() + " n\u00e3o implementa a interface TelaQuadro.");
        }
        catch (InstantiationException e) {
            throw new ConfiguracaoException("Erro ao instanciar a classe: " + classePainel.getName() + ".");
        }
        catch (IllegalAccessException e) {
            throw new ConfiguracaoException("Erro ao instanciar a classe: " + classePainel.getName() + ".");
        }
        return quadro;
    }

    protected void inicializaPainelQuadro(TelaQuadro quadro, Remessa remessa, QuadroContas quadroContas, ActionListener btnPopupListener) {
        quadro.setQuadroContas(quadroContas);
        quadro.inicializaDadosPlanilha(this._tela.getIdentificadorConta());
        quadro.initializaDataBindings(remessa, this._bindingContext, quadroContas, btnPopupListener);
    }

    private void inicializaBindingQuadroTotal(BindingContext bindCtx, QuadroTotal quadroTotal, PainelQuadroTotal pnlTotal, List quadrosAjustes) {
        if (quadroTotal != null) {
            pnlTotal.inicializaBindingQuadroTotal(bindCtx, quadroTotal);
            for (int i = 0; i < quadrosAjustes.size(); ++i) {
                QuadroAjusteValores quadroAjuste = (QuadroAjusteValores)quadrosAjustes.get(i);
                quadroAjuste.adicionaNomeVOTotal(quadroTotal.getNomeViewObject());
                if (quadroTotal.getDetalheTotal() == null) continue;
                quadroAjuste.adicionaNomeVOTotal(quadroTotal.getDetalheTotal().getNomeViewObject());
            }
        }
    }

    @Override
    public void finalizaTela() {
        for (PadModelo quadro : this._quadrosPanel) {
            quadro.finalizaTela();
        }
    }

    public JUPanelBinding getPanelBinding() {
        return this._panelBinding;
    }

    @Override
    public boolean validaTela() {
        return true;
    }
}

