/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC220;
import br.gov.rs.tce.ws.validacao.client.SiapcLicitaconClient;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionAvancarUC220
extends PadAbstractAction {
    private static Log log = LogFactory.getLog(ActionAvancarUC220.class);

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) {
        ServicoPAD servicoPAD;
        ViewObject remessaViewObject;
        Row row;
        TelaUC220 telaUC220 = (TelaUC220)tela;
        if (!telaUC220.validaConsorcios()) {
            return false;
        }
        boolean consorcioPublico = telaUC220.isConsorcioPublico();
        Remessa remessa = ActionAvancarUC220.getRemessaSemAnoBiDataControl(binding);
        if (remessa != null) {
            remessa.setPossuiConsorcioPublico(consorcioPublico);
        }
        if ((row = (remessaViewObject = telaUC220.getRemessaViewObject()).first()) != null) {
            row.setAttribute("ConsorcioPublico", (Object)(consorcioPublico ? "S" : "N"));
        }
        if ((servicoPAD = telaUC220.getServicoPAD()).getTransaction().isDirty()) {
            servicoPAD.getTransaction().commit();
        }
        ViewObject consorcioViewObject = telaUC220.getConsorcioViewObject();
        long voRowCount = consorcioViewObject.getEstimatedRowCount();
        SiapcLicitaconClient.initialize();
        Connection conn = DatabaseHelper.getConnection(DatacontrolHelper.getServicoPADAppModule(binding));
        SiapcLicitaconClient.deleteAllContratosButEntidade(remessa.getCdEntidade(), conn);
        SiapcLicitaconClient.deleteAllLicitacoesButEntidade(remessa.getCdEntidade(), conn);
        SiapcLicitaconClient.deleteAllLicitacoesVencedoresButEntidade(remessa.getCdEntidade(), conn);
        ArrayList<Integer> cdEntidadeConsorcios = new ArrayList<Integer>();
        ServicoPAD ser = ActionAvancarUC220.getServicoPADAppModule(binding);
        ViewObject vo = ser.createViewObjectFromQueryStmt("UC220consorcios", "select distinct e.CD_ENTIDADE, e.nome, e.cd_entidade_pai from consorcios c inner join ENTIDADES e on lpad(trim(char(cgc)), '00000000000000') = e.cnpj");
        vo.executeQuery();
        long queryRowCount = 0L;
        while (vo.hasNext()) {
            Row r = vo.next();
            int cdEntidade = ((BigDecimal)r.getAttribute(0)).intValue();
            cdEntidadeConsorcios.add(cdEntidade);
            ++queryRowCount;
        }
        vo.closeRowSet();
        vo.remove();
        if (queryRowCount != voRowCount) {
            log.warn((Object)(voRowCount + " cons\u00f3rcios cadastrados, por\u00e9m apenas " + queryRowCount + " constam na tabela de entidades"));
        }
        try {
            if (cdEntidadeConsorcios.size() > 0) {
                for (Integer cdEntidade : cdEntidadeConsorcios) {
                    SiapcLicitaconClient.buscaLicitacoesVencedoresECarrega(cdEntidade, false, conn);
                    SiapcLicitaconClient.buscaContratosECarrega(cdEntidade, false, conn);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ActionAvancarUC220.exibeMensagemWarning(PadWizardHelper.getInstance().getForm(), "Erro ao consultar dados do TCE-RS [IOException: " + e.getMessage() + "]");
            return false;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            ActionAvancarUC220.exibeMensagemWarning(PadWizardHelper.getInstance().getForm(), "Erro ao consultar dados do TCE-RS [RuntimeException: " + e.getMessage() + "]");
            return false;
        }
        System.out.println("Action Avan\u00e7ar da TelaUC220 executada...");
        return true;
    }
}

