/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.servico.ServicoPADImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasViewRowImpl;
import br.gov.rs.tce.pad.util.EnviaArquivosHttp;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC088;
import br.gov.rs.tce.pcdi.ws.soap.webservice.Response;
import br.gov.rs.tce.ws.recepcao.client.RecepcaoWSClient;
import br.gov.rs.tce.ws.responsaveis.client.ResponsaveisWSClient;
import java.awt.Component;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.ViewObject;

public class ActionAvancarUC088
extends PadAbstractAction {
    public ActionAvancarUC088() {
        this.setCriaThreadTratamentoAcao(true);
    }

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        TelaUC088 t88 = (TelaUC088)tela;
        if (t88.usarServicoPcdi2()) {
            return this.enviarPCDI2(tela, binding);
        }
        throw new IllegalStateException("Servi\u00e7o ws-recepcao (pcdi2) n\u00e3o definido");
    }

    private RemessasViewRowImpl getRemessasViewRowImpl(BindingContext binding) {
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        ViewObject voRemCam = ser.findViewObject("RemessasDaEntidade");
        RemessasViewRowImpl remViewRow = (RemessasViewRowImpl)voRemCam.getCurrentRow();
        return remViewRow;
    }

    private boolean enviarPCDI2(PadModelo tela, BindingContext binding) {
        boolean ok = false;
        try {
            Remessa remessa = ActionAvancarUC088.getRemessaDataControl(binding);
            String aplicacao = null;
            aplicacao = remessa.getDataFinal() != null ? "padp" + remessa.getCdEntidade() + "I" : "pcdi" + remessa.getCdEntidade() + "I";
            BarraProgressoModel modelProgresso = new BarraProgressoModel();
            modelProgresso.setValueIsAdjusting(true);
            ((TelaUC088)tela).defineModeloProgresso(modelProgresso);
            ((TelaUC088)tela).isProgressoIndeterminado(true);
            ResponsaveisWSClient.initalize();
            RecepcaoWSClient.initalize();
            String AbsolutePath = new File("").getAbsolutePath();
            File fileRemessa = new File(AbsolutePath + "/remessa/remessa.dat");
            FileDataSource fileDataSource = new FileDataSource(fileRemessa);
            byte[] encoded = Files.readAllBytes(Paths.get(AbsolutePath + "/remessa/remessa_info.xml", new String[0]));
            String remessaInfo = new String(encoded, Charset.defaultCharset());
            Response reponseCode = remessa.getTipoOperacao() == 6 || remessaInfo.contains("cod-barras-rdi") ? RecepcaoWSClient.receberComplementar(new DataHandler((DataSource)fileDataSource), remessaInfo, fileRemessa.length()) : RecepcaoWSClient.receberNormal(new DataHandler((DataSource)fileDataSource), new String(encoded, Charset.defaultCharset()), fileRemessa.length());
            EnviaArquivosHttp.analisaResponse(reponseCode);
            ((TelaUC088)tela).setLabel("Arquivo enviado com sucesso");
            ((TelaUC088)tela).isProgressoIndeterminado(false);
            modelProgresso.setValue(modelProgresso.getMaximum());
            if (this.getRemessasViewRowImpl(binding).getEscolhidoPre().equalsIgnoreCase("S")) {
                ActionAvancarUC088.exibeMensagemAviso("Dados enviados com sucesso. Verifique o recibo da remessa no portal do TCE-RS:\nPortal TCE > Jurisdicionados > Sistemas de Controle Externo > SIAPC > Relat\u00f3rios e Recibos de Envio", (Component)((Object)tela));
            } else {
                ActionAvancarUC088.exibeMensagemAviso("Dados enviados com sucesso.", (Component)((Object)tela));
            }
            ok = true;
        }
        catch (Exception e) {
            ((TelaUC088)tela).isProgressoIndeterminado(false);
            e.printStackTrace();
            ActionAvancarUC088.exibeMensagemErro(e.getMessage(), (Component)((Object)tela));
        }
        return ok;
    }

    private class BarraProgressoModel
    extends DefaultBoundedRangeModel
    implements ChangeListener {
        public BarraProgressoModel() {
            this.setMinimum(0);
            this.setMaximum(100);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            EnviaArquivosHttp envio = (EnviaArquivosHttp)event.getSource();
            this.setValue(envio.getProgresso());
        }
    }
}

