/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.TipoEntidadesList;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.util.ProcessaArquivoHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC055Model;
import java.util.Collections;
import java.util.List;
import oracle.adf.model.BindingContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionAvancarUC055
extends PadAbstractAction {
    private static int _executaVerificacao = 1;
    private TelaUC055Model _modelUC055 = null;
    private static Log log = LogFactory.getLog(ActionAvancarUC055.class);

    public ActionAvancarUC055() {
        this.setCriaThreadTratamentoAcao(true);
    }

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        boolean avancaTela = false;
        this._modelUC055 = (TelaUC055Model)binding.get((Object)"modelUC055");
        ServicoPAD servicoPAD = DatacontrolHelper.getServicoPADAppModule(binding);
        Remessa remessa = PadAbstractAction.getRemessaDataControl(binding);
        if (_executaVerificacao == 1) {
            boolean arquivosModificados = false;
            if (remessa.getTipoOperacao() != 6) {
                arquivosModificados = this.verificaAlteracaoArquivosUC048(remessa, servicoPAD);
            }
            if (arquivosModificados) {
                PadAbstractAction.exibeMensagemAviso("<html>O sistema identificou que houve mudan\u00e7as nos arquivos de informa\u00e7\u00f5es com rela\u00e7\u00e3o aos dados anteriormente carregados,<BR> \u00e9 OBRIGAT\u00d3RIO que uma nova carga seja realizada, retorne a tela de carga dos tr\u00eas (3) arquivos!</html>", PadWizardHelper.getInstance().getForm());
                return false;
            }
            avancaTela = this._modelUC055.execute(binding);
            if (!avancaTela) {
                servicoPAD.criaJustificativasDeValidacao(remessa);
            }
        } else {
            avancaTela = true;
        }
        return avancaTela;
    }

    public static void setExecutaVerificacao(int executaVerificacao) {
        _executaVerificacao = executaVerificacao;
    }

    public static Integer getExecutaVerificacao() {
        return _executaVerificacao;
    }

    private boolean verificaAlteracaoArquivosUC048(Remessa remessa, ServicoPAD servicoPAD) {
        boolean modificados = false;
        if (!remessa.getTipoSetor().equals("C") && !TipoEntidadesList.getLeiPorTipoSetor(remessa.getTipoSetor()).equals("6404/76")) {
            Arquivos arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML(servicoPAD.resolveArquivoConfigFluxo(remessa.getTipoOperacao()));
            List<Arquivo> arquivosSel = Collections.unmodifiableList(arquivos.getArquivosPorLeiEntidade("UC048", remessa.getTipoSetor(), remessa.getPeriodoInformacoes(), remessa.getMes(), remessa.getTipoOperacao()));
            modificados = !ProcessaArquivoHelper.validaIntegridadeArquivosInformacoes(arquivosSel, remessa);
        }
        return modificados;
    }
}

