/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.ArquivoContabil;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoListener;
import br.gov.rs.tce.pad.modelo.importacao.RepositorioArquivosControleDerbyDBImpl;
import br.gov.rs.tce.pad.modelo.mensagem.MensagemFactory;
import br.gov.rs.tce.pad.modelo.servico.common.ContasModule;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.modelo.verificacao.VerificacaoArquivosControle;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.util.ProcessaArquivoHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC048;
import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.adf.model.BindingContext;
import oracle.jbo.ViewObject;

public class ActionAvancarUC048
extends PadAbstractAction {
    private static final String MSG_UC040_01 = "UC048-01";

    public ActionAvancarUC048() {
        this.setCriaThreadTratamentoAcao(true);
    }

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        SituacaoVerificacao situacao = new SituacaoVerificacao();
        Remessa remessa = ActionAvancarUC048.getRemessaDataControl(binding);
        ServicoPAD servicoPAD = DatacontrolHelper.getServicoPADAppModule(binding);
        Arquivos arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML(servicoPAD.resolveArquivoConfigFluxo(remessa.getTipoOperacao()));
        List<Arquivo> arquivosSel = Collections.unmodifiableList(arquivos.getArquivosPorLeiEntidade("UC048", remessa.getTipoSetor(), remessa.getPeriodoInformacoes(), remessa.getMes(), remessa.getTipoOperacao()));
        boolean avancaTela = true;
        boolean carregaArquivos = true;
        TelaUC048 t = (TelaUC048)tela;
        if (!t.getAvancar()) {
            if (remessa.isCargaArquivosSelecaoEfetuada()) {
                String mensagem = MensagemFactory.getInstancia().constroiMensagem(MSG_UC040_01).getTexto();
                carregaArquivos = ActionAvancarUC048.exibeMensagemSimNao(mensagem, (Component)((Object)tela));
            }
            if (!carregaArquivos) {
                boolean bl = carregaArquivos = !ProcessaArquivoHelper.validaIntegridadeArquivosInformacoes(arquivosSel, remessa);
                if (carregaArquivos) {
                    ActionAvancarUC048.exibeMensagemAviso("<html>O sistema identificou que houve mudan\u00e7as nos arquivos de informa\u00e7\u00f5es<br>com rela\u00e7\u00e3o aos dados anteriormente carregados, \u00e9 OBRIGAT\u00d3RIO que uma nova carga seja realizada !</html>", (Component)((Object)tela));
                } else {
                    t.setValueModeloBarrasProgressoMaximo();
                }
            }
            if (carregaArquivos) {
                situacao.setRemessa(remessa);
                ContasModule contasMod = DatacontrolHelper.getContasModuleAppModule(binding);
                ImportacaoListenerProgresso listener = new ImportacaoListenerProgresso();
                this.defineModelosBarrasProgresso(tela, listener);
                Connection conexao = null;
                try {
                    conexao = DatabaseHelper.getConnection(contasMod);
                    VerificacaoArquivosControle controle = new VerificacaoArquivosControle(arquivos);
                    this.removeChavesEstrangeiras(arquivosSel, conexao);
                    controle.verificaArquivos(situacao, conexao, listener, arquivosSel);
                }
                catch (RuntimeException th) {
                    th.printStackTrace();
                    throw th;
                }
                finally {
                    if (conexao != null) {
                        try {
                            conexao.commit();
                        }
                        catch (SQLException e) {
                            throw new PersistenciaException("10018", null, e);
                        }
                    }
                }
                contasMod.limpaContasRemessaCompleta();
                servicoPAD.limpaJustificativasPosCargaArquivos();
                if (situacao.isVerificacaoEfetuadaComSucesso()) {
                    remessa.setCargaArquivosSelecaoEfetuada(true);
                    ViewObject voRemessa = servicoPAD.findViewObject("RemessasDaEntidade");
                    voRemessa.getCurrentRow().setAttribute("SituacaoCarga", (Object)1);
                    remessa.adicionaIdentificadoresArquivo(situacao);
                    servicoPAD.salvaIdentificadoresIntegridadeArquivos(remessa);
                    ActionAvancarUC048.exibeMensagemAviso("Carga finalizada com sucesso.", (Component)((Object)tela));
                    avancaTela = true;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Erros encontrados na carga dos 3 arquivos:");
                        for (int i = 0; i < situacao.getMensagens().size(); ++i) {
                            log.debug((Object)situacao.getMensagens().get(i));
                        }
                    }
                    StringBuffer msg = new StringBuffer("<html>Carga finalizada por\u00e9m ocorreram erros:<ul type='Square'>");
                    for (int i = 0; i < arquivosSel.size(); ++i) {
                        Arquivo arq = arquivosSel.get(i);
                        MetadadosArquivoContabil meta = situacao.getArquivoPorIdentificador(arq.getIdentificador());
                        if (meta.getSituacao() == 1) continue;
                        if (meta.isErroChavePrimaria()) {
                            String[] camposPK = arq.getTabela().getChavePrimaria();
                            StringBuffer campoPK = new StringBuffer();
                            for (int j = 0; j < camposPK.length; ++j) {
                                campoPK.append(camposPK[j]);
                                if (j + 1 >= camposPK.length) continue;
                                campoPK.append(", ");
                            }
                            msg.append("<li>Arquivo n\u00e3o carregado: " + arq.getNome() + ", porque existem c\u00f3digos duplicados no campo: " + campoPK.toString() + ".</li>");
                            continue;
                        }
                        msg.append("<li>Arquivo n\u00e3o carregado: " + arq.getNome() + ", porque possui os seguintes erros na sua estrutura:");
                        msg.append("<ul type='Disc'>");
                        List<MensagemInstancia> lista = situacao.getMensagens();
                        int count = 0;
                        for (MensagemInstancia msgInstancia : lista) {
                            if (!msgInstancia.getArquivo().equals(meta.getArquivo().getNome())) continue;
                            if (count >= 10) {
                                msg.append("<li>Foram localizados mais de 10 erros neste arquivo, corrija-os e volte a executar a carga novamente.</li>");
                                break;
                            }
                            msg.append("<li>").append(msgInstancia.getCodigoMensagem()).append(": ").append(msgInstancia.getTexto()).append("</li>");
                            ++count;
                        }
                        msg.append("</ul></li>");
                    }
                    msg.append("</ul></html>");
                    ActionAvancarUC048.exibeMensagemAviso(msg.toString(), (Component)((Object)tela));
                    avancaTela = false;
                }
            }
            t.setAvancar(avancaTela);
            avancaTela = false;
        }
        this.salvaDadosRemessa(binding);
        return avancaTela;
    }

    private void removeChavesEstrangeiras(List<Arquivo> arquivosSel, Connection conexao) {
        for (int i = 0; i < arquivosSel.size(); ++i) {
            Arquivo arquivo = arquivosSel.get(i);
            RepositorioArquivosControleDerbyDBImpl.removeChavesEstrangeirasDaTabela(conexao, arquivo.getTabela().getNome());
        }
    }

    private void defineModelosBarrasProgresso(PadModelo tela, ImportacaoListenerProgresso listener) {
        TelaUC048 telaUC48 = (TelaUC048)tela;
        ModeloBarraProgresso modBalVer = new ModeloBarraProgresso(ArquivoContabil.BALANCETE_VERIFICACAO);
        ModeloBarraProgresso modBalRec = new ModeloBarraProgresso(ArquivoContabil.BALANCETE_RECEITA);
        ModeloBarraProgresso modRubrica = new ModeloBarraProgresso(ArquivoContabil.RUBRICA);
        listener.addModeloBarraProgresso(modBalVer);
        listener.addModeloBarraProgresso(modBalRec);
        listener.addModeloBarraProgresso(modRubrica);
        telaUC48.defineModelosBarrasProgresso(modRubrica, modBalRec, modBalVer);
    }

    private class ImportacaoListenerProgresso
    implements ImportacaoListener {
        private List<ModeloBarraProgresso> _listenerEventos = new ArrayList<ModeloBarraProgresso>(4);

        private ImportacaoListenerProgresso() {
        }

        public void addModeloBarraProgresso(ModeloBarraProgresso modeloBarra) {
            this._listenerEventos.add(modeloBarra);
        }

        @Override
        public void trataEvento(ImportacaoEvento evento) {
            block3: {
                block5: {
                    block4: {
                        if (evento.getTipoEvento() != 0) break block4;
                        for (int i = 0; i < this._listenerEventos.size(); ++i) {
                            ModeloBarraProgresso mod = this._listenerEventos.get(i);
                            if (!mod.isArquivoContabilRegistrado(evento.getArquivo().getArquivoContabilType())) continue;
                            MetadadosArquivoContabil meta = evento.getMetadadosArquivoAtual();
                            mod.setTamanhoArquivo(meta.getTamanhoArquivo());
                            mod.setTamanhoAtual(0L);
                            break block3;
                        }
                        break block3;
                    }
                    if (evento.getTipoEvento() != 1) break block5;
                    for (int i = 0; i < this._listenerEventos.size(); ++i) {
                        ModeloBarraProgresso mod = this._listenerEventos.get(i);
                        if (!mod.isArquivoContabilRegistrado(evento.getArquivo().getArquivoContabilType())) continue;
                        if (evento.getMetadadosArquivoAtual().getSituacao() != 1) break block3;
                        mod.setValue(100);
                        break block3;
                    }
                    break block3;
                }
                if (evento.getTipoEvento() != 3) break block3;
                for (int i = 0; i < this._listenerEventos.size(); ++i) {
                    ModeloBarraProgresso mod = this._listenerEventos.get(i);
                    if (!mod.isArquivoContabilRegistrado(evento.getArquivo().getArquivoContabilType())) continue;
                    mod.setTamanhoAtual(evento.getMetadadosArquivoAtual().getBytesLidos());
                    break;
                }
            }
        }
    }

    private class ModeloBarraProgresso
    implements BoundedRangeModel {
        private int _arqContabilTipoRegistrado;
        private long _tamanhoArquivo;
        private List<ChangeListener> _changeListener;
        private int _value;

        public ModeloBarraProgresso(ArquivoContabil arquivoContabil) {
            this._arqContabilTipoRegistrado = arquivoContabil.getType();
            this._changeListener = new ArrayList<ChangeListener>(1);
        }

        public boolean isArquivoContabilRegistrado(int arquivoContabilType) {
            return this._arqContabilTipoRegistrado == arquivoContabilType;
        }

        public void setTamanhoArquivo(long tamanho) {
            this._tamanhoArquivo = tamanho;
        }

        @Override
        public void setValue(int newValue) {
            this._value = newValue;
            this.notificaMudanca();
        }

        public void setTamanhoAtual(long tamanho) {
            int progresso;
            if (tamanho > 0L && (progresso = (int)((double)tamanho * 100.0 / (double)this._tamanhoArquivo)) != this._value) {
                this.setValue(progresso);
            }
        }

        private void notificaMudanca() {
            for (int i = 0; i < this._changeListener.size(); ++i) {
                this._changeListener.get(i).stateChanged(new ChangeEvent(this));
            }
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            this._changeListener.add(listener);
        }

        @Override
        public int getValue() {
            return this._value;
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            for (int i = 0; i < this._changeListener.size(); ++i) {
                ChangeListener obj = this._changeListener.get(i);
                if (obj != listener) continue;
                this._changeListener.remove(i);
            }
        }

        @Override
        public int getMaximum() {
            return 100;
        }

        @Override
        public int getMinimum() {
            return 0;
        }

        @Override
        public void setValueIsAdjusting(boolean val) {
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }

        @Override
        public void setRangeProperties(int x, int y, int a, int b, boolean adjusting) {
        }

        @Override
        public void setMinimum(int x) {
        }

        @Override
        public void setMaximum(int x) {
        }

        @Override
        public void setExtent(int x) {
        }

        @Override
        public int getExtent() {
            return 0;
        }
    }
}

