/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.servico.ServicoPADImpl;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC043;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Date;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionAvancarUC043
extends PadAbstractAction {
    private static final String TIPO_RESPONSAVEL = "A";
    private String TIPO_ENTIDADE = "P";
    private boolean resValidaMandato = true;

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        String poder = null;
        Remessa remessa = ActionAvancarUC043.getRemessaDataControl(binding);
        String tipoSetor = remessa.getTipoSetor();
        if (tipoSetor.equals("C")) {
            this.TIPO_ENTIDADE = "C";
        }
        if (remessa != null) {
            poder = remessa.getTipoSetor().equals("C") ? "LEGISLATIVO" : (remessa.getTipoSetor().equals("P") ? "EXECUTIVO" : "AUTARQUIA");
        }
        TelaUC043 t = (TelaUC043)tela;
        int status = this.popupTransactionDialog(binding, (Component)((Object)tela), "Administrador");
        boolean retorno = true;
        if (t.isCamposPreenchidos()) {
            if (status != 1) {
                boolean bl = retorno = status != 0 && t.validaTela();
                if (retorno) {
                    this.salvaDadosRemessa(binding);
                } else if (status == 0) {
                    if (!t.validaDatasMandato() || !t.validaMandato()) {
                        return false;
                    }
                    retorno = true;
                }
            } else {
                this.cancelaDadosRemessa(binding);
                retorno = this.validaQtdeAdministradores(t, binding);
            }
            if (retorno && t.avancaTela(poder)) {
                return true;
            }
        }
        return false;
    }

    private boolean validaQtdeAdministradores(TelaUC043 tela, BindingContext binding) {
        ServicoPAD ser = ActionAvancarUC043.getServicoPADAppModule(binding);
        ViewObject vo = ser.findViewObject("Responsaveis");
        if (vo != null && vo.getRowCount() <= 0) {
            ActionAvancarUC043.exibeMensagemAviso("\u00c9 obrigat\u00f3rio o cadastro de pelo menos UM Administrador!", tela);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validaMandatoAdministrador(TelaUC043 tela, BindingContext binding) {
        ServicoPADImpl ser = (ServicoPADImpl)ActionAvancarUC043.getServicoPADAppModule(binding);
        Remessa remessa = ActionAvancarUC043.getRemessaDataControl(binding);
        ViewObject vo = null;
        try {
            vo = ser.createViewObject("ValidaResponsaveisView", ser.getResponsaveis().getDefFullName());
            Row r = null;
            Date dtInicio = null;
            Date dtFim = null;
            String cpf = null;
            String tipoResponsavel = null;
            String tipoEntidade = null;
            String where_old = vo.getWhereClause();
            vo.setWhereClause("TP_RESPONSAVEL = ? AND ID_PREFEITURA_CAMARA = ?");
            vo.setWhereClauseParam(0, (Object)TIPO_RESPONSAVEL);
            vo.setWhereClauseParam(1, (Object)this.TIPO_ENTIDADE);
            vo.executeQuery();
            vo.first();
            vo.previous();
            while ((r = vo.next()) != null) {
                dtInicio = (Date)r.getAttribute("DtInicio");
                dtFim = (Date)r.getAttribute("DtTermino");
                cpf = ((BigDecimal)r.getAttribute("Cpf")).toString();
                tipoResponsavel = (String)r.getAttribute("TpResponsavel");
                if (!ser.validaMandatoResponsavel(tipoResponsavel, tipoEntidade = (String)r.getAttribute("IdPrefeituraCamara"), dtInicio, dtFim, cpf)) continue;
                ActionAvancarUC043.exibeMensagemAviso("<html>N\u00e3o deve haver sobreposi\u00e7\u00e3o de datas de mandatos de Administradores de um mesmo Poder<br> nem sobreposi\u00e7\u00e3o de datas de diferentes mandatos para um mesmo Administrador. <br></html>", tela);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return true;
    }
}

