/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.remessa.RemessaDataControlControle;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.excecao.PADRuntimeException;
import br.gov.rs.tce.pad.excecao.ValidacaoException;
import br.gov.rs.tce.pad.modelo.GeraArquivoBackup;
import br.gov.rs.tce.pad.modelo.RecuperaArquivoBackup;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC036;
import br.gov.rs.tce.pad.visao.panel.TelaUC039;
import br.gov.rs.tce.pad.visao.panel.TelaUC041;
import br.gov.rs.tce.pad.visao.panel.TelaUC060;
import br.gov.rs.tce.pad.visao.panel.TelaUC060B;
import br.gov.rs.tce.pad.visao.panel.TelaUC201;
import java.io.File;
import java.text.MessageFormat;
import oracle.adf.model.BindingContext;
import oracle.jbo.ViewObject;

public class ActionAvancarUC036
extends PadAbstractAction {
    private static final String MENSAGEM_DEVE_VERIFICAR_ANTES = "\u00c9 necess\u00e1rio ter executado a verifica\u00e7\u00e3o de arquivos pelo menos uma vez antes de realizar a consolida\u00e7\u00e3o";
    private static int _executaVerificacao = 0;
    private static final String AVISO_SUCESSO_BACKUP = "Arquivo de Backup gerado com sucesso";
    private static final String AVISO_SUCESSO_RESTORE = "Arquivo de Origem recuperado com sucesso. Entidade recuperada: ";
    private static final String AVISO_RESTORE_EXCLUSAO = "Os dados da remessa ser\u00e3o exclu\u00eddos para recuperar os dados do backup. Confirma opera\u00e7\u00e3o?";
    private static final String AVISO_ERRO_BACKUP = "N\u00e3o foi poss\u00edvel gerar arquivo de Backup. Verifique o destino";
    private static final String AVISO_ERRO_RESTORE = "Tipo de entidade do backup n\u00e3o corresponde ao tipo de entidade selecionada.";
    private static final String AVISO_ERRO_RESTORE_ARQUIVO = "Arquivo de Origem dos dados n\u00e3o \u00e9 valido";

    public static void setExecutaVerificacao(int executaVerificacao) {
        _executaVerificacao = executaVerificacao;
    }

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        Remessa remessa = DatacontrolHelper.getRemessaSemAnoBiDataControl(binding);
        TelaUC036 t = (TelaUC036)tela;
        ServicoPAD ser = ActionAvancarUC036.getServicoPADAppModule(binding);
        boolean retorno = false;
        if (t.validaTela()) {
            if (remessa.getTipoOperacao() == 0 || remessa.getTipoOperacao() != t.getValor()) {
                TelaUC039.limpaTabelasArquivos = 1;
            }
            remessa.setTipoOperacao(t.getValor());
            if (_executaVerificacao == 1) {
                TipoBancoDados TP_DATABASE = TipoBancoDados.DERBY_DB;
                if (remessa.getTipoOperacao() == 3) {
                    try {
                        GeraArquivoBackup gera = new GeraArquivoBackup(ser, new File(t.getPath()), ActionAvancarUC036.getRemessaDataControl(binding), TP_DATABASE);
                        gera.geraArquivo();
                        if (t.validaPath()) {
                            t.exibeMensagemInfo(AVISO_SUCESSO_BACKUP);
                        }
                    }
                    catch (Exception ex) {
                        t.exibeMensagemWarning(AVISO_ERRO_BACKUP);
                    }
                    remessa.setTipoOperacao(1);
                } else if (remessa.getTipoOperacao() == 4) {
                    try {
                        if (t.exibeConfirmacao(AVISO_RESTORE_EXCLUSAO) && t.validaPath()) {
                            TelaUC039.setFezBackup(true);
                            ser.limpaRemessa();
                            RecuperaArquivoBackup cons = new RecuperaArquivoBackup(ser);
                            cons.recuperaArquivoPrefeitura(new File(t.getPath()), remessa, 0);
                            remessa = this.getRemessaPrincipal(binding);
                            this.salvaDadosRemessa(binding);
                            ViewObject voRemessa = ser.findViewObject("RemessasDaEntidade");
                            voRemessa.clearCache();
                            voRemessa.executeQuery();
                            RemessaDataControlControle dc = (RemessaDataControlControle)binding.findDataControl("RemessaDataControl");
                            dc.inicializaControle();
                            t.exibeMensagemInfo(AVISO_SUCESSO_RESTORE + ser.getNomeEntidade(remessa));
                            Remessa remessaControle = ActionAvancarUC036.getRemessaSemAnoBiDataControl(binding);
                            remessaControle.setCargaArquivosSelecaoEfetuada(false);
                            remessaControle.setTipoOperacao(1);
                            TelaUC041._habilitarTelaUC041 = 1;
                            TelaUC060._habilitarTelaUC060 = 1;
                            TelaUC060B._habilitarTelaUC060B = 1;
                            TelaUC201._habilitarTelaUC201 = 1;
                        }
                    }
                    catch (PADRuntimeException pe) {
                        pe.printStackTrace();
                        t.exibeMensagemWarning(AVISO_ERRO_RESTORE);
                    }
                    catch (ValidacaoException vx) {
                        vx.printStackTrace();
                        t.exibeMensagemWarning(AVISO_ERRO_RESTORE_ARQUIVO);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                t.escondeItemArquivo();
                t.selecionaRadio();
            } else if (remessa.getTipoOperacao() == 2) {
                try {
                    this.getRemessaPrincipal(binding);
                    retorno = true;
                }
                catch (ConfiguracaoException ce) {
                    ActionAvancarUC036.exibeMensagemAviso(MessageFormat.format(MENSAGEM_DEVE_VERIFICAR_ANTES, new Object[0]), form);
                    retorno = false;
                }
            } else {
                retorno = true;
            }
        }
        log.debug((Object)("Transacao Modificada ? = " + binding.findDataControl("ServicoPADDataControl").isTransactionModified()));
        return retorno;
    }
}

