/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.modelo.servico.acessodados.ArquivosComplementaresViewRowImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasViewRowImpl;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadErrorDialog;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.panel.PadNavigationBar;
import br.gov.rs.tce.pad.visao.panel.TelaUC216RowSetListener;
import br.gov.rs.tce.pad.visao.panel.TelaUC216VariousListener;
import br.gov.rs.tce.siapc.exception.ResponsaveisFault;
import br.gov.rs.tce.ws.responsaveis.client.ResponsaveisWSClient;
import https.wsresponsaveis_tce_rs_gov.ResponsaveisWSPojo;
import https.wsresponsaveis_tce_rs_gov.ResponsavelWSPojo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.net.NoRouteToHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JUNavigationBar;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaUC216
extends JPanel
implements JUPanel,
PadModelo {
    static final Log log = LogFactory.getLog(TelaUC216.class);
    private static final long serialVersionUID = 1L;
    public static final String SIM = "S";
    public static final String NAO = "N";
    public static final String TIPO_PAD = "PD";
    public static final String TIPO_LD = "LD";
    public static final String TIPO_FP = "FP";
    public static final String TIPO_RP = "RP";
    public static final String NOME_PAD = "PAD";
    public static final String NOME_LD = "Livro Di\u00e1rio Geral";
    public static final String NOME_FP = "Folha de Pagamento";
    public static final String NOME_RP = "Receita P\u00fablica";
    public static final Long COD_LD = 10L;
    public static final Long COD_FP = 11L;
    public static final Long COD_RP = 12L;
    private final JPanel pnlSul = new JPanel();
    private JUNavigationBar navIndiretas;
    private final TelaUC216RowSetListener telaUC216RowSetListener = new TelaUC216RowSetListener(this);
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC216UIModel");
    private final JPanel dataPanel = new JPanel();
    private final BorderLayout borderLayout = new BorderLayout();
    private final GridLayout gridLayout = new GridLayout();
    private final JTable tableArquivosComplementaresDaRemessa = new JTable();
    private final JScrollPane scroller = new JScrollPane();

    public void jbInit() throws Exception {
        this.dataPanel.setLayout(this.gridLayout);
        this.dataPanel.setMinimumSize(new Dimension(100, 100));
        this.dataPanel.setBounds(new Rectangle(0, 100, 620, 200));
        this.dataPanel.setPreferredSize(new Dimension(620, 120));
        this.setLayout(this.borderLayout);
        this.setBounds(new Rectangle(0, 0, 620, 320));
        this.tableArquivosComplementaresDaRemessa.setModel((TableModel)this.panelBinding.bindUIControl("ArquivosComplementaresDaRemessa", (Object)this.tableArquivosComplementaresDaRemessa));
        this.scroller.setSize(new Dimension(620, 200));
        this.scroller.setPreferredSize(new Dimension(620, 120));
        this.navIndiretas = new PadNavigationBar(this);
        this.navIndiretas.setFloatable(false);
        this.navIndiretas.setHasExecuteButton(false);
        this.navIndiretas.setHasFindButton(false);
        this.scroller.getViewport().add((Component)this.tableArquivosComplementaresDaRemessa, null);
        this.dataPanel.add(this.scroller);
        this.add((Component)this.dataPanel, "Center");
        this.pnlSul.add((Component)this.navIndiretas, null);
        this.add((Component)this.pnlSul, "South");
        this.navIndiretas.setModel(JUNavigationBar.createViewBinding((JUPanelBinding)this.panelBinding, (JUNavigationBar)this.navIndiretas, (String)"ArquivosComplementaresDaRemessa", null, (String)"ArquivosComplementaresDaRemessaIter"));
        this.navIndiretas.setHasDeleteButton(false);
        this.navIndiretas.setHasInsertButton(false);
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(this.panelBinding.getBindingContext());
        ViewObject vo = ser.findViewObject("ArquivosComplementaresDaRemessa");
        vo.addListener((Object)this.telaUC216RowSetListener);
        this.preparaColunasTabela();
        this.preparaTamanhoCampos();
        this.consisteComponentesTela();
    }

    void consisteComponentesTela() {
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(this.panelBinding.getBindingContext());
        ViewObject vo = ser.findViewObject("ArquivosComplementaresDaRemessa");
        ArquivosComplementaresViewRowImpl arqRowCurr = (ArquivosComplementaresViewRowImpl)vo.getCurrentRow();
        if (arqRowCurr == null || SIM.equals(arqRowCurr.getSolicitado())) {
            // empty if block
        }
    }

    private void preparaTamanhoCampos() {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        }
        catch (ClassNotFoundException cnfe) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exemp) {
                exemp.printStackTrace();
            }
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC216 panel = new TelaUC216();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"ServicoPADDataControl", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    public void bindNestedContainer(JUPanelBinding ctr) {
        if (this.panelBinding.getPanel() == null) {
            ctr.setPanel((Object)this);
            this.panelBinding.release(DCDataControl.REL_VIEW_REFS);
            this.panelBinding = ctr;
            this.registerProjectGlobalVariables(this.panelBinding.getBindingContext());
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ctr.reportException((Throwable)ex);
            }
        }
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    private void preparaColunasTabela() {
        TableColumnModel mdl = this.tableArquivosComplementaresDaRemessa.getColumnModel();
        DefaultTableCellRenderer dtcrRight = new DefaultTableCellRenderer();
        dtcrRight.setHorizontalAlignment(4);
        mdl.getColumn(0).setHeaderValue("Tipo");
        mdl.getColumn(0).setPreferredWidth(100);
        mdl.getColumn(1).setHeaderValue("Respons\u00e1vel pelas informa\u00e7\u00f5es");
        mdl.getColumn(1).setPreferredWidth(260);
        mdl.getColumn(2).setHeaderValue("Solicitado?");
        mdl.getColumn(2).setPreferredWidth(60);
        TelaUC216VariousListener thelistener = new TelaUC216VariousListener(this);
        this.tableArquivosComplementaresDaRemessa.addPropertyChangeListener(thelistener);
        JTextField tf = new JTextField();
        tf.setEditable(false);
        DefaultCellEditor cellEditorDesabilitado = new DefaultCellEditor(tf);
        mdl.getColumn(1).setCellEditor(cellEditorDesabilitado);
        MouseListener[] listeners = this.tableArquivosComplementaresDaRemessa.getTableHeader().getMouseListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.tableArquivosComplementaresDaRemessa.getTableHeader().removeMouseListener(listeners[i]);
        }
        this.tableArquivosComplementaresDaRemessa.getTableHeader().setReorderingAllowed(false);
        this.tableArquivosComplementaresDaRemessa.getTableHeader().setResizingAllowed(false);
        this.tableArquivosComplementaresDaRemessa.grabFocus();
    }

    static String getTipoClicado(JTable jt) {
        int row = jt.getEditingRow();
        String dsTipo = (String)jt.getModel().getValueAt(row, 0);
        log.debug((Object)("getTipoClicado [" + dsTipo + "]"));
        if (NOME_PAD.equals(dsTipo)) {
            return TIPO_PAD;
        }
        if (NOME_FP.equals(dsTipo)) {
            return TIPO_FP;
        }
        if (NOME_RP.equals(dsTipo)) {
            return TIPO_RP;
        }
        return null;
    }

    @Override
    public void preparaTela() {
        try {
            this.popularResponsaveis();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.limpaTabela();
        }
    }

    @Override
    public void finalizaTela() {
    }

    @Override
    public boolean validaTela() {
        return true;
    }

    private void validaSelecaoTiposArquivos(ViewObject vo, String tipoClicado) {
        Row[] rows = vo.getAllRowsInRange();
        ArquivosComplementaresViewRowImpl rPAD = null;
        ArquivosComplementaresViewRowImpl rLIVRO = null;
        ArquivosComplementaresViewRowImpl rFOLHA = null;
        ArquivosComplementaresViewRowImpl rRECEITA = null;
        for (int i = 0; i < rows.length; ++i) {
            ArquivosComplementaresViewRowImpl aux = (ArquivosComplementaresViewRowImpl)rows[i];
            if (aux.getTipo().equals(TIPO_PAD)) {
                rPAD = aux;
                continue;
            }
            if (aux.getTipo().equals(TIPO_LD)) {
                rLIVRO = aux;
                continue;
            }
            if (aux.getTipo().equals(TIPO_FP)) {
                rFOLHA = aux;
                continue;
            }
            if (!aux.getTipo().equals(TIPO_RP)) continue;
            rRECEITA = aux;
        }
        if (rPAD != null && rPAD.getSolicitado().equals(NAO)) {
            rPAD.limpaCampos();
            if (rLIVRO != null) {
                rLIVRO.setSolicitado(NAO);
            }
            if (rRECEITA != null) {
                rRECEITA.setSolicitado(NAO);
            }
        }
        log.debug((Object)("tipoClicado [" + tipoClicado + "]: PAD = " + (rPAD != null ? rPAD.getSolicitadoBoolean() : "[NULL]") + " ; FOLHA = " + rFOLHA.getSolicitadoBoolean()));
        if (TIPO_PAD.equals(tipoClicado) && rPAD != null && rPAD.getSolicitadoBoolean().booleanValue()) {
            rFOLHA.setSolicitado(NAO);
        }
        if (TIPO_FP.equals(tipoClicado) && rFOLHA.getSolicitadoBoolean().booleanValue()) {
            if (rPAD != null) {
                rPAD.setSolicitado(NAO);
            }
            if (rRECEITA != null) {
                rRECEITA.setSolicitado(NAO);
            }
        }
        if (TIPO_RP.equals(tipoClicado) && rRECEITA != null && rRECEITA.getSolicitadoBoolean().booleanValue() && rFOLHA != null) {
            rFOLHA.setSolicitado(NAO);
        }
    }

    public String validaAvancar() {
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(this.panelBinding.getBindingContext());
        ViewObject vo = ser.findViewObject("ArquivosComplementaresDaRemessa");
        return this.validaAvancar(vo);
    }

    String validaAvancar(ViewObject vo) {
        Row[] rows = vo.getAllRowsInRange();
        ArquivosComplementaresViewRowImpl rLIVRO = null;
        ArquivosComplementaresViewRowImpl rFOLHA = null;
        ArquivosComplementaresViewRowImpl rRECEITA = null;
        for (int i = 0; i < rows.length; ++i) {
            ArquivosComplementaresViewRowImpl aux = (ArquivosComplementaresViewRowImpl)rows[i];
            if (aux.getTipo().equals(TIPO_PAD)) continue;
            if (aux.getTipo().equals(TIPO_LD)) {
                rLIVRO = aux;
                continue;
            }
            if (aux.getTipo().equals(TIPO_FP)) {
                rFOLHA = aux;
                continue;
            }
            if (!aux.getTipo().equals(TIPO_RP)) continue;
            rRECEITA = aux;
        }
        vo.clearCache();
        vo.first();
        if (rLIVRO != null && rLIVRO.getSolicitadoBoolean().booleanValue() && rFOLHA.getSolicitadoBoolean().booleanValue()) {
            return "N\u00e3o \u00e9 poss\u00edvel selecionar Livro Di\u00e1rio e Folha de Pagamento simultaneamente";
        }
        if (rLIVRO != null && rLIVRO.getSolicitadoBoolean().booleanValue() && rRECEITA != null && rRECEITA.getSolicitadoBoolean().booleanValue()) {
            return "N\u00e3o \u00e9 poss\u00edvel selecionar Livro Di\u00e1rio e Receita P\u00fablica simultaneamente";
        }
        if (rFOLHA.getSolicitadoBoolean().booleanValue() && rRECEITA != null && rRECEITA.getSolicitadoBoolean().booleanValue()) {
            return "N\u00e3o \u00e9 poss\u00edvel selecionar Folha de Pagamento e Receita P\u00fablica simultaneamente";
        }
        return null;
    }

    public ArquivosComplementaresViewRowImpl getRowPAD(ViewObject vo) {
        Row[] rows = vo.getAllRowsInRange();
        ArquivosComplementaresViewRowImpl rPAD = null;
        for (int i = 0; i < rows.length; ++i) {
            ArquivosComplementaresViewRowImpl aux = (ArquivosComplementaresViewRowImpl)rows[i];
            if (!aux.getTipo().equals(TIPO_PAD)) continue;
            rPAD = aux;
        }
        return rPAD;
    }

    void tableRowChanged_actionPerformed(Object src) {
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(this.panelBinding.getBindingContext());
        ViewObject vo = ser.findViewObject("ArquivosComplementaresDaRemessa");
        ArquivosComplementaresViewRowImpl arqRowCurr = (ArquivosComplementaresViewRowImpl)vo.getCurrentRow();
        String tipoClicado = null;
        if (src instanceof JTable) {
            JTable jt = (JTable)src;
            int row = jt.getEditingRow();
            log.debug((Object)("row: " + row));
            tipoClicado = TelaUC216.getTipoClicado(jt);
            log.debug((Object)("tipoClicado: " + tipoClicado));
        }
        if (arqRowCurr == null && this.tableArquivosComplementaresDaRemessa.getSelectedRow() >= 0) {
            vo.setCurrentRowAtRangeIndex(this.tableArquivosComplementaresDaRemessa.getSelectedRow());
            arqRowCurr = (ArquivosComplementaresViewRowImpl)vo.getCurrentRow();
            if (arqRowCurr != null) {
                log.info((Object)("arqRowCurr era null: " + this.tableArquivosComplementaresDaRemessa.getSelectedRow() + " // " + arqRowCurr.getTipo() + " / " + arqRowCurr.getSolicitado()));
            } else {
                log.info((Object)("arqRowCurr era null e continua null: " + this.tableArquivosComplementaresDaRemessa.getSelectedRow()));
            }
        }
        if (arqRowCurr == null) {
            return;
        }
        if (!SIM.equals(arqRowCurr.getSolicitado())) {
            arqRowCurr.limpaCampos();
        }
        this.validaSelecaoTiposArquivos(vo, tipoClicado);
        this.consisteComponentesTela();
    }

    void copiaInfoPADParaOutros() {
        ArquivosComplementaresViewRowImpl rTmp;
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(this.panelBinding.getBindingContext());
        ViewObject vo = ser.findViewObject("ArquivosComplementaresDaRemessa");
        ArquivosComplementaresViewRowImpl rCurr = (ArquivosComplementaresViewRowImpl)vo.getCurrentRow();
        ArquivosComplementaresViewRowImpl rPAD = rTmp = (ArquivosComplementaresViewRowImpl)vo.first();
        while (vo.hasNext()) {
            rTmp = (ArquivosComplementaresViewRowImpl)vo.next();
            if (!SIM.equals(rTmp.getSolicitado()) || rTmp.getMatriculaAuditor() != null && !"".equals(rTmp.getMatriculaAuditor()) || rTmp.getDtSolicitacao() != null || rTmp.getNomeAuditor() != null && !"".equals(rTmp.getNomeAuditor()) || rTmp.getNomeResponsavelEntidade() != null && !"".equals(rTmp.getNomeResponsavelEntidade()) || rTmp.getNrSolicitacao() != null && !"".equals(rTmp.getNrSolicitacao())) continue;
            rTmp.setMatriculaAuditor(rPAD.getMatriculaAuditor());
            rTmp.setDtSolicitacao(rPAD.getDtSolicitacao());
            rTmp.setNomeAuditor(rPAD.getNomeAuditor());
            rTmp.setNrSolicitacao(rPAD.getNrSolicitacao());
        }
        vo.setCurrentRow((Row)rCurr);
    }

    private void popularResponsaveis() throws Exception {
        List<ResponsavelWSPojo> responsaveis = TelaUC216.buscarResponsaveisComplementares((JUFormBinding)this.panelBinding);
        if (responsaveis == null) {
            log.warn((Object)"responsaveis eh NULL!");
            return;
        }
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(this.panelBinding.getBindingContext());
        ViewObject vo = ser.findViewObject("ArquivosComplementaresDaRemessa");
        ArquivosComplementaresViewRowImpl arqRowCurr = (ArquivosComplementaresViewRowImpl)vo.first();
        HashSet<Long> vinculoSetado = new HashSet<Long>();
        log.info((Object)("responsaveis.size() = " + responsaveis.size()));
        if (!responsaveis.isEmpty()) {
            while (vo.getCurrentRow() != null) {
                arqRowCurr = (ArquivosComplementaresViewRowImpl)vo.getCurrentRow();
                log.info((Object)("row: tipo=" + arqRowCurr.getTipo() + " ; dstipo=" + arqRowCurr.getDsTipo() + " ; solicitado=" + arqRowCurr.getSolicitado()));
                Long vinculoResponsavel = 0L;
                if (arqRowCurr.getDsTipo().equals(NOME_FP)) {
                    vinculoResponsavel = COD_FP;
                } else if (arqRowCurr.getDsTipo().equals(NOME_LD)) {
                    vinculoResponsavel = COD_LD;
                } else if (arqRowCurr.getDsTipo().equals(NOME_RP)) {
                    vinculoResponsavel = COD_RP;
                }
                for (ResponsavelWSPojo responsavel : responsaveis) {
                    if (!vinculoResponsavel.equals(responsavel.getVinculo())) continue;
                    if (!vinculoSetado.contains(vinculoResponsavel)) {
                        arqRowCurr.setNomeResponsavelEntidade(responsavel.getNome());
                        log.info((Object)("setando responsavel: nome: " + responsavel.getNome() + " / vinculo: " + vinculoResponsavel));
                        vinculoSetado.add(vinculoResponsavel);
                        continue;
                    }
                    log.info((Object)("vinculo j\u00e1 setado: nome: " + responsavel.getNome() + " / vinculo: " + vinculoResponsavel));
                }
                vo.next();
            }
            ser.getTransaction().commit();
        } else {
            log.warn((Object)("responsaveis vazio! [" + responsaveis.size() + "]"));
        }
    }

    private void limpaTabela() {
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(this.panelBinding.getBindingContext());
        ViewObject vo = ser.findViewObject("ArquivosComplementaresDaRemessa");
        ArquivosComplementaresViewRowImpl arqRowCurr = (ArquivosComplementaresViewRowImpl)vo.getCurrentRow();
        while (arqRowCurr != null) {
            arqRowCurr.limpaCampos();
            arqRowCurr.limpaResponsaveis();
            vo.next();
            arqRowCurr = (ArquivosComplementaresViewRowImpl)vo.getCurrentRow();
        }
        ser.getTransaction().commit();
    }

    private String consultaNomeContabilista() {
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(this.panelBinding.getBindingContext());
        ViewObject vo = ser.findViewObject("RemessasDaEntidade");
        RemessasViewRowImpl rCurr = (RemessasViewRowImpl)vo.getCurrentRow();
        return rCurr.getContabilista();
    }

    public static List<ResponsavelWSPojo> buscarResponsaveisComplementares(JUFormBinding panelBinding) throws Exception {
        List<ResponsavelWSPojo> responsaveis = null;
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(panelBinding.getBindingContext());
        ViewObject vo = ser.findViewObject("RemessasDaEntidade");
        Row r = vo.getCurrentRow();
        try {
            ResponsaveisWSClient.initalize();
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            String dtFinalCompl = df.format(new Date());
            String dtExercicio = "01/01/" + r.getAttribute("AnoExercicio");
            Long cdEntidade = Long.valueOf(r.getAttribute("CdEntidade").toString());
            log.info((Object)("-> buscarResponsaveisComplementares: org=" + cdEntidade + " ; dtExercicio=" + dtExercicio + " ; dtFinalCompl=" + dtFinalCompl));
            ResponsaveisWSPojo responsaveisPojo = ResponsaveisWSClient.buscarResponsaveisComplementares(cdEntidade, dtExercicio, dtFinalCompl);
            if (responsaveisPojo == null || responsaveisPojo.getResponsavel().isEmpty()) {
                throw new ResponsaveisFault("N\u00e3o existem respons\u00e1veis complementares definidos para o \u00f3rg\u00e3o. Favor atualizar as informa\u00e7\u00f5es no SISCAD.");
            }
            if (responsaveisPojo != null) {
                responsaveis = responsaveisPojo.getResponsavel();
            }
        }
        catch (ResponsaveisFault e) {
            TelaUC216.exibeMensagemWarning(e);
            throw e;
        }
        catch (SOAPFaultException e) {
            TelaUC216.exibeMensagemWarning((Exception)((Object)e));
            throw e;
        }
        catch (NoRouteToHostException e) {
            TelaUC216.exibeMensagemWarning(e);
            throw e;
        }
        catch (WebServiceException e) {
            TelaUC216.exibeMensagemWarning((Exception)((Object)e));
            throw e;
        }
        catch (IllegalStateException e) {
            TelaUC216.exibeMensagemWarning(e);
            throw e;
        }
        catch (Exception e) {
            TelaUC216.exibeMensagemErro(e, panelBinding);
            throw e;
        }
        return responsaveis;
    }

    private static void exibeMensagemErro(Exception e, JUFormBinding panelBinding) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        PadErrorDialog errorDialog = new PadErrorDialog(form);
        errorDialog.reportException(panelBinding, e);
    }

    private static void exibeMensagemWarning(Exception e) {
        String message = "Erro ao consultar dados de respons\u00e1veis.\n\n[" + e.getMessage() + "]";
        log.warn((Object)message, (Throwable)e);
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        JOptionPane.showMessageDialog(form, message, "Aten\u00e7\u00e3o", 2);
    }
}

