/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.resource.PadImage;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.util.SiscadUtil;
import br.gov.rs.tce.pad.util.VersaoUtils;
import br.gov.rs.tce.pad.visao.PadDesktop;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.panel.DialogSenhas;
import br.gov.rs.tce.siapc.exception.ResponsaveisFault;
import br.gov.rs.tce.ws.responsaveis.client.ResponsaveisWSClient;
import https.wsresponsaveis_tce_rs_gov.EntidadeSatbWSPojo;
import https.wsresponsaveis_tce_rs_gov_br.Exception;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.NoRouteToHostException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import oracle.adf.model.BindingContext;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaApresentacao
extends JPanel
implements PadModelo {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TelaApresentacao.class);
    private JPanel panelCentro;
    private JPanel panelSul;
    private XYLayout xYLayout1 = new XYLayout();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private JLabel jLabel5 = new JLabel();
    private JLabel jLabel6 = new JLabel();
    private JLabel jLabel7 = new JLabel();
    private JLabel jLabel8 = new JLabel();
    private JLabel jLabel9 = new JLabel();
    private JButton jBttChave = new JButton();
    private ImageIcon chaveIcon = PadImage.createImageIcon("imagens/chave.gif");
    private JButton jBttReload = new JButton();
    private ImageIcon reloadIcon = PadImage.createImageIcon("imagens/icone_reload.png");
    private BorderLayout borderLayout1 = new BorderLayout();
    private BindingContext _bindingContext;

    public TelaApresentacao() {
        super(new BorderLayout());
        try {
            this.jbInit();
        }
        catch (java.lang.Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws java.lang.Exception {
        this.setBackground(Color.white);
        this.jBttChave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaApresentacao.this.jBttChave_actionPerformed(e);
            }
        });
        this.jBttReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaApresentacao.this.jBttReload_actionPerformed(e);
            }
        });
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(374, 363));
        this.add((Component)this.constroePanelSul(), "South");
        this.add((Component)this.constroePanelCentro(), "Center");
    }

    private void jBttChave_actionPerformed(ActionEvent e) {
        Remessa remessa = (Remessa)this._bindingContext.findDataControl("RemessaDataControl").getDataProvider();
        Container a = this.getParent();
        while (!((a = a.getParent()) instanceof PadWizardForm)) {
        }
        new DialogSenhas((Frame)((PadWizardForm)a), "Informe a senha fornecida pelo TCE-RS", true, remessa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jBttReload_actionPerformed(ActionEvent e) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        form.defineCursor(3);
        try {
            List<EntidadeSatbWSPojo> entidades = this.consultaWebServiceListaEntidades();
            SiscadUtil.atualizaEntidades(entidades, this._bindingContext);
        }
        finally {
            form.defineCursor(0);
        }
    }

    private JPanel constroePanelCentro() {
        this.panelCentro = new JPanel();
        this.panelCentro.setLayout(null);
        this.panelCentro.setBackground(Color.white);
        this.jLabel1.setText("Bem vindo ao Programa Autenticador de Dados!");
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setBounds(new Rectangle(20, 30, 355, 15));
        this.jLabel2.setText("O PAD automatizar\u00e1 a verifica\u00e7\u00e3o dos arquivos do SIAPC");
        this.jLabel2.setFont(new Font("Tahoma", 0, 12));
        this.jLabel2.setBounds(new Rectangle(30, 85, 325, 15));
        this.jLabel3.setText("Suas funcionalidades s\u00e3o:");
        this.jLabel3.setFont(new Font("Tahoma", 0, 12));
        this.jLabel3.setBounds(new Rectangle(30, 125, 185, 15));
        this.jLabel5.setText("* Verifica\u00e7\u00e3o e autentica\u00e7\u00e3o dos arquivos do SIAPC;");
        this.jLabel5.setFont(new Font("Tahoma", 0, 12));
        this.jLabel5.setBounds(new Rectangle(45, 155, 320, 15));
        this.jLabel6.setText("* Grava\u00e7\u00e3o das remessas, original e backup;");
        this.jLabel6.setFont(new Font("Tahoma", 0, 12));
        this.jLabel6.setBounds(new Rectangle(45, 185, 315, 15));
        this.jLabel7.setText("* Emiss\u00e3o do Relat\u00f3rio de Valida\u00e7\u00e3o e Encaminhamento;");
        this.jLabel7.setFont(new Font("Tahoma", 0, 12));
        this.jLabel7.setBounds(new Rectangle(45, 215, 325, 15));
        this.jLabel8.setText("* Emiss\u00e3o dos demonstrativos da LRF;");
        this.jLabel8.setFont(new Font("Tahoma", 0, 12));
        this.jLabel8.setBounds(new Rectangle(45, 245, 275, 15));
        this.jLabel9.setText("* Emiss\u00e3o do alerta previsto no \u00a71\u00ba do artigo 59 da LRF");
        this.jLabel9.setFont(new Font("Tahoma", 0, 12));
        this.jLabel9.setBounds(new Rectangle(45, 275, 320, 15));
        this.panelCentro.add((Component)this.jLabel9, null);
        this.panelCentro.add((Component)this.jLabel8, null);
        this.panelCentro.add((Component)this.jLabel7, null);
        this.panelCentro.add((Component)this.jLabel6, null);
        this.panelCentro.add((Component)this.jLabel5, null);
        this.panelCentro.add((Component)this.jLabel3, null);
        this.panelCentro.add((Component)this.jLabel2, null);
        this.panelCentro.add((Component)this.jLabel1, null);
        return this.panelCentro;
    }

    private JPanel constroePanelSul() {
        this.panelSul = new JPanel();
        this.panelSul.setBackground(Color.white);
        this.panelSul.setLayout((LayoutManager)this.xYLayout1);
        this.jBttReload.setBackground(Color.white);
        this.jBttReload.setBorder(BorderFactory.createLineBorder(Color.white, 1));
        this.jBttReload.setIcon(this.reloadIcon);
        this.jBttReload.setToolTipText("Recarrega entidades a partir do cadastro do SISCAD");
        this.jBttChave.setBackground(Color.white);
        this.jBttChave.setBorder(BorderFactory.createLineBorder(Color.white, 1));
        this.jBttChave.setIcon(this.chaveIcon);
        this.jBttChave.setToolTipText("Senha para rotinas cont\u00e1beis");
        this.panelSul.add((Component)this.jBttReload, new XYConstraints(360, 10, 20, 20));
        this.panelSul.add((Component)this.jBttChave, new XYConstraints(380, 10, 20, 20));
        return this.panelSul;
    }

    @Override
    public void preparaTela() {
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        this._bindingContext = bindCtx;
    }

    @Override
    public final void finalizaTela() {
    }

    List<EntidadeSatbWSPojo> consultaWebServiceListaEntidades() {
        try {
            ResponsaveisWSClient.initalize();
            return ResponsaveisWSClient.listaEntidadesAtualizadas(SiscadUtil.buscaEntidadesNroAnos);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            if (e.getMessage().indexOf("invalid JAXP api or implementation") > -1) {
                TelaApresentacao.exibeMensagemWarning(this, "Erro ao estabelecer conex\u00e3o com o TCE. Poss\u00edvel problema de cadastro no SISCAD.");
            } else {
                TelaApresentacao.exibeMensagemWarning(this, "Erro inesperado: " + e.getMessage());
            }
        }
        catch (ResponsaveisFault e) {
            TelaApresentacao.exibeMensagemWarning(this, e.getMessage());
        }
        catch (SOAPFaultException e) {
            e.printStackTrace();
            TelaApresentacao.exibeMensagemWarning(this, e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Exce\u00e7\u00e3o wsclient: " + e);
            e.printStackTrace();
            TelaApresentacao.exibeMensagemWarning(this, e.getMessage());
        }
        catch (NoRouteToHostException e) {
            e.printStackTrace();
            TelaApresentacao.exibeMensagemWarning(this, "N\u00e3o foi poss\u00edvel estabelecer conex\u00e3o com o TCE. Favor verifique sua conex\u00e3o com a internet. Caso o erro persista, entre em contato com o TCE.");
        }
        catch (WebServiceException e) {
            log.warn((Object)("WebServiceException: " + (Object)((Object)e)));
            e.printStackTrace();
            TelaApresentacao.exibeMensagemWarning(this, "N\u00e3o foi poss\u00edvel estabelecer conex\u00e3o com o TCE. Favor verifique sua conex\u00e3o com a internet. Caso o erro persista, entre em contato com o TCE.");
        }
        catch (java.lang.Exception e) {
            e.printStackTrace();
            TelaApresentacao.exibeMensagemWarning(this, e.getMessage());
        }
        return null;
    }

    @Override
    public boolean validaTela() {
        VersaoUtils validaVersao = new VersaoUtils(DatacontrolHelper.getServicoPADAppModule(this._bindingContext));
        PadWizardForm padForm = PadWizardHelper.getInstance().getForm();
        File databaseDir = new File(System.getProperty("user.dir") + File.separator + "database");
        if (validaVersao.getVersaoPADDatabase() == null) {
            TelaApresentacao.exibeMensagemWarning(padForm, " Foi detectado que a base de dados em uso n\u00e3o corresponde \u00e0 vers\u00e3o do PAD instalada na m\u00e1quina.\n O PAD deve ser instalado novamente em um diret\u00f3rio vazio e nenhum arquivo deve ser alterado ap\u00f3s\n o t\u00e9rmino do procedimento.");
            padForm.setTitle("PAD " + PadDesktop.getVersaoTitulo() + " (Base de Dados Inv\u00e1lida)");
            return false;
        }
        if (!VersaoUtils.hasWritePermission(databaseDir)) {
            TelaApresentacao.exibeMensagemWarning(padForm, " Foi detectado que o usu\u00e1rio atual n\u00e3o possui permiss\u00e3o de escrita na pasta de instala\u00e7\u00e3o do PAD.\n O PAD deve ser instalado novamente em um diret\u00f3rio com permiss\u00e3o de escrita para o usu\u00e1rio que executar\u00e1 o PAD.");
            padForm.setTitle("PAD " + PadDesktop.getVersaoTitulo() + " (Pasta de instala\u00e7\u00e3o Inv\u00e1lida)");
            return false;
        }
        int versaoJava = VersaoUtils.getJavaVersion();
        if (versaoJava <= 6) {
            log.error((Object)("versaoJava [" + versaoJava + "] <= 6: vers\u00e3o n\u00e3o suportada"));
            TelaApresentacao.exibeMensagemWarning(padForm, " Foi detectado que o PAD est\u00e1 sendo executado com uma m\u00e1quina virtual Java n\u00e3o suportada (vers\u00e3o menor que 1.7)");
            padForm.setTitle("PAD " + PadDesktop.getVersaoTitulo() + " (Vers\u00e3o do Java n\u00e3o suportada)");
            return false;
        }
        if (versaoJava == 7) {
            log.warn((Object)("versaoJava [" + versaoJava + "] = 7: possivelmente n\u00e3o ser\u00e1 suportada em vers\u00f5es futuras do PAD"));
        } else {
            log.info((Object)("versaoJava [" + versaoJava + "] ok"));
        }
        padForm.setTitle("PAD " + PadDesktop.getVersaoTitulo());
        return true;
    }

    public static void exibeMensagemWarning(Component parentComponent, String mensagem) {
        JOptionPane.showMessageDialog(parentComponent, mensagem, "Aten\u00e7\u00e3o", 2);
    }
}

