/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao;

import br.gov.rs.tce.pad.beans.TipoJustificativa;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAjudaAction;
import br.gov.rs.tce.pad.visao.action.PadAvancarAction;
import br.gov.rs.tce.pad.visao.action.PadFecharAction;
import br.gov.rs.tce.pad.visao.action.PadImprimirAction;
import br.gov.rs.tce.pad.visao.action.PadObservacoesAction;
import br.gov.rs.tce.pad.visao.action.PadSobreAction;
import br.gov.rs.tce.pad.visao.action.PadVoltarAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class PadWizardControle
extends JPanel {
    public static final String AVANCAR = "Avan\u00e7ar >";
    public static final String FECHAR = "Fechar";
    public static final String VOLTAR = "< Voltar";
    public static final String AJUDA = "Ajuda";
    public static final String SOBRE = "Sobre";
    public static final String IMPRIMIR = "Imprimir";
    public static final String VERIFICAR = "Verificar";
    public static final String CARREGAR = "Carregar";
    public static final String CONSOLIDAR = "Consolidar";
    public static final String ENVIAR = "Enviar";
    public static final String GRAVAR = "Gravar";
    public static final String ASSINAR_REMESSA = "Assinar";
    public static final String GERAR_REMESSA = "Gerar";
    public static final String PROCESSAR = "Processar";
    public static final String OBSERVACOES = "Observa\u00e7\u00f5es";
    public static final int LARGURA = 85;
    public static final int ALTURA = 23;
    private JButton btNext;
    private JButton btBack;
    private JButton btClose;
    private JButton btAbout;
    private JButton btHelp;
    private JButton btPrint;
    private JButton btObservacoes;
    private PadAvancarAction avancarAction;
    private PadVoltarAction voltarAction;
    private PadFecharAction fecharAction;
    private PadAjudaAction ajudaAction;
    private PadSobreAction sobreAction;
    private PadImprimirAction imprimirAction;
    private PadObservacoesAction observacoesAction;

    public PadWizardControle() {
        super(new BorderLayout());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            this.inicializaActions();
            this.inicializaPanel();
            this.btPrint.setVisible(false);
            this.btObservacoes.setVisible(false);
            this.habilitaBotaoVoltar(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void inicializaActions() {
        this.avancarAction = new PadAvancarAction(AVANCAR, "", 65);
        this.voltarAction = new PadVoltarAction(VOLTAR, "Volta a tela anterior.", 86);
        this.fecharAction = new PadFecharAction(FECHAR, "Fecha o programa.", 70);
        this.ajudaAction = new PadAjudaAction(AJUDA, "Exibe ajuda da tela atual.", 74);
        this.sobreAction = new PadSobreAction(SOBRE, "Exibe informa\u00e7\u00f5es sobre o PAD.", 83);
        this.imprimirAction = new PadImprimirAction(IMPRIMIR, "Imprimir o relat\u00f3rio.", 80);
        this.observacoesAction = new PadObservacoesAction(OBSERVACOES, "Escrever Observa\u00e7\u00f5es.", 79);
    }

    private void inicializaPanel() {
        this.createButtons();
        this.addButtons();
    }

    private void createButtons() {
        this.btNext = new JButton(this.avancarAction);
        this.btBack = new JButton(this.voltarAction);
        this.btClose = new JButton(this.fecharAction);
        this.btAbout = new JButton(this.sobreAction);
        this.btHelp = new JButton(this.ajudaAction);
        this.btPrint = new JButton(this.imprimirAction);
        this.btObservacoes = new JButton(this.observacoesAction);
        this.btNext.setPreferredSize(new Dimension(85, 23));
        this.btBack.setPreferredSize(new Dimension(85, 23));
        this.btClose.setPreferredSize(new Dimension(85, 23));
        this.btAbout.setPreferredSize(new Dimension(85, 23));
        this.btHelp.setPreferredSize(new Dimension(85, 23));
        this.btPrint.setPreferredSize(new Dimension(85, 23));
        this.btObservacoes.setPreferredSize(new Dimension(100, 23));
    }

    private void addButtons() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createPanelAbout(), "West");
        mainPanel.add((Component)this.createPanelControl(), "Center");
        mainPanel.add((Component)this.createPanelEnd(), "East");
        this.add((Component)new JSeparator(), "North");
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createPanelAbout() {
        JPanel panelStart = new JPanel();
        panelStart.add(this.btAbout);
        panelStart.add(this.btHelp);
        panelStart.add(this.btPrint);
        panelStart.add(this.btObservacoes);
        return panelStart;
    }

    private JPanel createPanelControl() {
        JPanel panelCenter = new JPanel();
        panelCenter.add(this.btBack);
        panelCenter.add(this.btNext);
        return panelCenter;
    }

    private JPanel createPanelEnd() {
        JPanel panelEnd = new JPanel();
        panelEnd.add(this.btClose);
        return panelEnd;
    }

    public void habilitaBotaoAvancar(boolean value) {
        this.btNext.setEnabled(value);
        this.repaintAvancar();
    }

    public void setDefaultFocus() {
        PadWizardHelper.getInstance().getForm().getRootPane().setDefaultButton(this.btNext);
        this.btNext.requestFocus();
    }

    public void setaNomeAvancar(String value) {
        this.btNext.setText(value);
    }

    public void setaLarguraAvancar(int largura) {
        this.btNext.setPreferredSize(new Dimension(largura, 23));
    }

    public void habilitaBotaoVoltar(boolean value) {
        this.btBack.setEnabled(value);
        this.repaintVoltar();
    }

    public void habilitaBotaoFechar(boolean value) {
        this.btClose.setEnabled(value);
    }

    public void habilitaBotaoImprimir(boolean value) {
        this.btPrint.setEnabled(value);
    }

    public void mostraBotaoImprimir(boolean value) {
        this.btPrint.setVisible(value);
    }

    public void habilitaBotaoObservacoes(boolean value, TipoJustificativa tjus, Integer cdPlanilia, Component c) {
        this.btObservacoes.setEnabled(value);
        this.btObservacoes.setVisible(value);
        this.observacoesAction.setParams(tjus, cdPlanilia, c);
    }

    public void repaintAvancar() {
        this.btNext.repaint();
    }

    public void repaintVoltar() {
        this.btBack.repaint();
    }
}

