/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.pad.beans.CabecalhoArquivo;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public final class ResolveStringConstantes {
    private static final String[] ARRAY_NOMES_CONTANTES = new String[]{"ANO_EXERCICIO_REMESSA", "ANO_EXERCICIO_ANTERIOR_REMESSA", "BIMESTRE_FINAL", "BIMESTRE_ANTERIOR_INICIAL", "MES_FINAL", "MES_ANTERIOR_INICIAL", "ENTIDADE_INDIRETA", "DATA_INICIAL_CABECALHO", "DATA_FINAL_CABECALHO", "ANO_EXERCICIO_ANTERIOR_CABECALHO", "ANO_EXERCICIO_CABECALHO", "MES_FINAL_EXTENSO", "MES_ANTERIOR_INICIAL_EXTENSO", "EH_PREFEITURA_CAMARA", "CD_ENTIDADE", "DATA_ATUAL", "DATA_FINAL_CABECALHO_STR_YMD"};
    private static final String ANO_EXERCICIO_REMESSA = ARRAY_NOMES_CONTANTES[0];
    private static final String ANO_EXERCICIO_ANTERIOR_REMESSA = ARRAY_NOMES_CONTANTES[1];
    private static final String BIMESTRE_FINAL = ARRAY_NOMES_CONTANTES[2];
    private static final String BIMESTRE_ANTERIOR_INICIAL = ARRAY_NOMES_CONTANTES[3];
    private static final String MES_FINAL = ARRAY_NOMES_CONTANTES[4];
    private static final String MES_ANTERIOR_INICIAL = ARRAY_NOMES_CONTANTES[5];
    private static final String ENTIDADE_INDIRETA = ARRAY_NOMES_CONTANTES[6];
    private static final String DATA_INICIAL_CABECALHO = ARRAY_NOMES_CONTANTES[7];
    private static final String DATA_FINAL_CABECALHO = ARRAY_NOMES_CONTANTES[8];
    private static final String ANO_EXERCICIO_ANTERIOR_CABECALHO = ARRAY_NOMES_CONTANTES[9];
    private static final String ANO_EXERCICIO_CABECALHO = ARRAY_NOMES_CONTANTES[10];
    private static final String MES_FINAL_EXTENSO = ARRAY_NOMES_CONTANTES[11];
    private static final String MES_ANTERIOR_INICIAL_EXTENSO = ARRAY_NOMES_CONTANTES[12];
    private static final String EH_PREFEITURA_CAMARA = ARRAY_NOMES_CONTANTES[13];
    private static final String CD_ENTIDADE = ARRAY_NOMES_CONTANTES[14];
    private static final String DATA_ATUAL = ARRAY_NOMES_CONTANTES[15];
    private static final String DATA_FINAL_CABECALHO_STR_YMD = ARRAY_NOMES_CONTANTES[16];
    static NumberFormat nfInteger;
    static DateFormat nfData;
    static DateFormat nfMesExtenso;
    static DateFormat nfYMD;

    private ResolveStringConstantes() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getValorString(String nomeConstante, Remessa remessa, CabecalhoArquivo cabecalho) {
        Object valor = null;
        int tamanho = nomeConstante.length() - 1;
        if (remessa == null) throw new IllegalStateException("Verifique o algoritmo que chamou este m\u00e9todo, o valor da remessa do arquivo nao est\u00e1 disponivel (null).");
        if (nomeConstante.equals(EH_PREFEITURA_CAMARA)) {
            valor = remessa.getTipoSetor().equals("P") || remessa.getTipoSetor().equals("C") ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        if (nomeConstante.charAt(0) == 'A') {
            if (nomeConstante.charAt(tamanho) == 'A') {
                if (nomeConstante.equals(ANO_EXERCICIO_REMESSA)) {
                    return remessa.getAnoExercicio();
                }
                if (!nomeConstante.equals(ANO_EXERCICIO_ANTERIOR_REMESSA)) return valor;
                return remessa.getAnoExercicio() - 1;
            }
            if (nomeConstante.charAt(tamanho) != 'O') return valor;
            if (cabecalho == null) throw new IllegalStateException("Verifique o algoritmo que chamou este m\u00e9todo, o valor do cabe\u00e7alho do arquivo nao est\u00e1 disponivel (null).");
            if (nomeConstante.equals(ANO_EXERCICIO_ANTERIOR_CABECALHO)) {
                return cabecalho.getAnoExercicio() - 1;
            }
            if (!nomeConstante.equals(ANO_EXERCICIO_CABECALHO)) return valor;
            return cabecalho.getAnoExercicio();
        }
        if (nomeConstante.charAt(0) == 'D') {
            if (nomeConstante.equals(DATA_ATUAL)) {
                return new java.sql.Date(new Date().getTime());
            }
            if (cabecalho == null) throw new IllegalStateException("Verifique o algoritmo que chamou este m\u00e9todo, o valor do cabe\u00e7alho do arquivo nao est\u00e1 disponivel (null).");
            if (nomeConstante.equals(DATA_INICIAL_CABECALHO)) {
                return cabecalho.getDataInicial();
            }
            if (nomeConstante.equals(DATA_FINAL_CABECALHO)) {
                return cabecalho.getDataFinal();
            }
            if (!nomeConstante.equals(DATA_FINAL_CABECALHO_STR_YMD)) return valor;
            Date dtFinal = cabecalho.getDataFinal();
            return nfYMD.format(dtFinal);
        }
        if (nomeConstante.charAt(0) == 'B') {
            if (remessa == null) return valor;
            if (nomeConstante.equals(BIMESTRE_ANTERIOR_INICIAL)) {
                return remessa.getBimestreAnteriorInicial();
            }
            if (!nomeConstante.equals(BIMESTRE_FINAL)) return valor;
            return remessa.getPeriodoInformacoes();
        }
        if (nomeConstante.charAt(0) == 'M') {
            if (remessa == null) return valor;
            if (nomeConstante.equals(MES_ANTERIOR_INICIAL)) {
                return remessa.getMesAnteriorInicial();
            }
            if (nomeConstante.equals(MES_FINAL)) {
                if (remessa.getMesFinalInformacoes() != 12) return remessa.getMesFinalInformacoes() + 1;
                return 12;
            }
            if (nomeConstante.equals(MES_ANTERIOR_INICIAL_EXTENSO)) {
                GregorianCalendar cal = new GregorianCalendar(new Locale("pt", "BR"));
                cal.set(5, 1);
                cal.set(2, remessa.getMesAnteriorInicial() - 1);
                return nfMesExtenso.format(cal.getTime());
            }
            if (!nomeConstante.equals(MES_FINAL_EXTENSO)) return valor;
            GregorianCalendar cal = new GregorianCalendar(new Locale("pt", "BR"));
            cal.set(5, 1);
            cal.set(2, remessa.getMesFinalInformacoes());
            return nfMesExtenso.format(cal.getTime());
        }
        if (nomeConstante.charAt(0) == 'E') {
            if (remessa == null) return valor;
            if (!nomeConstante.equals(ENTIDADE_INDIRETA)) return valor;
            return 0;
        }
        if (nomeConstante.charAt(0) != 'C') return valor;
        if (remessa == null) return valor;
        if (!nomeConstante.equals(CD_ENTIDADE)) return valor;
        return remessa.getCdEntidade();
    }

    public static String formataStringComConstantes(String texto, Remessa remessa) {
        return ResolveStringConstantes.formataStringComConstantes(texto, remessa, null);
    }

    public static String formataStringComConstantes(String texto, Remessa remessa, CabecalhoArquivo cabecalho) {
        if (texto != null) {
            StringBuffer textoBuffer = new StringBuffer(texto);
            Object[] valores = ResolveStringConstantes.extraiNomesContantes(textoBuffer, remessa, cabecalho);
            Locale loc = new Locale("pt", "BR");
            MessageFormat formato = new MessageFormat(textoBuffer.toString(), loc);
            for (int i = 0; i < valores.length; ++i) {
                if (valores[i] instanceof Integer) {
                    formato.setFormatByArgumentIndex(i, nfInteger);
                    continue;
                }
                if (!(valores[i] instanceof Date)) continue;
                formato.setFormatByArgumentIndex(i, nfData);
            }
            StringBuffer textoFormatado = new StringBuffer(textoBuffer.length());
            formato.format(valores, textoFormatado, (FieldPosition)null);
            return textoFormatado.toString();
        }
        return null;
    }

    private static Object[] extraiNomesContantes(StringBuffer texto, Remessa remessa, CabecalhoArquivo cabecalho) {
        int numConstantes = 0;
        for (int i = 0; i < texto.length(); ++i) {
            if (texto.charAt(i) != '{') continue;
            ++numConstantes;
        }
        Object[] constantes = new Object[numConstantes];
        int inicio = 0;
        int fim = 0;
        int idxConstante = 0;
        int tamanho = texto.length();
        for (int i = 0; i < tamanho; ++i) {
            if (texto.charAt(i) == '{') {
                inicio = i + 1;
                continue;
            }
            if (texto.charAt(i) != '}') continue;
            fim = i;
            String constante = texto.substring(inicio, fim);
            constantes[idxConstante] = ResolveStringConstantes.getValorString(constante, remessa, cabecalho);
            texto.delete(inicio, fim);
            String txtIdxConstante = String.valueOf(idxConstante);
            texto.insert(inicio, txtIdxConstante);
            ++idxConstante;
            i -= fim - inicio;
            i += txtIdxConstante.length();
            tamanho -= fim - inicio;
            tamanho += txtIdxConstante.length();
        }
        return constantes;
    }

    static {
        nfMesExtenso = new SimpleDateFormat("MMMMM", new Locale("pt", "BR"));
        nfYMD = new SimpleDateFormat("yyyy-MM-dd");
        nfInteger = NumberFormat.getIntegerInstance(new Locale("pt", "BR"));
        nfInteger.setGroupingUsed(false);
        nfData = new SimpleDateFormat("dd/MM/yyyy", new Locale("pt", "BR"));
        nfMesExtenso = new SimpleDateFormat("MMMMM", new Locale("pt", "BR"));
    }
}

