/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertiesUtil {
    protected static final Log log = LogFactory.getLog(PropertiesUtil.class);
    private static final String ARQUIVO_PROPERTIES = "conf/pad.properties";

    public static String carregaProperty(String key) {
        String value = null;
        try {
            File file = new File(ARQUIVO_PROPERTIES);
            FileInputStream is = null;
            Properties props = null;
            is = new FileInputStream(file);
            props = new Properties();
            props.load(is);
            value = props.getProperty(key);
            if (value != null) {
                log.info((Object)(key + ": " + value));
            } else {
                log.debug((Object)(key + " is null"));
            }
            ((InputStream)is).close();
            props.clear();
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        return value;
    }

    public static Integer carregaPropertyInteger(String key) {
        try {
            String valor = PropertiesUtil.carregaProperty(key);
            return Integer.parseInt(valor);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean carregaPropertyBoolean(String key, boolean def) {
        try {
            String valor = PropertiesUtil.carregaProperty(key);
            return "true".equals(valor);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static boolean getPropertyPermiteAvancarComErros() {
        return PropertiesUtil.carregaPropertyBoolean("pad.permiteAvancarComErros", false);
    }
}

