/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.assdigital.excecao.AssinaturaDigitalException;
import br.gov.rs.tce.assdigital.modelo.seguranca.AssinaturaDigitalControle;
import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.IdentificadorArquivo;
import br.gov.rs.tce.pad.beans.IdentificadorArquivoVerificacao;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.SegurancaException;
import br.gov.rs.tce.pad.modelo.seguranca.CriptografiaControle;
import br.gov.rs.tce.pad.util.CompactacaoHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProcessaArquivoHelper {
    protected static final Log log = LogFactory.getLog(ProcessaArquivoHelper.class);

    public static File[] listaArquivos(File diretorio) {
        return CompactacaoHelper.buscaArquivos(diretorio);
    }

    public List constroiListaArquivosDigestDiferente(String arqServidor, File arqOrigem) {
        ArrayList<String> retorno = new ArrayList<String>();
        Map<IdentificadorArquivo, IdentificadorArquivoVerificacao> arquivosOrigem = ProcessaArquivoHelper.criaListaIdentificadorArquivoVerificacao(CompactacaoHelper.buscaArquivos(arqOrigem));
        Map arquivosServidor = this.separaValoresDigest(arqServidor);
        for (IdentificadorArquivoVerificacao objectFileOrigem : arquivosOrigem.values()) {
            IdentificadorArquivoVerificacao objectFileServidor;
            if (objectFileOrigem.validaIntegridadeArquivo((objectFileServidor = (IdentificadorArquivoVerificacao)arquivosServidor.get(objectFileOrigem.getIdentificadorArquivo())).getDisgestArquivo())) continue;
            retorno.add(objectFileOrigem.getIdentificadorArquivo().toString());
        }
        return retorno;
    }

    public File compactaArquivos(File diretorioOrigem, File arquivoDestino, List arquivos) {
        CompactacaoHelper ch = new CompactacaoHelper();
        File[] files = new File[arquivos.size()];
        File destino = new File(diretorioOrigem + File.separator + arquivoDestino);
        for (int i = 0; i < arquivos.size(); ++i) {
            files[i] = new File(diretorioOrigem + File.separator + (String)arquivos.get(i));
        }
        ch.compacta(files, destino);
        return destino;
    }

    public void criptografaArquivos(File origem, File destino, String senha) throws SegurancaException, FileNotFoundException {
        CriptografiaControle.criptografa(origem, destino, senha);
    }

    public void descriptografaArquivos(File origem, File destino, String senha) throws SegurancaException, FileNotFoundException {
        CriptografiaControle.descriptografa(origem, destino, senha);
    }

    public static Map<IdentificadorArquivo, IdentificadorArquivoVerificacao> criaListaIdentificadorArquivoVerificacao(File[] arquivos) {
        MessageDigest digester;
        HashMap<IdentificadorArquivo, IdentificadorArquivoVerificacao> retorno = new HashMap<IdentificadorArquivo, IdentificadorArquivoVerificacao>();
        try {
            digester = AssinaturaDigitalControle.createDigest();
        }
        catch (AssinaturaDigitalException e) {
            throw new SegurancaException(e);
        }
        for (int i = 0; i < arquivos.length; ++i) {
            if (arquivos[i] == null) continue;
            IdentificadorArquivo idArq = Arquivo.criaIdenficadorArquivo(arquivos[i].getName());
            if (arquivos[i].exists()) {
                try {
                    IdentificadorArquivoVerificacao d = new IdentificadorArquivoVerificacao(idArq, AssinaturaDigitalControle.calculaDigest(arquivos[i], digester));
                    retorno.put(idArq, d);
                    continue;
                }
                catch (AssinaturaDigitalException e) {
                    throw new SegurancaException(e);
                }
            }
            log.warn((Object)("arquivo " + arquivos[i].getName() + " n\u00e3o encontrado"));
        }
        return retorno;
    }

    private Map separaValoresDigest(String valores) {
        HashMap<IdentificadorArquivo, IdentificadorArquivoVerificacao> retorno = new HashMap<IdentificadorArquivo, IdentificadorArquivoVerificacao>();
        String[] arquivos = valores.split(";");
        for (int i = 0; i < arquivos.length; ++i) {
            String valor = arquivos[i];
            String[] fileNamesDisgest = valor.split(",");
            if (fileNamesDisgest.length <= 1) continue;
            IdentificadorArquivoVerificacao d = new IdentificadorArquivoVerificacao(Arquivo.criaIdenficadorArquivo(fileNamesDisgest[0].trim()), fileNamesDisgest[1]);
            retorno.put(d.getIdentificadorArquivo(), d);
        }
        return retorno;
    }

    public static boolean validaIntegridadeArquivosInformacoes(List<Arquivo> arquivosSel, Remessa remessa) {
        boolean ok = true;
        int qtdArquivos = arquivosSel.size();
        File[] arquivosFisicos = new File[qtdArquivos];
        for (int i = 0; i < qtdArquivos; ++i) {
            Arquivo arquivo = arquivosSel.get(i);
            StringBuffer diretorio = new StringBuffer(remessa.getDiretorioOrigem());
            if (diretorio.charAt(diretorio.length() - 1) != File.separatorChar) {
                diretorio.append(File.separator);
            }
            arquivosFisicos[i] = new File(diretorio + arquivo.getNome());
        }
        Map<IdentificadorArquivo, IdentificadorArquivoVerificacao> disgestArquivos = ProcessaArquivoHelper.criaListaIdentificadorArquivoVerificacao(arquivosFisicos);
        for (IdentificadorArquivoVerificacao identVer : disgestArquivos.values()) {
            if (remessa.validaIntegridadeArquivoVerificacao(identVer.getIdentificadorArquivo(), identVer.getDisgestArquivo())) continue;
            ok = false;
            log.info((Object)("Erro validaIntegridadeArquivosInformacoes: " + identVer.getIdentificadorArquivo()));
            break;
        }
        return ok;
    }

    public static Map searchHashFileExist(List arquivosSel, Remessa remessa) {
        boolean ok = true;
        int qtdArquivos = arquivosSel.size();
        File[] arquivosFisicos = new File[qtdArquivos];
        Map<IdentificadorArquivo, IdentificadorArquivoVerificacao> disgestArquivos = null;
        boolean achou = false;
        for (int i = 0; i < qtdArquivos; ++i) {
            File file;
            Arquivo arquivo = (Arquivo)arquivosSel.get(i);
            StringBuffer diretorio = new StringBuffer(remessa.getDiretorioOrigem());
            if (diretorio.charAt(diretorio.length() - 1) != File.separatorChar) {
                diretorio.append(File.separator);
            }
            if (!(file = new File(diretorio + arquivo.getNome())).exists()) continue;
            achou = true;
            arquivosFisicos[i] = new File(diretorio + arquivo.getNome());
        }
        if (achou) {
            disgestArquivos = ProcessaArquivoHelper.criaListaIdentificadorArquivoVerificacao(arquivosFisicos);
        }
        return disgestArquivos;
    }

    public static List<String> todosIdsArqComplem() {
        ArrayList<String> idsArquivos = new ArrayList<String>();
        idsArquivos.add("TCE_4810");
        idsArquivos.add("TCE_4820");
        idsArquivos.add("TCE_4960");
        idsArquivos.add("TCE_4010");
        idsArquivos.add("TCE_4810_6404");
        idsArquivos.add("TCE_4820_6404");
        idsArquivos.add("TCE_4960_6404");
        idsArquivos.add("PAGTO_POS");
        idsArquivos.add("PENSIONISTA");
        idsArquivos.add("DEPENDENTE");
        return idsArquivos;
    }
}

