/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras.fun;

import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraLinha;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FUN09
extends RegraLinha {
    public static final String LINHAS = "verificacao.FUN09.linhas";
    public static final String FUNCOES = "verificacao.FUN09.funcoes";
    public static final int F99 = 99;
    public static final int MAX_LINHAS = 60;

    @Override
    public void executaRegraVerificacaoLinha(ImportacaoEvento evento, ValoresCampos valoresCampos, Long numeroLinha) {
        try {
            ContextoVerificacao contexto = evento.getContextoVerificacao();
            ArrayList<Long> linhas = (ArrayList<Long>)contexto.getAtributo(LINHAS);
            if (linhas == null) {
                linhas = new ArrayList<Long>();
                contexto.adicionaAtributo(LINHAS, linhas);
            }
            if (evento.getTipoEvento() == 3) {
                HashMap<Integer, String> funcoes = (HashMap<Integer, String>)contexto.getAtributo(FUNCOES);
                if (funcoes == null) {
                    Connection _conexao = (Connection)contexto.getAtributo("pad.conexaoDB");
                    Statement stmt = _conexao.createStatement();
                    ResultSet rs = stmt.executeQuery("select cd_funcao, ds_funcao from funcoes_portaria");
                    funcoes = new HashMap<Integer, String>();
                    while (rs.next()) {
                        funcoes.put(rs.getInt("cd_funcao"), rs.getString("ds_funcao"));
                    }
                    contexto.adicionaAtributo(FUNCOES, funcoes);
                }
                Integer codFuncao = (Integer)valoresCampos.getValorCampo("codFuncao");
                String nomeFuncao = (String)valoresCampos.getValorCampo("nomeFuncao");
                String dsFuncaoPortaria = null;
                if (funcoes.containsKey(codFuncao)) {
                    dsFuncaoPortaria = (String)funcoes.get(codFuncao);
                    if (!dsFuncaoPortaria.equals(FUN09.escapeString(nomeFuncao)) && !codFuncao.equals(99)) {
                        linhas.add(numeroLinha);
                    }
                } else {
                    linhas.add(numeroLinha);
                }
            } else if (evento.getTipoEvento() == 1 && linhas != null && linhas.size() > 0) {
                Object[] argumentos = new Object[]{FUN09.converteLinhastoTxt(linhas)};
                this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), evento.getArquivo(), argumentos);
            }
        }
        catch (SQLException e) {
            System.out.println("erro = " + e.getMessage());
        }
    }

    private static String converteLinhastoTxt(List<Long> linhas) {
        StringBuilder retorno = new StringBuilder();
        for (int i = 0; i < linhas.size(); ++i) {
            Long linha = linhas.get(i);
            retorno.append(linha);
            if (linhas.size() > 60 && i == 59) {
                retorno.append(" e outras");
                break;
            }
            if (i == linhas.size() - 2) {
                retorno.append(" e ");
                continue;
            }
            if (i >= linhas.size() - 1) continue;
            retorno.append(", ");
        }
        return retorno.toString();
    }

    private static String escapeString(String funcao) {
        if (funcao == null) {
            return null;
        }
        String retorno = funcao.toUpperCase();
        String[] caracteres = new String[]{"\u00c1", "\u00c2", "\u00c0", "\u00c3", "\u00c9", "\u00ca", "\u00c8", "\u00cd", "\u00cc", "\u00d3", "\u00d4", "\u00d2", "\u00d5", "\u00da", "\u00d9", "\u00dc", "\u00c7"};
        String[] replaceChars = new String[]{"A", "A", "A", "A", "E", "E", "E", "I", "I", "O", "O", "O", "O", "U", "U", "U", "C"};
        for (int i = 0; i < caracteres.length; ++i) {
            retorno = StringUtils.replace((String)retorno, (String)caracteres[i], (String)replaceChars[i]);
        }
        return retorno;
    }
}

