/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras.cre;

import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraLinha;

public class CRE15
extends RegraLinha {
    public static final String CONTADOR_CRE15 = "verificacao.CRE15.contador";
    public static final String CONTADOR_GERAL_CRE15 = "verificacao.CRE15.contadorGeral";

    @Override
    public void executaRegraVerificacaoLinha(ImportacaoEvento evento, ValoresCampos valoresCampos, Long numeroLinha) {
        ContextoVerificacao contexto = evento.getContextoVerificacao();
        Integer contador = (Integer)contexto.getAtributo(CONTADOR_CRE15);
        Integer contadorGeral = (Integer)contexto.getAtributo(CONTADOR_GERAL_CRE15);
        if (contador == null) {
            contador = 0;
        }
        if (contadorGeral == null) {
            contadorGeral = 0;
        }
        if (evento.getTipoEvento() == 3) {
            String uf = (String)valoresCampos.getValorCampo("uf");
            String endereco = (String)valoresCampos.getValorCampo("endereco");
            String cidade = (String)valoresCampos.getValorCampo("cidade");
            contadorGeral = contadorGeral + 1;
            contexto.adicionaAtributo(CONTADOR_GERAL_CRE15, contadorGeral);
            if (uf == null && endereco == null && cidade == null || uf.equals("") && endereco.equals("") && cidade.equals("")) {
                contador = contador + 1;
                contexto.adicionaAtributo(CONTADOR_CRE15, contador);
            }
        } else if (evento.getTipoEvento() == 1) {
            Double percentual;
            if (contador > 0 && (percentual = Double.valueOf((double)contador.intValue() * 100.0 / (double)contadorGeral.intValue())) > 0.0) {
                Object[] argumentos = new Object[]{percentual.intValue()};
                this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), evento.getArquivo(), argumentos);
            }
            contexto.removeAtributo(CONTADOR_CRE15);
            contexto.removeAtributo(CONTADOR_GERAL_CRE15);
        }
    }
}

