/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras;

import java.util.regex.Pattern;

public class RegraDVContaCorrente {
    static final Pattern zeros = Pattern.compile("0+");
    static final Pattern noves = Pattern.compile("9+");
    static final Pattern ultimoDigitoChar = Pattern.compile("\\d+[a-zA-Z]?");

    public static boolean verificaZeroNoves(String numContaCorrenteSG) {
        return zeros.matcher(numContaCorrenteSG).matches() || noves.matcher(numContaCorrenteSG).matches();
    }

    public static boolean verificaCaractereApenasNoUltimoDigito(String str) {
        return ultimoDigitoChar.matcher(str).matches();
    }

    public static boolean verificaDVConta(Integer codBancoSG, String codAgenciaBancoSG, String numContaCorrenteSG) {
        boolean ok = false;
        if (codBancoSG != null) {
            boolean ehZeros = false;
            if (codBancoSG == 41) {
                String numContaCorrenteVal;
                if (zeros.matcher(RegraDVContaCorrente.substringAte(numContaCorrenteSG, 10)).matches()) {
                    ehZeros = true;
                }
                if ((numContaCorrenteVal = RegraDVContaCorrente.substringApos(numContaCorrenteSG, 10)).length() == 10) {
                    ok = RegraDVContaCorrente.validaContaBanrisul(numContaCorrenteVal);
                }
            } else if (codBancoSG == 1) {
                String numContaCorrenteVal;
                if (zeros.matcher(RegraDVContaCorrente.substringAte(numContaCorrenteSG, 11)).matches()) {
                    ehZeros = true;
                }
                if ((numContaCorrenteVal = RegraDVContaCorrente.substringApos(numContaCorrenteSG, 11)).length() == 9) {
                    ok = RegraDVContaCorrente.validaContaBancoBrasil(numContaCorrenteVal);
                }
            } else if (codBancoSG == 237) {
                String numContaCorrenteVal;
                if (zeros.matcher(RegraDVContaCorrente.substringAte(numContaCorrenteSG, 12)).matches()) {
                    ehZeros = true;
                }
                if ((numContaCorrenteVal = RegraDVContaCorrente.substringApos(numContaCorrenteSG, 12)).length() == 8) {
                    ok = RegraDVContaCorrente.validaContaBancoBradesco(numContaCorrenteVal);
                }
            } else if (codBancoSG == 341) {
                String numContaCorrenteVal;
                if (zeros.matcher(RegraDVContaCorrente.substringAte(numContaCorrenteSG, 14)).matches()) {
                    ehZeros = true;
                }
                if ((numContaCorrenteVal = RegraDVContaCorrente.substringApos(numContaCorrenteSG, 14)).length() == 6 && codAgenciaBancoSG.length() >= 4) {
                    ok = RegraDVContaCorrente.validaContaBancoItau(codAgenciaBancoSG, numContaCorrenteVal);
                }
            } else if (codBancoSG == 399) {
                String numContaCorrenteVal;
                if (zeros.matcher(RegraDVContaCorrente.substringAte(numContaCorrenteSG, 13)).matches()) {
                    ehZeros = true;
                }
                if ((numContaCorrenteVal = RegraDVContaCorrente.substringApos(numContaCorrenteSG, 13)).length() == 7 && codAgenciaBancoSG.length() >= 4) {
                    ok = RegraDVContaCorrente.validaContaBancoHSBC(codAgenciaBancoSG, numContaCorrenteVal);
                }
            } else {
                ehZeros = true;
                ok = true;
            }
            if (!ehZeros) {
                ok = false;
            }
        }
        return ok;
    }

    static String substringAte(String str, int len) {
        if (str == null) {
            return "";
        }
        if (str.length() > len) {
            return str.substring(0, len);
        }
        return str;
    }

    static String substringApos(String str, int pos) {
        if (str == null) {
            return "";
        }
        if (str.length() > pos) {
            return str.substring(pos);
        }
        return "";
    }

    static boolean validaContaBanrisul(String numConta) {
        StringBuilder auxConta = new StringBuilder();
        auxConta.append(numConta.charAt(2));
        auxConta.append(numConta.charAt(0));
        auxConta.append(numConta.charAt(1));
        auxConta.append(numConta.substring(3, 10));
        int base = 2;
        int soma = 0;
        for (int i = 8; i >= 0; --i) {
            soma += (auxConta.charAt(i) - 48) * base;
            if ((base = (int)((byte)(base + 1))) <= 7) continue;
            base = 2;
        }
        char digito = (char)(soma % 11);
        digito = digito == '\u0000' ? (char)'0' : (digito == '\u0001' ? (char)'6' : (char)(11 - digito + 48));
        return digito == numConta.charAt(9);
    }

    static boolean validaContaBancoBrasil(String numConta) {
        StringBuilder auxConta = new StringBuilder();
        auxConta.append(numConta.substring(0, 8));
        int base = 2;
        int soma = 0;
        for (int i = 7; i >= 0; --i) {
            soma += (auxConta.charAt(i) - 48) * base;
            base = (byte)(base + 1);
        }
        int digito = soma % 11;
        digito = 11 - digito;
        char v_digito = (char)(digito + 48);
        if (digito == 10) {
            v_digito = 'X';
        } else if (digito == 11) {
            v_digito = '0';
        }
        return v_digito == 'X' ? numConta.charAt(8) == 'X' || numConta.charAt(8) == 'x' : v_digito == numConta.charAt(8);
    }

    static boolean validaContaBancoBradesco(String numConta) {
        char v_digito;
        StringBuilder auxConta = new StringBuilder();
        auxConta.append(numConta.substring(0, 7));
        int base = 2;
        int soma = 0;
        for (int i = 6; i >= 0; --i) {
            soma += (auxConta.charAt(i) - 48) * base;
            if ((base = (int)((byte)(base + 1))) <= 7) continue;
            base = 2;
        }
        int digito = soma % 11;
        if (digito == 0) {
            v_digito = '0';
        } else if (digito == 1) {
            v_digito = 'P';
        } else {
            digito = 11 - digito;
            v_digito = (char)(digito + 48);
        }
        return v_digito == numConta.charAt(7);
    }

    static boolean validaContaBancoSantander(String numAgencia, String numConta) {
        char v_digito;
        StringBuilder auxConta = new StringBuilder();
        auxConta.append(numAgencia.substring(1));
        auxConta.append("00");
        auxConta.append(numConta);
        int valor_multiplicado = 0;
        byte[] base = new byte[]{9, 7, 3, 1, 0, 0, 9, 7, 1, 3, 1, 9, 7, 3};
        int soma = 0;
        for (int i = 13; i >= 0; --i) {
            valor_multiplicado = (auxConta.charAt(i) - 48) * base[i];
            valor_multiplicado = RegraDVContaCorrente.extraiDezena(valor_multiplicado);
            soma += valor_multiplicado;
        }
        int digito = 10 - (soma = RegraDVContaCorrente.extraiDezena(soma));
        if (digito == 10) {
            digito = 0;
        }
        return (v_digito = (char)(digito + 48)) == numConta.charAt(8) && RegraDVContaCorrente.validaTipoConta(numConta);
    }

    static boolean validaContaBancoCEF(String numAgencia, String numConta) {
        char v_digito;
        StringBuilder auxConta = new StringBuilder();
        auxConta.append(numAgencia.substring(1));
        auxConta.append(numConta);
        int base = 2;
        int soma = 0;
        for (int i = 14; i >= 0; --i) {
            soma += (auxConta.charAt(i) - 48) * base;
            if ((base = (int)((byte)(base + 1))) <= 9) continue;
            base = 2;
        }
        int digito = (soma *= 10) % 11;
        if (digito == 10) {
            digito = 0;
        }
        return (v_digito = (char)(digito + 48)) == numConta.charAt(11);
    }

    static boolean validaContaBancoItau(String numAgencia, String numConta) {
        StringBuilder auxConta = new StringBuilder();
        auxConta.append(numAgencia.substring(1));
        auxConta.append(numConta);
        int valor_multiplicado = 0;
        int base = 2;
        int soma = 0;
        for (int i = 8; i >= 0; --i) {
            valor_multiplicado = (auxConta.charAt(i) - 48) * base;
            valor_multiplicado = RegraDVContaCorrente.somaDezena(valor_multiplicado);
            soma += valor_multiplicado;
            base = base == 2 ? 1 : 2;
        }
        int digito = soma % 10;
        digito = digito == 0 ? 0 : 10 - digito;
        char v_digito = (char)(digito + 48);
        return v_digito == numConta.charAt(5);
    }

    static boolean validaContaBancoReal(String numAgencia, String numConta) {
        StringBuilder auxConta = new StringBuilder();
        auxConta.append(numAgencia.substring(1));
        auxConta.append(numConta);
        byte[] base = new byte[]{8, 1, 4, 7, 2, 2, 5, 9, 3, 9, 5};
        int soma = 0;
        for (int i = 10; i >= 0; --i) {
            soma += (auxConta.charAt(i) - 48) * base[i];
        }
        int digito = soma % 11;
        digito = digito == 1 ? 0 : (digito == 0 ? 1 : 11 - digito);
        char v_digito = (char)(digito + 48);
        return v_digito == numConta.charAt(7);
    }

    static boolean validaContaBancoHSBC(String numAgencia, String numConta) {
        char v_digito;
        StringBuilder auxConta = new StringBuilder();
        auxConta.append(numAgencia.substring(1));
        auxConta.append(numConta);
        int base = 9;
        int soma = 0;
        for (int i = 9; i >= 0; --i) {
            soma += (auxConta.charAt(i) - 48) * base;
            if ((base = (int)((byte)(base - 1))) >= 2) continue;
            base = 9;
        }
        int digito = soma % 11;
        if (digito == 0 || digito == 10) {
            digito = 0;
        }
        return (v_digito = (char)(digito + 48)) == numConta.charAt(6);
    }

    private static int extraiDezena(int valor) {
        String dezena = "";
        int retorno = 0;
        dezena = Integer.toString(valor);
        int tamanho = dezena.length();
        retorno = tamanho == 1 ? valor : Integer.parseInt(dezena.substring(1));
        return retorno;
    }

    private static int somaDezena(int valor) {
        String dezena = "";
        int retorno = 0;
        dezena = Integer.toString(valor);
        int tamanho = dezena.length();
        if (tamanho == 1) {
            retorno = valor;
        } else {
            retorno = Integer.parseInt(dezena.substring(0, 1));
            retorno += Integer.parseInt(dezena.substring(1));
        }
        return retorno;
    }

    private static boolean validaTipoConta(String conta) {
        String[] tiposContas = new String[]{"01", "02", "03", "05", "07", "09", "13", "27", "35", "37", "43", "45", "46", "48", "50", "53", "60", "92"};
        boolean retorno = false;
        conta = conta.substring(0, 2);
        for (int i = 0; i < 18; ++i) {
            if (!conta.equals(tiposContas[i])) continue;
            retorno = true;
        }
        return retorno;
    }
}

