/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraConsultaBanco;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class RegraConsultaBancoBER24
extends RegraConsultaBanco {
    @Override
    public void executaRegraVerificacao(ImportacaoEvento evento) {
        SituacaoVerificacao situacaoVerificacao = evento.getSituacaoVerificacao();
        try {
            TipoBancoDados tpBanco = DatabaseHelper.recuperaTipoBancoDados(this._conexao.getMetaData());
            ConsultaSQL consultaSQL = this._configuracao.recuperaConsultaSQL(situacaoVerificacao.getRemessa(), evento.getMetadadosArquivoAtual().getCabecalho(), tpBanco);
            StringBuffer consulta = this.constroiConsulta(consultaSQL.getSql(), 300, situacaoVerificacao.getRemessa().getAnoBiGrupoContas());
            List contas = this.isContaVinculada(consulta);
            if (contas != null) {
                for (int i = 0; i < contas.size(); ++i) {
                    String conta = (String)contas.get(i);
                    if (conta == null) continue;
                    Object[] objetos = new Object[]{conta};
                    this.geraMensagemAssociadaRegra(situacaoVerificacao, this._metaDadosArquivo.getArquivo(), objetos);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenciaException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer constroiConsulta(String sqlBase, Integer tipoConta, String anoBi) {
        StringBuffer retorno;
        block15: {
            retorno = new StringBuffer(60);
            try {
                StringBuffer whereIn = new StringBuffer();
                StringBuffer whereNot = new StringBuffer();
                TipoBancoDados tipoBanco = DatabaseHelper.recuperaTipoBancoDados(this._conexao.getMetaData());
                int contador = 0;
                PreparedStatement stmt = this._conexao.prepareStatement("Select * from grupo_contas_padrao where cd_tipo = ? and anobi = ? order by situacao");
                stmt.setInt(1, tipoConta);
                stmt.setString(2, anoBi);
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    ++contador;
                    if ("E".equals(rs.getString("SITUACAO"))) {
                        if (whereNot.length() != 0) {
                            whereNot.append("\n AND ");
                        } else {
                            whereNot.append("\n WHERE ");
                        }
                        if (tipoBanco.equals(TipoBancoDados.ORACLE_DB)) {
                            whereNot.append(" conta NOT LIKE '").append(rs.getString("GRUPO_CONTA")).append("'");
                            continue;
                        }
                        if (tipoBanco.equals(TipoBancoDados.DERBY_DB)) {
                            whereNot.append(" char(conta) NOT LIKE '").append(rs.getString("GRUPO_CONTA")).append("'");
                            continue;
                        }
                        throw new IllegalArgumentException("N\u00e3o foi possivel reconhecer o Banco de Dados para esta rotina");
                    }
                    if (whereIn.length() != 0) {
                        whereIn.append("\n OR ");
                    } else {
                        whereIn.append("\n WHERE ");
                    }
                    if (tipoBanco.equals(TipoBancoDados.ORACLE_DB)) {
                        whereIn.append(" conta LIKE '").append(rs.getString("GRUPO_CONTA")).append("'");
                        continue;
                    }
                    if (tipoBanco.equals(TipoBancoDados.DERBY_DB)) {
                        whereIn.append(" char(conta) LIKE '").append(rs.getString("GRUPO_CONTA")).append("'");
                        continue;
                    }
                    throw new IllegalArgumentException("N\u00e3o foi possivel reconhecer o Banco de Dados para esta rotina");
                }
                if (contador > 0) {
                    retorno.append("SELECT * FROM ( ");
                    retorno.append(" SELECT * FROM ( ");
                    retorno.append(sqlBase);
                    retorno.append(" ) a ");
                    retorno.append(whereIn);
                    retorno.append(" ) b ");
                    retorno.append(whereNot);
                    break block15;
                }
                retorno.append(sqlBase);
            }
            catch (SQLException e) {
                log.info((Object)("erro = " + e.getMessage()));
            }
        }
        log.debug((Object)("Consulta tipo conta " + tipoConta + ": " + retorno));
        retorno.append(" ORDER BY conta ASC");
        return retorno;
    }

    private List isContaVinculada(StringBuffer sql) {
        String retorno = null;
        ArrayList<String> contas = new ArrayList<String>();
        try {
            Statement st = this._conexao.createStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                retorno = rs.getString("conta");
                contas.add(retorno);
            }
        }
        catch (SQLException e) {
            System.out.println(">>>> Erro = " + e.getMessage());
        }
        return contas;
    }
}

