/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao.test;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.CondicaoComando;
import br.gov.rs.tce.pad.beans.types.EventoImportacao;
import br.gov.rs.tce.pad.excecao.CargaCanceladaException;
import br.gov.rs.tce.pad.excecao.RegraDesabilitadaException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoListener;
import br.gov.rs.tce.pad.modelo.verificacao.ExecutorRegras;
import br.gov.rs.tce.pad.modelo.verificacao.VerificacaoArquivosControle;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;

public class ValidadorTester
extends JFrame {
    Connection conexao;
    Thread thBanco;
    Arquivos arquivos;
    Thread th;
    String dirBD;
    private JScrollPane spArquivos = new JScrollPane();
    private XYLayout xYLayout1 = new XYLayout();
    private JList lArquivos = new JList();
    private JButton jButton1 = new JButton();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JButton btntodos = new JButton();
    private JToggleButton jToggleButton1 = new JToggleButton();
    private JPanel jPanel2 = new JPanel();
    private XYLayout xYLayout2 = new XYLayout();
    private JLabel jLabel6 = new JLabel();
    private JTextField edDiretorio = new JTextField();
    private JTextField edCnpj = new JTextField();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JComboBox jComboBox1 = new JComboBox();
    private JLabel jLabel3 = new JLabel();
    private JLabel jLabel4 = new JLabel();
    private JTextField edAno = new JTextField();
    private JButton jButton3 = new JButton();
    private JLabel jLabel5 = new JLabel();
    private JComboBox jComboBox2 = new JComboBox();
    private JLabel lblArquivo = new JLabel();
    private ComboBoxModel comboBoxModel1;
    private ComboBoxModel comboBoxModel2;
    public static final String DIR_PROPERTY = "dir";
    public static final String EXERCICIO = "exercicio";
    public static final String CNPJ = "cnpj";
    public static final String TIPO_SETOR = "tipo-setor";
    public static final String PERIODO = "periodo";
    private JTable jTable1 = new JTable();
    private JCheckBox ckDepedencias = new JCheckBox();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JList listRegras = new JList();
    private JButton btnRegra = new JButton();
    private Label lblProgresso = new Label();
    static NumberFormat df = DecimalFormat.getPercentInstance();
    private JButton button1 = new JButton();
    private Checkbox ckPK = new Checkbox();
    private Checkbox ckFK = new Checkbox();
    private JButton btnRecargaXML = new JButton();

    public ValidadorTester() {
        Object[] itens = new Object[]{"1o. Bimestre", "2o. Bimestre", "3o. Bimestre", "4o. Bimestre", "5o. Bimestre", "6o. Bimestre"};
        this.comboBoxModel1 = new DefaultComboBoxModel<Object>(itens);
        Object[] itens2 = new Object[]{"P - Prefeitura", "C - Camara", "A - Autarquia", "F - Funda\u00e7\u00e3o 4320/64", "S - Consorcio 6404/76", "E - Empresa", "T - Funda\u00e7\u00e3o - 6404/76", "O - Cons\u00f3rcio - 4320/64"};
        this.comboBoxModel2 = new DefaultComboBoxModel<Object>(itens2);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File f = new File("config.properties");
        if (f.exists()) {
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(f));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.edDiretorio.setText(prop.getProperty(DIR_PROPERTY));
            this.edAno.setText(prop.getProperty(EXERCICIO));
            this.edCnpj.setText(prop.getProperty(CNPJ));
            this.jComboBox2.setSelectedIndex(Integer.parseInt(prop.getProperty(TIPO_SETOR)));
            this.jComboBox1.setSelectedIndex(Integer.parseInt(prop.getProperty(PERIODO)));
        } else {
            this.comboBoxModel1.setSelectedItem(itens[0]);
            this.comboBoxModel2.setSelectedItem(itens2[0]);
            this.edAno.setText("2004");
            this.edDiretorio.setText("C:\\");
        }
        this.setDefaultCloseOperation(3);
    }

    private void jbInit() throws Exception {
        this.jComboBox2.setModel(this.comboBoxModel2);
        this.jComboBox1.setModel(this.comboBoxModel1);
        this.getContentPane().setLayout((LayoutManager)this.xYLayout1);
        this.setTitle("Validador");
        this.xYLayout1.setWidth(1069);
        this.xYLayout1.setHeight(533);
        this.jButton1.setText("start");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidadorTester.this.jButton1_actionPerformed(e);
            }
        });
        this.btntodos.setText("ALL");
        this.jToggleButton1.setText("Banco Derby fechado");
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidadorTester.this.jToggleButton1_actionPerformed(e);
            }
        });
        this.jPanel2.setLayout((LayoutManager)this.xYLayout2);
        this.jPanel2.setPreferredSize(new Dimension(595, 120));
        this.jLabel6.setText("Vers\u00e3o 1.0 - Beta");
        this.jLabel1.setText("Diret\u00f3rio:");
        this.jLabel2.setText("CNPJ:");
        this.jLabel3.setText("Per\u00edodo:");
        this.jLabel4.setText("Ano exerc\u00edcio:");
        this.jButton3.setText("Procurar");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidadorTester.this.jButton2_actionPerformed(e);
            }
        });
        this.jLabel5.setText("Tipo setor:");
        this.jPanel2.add((Component)this.ckFK, new XYConstraints(510, 65, 73, 23));
        this.jPanel2.add((Component)this.ckPK, new XYConstraints(510, 40, -1, -1));
        this.jPanel2.add((Component)this.ckDepedencias, new XYConstraints(375, 65, 130, 25));
        this.jPanel2.add((Component)this.jLabel6, new XYConstraints(510, 5, 110, 15));
        this.jPanel2.add((Component)this.edDiretorio, new XYConstraints(90, 10, 295, 20));
        this.jPanel2.add((Component)this.edCnpj, new XYConstraints(90, 35, 110, 20));
        this.jPanel2.add((Component)this.jLabel1, new XYConstraints(10, 15, 50, 15));
        this.jPanel2.add((Component)this.jLabel2, new XYConstraints(10, 40, 35, 15));
        this.jPanel2.add((Component)this.jComboBox1, new XYConstraints(215, 65, 140, 20));
        this.jPanel2.add((Component)this.jLabel3, new XYConstraints(170, 65, 45, 15));
        this.jPanel2.add((Component)this.jLabel4, new XYConstraints(10, 60, 75, 15));
        this.jPanel2.add((Component)this.edAno, new XYConstraints(90, 60, 65, 20));
        this.jPanel2.add((Component)this.jButton3, new XYConstraints(395, 10, 95, 20));
        this.jPanel2.add((Component)this.jLabel5, new XYConstraints(210, 40, 55, 15));
        this.jPanel2.add((Component)this.jComboBox2, new XYConstraints(290, 35, 140, 20));
        this.jScrollPane2.getViewport().add((Component)this.listRegras, null);
        this.getContentPane().add((Component)this.btnRecargaXML, new XYConstraints(450, 95, 155, 25));
        this.getContentPane().add((Component)this.button1, new XYConstraints(330, 95, -1, -1));
        this.getContentPane().add((Component)this.lblProgresso, new XYConstraints(640, 475, -1, -1));
        this.getContentPane().add((Component)this.btnRegra, new XYConstraints(905, 10, 95, 25));
        this.getContentPane().add((Component)this.jScrollPane2, new XYConstraints(900, 40, 130, 430));
        this.getContentPane().add((Component)this.lblArquivo, new XYConstraints(15, 480, 455, 15));
        this.getContentPane().add((Component)this.jPanel2, new XYConstraints(0, 0, 625, 90));
        this.getContentPane().add((Component)this.jToggleButton1, new XYConstraints(155, 95, 145, 25));
        this.getContentPane().add((Component)this.btntodos, new XYConstraints(730, 15, 73, 23));
        this.jScrollPane1.getViewport().add((Component)this.jTable1, null);
        this.getContentPane().add((Component)this.jScrollPane1, new XYConstraints(5, 130, 680, 340));
        this.getContentPane().add((Component)this.jButton1, new XYConstraints(15, 95, 73, 23));
        this.spArquivos.getViewport().add((Component)this.lArquivos, null);
        this.getContentPane().add((Component)this.spArquivos, new XYConstraints(695, 40, 180, 430));
        this.btnRegra.setText("Executa");
        this.ckDepedencias.setText("Valida dependencias");
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.btntodos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidadorTester.this.btntodos_actionPerformed(e);
            }
        });
        this.lblArquivo.setText("jLabel7");
        this.lArquivos.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ValidadorTester.this.lArquivos_mouseClicked(e);
            }
        });
        this.btnRegra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidadorTester.this.btnRegra_actionPerformed(e);
            }
        });
        this.btnRecargaXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidadorTester.this.recargaXML_actionPerformed(e);
            }
        });
        this.btnRecargaXML.setText("Recarrega arquivos.xml");
        this.ckPK.setState(true);
        this.ckFK.setState(true);
        this.ckFK.setLabel("Cria FK");
        this.ckPK.setLabel("Cria PK");
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ValidadorTester.this.jTable1_mouseClicked(e);
            }
        });
        this.jTable1.setCellSelectionEnabled(false);
        this.button1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidadorTester.this.button1_actionPerformed(e);
            }
        });
        this.button1.setText("Cancelar carga");
        this.lblProgresso.setText("0%");
        this.atualizaArquivosXML();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Properties prop = new Properties();
                prop.setProperty(ValidadorTester.DIR_PROPERTY, ValidadorTester.this.edDiretorio.getText());
                prop.setProperty(ValidadorTester.EXERCICIO, ValidadorTester.this.edAno.getText());
                prop.setProperty(ValidadorTester.PERIODO, Integer.toString(ValidadorTester.this.jComboBox1.getSelectedIndex()));
                prop.setProperty(ValidadorTester.CNPJ, ValidadorTester.this.edCnpj.getText());
                prop.setProperty(ValidadorTester.TIPO_SETOR, Integer.toString(ValidadorTester.this.jComboBox2.getSelectedIndex()));
                try {
                    prop.store(new FileOutputStream("config.properties"), null);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                ValidadorTester.this.shutdown();
            }
        });
    }

    private SituacaoVerificacao constroiSituacaoVerificacao() {
        SituacaoVerificacao situacao = new SituacaoVerificacao();
        Remessa rem = new Remessa();
        rem.setAnoExercicio(Integer.parseInt(this.edAno.getText()));
        rem.setCnpjEntidade(this.edCnpj.getText());
        rem.setDiretorioOrigem(this.edDiretorio.getText());
        String sel = (String)this.comboBoxModel1.getSelectedItem();
        rem.setPeriodoInformacoes(Integer.parseInt(sel.substring(0, 1)));
        sel = (String)this.comboBoxModel2.getSelectedItem();
        rem.setTipoSetor(sel.substring(0, 1));
        situacao.setRemessa(rem);
        return situacao;
    }

    private void jButton1_actionPerformed(ActionEvent e) {
        if (!this.jToggleButton1.isSelected()) {
            this.abreBanco();
        }
        final SituacaoVerificacao situacao = this.constroiSituacaoVerificacao();
        final ModeloTabelaVerificacao listener = new ModeloTabelaVerificacao(situacao);
        this.jTable1.setModel(listener);
        this.lblArquivo.setText("Carregando regras de verifica\u00e7\u00e3o e configura\u00e7\u00e3o de arquivos cont\u00e1beis...");
        Arquivos arq = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-principal");
        this.lblArquivo.setText("Regras de verifica\u00e7\u00e3o e configura\u00e7\u00e3o de arquivos cont\u00e1bies carregados.");
        Arquivo[] arqs2 = this.arquivos.getTodosArquivos();
        for (int i = 0; i < arqs2.length; ++i) {
            Arquivo a = arqs2[i];
            a.setCriaChavePrimaria(this.ckPK.getState());
            a.setCriaChaveEstrangeira(this.ckFK.getState());
        }
        final ArrayList<Arquivo> selecionados = new ArrayList<Arquivo>();
        ListModel lista = this.lArquivos.getModel();
        Object[] selecao = this.lArquivos.getSelectedValues();
        for (int i = 0; i < selecao.length; ++i) {
            String s = (String)selecao[i];
            selecionados.add(this.arquivos.getArquivoPorIdentificador(Arquivo.criaIdenficadorArquivo(s)));
        }
        final ValidadorTester f = this;
        this.th = new Thread(){

            @Override
            public void run() {
                block9: {
                    VerificacaoArquivosControle verificacao = new VerificacaoArquivosControle(ValidadorTester.this.arquivos);
                    try {
                        if (ValidadorTester.this.thBanco != null) {
                            ValidadorTester.this.thBanco.join();
                        }
                        if (ValidadorTester.this.conexao == null) {
                            JOptionPane.showMessageDialog(f, "N\u00e3o foi possivel abrir o banco de dados.");
                            return;
                        }
                        verificacao.setValidaDependencias(ValidadorTester.this.ckDepedencias.isSelected());
                        verificacao.verificaArquivos(situacao, ValidadorTester.this.conexao, listener, selecionados);
                        JOptionPane.showMessageDialog(f, "Verifica\u00e7\u00e3o finalizada.");
                        if (ValidadorTester.this.conexao == null) break block9;
                        try {
                            ValidadorTester.this.conexao.commit();
                        }
                        catch (SQLException sqle) {
                            sqle.printStackTrace();
                        }
                    }
                    catch (CargaCanceladaException cce) {
                        ValidadorTester.this.lblArquivo.setText(cce.getMessage());
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                        JOptionPane.showMessageDialog(f, "Ocorreu um erro durante a execu\u00e7\u00e3o, entre em contato com a equipe da AdvancedIT. (" + e2.getMessage() + ").");
                    }
                }
            }
        };
        this.th.start();
    }

    private void jButton2_actionPerformed(ActionEvent e) {
        String filename = "C:/";
        JFileChooser fc = new JFileChooser(new File(filename));
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(this) == 0) {
            if (fc.getSelectedFile().exists()) {
                this.edDiretorio.setText(fc.getSelectedFile().getAbsolutePath());
            } else {
                JOptionPane.showMessageDialog(this, "O diretorio informado n\u00e3o existe ou \u00e9 inv\u00e1lido.");
            }
        }
    }

    private void jToggleButton1_actionPerformed(ActionEvent e) {
        if (!this.jToggleButton1.isSelected()) {
            this.shutdown();
            this.jToggleButton1.setText("Banco Derby fechado");
        } else {
            String filename = "../PAD-Desktop/database";
            JFileChooser fc = new JFileChooser(new File(filename));
            fc.setFileSelectionMode(1);
            if (fc.showOpenDialog(this) == 0) {
                if (fc.getSelectedFile().exists()) {
                    this.dirBD = fc.getSelectedFile().getAbsolutePath();
                    this.abreBanco();
                    this.jToggleButton1.setText("Banco Derby aberto");
                } else {
                    JOptionPane.showMessageDialog(this, "O diretorio informado n\u00e3o existe ou \u00e9 inv\u00e1lido.");
                    this.jToggleButton1.setSelected(false);
                }
            } else {
                this.jToggleButton1.setSelected(false);
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ValidadorTester f = new ValidadorTester();
        f.pack();
        f.show();
    }

    void abreBanco() {
        if (this.dirBD == null) {
            this.dirBD = "../PAD-Desktop/database";
        }
        if (this.conexao == null) {
            this.thBanco = new Thread(){

                @Override
                public void run() {
                    ValidadorTester.this.lblArquivo.setText("Abrindo banco de dados...");
                    ValidadorTester.this.conexao = ValidadorTester.this.criaConexaoDB(ValidadorTester.this.dirBD);
                    if (ValidadorTester.this.conexao != null) {
                        ValidadorTester.this.lblArquivo.setText("Banco de dados aberto.");
                        ValidadorTester.this.jToggleButton1.setText("Banco Derby aberto");
                        ValidadorTester.this.jToggleButton1.setSelected(true);
                    } else {
                        ValidadorTester.this.lblArquivo.setText("Banco de dados N\u00c3O foi aberto.");
                        ValidadorTester.this.conexao = null;
                    }
                }
            };
            this.thBanco.start();
        }
    }

    private void atualizaProgresso(ImportacaoEvento evento) {
        double lidos = (double)evento.getMetadadosArquivoAtual().getBytesLidos() * 1.0;
        double total = evento.getMetadadosArquivoAtual().getTamanhoArquivo();
        double prg = lidos / total;
        this.lblProgresso.setText(df.format(prg));
    }

    private Connection criaConexaoDB(String dir) {
        Connection conexao = null;
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            conexao = DriverManager.getConnection("jdbc:derby:" + this.dirBD, "PADWEB", "PADWEB");
            conexao.setAutoCommit(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conexao;
    }

    public void shutdown() {
        try {
            if (this.conexao != null && !this.conexao.isClosed()) {
                this.conexao.close();
                this.conexao = null;
            }
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void btntodos_actionPerformed(ActionEvent e) {
        this.lArquivos.setSelectionInterval(0, this.lArquivos.getModel().getSize());
    }

    private void btnRegra_actionPerformed(ActionEvent e) {
        if (!this.jToggleButton1.isSelected()) {
            this.abreBanco();
            if (this.thBanco != null) {
                try {
                    this.thBanco.join();
                }
                catch (InterruptedException ie) {
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(this, "Banco de dados precisa ser aberto antes de executar");
                return;
            }
        }
        SituacaoVerificacao situacao = this.constroiSituacaoVerificacao();
        ModeloTabelaVerificacao listener = new ModeloTabelaVerificacao(situacao);
        final Arquivo arq = this.arquivos.getArquivoPorIdentificador(Arquivo.criaIdenficadorArquivo((String)this.lArquivos.getSelectedValue()));
        this.jTable1.setModel(listener);
        final ExecutorRegras exec = new VerificacaoArquivosControle().constroiExecutorRegras(listener);
        ArrayList<Arquivo> metalist = new ArrayList<Arquivo>();
        metalist.add(arq);
        situacao.inicializaMetadadosArquivos(metalist, this.edDiretorio.getText());
        MetadadosArquivoContabil meta = situacao.getArquivoPorIdentificador(arq.getIdentificador());
        ContextoVerificacao contexto = new ContextoVerificacao();
        contexto.adicionaAtributo("pad.conexaoDB", this.conexao);
        final ValidadorTester f = this;
        final ImportacaoEvento evento = new ImportacaoEvento(meta, contexto, situacao, 1);
        this.th = new Thread(){

            @Override
            public void run() {
                if (ValidadorTester.this.listRegras.getSelectedIndices().length == 1) {
                    try {
                        ValidadorTester.this.lblArquivo.setText("Executando regra: " + ValidadorTester.this.listRegras.getSelectedValue());
                        exec.executaRegraVerificacao((String)ValidadorTester.this.listRegras.getSelectedValue(), evento);
                        JOptionPane.showMessageDialog(f, "Regra executada - " + ValidadorTester.this.listRegras.getSelectedValue());
                    }
                    catch (RegraDesabilitadaException re) {
                        re.printStackTrace();
                    }
                } else if (ValidadorTester.this.listRegras.getSelectedIndices().length == 0) {
                    ValidadorTester.this.lblArquivo.setText("Executando regras contabeis para o arquivo: " + arq.getNomeCompleto());
                    exec.executaRegrasVerificacao(arq, evento);
                    JOptionPane.showMessageDialog(f, "Regras contabeis arquivo - " + arq.getNomeCompleto());
                }
            }
        };
        this.th.start();
    }

    private void lArquivos_mouseClicked(MouseEvent e) {
        if (this.lArquivos.getSelectedIndices().length == 1) {
            DefaultListModel<String> mdRegras = new DefaultListModel<String>();
            Arquivo arq = this.arquivos.getArquivoPorIdentificador(Arquivo.criaIdenficadorArquivo((String)this.lArquivos.getSelectedValue()));
            if (arq.getRegrasAssociadas() != null) {
                List<String> regras = arq.getRegrasAssociadas().getRegrasAssociadas(EventoImportacao.CARGA, CondicaoComando.APOS);
                for (int j = 0; j < regras.size(); ++j) {
                    mdRegras.addElement(regras.get(j));
                }
            }
            this.listRegras.setModel(mdRegras);
        }
    }

    private void button1_actionPerformed(ActionEvent e) {
        if (this.th != null) {
            this.th.interrupt();
        }
    }

    private void jTable1_mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && this.jTable1.getSelectedRow() >= 0) {
            String msg = (String)this.jTable1.getModel().getValueAt(this.jTable1.getSelectedRow(), 4);
            JOptionPane.showMessageDialog(this, msg);
            System.out.println("msg == " + msg);
        }
    }

    private void recargaXML_actionPerformed(ActionEvent e) {
        this.atualizaArquivosXML();
    }

    private void atualizaArquivosXML() {
        this.arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-principal", new File("src/arquivos.xml"), true);
        DefaultListModel<String> md = new DefaultListModel<String>();
        Arquivo[] arqs = this.arquivos.getTodosArquivos();
        DefaultListModel mdRegras = new DefaultListModel();
        for (int i = 0; i < this.arquivos.getArquivoCount(); ++i) {
            md.add(i, arqs[i].getIdentificador().toString());
        }
        this.lArquivos.setModel(md);
    }

    class ModeloTabelaVerificacao
    extends AbstractTableModel
    implements ImportacaoListener {
        SituacaoVerificacao _situacao;
        String[] columnNames = new String[]{"Num.", "Tipo", "Arquivo", "C\u00f3digo", "Texto"};

        public ModeloTabelaVerificacao(SituacaoVerificacao situacao) {
            this._situacao = situacao;
        }

        @Override
        public Object getValueAt(int row, int col) {
            MensagemInstancia msg = this._situacao.getMensagens().get(row);
            Object value = null;
            switch (col) {
                case 0: {
                    value = msg.getIndicador();
                    break;
                }
                case 1: {
                    value = msg.getTipo();
                    break;
                }
                case 2: {
                    value = msg.getArquivo();
                    break;
                }
                case 3: {
                    value = msg.getCodigoMensagem();
                    break;
                }
                case 4: {
                    value = msg.getTexto();
                }
            }
            return value;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        @Override
        public int getRowCount() {
            return this._situacao.getMensagens().size();
        }

        public SituacaoVerificacao getSituacao() {
            return this._situacao;
        }

        @Override
        public void trataEvento(ImportacaoEvento evento) {
            if (evento.getTipoEvento() == 0) {
                ValidadorTester.this.lblArquivo.setText("Carregando: " + evento.getNomeArquivo());
            } else if (evento.getTipoEvento() == 3) {
                ValidadorTester.this.atualizaProgresso(evento);
            } else if (evento.getTipoEvento() != 6) {
                if (evento.getTipoEvento() == 1) {
                    ValidadorTester.this.atualizaProgresso(evento);
                    this.fireTableDataChanged();
                } else if (evento.getTipoEvento() == 7) {
                    int[] colWidths = new int[]{12, 30, 30, 70, 300};
                    TableColumnModel modelo = ValidadorTester.this.jTable1.getColumnModel();
                    for (int i = 0; i < colWidths.length; ++i) {
                        modelo.getColumn(i).setPreferredWidth(colWidths[i]);
                    }
                    this.fireTableDataChanged();
                }
            }
        }
    }
}

