/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao.test;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.remessa.RemessaPrefeitura;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoListener;
import br.gov.rs.tce.pad.modelo.verificacao.VerificacaoArquivosControle;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class ImportacaoControleTest {
    protected static final Log log = LogFactory.getLog(ImportacaoControleTest.class);
    String padModeloSrcDir = "../PAD-Modelo/src";
    ImportacaoListener importacaoListenerLoggger = new ImportacaoListener(){

        @Override
        public void trataEvento(ImportacaoEvento ie) {
        }
    };
    VerificacaoArquivosControle verificacaoArquivosControle;

    @Test
    public void testCarregaDefinicoesArquivosContabeis() {
        File arquivoXML = null;
        VerificacaoArquivosControle verificacaoArquivosControle = null;
        SituacaoVerificacao situacaoVerificacao = null;
        arquivoXML = new File(this.padModeloSrcDir + "/arquivos.xml");
        if (!arquivoXML.exists()) {
            throw new IllegalStateException("arquivo '" + arquivoXML + "' n\u00e3o existe");
        }
        Arquivos arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-principal", arquivoXML);
        Arquivo arquivo = arquivos.getArquivoPorIdentificador(Arquivo.criaIdenficadorArquivo("ORGAO"));
        Arquivos arquivosSelecionados = new Arquivos();
        arquivosSelecionados.addArquivo(arquivo);
        verificacaoArquivosControle = new VerificacaoArquivosControle(arquivosSelecionados);
        situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessa());
        Connection conexao = this.criaConexaoDB();
        verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, conexao, new ImportacaoListener(){

            @Override
            public void trataEvento(ImportacaoEvento ie) {
                log.debug((Object)("Evento recebido: " + ie.getTipoEvento()));
            }
        });
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        for (int i = 0; i < msgs.size(); ++i) {
            System.out.println("mensagem[" + i + "]: " + msgs.get(i) + " ; codigo = " + msgs.get(i).getCodigoMensagem());
        }
        this.shutdown();
        Assert.assertEquals((long)0L, (long)msgs.size());
    }

    @Test
    public void testCarregaDefinicoesArquivosContabeisErro() {
        this.setupVerificacaoArquivosControle();
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2005, 2, "88379763000136", "src_test/2bi05-PMIgrejinha Orig-1bi05-erro"));
        Connection conexao = this.criaConexaoDB();
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        for (int i = 0; i < msgs.size(); ++i) {
            System.out.println("mensagem[" + i + "]: " + msgs.get(i) + " ; codigo = " + msgs.get(i).getCodigoMensagem());
        }
        this.shutdown();
        Assert.assertEquals((long)1L, (long)msgs.size());
    }

    public void shutdown() {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void setupVerificacaoArquivosControle() {
        File arquivoXML = new File(this.padModeloSrcDir + "/arquivos.xml");
        this.verificacaoArquivosControle = null;
        if (!arquivoXML.exists()) {
            throw new IllegalStateException("arquivo '" + arquivoXML + "' n\u00e3o existe");
        }
        Arquivos arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-principal", arquivoXML);
        Arquivo arquivo = arquivos.getArquivoPorIdentificador(Arquivo.criaIdenficadorArquivo("ORGAO"));
        Arquivos arquivosSelecionados = new Arquivos();
        arquivosSelecionados.addArquivo(arquivo);
        this.verificacaoArquivosControle = new VerificacaoArquivosControle(arquivosSelecionados);
    }

    private Remessa criaRemessa() {
        return this.criaRemessaPrefeitura(2005, 2, "88379763000136", "src_test/2bi05-PMIgrejinha Orig-1bi05-CTV_19");
    }

    protected Remessa criaRemessaPrefeitura(int ano, int periodo, String cnpj, String diretorio) {
        RemessaPrefeitura remessa = new RemessaPrefeitura();
        remessa.setAnoExercicio(ano);
        remessa.setCnpjEntidade(cnpj);
        if (!new File(diretorio).isDirectory()) {
            throw new RuntimeException("caminho '" + diretorio + "' deve ser um diret\u00f3rio v\u00e1lido");
        }
        remessa.setDiretorioOrigem(diretorio);
        remessa.setPeriodoInformacoes(periodo);
        remessa.setTipoSetor("P");
        return remessa;
    }

    protected Connection criaConexaoDB() {
        Connection conexao = null;
        System.out.println("user.dir: " + System.getProperty("user.dir"));
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            conexao = DriverManager.getConnection("jdbc:derby:./test/database", "PADWEB", "PADWEB");
        }
        catch (Exception e) {
            System.out.println("criaConexaoDB: exception: " + e);
        }
        return conexao;
    }
}

