/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.importacao.BaseRepositorioArquivosControle;
import br.gov.rs.tce.pad.modelo.importacao.RepositorioArquivosControle;
import java.sql.SQLException;

public final class RepositorioArquivosControleDBImpl
extends BaseRepositorioArquivosControle
implements RepositorioArquivosControle {
    static final int CODIGO_ERRO_PK_ORACLE = 2437;
    static final int CODIGO_ERRO_FK_ORACLE = 2298;
    static final int CODIGO_CHAVE_PRIMARIA_NAO_EXISTE = 2441;
    static final int CODIGO_TABELA_NAO_ENCONTRADA = 942;

    @Override
    public void removeTabela(String tabela) {
        block2: {
            try {
                String sql = " DROP TABLE " + tabela + " CASCADE CONSTRAINTS";
                this.executaDDL(sql);
            }
            catch (PersistenciaException e) {
                SQLException sqle = (SQLException)e.getCause();
                if (sqle.getErrorCode() == 942) break block2;
                throw e;
            }
        }
    }

    @Override
    protected String montaSQLCriacaoTabelaAuxiliar(Arquivo arquivo) {
        String[] colunas = arquivo.getTabela().getColunasTabelaAuxiliar();
        String sql = "CREATE TABLE " + arquivo.getTabela().getTabelaAuxiliar() + " AS ( SELECT DISTINCT ";
        for (int i = 0; i < colunas.length; ++i) {
            sql = sql + colunas[i];
            if (i + 1 >= colunas.length) continue;
            sql = sql + ", ";
        }
        sql = sql + " FROM " + arquivo.getTabela().getNome() + " ) ";
        return sql;
    }

    @Override
    public void limpaTabela(String nomeTabela) {
        String sql = "TRUNCATE TABLE " + nomeTabela;
        this.executaDDL(sql);
    }

    @Override
    protected String montaSQLRemoveChavePrimaria(String nomeTabela) {
        String sql = null;
        sql = "ALTER TABLE " + nomeTabela + " DROP PRIMARY KEY CASCADE";
        return sql;
    }

    @Override
    protected void verificaExcecaoChavePrimaria(SQLException sqle, String nomeTabela) {
        if (sqle.getErrorCode() != 2437) {
            throw new PersistenciaException("10013", new Object[]{nomeTabela}, sqle);
        }
    }

    @Override
    protected void verificaExcecaoChaveEstrangeira(SQLException sqle, String nomeTabelaOrigem, String nomeTabelaDestino) {
        if (sqle.getErrorCode() != 2298) {
            throw new PersistenciaException("10014", new Object[]{nomeTabelaOrigem, nomeTabelaDestino}, sqle);
        }
    }

    @Override
    public void criaTabelaAuxiliar(Arquivo arquivo) {
        String sql = this.montaSQLCriacaoTabelaAuxiliar(arquivo);
        System.out.println(">>>> criaTabelaAuxiliar >>> SQL \n" + sql);
        this.executaDDL(sql);
        this.criaChavePrimaria(arquivo.getTabela().getTabelaAuxiliar(), arquivo.getTabela().getColunasTabelaAuxiliar(), null, false);
    }

    @Override
    public void removeChavePrimaria(String nomeTabela) {
        block2: {
            try {
                this.executaDDL(this.montaSQLRemoveChavePrimaria(nomeTabela));
            }
            catch (PersistenciaException e) {
                SQLException sqle = (SQLException)e.getCause();
                if (sqle.getErrorCode() == 2441) break block2;
                throw e;
            }
        }
    }

    public void removeChavesEstrangeiras(String nomeTabela) {
    }
}

